function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiComboBox } from '@elastic/eui';
import { i18n } from '@kbn/i18n'; // @ts-ignore

import { isMetricEnabled } from '../../lib/check_ui_restrictions';
var metricAggs = [{
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.averageLabel', {
    defaultMessage: 'Average'
  }),
  value: 'avg'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.cardinalityLabel', {
    defaultMessage: 'Cardinality'
  }),
  value: 'cardinality'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.countLabel', {
    defaultMessage: 'Count'
  }),
  value: 'count'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.filterRatioLabel', {
    defaultMessage: 'Filter Ratio'
  }),
  value: 'filter_ratio'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.positiveRateLabel', {
    defaultMessage: 'Positive Rate'
  }),
  value: 'positive_rate'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.maxLabel', {
    defaultMessage: 'Max'
  }),
  value: 'max'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.minLabel', {
    defaultMessage: 'Min'
  }),
  value: 'min'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.percentileLabel', {
    defaultMessage: 'Percentile'
  }),
  value: 'percentile'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.percentileRankLabel', {
    defaultMessage: 'Percentile Rank'
  }),
  value: 'percentile_rank'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.staticValueLabel', {
    defaultMessage: 'Static Value'
  }),
  value: 'static'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.stdDeviationLabel', {
    defaultMessage: 'Std. Deviation'
  }),
  value: 'std_deviation'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.sumLabel', {
    defaultMessage: 'Sum'
  }),
  value: 'sum'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.sumOfSquaresLabel', {
    defaultMessage: 'Sum of Squares'
  }),
  value: 'sum_of_squares'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.topHitLabel', {
    defaultMessage: 'Top Hit'
  }),
  value: 'top_hit'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.valueCountLabel', {
    defaultMessage: 'Value Count'
  }),
  value: 'value_count'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.metricsAggs.varianceLabel', {
    defaultMessage: 'Variance'
  }),
  value: 'variance'
}];
var pipelineAggs = [{
  label: i18n.translate('visTypeTimeseries.aggSelect.pipelineAggs.bucketScriptLabel', {
    defaultMessage: 'Bucket Script'
  }),
  value: 'calculation'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.pipelineAggs.cumulativeSumLabel', {
    defaultMessage: 'Cumulative Sum'
  }),
  value: 'cumulative_sum'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.pipelineAggs.derivativeLabel', {
    defaultMessage: 'Derivative'
  }),
  value: 'derivative'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.pipelineAggs.movingAverageLabel', {
    defaultMessage: 'Moving Average'
  }),
  value: 'moving_average'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.pipelineAggs.positiveOnlyLabel', {
    defaultMessage: 'Positive Only'
  }),
  value: 'positive_only'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.pipelineAggs.serialDifferenceLabel', {
    defaultMessage: 'Serial Difference'
  }),
  value: 'serial_diff'
}];
var siblingAggs = [{
  label: i18n.translate('visTypeTimeseries.aggSelect.siblingAggs.overallAverageLabel', {
    defaultMessage: 'Overall Average'
  }),
  value: 'avg_bucket'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.siblingAggs.overallMaxLabel', {
    defaultMessage: 'Overall Max'
  }),
  value: 'max_bucket'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.siblingAggs.overallMinLabel', {
    defaultMessage: 'Overall Min'
  }),
  value: 'min_bucket'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.siblingAggs.overallStdDeviationLabel', {
    defaultMessage: 'Overall Std. Deviation'
  }),
  value: 'std_deviation_bucket'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.siblingAggs.overallSumLabel', {
    defaultMessage: 'Overall Sum'
  }),
  value: 'sum_bucket'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.siblingAggs.overallSumOfSquaresLabel', {
    defaultMessage: 'Overall Sum of Squares'
  }),
  value: 'sum_of_squares_bucket'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.siblingAggs.overallVarianceLabel', {
    defaultMessage: 'Overall Variance'
  }),
  value: 'variance_bucket'
}];
var specialAggs = [{
  label: i18n.translate('visTypeTimeseries.aggSelect.specialAggs.seriesAggLabel', {
    defaultMessage: 'Series Agg'
  }),
  value: 'series_agg'
}, {
  label: i18n.translate('visTypeTimeseries.aggSelect.specialAggs.mathLabel', {
    defaultMessage: 'Math'
  }),
  value: 'math'
}];
var FILTER_RATIO_AGGS = ['avg', 'cardinality', 'count', 'positive_rate', 'max', 'min', 'sum', 'value_count'];
var HISTOGRAM_AGGS = ['avg', 'count', 'sum', 'value_count'];
var allAggOptions = [].concat(metricAggs, pipelineAggs, siblingAggs, specialAggs);

function filterByPanelType(panelType) {
  return function (agg) {
    if (panelType === 'table') return agg.value !== 'series_agg';
    return true;
  };
}

export function AggSelect(props) {
  var siblings = props.siblings,
      panelType = props.panelType,
      value = props.value,
      onChange = props.onChange,
      uiRestrictions = props.uiRestrictions,
      rest = _objectWithoutProperties(props, ["siblings", "panelType", "value", "onChange", "uiRestrictions"]);

  var selectedOptions = allAggOptions.filter(function (option) {
    return value === option.value && isMetricEnabled(option.value, uiRestrictions);
  });
  var enablePipelines = siblings.some(function (s) {
    return !!metricAggs.find(function (m) {
      return m.value === s.type;
    });
  });
  if (siblings.length <= 1) enablePipelines = false;
  var options;

  if (panelType === 'metrics') {
    options = metricAggs;
  } else if (panelType === 'filter_ratio') {
    options = metricAggs.filter(function (m) {
      return FILTER_RATIO_AGGS.includes("".concat(m.value));
    });
  } else if (panelType === 'histogram') {
    options = metricAggs.filter(function (m) {
      return HISTOGRAM_AGGS.includes("".concat(m.value));
    });
  } else {
    var disableSiblingAggs = function disableSiblingAggs(agg) {
      return _objectSpread(_objectSpread({}, agg), {}, {
        disabled: !enablePipelines || !isMetricEnabled(agg.value, uiRestrictions)
      });
    };

    options = [{
      label: i18n.translate('visTypeTimeseries.aggSelect.aggGroups.metricAggLabel', {
        defaultMessage: 'Metric Aggregations'
      }),
      options: metricAggs.map(function (agg) {
        return _objectSpread(_objectSpread({}, agg), {}, {
          disabled: !isMetricEnabled(agg.value, uiRestrictions)
        });
      })
    }, {
      label: i18n.translate('visTypeTimeseries.aggSelect.aggGroups.parentPipelineAggLabel', {
        defaultMessage: 'Parent Pipeline Aggregations'
      }),
      options: pipelineAggs.filter(filterByPanelType(panelType)).map(disableSiblingAggs)
    }, {
      label: i18n.translate('visTypeTimeseries.aggSelect.aggGroups.siblingPipelineAggLabel', {
        defaultMessage: 'Sibling Pipeline Aggregations'
      }),
      options: siblingAggs.map(disableSiblingAggs)
    }, {
      label: i18n.translate('visTypeTimeseries.aggSelect.aggGroups.specialAggLabel', {
        defaultMessage: 'Special Aggregations'
      }),
      options: specialAggs.map(disableSiblingAggs)
    }];
  }

  var handleChange = function handleChange(currentlySelectedOptions) {
    if (!currentlySelectedOptions || currentlySelectedOptions.length <= 0) return;
    onChange(currentlySelectedOptions);
  };

  return /*#__PURE__*/React.createElement("div", {
    "data-test-subj": "aggSelector"
  }, /*#__PURE__*/React.createElement(EuiComboBox, _extends({
    isClearable: false,
    placeholder: i18n.translate('visTypeTimeseries.aggSelect.selectAggPlaceholder', {
      defaultMessage: 'Select aggregation'
    }),
    options: options,
    selectedOptions: selectedOptions,
    onChange: handleChange,
    singleSelection: {
      asPlainText: true
    }
  }, rest)));
}