/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.conda;

import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserFactoryImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import com.intellij.tools.ToolsBundle;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PyCharmCommunityBundle;
import com.jetbrains.python.conda.InstallCondaUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class PyCharmCustomizeCondaSetupStep
extends AbstractCustomizeWizardStep {
    private static final Logger LOG = Logger.getInstance(PyCharmCustomizeCondaSetupStep.class);
    private final ProgressIndicator myProgressIndicator = new ProgressIndicatorBase();
    private final JButton myInstallButton;
    private final TextFieldWithBrowseButton mySetupCondaFileChooser;
    private final JProgressBar myProgressBar;
    private final JPanel myProgressPanel;
    private final LinkLabel myCancelLink;
    private VirtualFile myLastSelection;

    public PyCharmCustomizeCondaSetupStep() {
        this.setLayout(new BorderLayout());
        this.myProgressBar = new JProgressBar(0, 100);
        this.myProgressBar.setStringPainted(true);
        this.myProgressBar.setIndeterminate(true);
        this.myCancelLink = new LinkLabel(PyCharmCommunityBundle.message("conda.setup.cancel.link.text", new Object[0]), null);
        this.myCancelLink.setVisible(false);
        this.myCancelLink.setListener((aSource, aLinkData) -> {
            this.myProgressIndicator.cancel();
            PyCharmCustomizeCondaSetupStep.showErrorDialog(ActionsBundle.message((String)"action.SetupMiniconda.installCanceled", (Object[])new Object[0]), false);
            this.unlockElementsAfterInstall();
        }, null);
        JPanel linkWrapper = new JPanel(new FlowLayout(1, 0, 0));
        linkWrapper.add((Component)this.myCancelLink);
        this.myProgressPanel = new JPanel((LayoutManager)new VerticalFlowLayout(true, false));
        this.myProgressPanel.add(this.myProgressBar);
        this.myProgressPanel.add(linkWrapper);
        this.myProgressPanel.setEnabled(true);
        this.myProgressPanel.setVisible(false);
        File installationPath = InstallCondaUtils.getDefaultDirectoryFile();
        this.myLastSelection = new CoreLocalFileSystem().findFileByIoFile(installationPath);
        this.myInstallButton = new JButton(ActionsBundle.message((String)"action.SetupMiniconda.actionName", (Object[])new Object[0]));
        this.myInstallButton.addActionListener(e -> this.installButtonActionListener());
        this.mySetupCondaFileChooser = new TextFieldWithBrowseButton();
        this.mySetupCondaFileChooser.setText(installationPath.getAbsolutePath());
        this.mySetupCondaFileChooser.addActionListener(e -> this.setupFileChooserActionListener());
        JPanel controls = new JPanel(new GridBagLayout());
        controls.setOpaque(false);
        GridBag gbc = new GridBag().setDefaultAnchor(17).setDefaultFill(1).setDefaultWeightX(1.0);
        gbc.insets.top = UIUtil.PANEL_REGULAR_INSETS.top;
        gbc.insets.left = UIUtil.PANEL_REGULAR_INSETS.left;
        controls.add((Component)this.myInstallButton, gbc.anchor(18));
        gbc.nextLine();
        JLabel specifyPath = new JLabel(PyCharmCustomizeCondaSetupStep.wrapInHtml(ActionsBundle.message((String)"action.SetupMiniconda.specifyPath", (Object[])new Object[0]) + "<br>"));
        controls.add((Component)specifyPath, gbc.nextLine());
        controls.add((Component)this.mySetupCondaFileChooser, gbc.nextLine());
        JLabel description = new JLabel(PyCharmCustomizeCondaSetupStep.wrapInHtml(ActionsBundle.message((String)"action.SetupMiniconda.description", (Object[])new Object[0]) + "<br>"));
        controls.add((Component)description, gbc.nextLine());
        controls.add((Component)this.myProgressPanel, gbc.nextLine());
        JPanel content = new JPanel(PyCharmCustomizeCondaSetupStep.createSmallBorderLayout());
        content.add((Component)controls, "North");
        this.add(content, "Center");
    }

    private void lockElementsOnInstall() {
        this.myInstallButton.setEnabled(false);
        this.mySetupCondaFileChooser.setEnabled(false);
        this.myProgressBar.setString(PyCharmCommunityBundle.message("conda.setup.installing.progress.text", new Object[0]));
        this.myProgressPanel.setVisible(true);
        this.myCancelLink.setVisible(true);
    }

    private void unlockElementsAfterInstall() {
        this.mySetupCondaFileChooser.setEnabled(true);
        this.myInstallButton.setEnabled(true);
        this.myProgressPanel.setVisible(false);
        this.myCancelLink.setVisible(false);
    }

    private void installButtonActionListener() {
        String path = InstallCondaUtils.beatifyPath(this.mySetupCondaFileChooser.getText());
        String errorMessage = InstallCondaUtils.checkPath(path);
        if (errorMessage != null) {
            PyCharmCustomizeCondaSetupStep.showErrorDialog(errorMessage, false);
            return;
        }
        this.lockElementsOnInstall();
        ProcessOutput[] processOutput = new ProcessOutput[1];
        AppExecutorUtil.getAppExecutorService().submit(() -> {
            try {
                CapturingProcessHandler handler = InstallCondaUtils.installationHandler(path, (Function1<? super String, Unit>)((Function1)line -> {
                    this.myProgressBar.setString((String)line);
                    return Unit.INSTANCE;
                }));
                processOutput[0] = handler.runProcessWithProgressIndicator(this.myProgressIndicator);
                LOG.info(processOutput[0].getStdout());
                int exitCode = processOutput[0].getExitCode();
                if (exitCode == 0) {
                    this.myInstallButton.setText(PyCharmCommunityBundle.message("conda.setup.install.button.installed.text", new Object[0]));
                } else {
                    PyCharmCustomizeCondaSetupStep.showErrorDialog(processOutput[0].getStderr(), true);
                    this.unlockElementsAfterInstall();
                }
            }
            catch (Exception e) {
                PyCharmCustomizeCondaSetupStep.showErrorDialog(processOutput[0].getStderr(), true);
                this.unlockElementsAfterInstall();
            }
            finally {
                this.myProgressPanel.setVisible(false);
            }
        });
    }

    private void setupFileChooserActionListener() {
        FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        chooserDescriptor.setHideIgnored(false);
        chooserDescriptor.withFileFilter(file -> file.isDirectory());
        Ref fileRef = Ref.create();
        PathChooserDialog chooser = FileChooserFactoryImpl.createNativePathChooserIfEnabled((FileChooserDescriptor)chooserDescriptor, null, (Component)((Object)this));
        if (chooser == null) {
            File file2;
            File lastSelectedFile = this.myLastSelection == null ? null : VfsUtilCore.virtualToIoFile((VirtualFile)this.myLastSelection);
            JFileChooser fc = new JFileChooser(lastSelectedFile == null ? null : lastSelectedFile.getParentFile());
            fc.setSelectedFile(lastSelectedFile);
            fc.setFileSelectionMode(1);
            fc.setFileHidingEnabled(SystemInfo.isWindows || SystemInfo.isMac);
            int returnVal = fc.showOpenDialog((Component)((Object)this));
            if (returnVal == 0 && (file2 = fc.getSelectedFile()) != null) {
                fileRef.set((Object)new CoreLocalVirtualFile(new CoreLocalFileSystem(), file2));
                this.mySetupCondaFileChooser.setText(file2.getAbsolutePath());
            }
        } else {
            chooser.choose(this.myLastSelection, files -> fileRef.set((Object)((VirtualFile)files.get(0))));
        }
        if (!fileRef.isNull()) {
            File file3 = VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)fileRef.get()));
            this.myLastSelection = (VirtualFile)fileRef.get();
            this.mySetupCondaFileChooser.setText(file3.getAbsolutePath());
        }
    }

    public String getTitle() {
        return PyCharmCommunityBundle.message("conda.setup.wizard.step.title", new Object[0]);
    }

    protected String getHTMLHeader() {
        return PyCharmCustomizeCondaSetupStep.wrapInHtml("<h2>Miniconda</h2>");
    }

    protected String getHTMLFooter() {
        return PyCharmCommunityBundle.message("conda.setup.wizard.step.footer.content", ToolsBundle.message((String)"tools.settings", (Object[])new Object[0]), ActionsBundle.message((String)"action.SetupMiniconda.actionNameWithDots", (Object[])new Object[0]));
    }

    private static void showErrorDialog(@NotNull String message, boolean log) {
        if (message == null) {
            PyCharmCustomizeCondaSetupStep.$$$reportNull$$$0(0);
        }
        if (log) {
            LOG.error(message);
        }
        SwingUtilities.invokeLater(() -> Messages.showErrorDialog((String)message, (String)ActionsBundle.message((String)"action.SetupMiniconda.installFailed", (Object[])new Object[0])));
    }

    private static String wrapInHtml(@NotNull String text) {
        if (text == null) {
            PyCharmCustomizeCondaSetupStep.$$$reportNull$$$0(1);
        }
        return "<html><body>" + text + "</body></html>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/conda/PyCharmCustomizeCondaSetupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapInHtml";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

