/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchUtil {
    private static final Logger LOG = Logger.getInstance(GitBranchUtil.class);
    private static final String NO_BRANCH_NAME = "(no branch)";

    private GitBranchUtil() {
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfoForBranch(@NotNull GitRepository repository, @NotNull GitLocalBranch branch) {
        if (repository == null) {
            GitBranchUtil.$$$reportNull$$$0(0);
        }
        if (branch == null) {
            GitBranchUtil.$$$reportNull$$$0(1);
        }
        return GitBranchUtil.getTrackInfo(repository, branch.getName());
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfo(@NotNull GitRepository repository, @NotNull String localBranchName) {
        if (repository == null) {
            GitBranchUtil.$$$reportNull$$$0(2);
        }
        if (localBranchName == null) {
            GitBranchUtil.$$$reportNull$$$0(3);
        }
        return repository.getBranchTrackInfo(localBranchName);
    }

    @NotNull
    static String getCurrentBranchOrRev(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(4);
        }
        if (repositories.size() > 1) {
            GitMultiRootBranchConfig multiRootBranchConfig = new GitMultiRootBranchConfig(repositories);
            String currentBranch = multiRootBranchConfig.getCurrentBranch();
            LOG.assertTrue(currentBranch != null, (Object)("Repositories have unexpectedly diverged. " + (Object)((Object)multiRootBranchConfig)));
            String string = currentBranch;
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        assert (!repositories.isEmpty()) : "No repositories passed to GitBranchOperationsProcessor.";
        GitRepository repository = repositories.iterator().next();
        return GitBranchUtil.getBranchNameOrRev(repository);
    }

    @NotNull
    public static Collection<String> convertBranchesToNames(@NotNull Collection<? extends GitBranch> branches2) {
        if (branches2 == null) {
            GitBranchUtil.$$$reportNull$$$0(6);
        }
        List list = ContainerUtil.map(branches2, GitReference::getName);
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public static List<String> getAllTags(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(8);
        }
        if (root == null) {
            GitBranchUtil.$$$reportNull$$$0(9);
        }
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.TAG);
        h2.addParameters("-l");
        h2.setSilent(true);
        final ArrayList<String> tags = new ArrayList<String>();
        h2.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return;
                }
                if (line.length() != 0) {
                    tags.add(line);
                }
            }
        });
        GitCommandResult result2 = Git.getInstance().runCommandWithoutCollectingOutput(h2);
        result2.throwOnError(new int[0]);
        ArrayList<String> arrayList = tags;
        if (arrayList == null) {
            GitBranchUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<String> getBranchNamesWithoutRemoteHead(@NotNull Collection<? extends GitRemoteBranch> remoteBranches) {
        if (remoteBranches == null) {
            GitBranchUtil.$$$reportNull$$$0(11);
        }
        List list = ContainerUtil.filter(GitBranchUtil.convertBranchesToNames(remoteBranches), input -> !input.equals("HEAD"));
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public static String stripRefsPrefix(@NotNull String branchName) {
        if (branchName == null) {
            GitBranchUtil.$$$reportNull$$$0(13);
        }
        if (branchName.startsWith("refs/heads/")) {
            String string = branchName.substring("refs/heads/".length());
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (branchName.startsWith("refs/remotes/")) {
            String string = branchName.substring("refs/remotes/".length());
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (branchName.startsWith("refs/tags/")) {
            String string = branchName.substring("refs/tags/".length());
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = branchName;
        if (string == null) {
            GitBranchUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static String getBranchNameOrRev(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchUtil.$$$reportNull$$$0(18);
        }
        if (repository.isOnBranch()) {
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            assert (currentBranch != null);
            String string = currentBranch.getName();
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(19);
            }
            return string;
        }
        String currentRevision = repository.getCurrentRevision();
        return currentRevision != null ? currentRevision.substring(0, 7) : "";
    }

    @Nullable
    public static GitNewBranchOptions getNewBranchNameFromUser(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull String dialogTitle, @Nullable String initialName) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(20);
        }
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(21);
        }
        if (dialogTitle == null) {
            GitBranchUtil.$$$reportNull$$$0(22);
        }
        return GitBranchUtil.getNewBranchNameFromUser(project, repositories, dialogTitle, initialName, false);
    }

    @Nullable
    public static GitNewBranchOptions getNewBranchNameFromUser(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull String dialogTitle, @Nullable String initialName, boolean showTrackingOption) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(23);
        }
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(24);
        }
        if (dialogTitle == null) {
            GitBranchUtil.$$$reportNull$$$0(25);
        }
        return new GitNewBranchDialog(project, repositories, dialogTitle, initialName, true, false, showTrackingOption).showAndGetOptions();
    }

    @NotNull
    public static String getDisplayableBranchText(@NotNull GitRepository repository) {
        Repository.State state;
        if (repository == null) {
            GitBranchUtil.$$$reportNull$$$0(26);
        }
        if ((state = repository.getState()) == Repository.State.DETACHED) {
            String currentRevision = repository.getCurrentRevision();
            assert (currentRevision != null) : "Current revision can't be null in DETACHED state, only on the fresh repository.";
            String string = DvcsUtil.getShortHash((String)currentRevision);
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(27);
            }
            return string;
        }
        String prefix = "";
        if (state == Repository.State.MERGING || state == Repository.State.REBASING) {
            prefix = state.toString() + " ";
        } else if (state == Repository.State.GRAFTING) {
            prefix = "Cherry-picking in ";
        } else if (state == Repository.State.REVERTING) {
            prefix = "Reverting in ";
        }
        GitLocalBranch branch = repository.getCurrentBranch();
        String branchName = branch == null ? "" : branch.getName();
        String string = prefix + branchName;
        if (string == null) {
            GitBranchUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Nullable
    public static GitRepository getCurrentRepository(@NotNull Project project) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(29);
        }
        return GitBranchUtil.getRepositoryOrGuess(project, DvcsUtil.getSelectedFile((Project)project));
    }

    @Nullable
    public static GitRepository getRepositoryOrGuess(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(30);
        }
        if (project.isDisposed()) {
            return null;
        }
        return (GitRepository)DvcsUtil.guessRepositoryForFile((Project)project, (RepositoryManager)GitUtil.getRepositoryManager(project), (VirtualFile)file, (String)GitVcsSettings.getInstance(project).getRecentRootPath());
    }

    @NotNull
    public static Collection<String> getCommonBranches(Collection<? extends GitRepository> repositories, boolean local) {
        Collection<String> names = local ? GitBranchUtil.convertBranchesToNames(GitBranchUtil.getCommonLocalBranches(repositories)) : GitBranchUtil.getBranchNamesWithoutRemoteHead(GitBranchUtil.getCommonRemoteBranches(repositories));
        List list = ((StreamEx)StreamEx.of(names).sorted(StringUtil::naturalCompare)).toList();
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    public static List<GitLocalBranch> getCommonLocalBranches(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(32);
        }
        return GitBranchUtil.collectCommon(repositories.stream().map(repository -> repository.getBranches().getLocalBranches()));
    }

    @NotNull
    public static List<GitRemoteBranch> getCommonRemoteBranches(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(33);
        }
        return GitBranchUtil.collectCommon(repositories.stream().map(repository -> repository.getBranches().getRemoteBranches()));
    }

    @NotNull
    public static <T> List<T> collectCommon(@NotNull Stream<? extends Collection<T>> groups) {
        if (groups == null) {
            GitBranchUtil.$$$reportNull$$$0(34);
        }
        return GitBranchUtil.collectCommon(groups, ContainerUtil.canonicalStrategy());
    }

    @NotNull
    public static <T> List<T> collectCommon(@NotNull Stream<? extends Collection<T>> groups, @NotNull TObjectHashingStrategy<T> hashingStrategy) {
        if (groups == null) {
            GitBranchUtil.$$$reportNull$$$0(35);
        }
        if (hashingStrategy == null) {
            GitBranchUtil.$$$reportNull$$$0(36);
        }
        ArrayList common = new ArrayList();
        boolean[] firstGroup = new boolean[]{true};
        groups.forEach(values -> {
            if (firstGroup[0]) {
                firstGroup[0] = false;
                common.addAll(values);
            } else {
                THashSet c = new THashSet(values, hashingStrategy);
                common.retainAll((Collection<?>)c);
            }
        });
        ArrayList arrayList = common;
        if (arrayList == null) {
            GitBranchUtil.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @NotNull
    public static <T extends GitReference> List<T> sortBranchesByName(@NotNull Collection<? extends T> branches2) {
        if (branches2 == null) {
            GitBranchUtil.$$$reportNull$$$0(38);
        }
        List list = branches2.stream().sorted(Comparator.comparing(GitReference::getFullName, NaturalComparator.INSTANCE)).collect(Collectors.toList());
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    public static Collection<String> getBranches(@NotNull Project project, @NotNull VirtualFile root, boolean localWanted, boolean remoteWanted, @Nullable String containingCommit) throws VcsException {
        String[] split;
        String output;
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(40);
        }
        if (root == null) {
            GitBranchUtil.$$$reportNull$$$0(41);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.BRANCH);
        handler.setSilent(true);
        handler.addParameters("--no-color");
        boolean remoteOnly = false;
        if (remoteWanted && localWanted) {
            handler.addParameters("-a");
            remoteOnly = false;
        } else if (remoteWanted) {
            handler.addParameters("-r");
            remoteOnly = true;
        }
        if (containingCommit != null) {
            handler.addParameters("--contains", containingCommit);
        }
        if ((output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0])).trim().length() == 0) {
            List<String> list;
            try {
                File headFile = GitUtil.getRepositoryForRoot(project, root).getRepositoryFiles().getHeadFile();
                String head = FileUtil.loadFile((File)headFile, (Charset)StandardCharsets.UTF_8).trim();
                String prefix = "ref: refs/heads/";
                list = head.startsWith("ref: refs/heads/") ? Collections.singletonList(head.substring("ref: refs/heads/".length())) : Collections.emptyList();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                List<String> list2 = Collections.emptyList();
                if (list2 == null) {
                    GitBranchUtil.$$$reportNull$$$0(43);
                }
                return list2;
            }
            if (list == null) {
                GitBranchUtil.$$$reportNull$$$0(42);
            }
            return list;
        }
        ArrayList<String> branches2 = new ArrayList<String>();
        for (String b : split = output.split("\n")) {
            boolean isRemote;
            if ((b = b.substring(2).trim()).equals(NO_BRANCH_NAME)) continue;
            String remotePrefix = null;
            if (b.startsWith("remotes/")) {
                remotePrefix = "remotes/";
            } else if (b.startsWith("refs/remotes/")) {
                remotePrefix = "refs/remotes/";
            }
            boolean bl = isRemote = remotePrefix != null || remoteOnly;
            if (isRemote) {
                int idx;
                if (!remoteOnly) {
                    b = b.substring(remotePrefix.length());
                }
                if ((idx = b.indexOf("HEAD ->")) > 0) continue;
            }
            branches2.add(b);
        }
        ArrayList<String> arrayList = branches2;
        if (arrayList == null) {
            GitBranchUtil.$$$reportNull$$$0(44);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 27: 
            case 28: 
            case 31: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 27: 
            case 28: 
            case 31: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranchName";
                break;
            }
            case 4: 
            case 21: 
            case 24: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 27: 
            case 28: 
            case 31: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchUtil";
                break;
            }
            case 6: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
            case 8: 
            case 20: 
            case 23: 
            case 29: 
            case 30: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranches";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranchOrRev";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertBranchesToNames";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTags";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNamesWithoutRemoteHead";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "stripRefsPrefix";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNameOrRev";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayableBranchText";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonBranches";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommon";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "sortBranchesByName";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTrackInfoForBranch";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTrackInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchOrRev";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 27: 
            case 28: 
            case 31: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertBranchesToNames";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllTags";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBranchNamesWithoutRemoteHead";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "stripRefsPrefix";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBranchNameOrRev";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNewBranchNameFromUser";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayableBranchText";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRepository";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryOrGuess";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCommonLocalBranches";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getCommonRemoteBranches";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "collectCommon";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "sortBranchesByName";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getBranches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 27: 
            case 28: 
            case 31: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

