/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ThreeState;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.CachingFileTester;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitNotInstalledException;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionIdentificationException;
import git4idea.config.NotificationErrorNotifier;
import git4idea.i18n.GitBundle;
import java.io.File;
import java.nio.file.NoSuchFileException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableManager {
    private static final Logger LOG = Logger.getInstance(GitExecutableManager.class);
    @NotNull
    private final GitExecutableDetector myExecutableDetector = new GitExecutableDetector();
    @NotNull
    private final CachingFileTester<GitVersion> myVersionCache = new CachingFileTester<GitVersion>(){

        @Override
        @NotNull
        protected GitVersion testExecutable(@NotNull GitExecutable executable) throws VcsException, ParseException {
            if (executable == null) {
                1.$$$reportNull$$$0(0);
            }
            GitVersion gitVersion = GitExecutableManager.doGetGitVersion(executable);
            if (gitVersion == null) {
                1.$$$reportNull$$$0(1);
            }
            return gitVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/config/GitExecutableManager$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/config/GitExecutableManager$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "testExecutable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "testExecutable";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    public static GitExecutableManager getInstance() {
        return (GitExecutableManager)ServiceManager.getService(GitExecutableManager.class);
    }

    private static GitVersion doGetGitVersion(@NotNull GitExecutable executable) throws VcsException, ParseException {
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(0);
        }
        GitVersion.Type type = null;
        if (executable instanceof GitExecutable.Unknown) {
            type = GitVersion.Type.UNDEFINED;
        } else if (executable instanceof GitExecutable.Wsl) {
            WSLDistribution distribution = ((GitExecutable.Wsl)executable).getDistribution();
            type = WSLUtil.isWsl1((WSLDistribution)distribution) == ThreeState.YES ? GitVersion.Type.WSL1 : GitVersion.Type.WSL2;
        }
        LOG.debug("Acquiring git version for " + executable);
        GitLineHandler handler = new GitLineHandler(null, new File("."), executable, GitCommand.VERSION, Collections.emptyList());
        handler.setPreValidateExecutable(false);
        handler.setSilent(false);
        handler.setTerminationTimeout(1000);
        handler.setStdoutSuppressed(false);
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        String rawResult = result2.getOutputOrThrow(new int[0]);
        GitVersion version = GitVersion.parse(rawResult, type);
        LOG.info("Git version for " + executable + ": " + version.toString());
        return version;
    }

    @NotNull
    public String getPathToGit() {
        String string = this.getPathToGit(null);
        if (string == null) {
            GitExecutableManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getPathToGit(@Nullable Project project) {
        String pathToGit = this.getPathToGit(project, true);
        if (pathToGit == null) {
            pathToGit = GitExecutableDetector.getDefaultExecutable();
        }
        String string = pathToGit;
        if (string == null) {
            GitExecutableManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private String getPathToGit(@Nullable Project project, boolean detectIfNeeded) {
        String path;
        String string = path = project != null ? GitVcsSettings.getInstance(project).getPathToGit() : null;
        if (path == null) {
            path = GitVcsApplicationSettings.getInstance().getSavedPathToGit();
        }
        if (path == null) {
            path = this.getDetectedExecutable(project, detectIfNeeded);
        }
        return path;
    }

    @NotNull
    public GitExecutable getExecutable(@Nullable Project project) {
        String path = this.getPathToGit(project);
        GitExecutable gitExecutable = this.getExecutable(path);
        if (gitExecutable == null) {
            GitExecutableManager.$$$reportNull$$$0(3);
        }
        return gitExecutable;
    }

    @NotNull
    public GitExecutable getExecutable(@NotNull String pathToGit) {
        Pair<String, WSLDistribution> pair;
        if (pathToGit == null) {
            GitExecutableManager.$$$reportNull$$$0(4);
        }
        if ((pair = GitExecutableManager.parseWslPath(pathToGit)) != null) {
            if (pair.second != null) {
                return new GitExecutable.Wsl((String)pair.first, (WSLDistribution)pair.second);
            }
            return new GitExecutable.Unknown("wsl-unknown", (String)pair.first, GitBundle.message("git.executable.unknown.wsl.distribution.error.message", new Object[0]));
        }
        return new GitExecutable.Local(pathToGit);
    }

    public static boolean supportWslExecutable() {
        return WSLUtil.isSystemCompatible() && Experiments.getInstance().isFeatureEnabled("wsl.p9.show.roots.in.file.chooser");
    }

    @Nullable
    private static WSLDistribution getProjectWslDistribution(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        String basePath = project.getBasePath();
        if (basePath == null) {
            return null;
        }
        Pair<String, WSLDistribution> pair = GitExecutableManager.parseWslPath(FileUtil.toSystemDependentName((String)basePath));
        return pair != null ? (WSLDistribution)pair.second : null;
    }

    @Nullable
    private static @Nullable Pair<String, @Nullable WSLDistribution> parseWslPath(@NotNull String path) {
        if (path == null) {
            GitExecutableManager.$$$reportNull$$$0(5);
        }
        if (!GitExecutableManager.supportWslExecutable()) {
            return null;
        }
        if (!path.startsWith("\\\\wsl$\\")) {
            return null;
        }
        int index = (path = StringUtil.trimStart((String)path, (String)"\\\\wsl$\\")).indexOf(92);
        if (index == -1) {
            return null;
        }
        String distName = path.substring(0, index);
        String wslPath = FileUtil.toSystemIndependentName((String)path.substring(index));
        WSLDistribution distribution = WSLUtil.getDistributionByMsId((String)distName);
        if (distribution == null) {
            LOG.debug(String.format("Unknown WSL distribution: %s, known distributions: %s", distName, StringUtil.join((Collection)WSLUtil.getAvailableDistributions(), WSLDistribution::getMsId, (String)", ")));
        }
        return Pair.create((Object)wslPath, (Object)distribution);
    }

    @NotNull
    public String getDetectedExecutable(@Nullable Project project) {
        String executable = this.getDetectedExecutable(project, true);
        String string = executable != null ? executable : GitExecutableDetector.getDefaultExecutable();
        if (string == null) {
            GitExecutableManager.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private String getDetectedExecutable(@Nullable Project project, boolean detectIfNeeded) {
        WSLDistribution distribution = GitExecutableManager.getProjectWslDistribution(project);
        if (detectIfNeeded) {
            return this.myExecutableDetector.detect(distribution);
        }
        return this.myExecutableDetector.getExecutable(distribution);
    }

    public void dropExecutableCache() {
        this.myExecutableDetector.clear();
    }

    @NotNull
    public GitVersion getVersion(@NotNull Project project) {
        String pathToGit;
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(7);
        }
        if ((pathToGit = this.getPathToGit(project, false)) == null) {
            GitVersion gitVersion = GitVersion.NULL;
            if (gitVersion == null) {
                GitExecutableManager.$$$reportNull$$$0(8);
            }
            return gitVersion;
        }
        GitExecutable executable = this.getExecutable(pathToGit);
        GitVersion gitVersion = this.getVersion(executable);
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(9);
        }
        return gitVersion;
    }

    @NotNull
    public GitVersion getVersion(@NotNull GitExecutable executable) {
        CachingFileTester.TestResult result2;
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(10);
        }
        if ((result2 = this.myVersionCache.getCachedResultFor(executable)) == null || result2.getResult() == null) {
            GitVersion gitVersion = GitVersion.NULL;
            if (gitVersion == null) {
                GitExecutableManager.$$$reportNull$$$0(11);
            }
            return gitVersion;
        }
        GitVersion gitVersion = (GitVersion)result2.getResult();
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(12);
        }
        return gitVersion;
    }

    @NotNull
    public GitVersion getVersionUnderModalProgressOrCancel(@NotNull Project project) throws ProcessCanceledException {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(13);
        }
        GitVersion gitVersion = (GitVersion)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            GitVersion version;
            GitExecutable executable = this.getExecutable(project);
            try {
                version = this.identifyVersion(executable);
            }
            catch (GitVersionIdentificationException e) {
                throw new ProcessCanceledException();
            }
            return version;
        }, GitBundle.getString("git.executable.version.progress.title"), true, project);
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(14);
        }
        return gitVersion;
    }

    @Nullable
    public GitVersion tryGetVersion(@NotNull Project project) {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(15);
        }
        return (GitVersion)GitExecutableManager.runUnderProgressIfNeeded(project, GitBundle.getString("git.executable.version.progress.title"), () -> {
            try {
                GitExecutable executable = this.getExecutable(project);
                return this.identifyVersion(executable);
            }
            catch (ProcessCanceledException e) {
                return null;
            }
            catch (GitVersionIdentificationException e) {
                return null;
            }
        });
    }

    static <T> T runUnderProgressIfNeeded(@Nullable Project project, @NotNull String title, @NotNull ThrowableComputable<T, RuntimeException> task2) {
        if (title == null) {
            GitExecutableManager.$$$reportNull$$$0(16);
        }
        if (task2 == null) {
            GitExecutableManager.$$$reportNull$$$0(17);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(task2, title, true, project);
        }
        return (T)task2.compute();
    }

    @NotNull
    public GitVersion identifyVersion(@NotNull String pathToGit) throws GitVersionIdentificationException {
        if (pathToGit == null) {
            GitExecutableManager.$$$reportNull$$$0(18);
        }
        GitVersion gitVersion = this.identifyVersion(this.getExecutable(pathToGit));
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(19);
        }
        return gitVersion;
    }

    @NotNull
    public GitVersion identifyVersion(@NotNull GitExecutable executable) throws GitVersionIdentificationException {
        CachingFileTester.TestResult result2;
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(20);
        }
        if ((result2 = this.myVersionCache.getResultFor(executable)).getResult() == null) {
            Exception e = result2.getException();
            if (e instanceof NoSuchFileException && executable.getExePath().equals(GitExecutableDetector.getDefaultExecutable())) {
                throw new GitNotInstalledException(GitBundle.message("executable.error.git.not.installed", new Object[0]), e);
            }
            throw new GitVersionIdentificationException(GitBundle.message("git.executable.validation.cant.identify.executable.message", executable), e);
        }
        GitVersion gitVersion = (GitVersion)result2.getResult();
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(21);
        }
        return gitVersion;
    }

    public void dropVersionCache(@NotNull GitExecutable executable) {
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(22);
        }
        this.myVersionCache.dropCache(executable);
    }

    public boolean testGitExecutableVersionValid(@NotNull Project project) {
        GitExecutable executable;
        GitVersion version;
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(23);
        }
        if ((version = this.identifyVersionOrDisplayError(project, executable = this.getExecutable(project))) == null) {
            return false;
        }
        GitExecutableProblemsNotifier executableProblemsNotifier = GitExecutableProblemsNotifier.getInstance(project);
        if (version.isSupported()) {
            executableProblemsNotifier.expireNotifications();
            return true;
        }
        GitExecutableProblemHandlersKt.showUnsupportedVersionError(project, version, new NotificationErrorNotifier(project));
        return false;
    }

    @Nullable
    private GitVersion identifyVersionOrDisplayError(@NotNull Project project, @NotNull GitExecutable executable) {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(24);
        }
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(25);
        }
        try {
            return this.identifyVersion(executable);
        }
        catch (GitVersionIdentificationException e) {
            GitExecutableProblemsNotifier.getInstance(project).notifyExecutionError(e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitExecutableManager";
                break;
            }
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToGit";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 13: 
            case 15: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitExecutableManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToGit";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectedExecutable";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionUnderModalProgressOrCancel";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "identifyVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doGetGitVersion";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 19: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExecutable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseWslPath";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getVersionUnderModalProgressOrCancel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryGetVersion";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runUnderProgressIfNeeded";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "identifyVersion";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "dropVersionCache";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "testGitExecutableVersionValid";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "identifyVersionOrDisplayError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

