/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.AppTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerKt;
import git4idea.index.GitStageTrackerListener;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.index.vfs.GitIndexVirtualFileKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitUntrackedFilesHolder;
import git4idea.status.GitChangeProvider;
import git4idea.status.GitStagingAreaHolder;
import git4idea.util.CollectionUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0003)*+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0001J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020 H\u0002J\u0016\u0010!\u001a\u00020\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001fH\u0002J\u0006\u0010%\u001a\u00020\u0017J\u001c\u0010&\u001a\u00020\u00172\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110(H\u0002R\u0019\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u0015\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lgit4idea/index/GitStageTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "dirtyScopeManager", "Lcom/intellij/openapi/vcs/changes/VcsDirtyScopeManager;", "Lorg/jetbrains/annotations/NotNull;", "getDirtyScopeManager", "()Lcom/intellij/openapi/vcs/changes/VcsDirtyScopeManager;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lgit4idea/index/GitStageTrackerListener;", "kotlin.jvm.PlatformType", "getProject", "()Lcom/intellij/openapi/project/Project;", "state", "Lgit4idea/index/GitStageTracker$State;", "getState", "()Lgit4idea/index/GitStageTracker$State;", "setState", "(Lgit4idea/index/GitStageTracker$State;)V", "addListener", "", "listener", "disposable", "dispose", "doUpdateState", "repository", "Lgit4idea/repo/GitRepository;", "gitRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "markDirty", "file", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "scheduleUpdateAll", "update", "updater", "Lkotlin/Function1;", "Companion", "RootState", "State", "intellij.vcs.git"})
public final class GitStageTracker
implements Disposable {
    private final EventDispatcher<GitStageTrackerListener> eventDispatcher;
    @NotNull
    private volatile State state;
    @NotNull
    private final Project project;
    private static final Logger LOG;
    public static final Companion Companion;

    private final VcsDirtyScopeManager getDirtyScopeManager() {
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsDirtyScopeManager, (String)"VcsDirtyScopeManager.getInstance(project)");
        return vcsDirtyScopeManager;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    public final void setState(@NotNull State state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"<set-?>");
        this.state = state;
    }

    public final void scheduleUpdateAll() {
        List<VirtualFile> gitRoots = this.gitRoots();
        LOG.debug("Mark dirty " + gitRoots);
        this.getDirtyScopeManager().filesDirty((Collection)CollectionsKt.emptyList(), (Collection)gitRoots);
    }

    private final void markDirty(VirtualFile file) {
        VirtualFile virtualFile = GitStageTrackerKt.access$getRoot(this.project, file);
        if (virtualFile == null) {
            return;
        }
        VirtualFile root = virtualFile;
        if (!this.gitRoots().contains(root)) {
            return;
        }
        LOG.debug("Mark dirty " + GitIndexVirtualFileKt.filePath(file));
        this.getDirtyScopeManager().fileDirty(GitIndexVirtualFileKt.filePath(file));
    }

    /*
     * WARNING - void declaration
     */
    private final void markDirty(List<? extends VFileEvent> events) {
        void $this$mapTo$iv$iv;
        GitIndexVirtualFile it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        VirtualFile virtualFile;
        Collection collection;
        void $this$mapTo$iv$iv2;
        GitRepository repo;
        Iterable $this$filterTo$iv$iv2;
        List<VirtualFile> gitRoots = this.gitRoots();
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gitRepositoryManager), (String)"GitRepositoryManager.getInstance(project)");
        List<GitRepository> list = gitRepositoryManager.getRepositories();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"GitRepositoryManager.get\u2026nce(project).repositories");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            boolean bl;
            block9: {
                repo = (GitRepository)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = events;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        VFileEvent e = (VFileEvent)element$iv;
                        boolean bl3 = false;
                        if (!GitUntrackedFilesHolder.totalRefreshNeeded(repo, e.getPath())) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it2;
            repo = (GitRepository)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v3 = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
            virtualFile = v3.getRoot();
            collection.add(virtualFile);
        }
        Set roots = CollectionsKt.intersect((Iterable)((List)destination$iv$iv), (Iterable)gitRoots);
        Iterable $this$mapNotNull$iv = events;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            GitIndexVirtualFile gitIndexVirtualFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl4 = false;
            VFileEvent it3 = (VFileEvent)element$iv$iv;
            boolean bl5 = false;
            VirtualFile virtualFile2 = it3.getFile();
            if (!(virtualFile2 instanceof GitIndexVirtualFile)) {
                virtualFile2 = null;
            }
            if ((GitIndexVirtualFile)virtualFile2 == null) continue;
            boolean bl6 = false;
            boolean bl7 = false;
            GitIndexVirtualFile it$iv$iv = gitIndexVirtualFile;
            boolean bl8 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Iterable $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$filter2 = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GitIndexVirtualFile)((Object)element$iv$iv);
            boolean bl9 = false;
            if (!gitRoots.contains(it.getRoot())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (GitIndexVirtualFile)((Object)item$iv$iv);
            collection = destination$iv$iv2;
            boolean bl10 = false;
            virtualFile = it.getFilePath();
            collection.add(virtualFile);
        }
        List files = (List)destination$iv$iv2;
        LOG.debug("Mark dirty", new Object[]{files, roots});
        this.getDirtyScopeManager().filesDirty((Collection)CollectionsKt.emptyList(), (Collection)roots);
        this.getDirtyScopeManager().filePathsDirty((Collection)files, (Collection)CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private final void doUpdateState(GitRepository repository) {
        void $this$associateByTo$iv$iv;
        GitFileStatus gitFileStatus;
        Object object;
        void $this$mapTo$iv$iv;
        LOG.debug("Updating " + repository.getRoot());
        GitUntrackedFilesHolder gitUntrackedFilesHolder = repository.getUntrackedFilesHolder();
        Intrinsics.checkExpressionValueIsNotNull((Object)gitUntrackedFilesHolder, (String)"repository.untrackedFilesHolder");
        Collection<FilePath> collection = gitUntrackedFilesHolder.getUntrackedFilePaths();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"repository.untrackedFilesHolder.untrackedFilePaths");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            FilePath filePath = (FilePath)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            gitFileStatus = GitFileStatusKt.untrackedStatus((FilePath)v2);
            object.add(gitFileStatus);
        }
        List untracked = (List)destination$iv$iv;
        GitStagingAreaHolder gitStagingAreaHolder = repository.getStagingAreaHolder();
        Intrinsics.checkExpressionValueIsNotNull((Object)gitStagingAreaHolder, (String)"repository.stagingAreaHolder");
        List<GitFileStatus> list = gitStagingAreaHolder.getAllRecords();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"repository.stagingAreaHolder.allRecords");
        Iterable $this$associateBy$iv = CollectionsKt.union((Iterable)list, (Iterable)untracked);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable $i$f$mapTo22 = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            GitFileStatus gitFileStatus2 = (GitFileStatus)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            gitFileStatus = it.getPath();
            object.put(gitFileStatus, element$iv$iv);
        }
        Map status = MapsKt.toMutableMap((Map)destination$iv$iv2);
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileDocumentManager, (String)"FileDocumentManager.getInstance()");
        for (Document document : fileDocumentManager.getUnsavedDocuments()) {
            GitFileStatus fileStatus;
            VirtualFile root;
            VirtualFile file;
            if (FileDocumentManager.getInstance().getFile(document) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileDocumentManager.getI\u2026ile(document) ?: continue");
            if (!file.isValid() || !FileDocumentManager.getInstance().isFileModified(file)) continue;
            if (GitStageTrackerKt.access$getRoot(this.project, file) == null) {
                continue;
            }
            if (Intrinsics.areEqual((Object)root, (Object)repository.getRoot()) ^ true) continue;
            FilePath filePath = GitIndexVirtualFileKt.filePath(file);
            if (repository.getIgnoredFilesHolder().containsFile(filePath)) continue;
            GitFileStatus gitFileStatus3 = fileStatus = (GitFileStatus)status.get(filePath);
            if (gitFileStatus3 != null && !gitFileStatus3.isTracked()) continue;
            if (file instanceof GitIndexVirtualFile) {
                GitFileStatus gitFileStatus4 = fileStatus;
                if ((gitFileStatus4 != null ? gitFileStatus4.getStagedStatus() : null) == null) {
                    GitFileStatus gitFileStatus5 = fileStatus;
                    GitFileStatus gitFileStatus6 = fileStatus;
                    status.put(filePath, new GitFileStatus('M', gitFileStatus5 != null ? gitFileStatus5.getWorkTree() : (char)' ', filePath, (FilePath)(gitFileStatus6 != null ? gitFileStatus6.getOrigPath() : null)));
                    continue;
                }
            }
            if (!file.isInLocalFileSystem()) continue;
            GitFileStatus gitFileStatus7 = fileStatus;
            if ((gitFileStatus7 != null ? gitFileStatus7.getUnStagedStatus() : null) != null) continue;
            GitFileStatus gitFileStatus8 = fileStatus;
            GitFileStatus gitFileStatus9 = fileStatus;
            status.put(filePath, new GitFileStatus(gitFileStatus8 != null ? gitFileStatus8.getIndex() : (char)' ', 'M', filePath, (FilePath)(gitFileStatus9 != null ? gitFileStatus9.getOrigPath() : null)));
        }
        VirtualFile virtualFile = repository.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"repository.root");
        RootState newRootState = new RootState(virtualFile, status);
        BaseSingleTaskControllerKt.runInEdt((Disposable)this, (Function0)((Function0)new Function0<Unit>(this, repository, newRootState){
            final /* synthetic */ GitStageTracker this$0;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ RootState $newRootState;

            public final void invoke() {
                GitStageTracker.access$update(this.this$0, (Function1)new Function1<State, State>(this){
                    final /* synthetic */ doUpdateState.1 this$0;

                    @NotNull
                    public final State invoke(@NotNull State it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        VirtualFile virtualFile = this.this$0.$repository.getRoot();
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"repository.root");
                        return it.updatedWith$intellij_vcs_git(virtualFile, this.this$0.$newRootState);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = gitStageTracker;
                this.$repository = gitRepository;
                this.$newRootState = rootState;
                super(0);
            }
        }));
    }

    public final void addListener(@NotNull GitStageTrackerListener listener, @NotNull Disposable disposable) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
        this.eventDispatcher.addListener((EventListener)listener, disposable);
    }

    private final List<VirtualFile> gitRoots() {
        return GitStageTrackerKt.access$gitRoots(this.project);
    }

    private final void update(Function1<? super State, State> updater) {
        this.state = (State)updater.invoke((Object)this.state);
        LOG.debug("New state", new Object[]{this.state});
        ((GitStageTrackerListener)this.eventDispatcher.getMulticaster()).update();
    }

    public void dispose() {
        this.state = State.Companion.getEMPTY$intellij_vcs_git();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public GitStageTracker(@NotNull Project project) {
        Map map2;
        void $this$associateWith$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        EventDispatcher eventDispatcher = EventDispatcher.create(GitStageTrackerListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(G\u2026ckerListener::class.java)");
        this.eventDispatcher = eventDispatcher;
        Iterable iterable = this.gitRoots();
        GitStageTracker gitStageTracker = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)element$iv$iv;
            Object t = element$iv$iv;
            map2 = result$iv;
            boolean bl = false;
            RootState rootState = RootState.Companion.empty((VirtualFile)it);
            map2.put(t, rootState);
        }
        Map map3 = map2 = (Map)result$iv;
        gitStageTracker.state = new State(map3);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                this.markDirty(events);
            }
        });
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)new VcsListener(){

            public final void directoryMappingChanged() {
                BaseSingleTaskControllerKt.runInEdt((Disposable)this, (Function0)((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        final List roots = this.gitRoots();
                        this.update((Function1<? super State, State>)((Function1)new Function1<State, State>(){

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final State invoke(@NotNull State oldState) {
                                Map map2;
                                Intrinsics.checkParameterIsNotNull((Object)oldState, (String)"oldState");
                                Iterable $this$associateWith$iv = roots;
                                boolean $i$f$associateWith = false;
                                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                                Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                                boolean $i$f$associateWithTo = false;
                                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                                    void it;
                                    VirtualFile virtualFile = (VirtualFile)element$iv$iv;
                                    Object t = element$iv$iv;
                                    map2 = result$iv;
                                    boolean bl = false;
                                    RootState rootState = oldState.getRootStates().get(it);
                                    if (rootState == null) {
                                        rootState = RootState.Companion.empty((VirtualFile)it);
                                    }
                                    RootState rootState2 = rootState;
                                    map2.put(t, rootState2);
                                }
                                Map map3 = map2 = (Map)result$iv;
                                return new State(map3);
                            }
                        }));
                    }
                }));
            }
        });
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void unsavedDocumentDropped(@NotNull Document document) {
                Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
                if (virtualFile == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"FileDocumentManager.getI\u2026tFile(document) ?: return");
                VirtualFile file = virtualFile;
                file.putUserData(GitStageTrackerKt.access$getPROCESSED$p(), null);
                this.markDirty(file);
            }

            public void fileContentReloaded(@NotNull VirtualFile file, @NotNull Document document) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
                file.putUserData(GitStageTrackerKt.access$getPROCESSED$p(), null);
                this.markDirty(file);
            }

            public void fileWithNoDocumentChanged(@NotNull VirtualFile file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                file.putUserData(GitStageTrackerKt.access$getPROCESSED$p(), null);
                this.markDirty(file);
            }

            public void beforeDocumentSaving(@NotNull Document document) {
                Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
                if (virtualFile == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"FileDocumentManager.getI\u2026tFile(document) ?: return");
                VirtualFile file = virtualFile;
                file.putUserData(GitStageTrackerKt.access$getPROCESSED$p(), null);
            }
        });
        connection.subscribe(GitChangeProvider.TOPIC, (Object)new GitChangeProvider.ChangeProviderListener(){

            @Override
            public final void repositoryUpdated(@NotNull GitRepository repository) {
                Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
                this.doUpdateState(repository);
            }
        });
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory, (String)"EditorFactory.getInstance()");
        editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(event.getDocument());
                if (virtualFile == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"FileDocumentManager.getI\u2026event.document) ?: return");
                VirtualFile file = virtualFile;
                if (file.getUserData(GitStageTrackerKt.access$getPROCESSED$p()) == null) {
                    file.putUserData(GitStageTrackerKt.access$getPROCESSED$p(), (Object)true);
                    this.markDirty(file);
                }
            }
        }, (Disposable)this);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(GitStageTracker.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(GitStageTracker::class.java)");
        LOG = logger;
    }

    @JvmStatic
    public static final GitStageTracker getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0013\u001a\u00020\u0011J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0006\u0010\u0016\u001a\u00020\u0011J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lgit4idea/index/GitStageTracker$RootState;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "statuses", "", "Lcom/intellij/openapi/vcs/FilePath;", "Lgit4idea/index/GitFileStatus;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/Map;)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getStatuses", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hasStagedFiles", "hashCode", "", "isEmpty", "toString", "", "Companion", "intellij.vcs.git"})
    public static final class RootState {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final Map<FilePath, GitFileStatus> statuses;
        public static final Companion Companion = new Companion(null);

        public final boolean hasStagedFiles() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.statuses.values();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitFileStatus line = (GitFileStatus)element$iv;
                        boolean bl2 = false;
                        if (!(line.getStagedStatus() != null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean isEmpty() {
            return this.statuses.isEmpty();
        }

        @NotNull
        public String toString() {
            return "RootState(root=" + this.root.getName() + ", statuses=" + CollectionUtilKt.toShortenedString$default(this.statuses, ",\n", 0, null, 6, null) + ')';
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public final Map<FilePath, GitFileStatus> getStatuses() {
            return this.statuses;
        }

        public RootState(@NotNull VirtualFile root, @NotNull Map<FilePath, GitFileStatus> statuses) {
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            Intrinsics.checkParameterIsNotNull(statuses, (String)"statuses");
            this.root = root;
            this.statuses = statuses;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        @NotNull
        public final Map<FilePath, GitFileStatus> component2() {
            return this.statuses;
        }

        @NotNull
        public final RootState copy(@NotNull VirtualFile root, @NotNull Map<FilePath, GitFileStatus> statuses) {
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            Intrinsics.checkParameterIsNotNull(statuses, (String)"statuses");
            return new RootState(root, statuses);
        }

        public static /* synthetic */ RootState copy$default(RootState rootState, VirtualFile virtualFile, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = rootState.root;
            }
            if ((n & 2) != 0) {
                map2 = rootState.statuses;
            }
            return rootState.copy(virtualFile, map2);
        }

        public int hashCode() {
            VirtualFile virtualFile = this.root;
            Map<FilePath, GitFileStatus> map2 = this.statuses;
            return (virtualFile != null ? virtualFile.hashCode() : 0) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RootState)) break block3;
                    RootState rootState = (RootState)object;
                    if (!Intrinsics.areEqual((Object)this.root, (Object)rootState.root) || !Intrinsics.areEqual(this.statuses, rootState.statuses)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/index/GitStageTracker$RootState$Companion;", "", "()V", "empty", "Lgit4idea/index/GitStageTracker$RootState;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.git"})
        public static final class Companion {
            @NotNull
            public final RootState empty(@NotNull VirtualFile root) {
                Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
                return new RootState(root, MapsKt.emptyMap());
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0012\u001a\u00020\u0010J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001d\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001aR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lgit4idea/index/GitStageTracker$State;", "", "rootStates", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lgit4idea/index/GitStageTracker$RootState;", "(Ljava/util/Map;)V", "getRootStates", "()Ljava/util/Map;", "stagedRoots", "", "getStagedRoots", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hasStagedRoots", "hashCode", "", "toString", "", "updatedWith", "root", "newState", "updatedWith$intellij_vcs_git", "Companion", "intellij.vcs.git"})
    public static final class State {
        @NotNull
        private final Map<VirtualFile, RootState> rootStates;
        @NotNull
        private static final State EMPTY;
        public static final Companion Companion;

        @NotNull
        public final Set<VirtualFile> getStagedRoots() {
            Map<VirtualFile, RootState> $this$filterValues$iv = this.rootStates;
            boolean $i$f$filterValues = false;
            LinkedHashMap<VirtualFile, RootState> result$iv = new LinkedHashMap<VirtualFile, RootState>();
            Map<VirtualFile, RootState> map2 = $this$filterValues$iv;
            boolean bl = false;
            for (Map.Entry<VirtualFile, RootState> entry$iv : map2.entrySet()) {
                RootState p1 = entry$iv.getValue();
                boolean bl2 = false;
                if (!p1.hasStagedFiles()) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            return ((Map)result$iv).keySet();
        }

        public final boolean hasStagedRoots() {
            boolean bl;
            block3: {
                Map<VirtualFile, RootState> $this$any$iv = this.rootStates;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Map<VirtualFile, RootState> map2 = $this$any$iv;
                    boolean bl2 = false;
                    Iterator<Map.Entry<VirtualFile, RootState>> iterator = map2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<VirtualFile, RootState> element$iv;
                        Map.Entry<VirtualFile, RootState> it = element$iv = iterator.next();
                        boolean bl3 = false;
                        if (!it.getValue().hasStagedFiles()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @NotNull
        public final State updatedWith$intellij_vcs_git(@NotNull VirtualFile root, @NotNull RootState newState) {
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            Intrinsics.checkParameterIsNotNull((Object)newState, (String)"newState");
            boolean bl = false;
            Map result2 = new LinkedHashMap();
            result2.putAll(this.rootStates);
            result2.put(root, newState);
            return new State(result2);
        }

        @NotNull
        public String toString() {
            return "State(" + CollectionUtilKt.toShortenedString$default(this.rootStates, "\n", 0, (Function1)toString.1.INSTANCE, 2, null);
        }

        @NotNull
        public final Map<VirtualFile, RootState> getRootStates() {
            return this.rootStates;
        }

        public State(@NotNull Map<VirtualFile, RootState> rootStates) {
            Intrinsics.checkParameterIsNotNull(rootStates, (String)"rootStates");
            this.rootStates = rootStates;
        }

        static {
            Companion = new Companion(null);
            EMPTY = new State(MapsKt.emptyMap());
        }

        @NotNull
        public final Map<VirtualFile, RootState> component1() {
            return this.rootStates;
        }

        @NotNull
        public final State copy(@NotNull Map<VirtualFile, RootState> rootStates) {
            Intrinsics.checkParameterIsNotNull(rootStates, (String)"rootStates");
            return new State(rootStates);
        }

        public static /* synthetic */ State copy$default(State state, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = state.rootStates;
            }
            return state.copy(map2);
        }

        public int hashCode() {
            Map<VirtualFile, RootState> map2 = this.rootStates;
            return map2 != null ? ((Object)map2).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (!Intrinsics.areEqual(this.rootStates, state.rootStates)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/index/GitStageTracker$State$Companion;", "", "()V", "EMPTY", "Lgit4idea/index/GitStageTracker$State;", "getEMPTY$intellij_vcs_git", "()Lgit4idea/index/GitStageTracker$State;", "intellij.vcs.git"})
        public static final class Companion {
            @NotNull
            public final State getEMPTY$intellij_vcs_git() {
                return EMPTY;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\t\u001a\u00020\nH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgit4idea/index/GitStageTracker$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lgit4idea/index/GitStageTracker;", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    public static final class Companion {
        @JvmStatic
        public final GitStageTracker getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return (GitStageTracker)project.getService(GitStageTracker.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

