/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitStageTracker;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.index.vfs.GitIndexVirtualFileKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0006\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"PROCESSED", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "file", "gitRoots", "", "status", "Lgit4idea/index/GitFileStatus;", "Lgit4idea/index/GitStageTracker;", "intellij.vcs.git"})
public final class GitStageTrackerKt {
    private static final Key<Boolean> PROCESSED;

    private static final VirtualFile getRoot(Project project, VirtualFile file) {
        return file instanceof GitIndexVirtualFile ? ((GitIndexVirtualFile)file).getRoot() : (file.isInLocalFileSystem() ? ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(file) : null);
    }

    private static final List<VirtualFile> gitRoots(Project project) {
        Object[] objectArray = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)GitVcs.getInstance(project));
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ProjectLevelVcsManager.g\u2026Vcs.getInstance(project))");
        return ArraysKt.toList((Object[])objectArray);
    }

    @Nullable
    public static final GitFileStatus status(@NotNull GitStageTracker $this$status, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)$this$status, (String)"$this$status");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        VirtualFile virtualFile = GitStageTrackerKt.getRoot($this$status.getProject(), file);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        FilePath filePath = GitIndexVirtualFileKt.filePath(file);
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance($this$status.getProject()).getRepositoryForRootQuick(root);
        if (gitRepository != null && (gitRepository = gitRepository.getIgnoredFilesHolder()) != null) {
            if (gitRepository.containsFile(filePath)) {
                return GitFileStatusKt.ignoredStatus(filePath);
            }
        }
        GitStageTracker.RootState rootState = $this$status.getState().getRootStates().get(root);
        if (rootState == null) {
            return null;
        }
        GitStageTracker.RootState rootState2 = rootState;
        GitFileStatus gitFileStatus = rootState2.getStatuses().get(filePath);
        if (gitFileStatus == null) {
            return GitFileStatusKt.notChangedStatus(filePath);
        }
        return gitFileStatus;
    }

    static {
        Key key = Key.create((String)"GitStageTracker.file.processed");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<Boolean>(\"Git\u2026eTracker.file.processed\")");
        PROCESSED = key;
    }

    public static final /* synthetic */ VirtualFile access$getRoot(Project project, VirtualFile file) {
        return GitStageTrackerKt.getRoot(project, file);
    }

    public static final /* synthetic */ List access$gitRoots(Project project) {
        return GitStageTrackerKt.gitRoots(project);
    }

    public static final /* synthetic */ Key access$getPROCESSED$p() {
        return PROCESSED;
    }
}

