/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorFactory {
    public static EditorFactory getInstance() {
        return (EditorFactory)ApplicationManager.getApplication().getService(EditorFactory.class);
    }

    @NotNull
    public abstract Document createDocument(@NotNull CharSequence var1);

    @NotNull
    public abstract Document createDocument(char @NotNull [] var1);

    public abstract Editor createEditor(@NotNull Document var1);

    public abstract Editor createViewer(@NotNull Document var1);

    public abstract Editor createEditor(@NotNull Document var1, @Nullable Project var2);

    public abstract Editor createEditor(@NotNull Document var1, @Nullable Project var2, @NotNull EditorKind var3);

    public abstract Editor createEditor(@NotNull Document var1, Project var2, @NotNull FileType var3, boolean var4);

    public abstract Editor createEditor(@NotNull Document var1, Project var2, @NotNull VirtualFile var3, boolean var4);

    public abstract Editor createEditor(@NotNull Document var1, Project var2, @NotNull VirtualFile var3, boolean var4, @NotNull EditorKind var5);

    public abstract Editor createViewer(@NotNull Document var1, @Nullable Project var2);

    public abstract Editor createViewer(@NotNull Document var1, @Nullable Project var2, @NotNull EditorKind var3);

    public abstract void releaseEditor(@NotNull Editor var1);

    @NotNull
    public abstract Stream<Editor> editors(@NotNull Document var1, @Nullable Project var2);

    @NotNull
    public final Stream<Editor> editors(@NotNull Document document) {
        if (document == null) {
            EditorFactory.$$$reportNull$$$0(0);
        }
        Stream<Editor> stream = this.editors(document, null);
        if (stream == null) {
            EditorFactory.$$$reportNull$$$0(1);
        }
        return stream;
    }

    public final Editor @NotNull [] getEditors(@NotNull Document document, @Nullable Project project) {
        if (document == null) {
            EditorFactory.$$$reportNull$$$0(2);
        }
        Editor[] editorArray = (Editor[])this.editors(document, project).toArray(Editor[]::new);
        if (editorArray == null) {
            EditorFactory.$$$reportNull$$$0(3);
        }
        return editorArray;
    }

    public final Editor @NotNull [] getEditors(@NotNull Document document) {
        if (document == null) {
            EditorFactory.$$$reportNull$$$0(4);
        }
        return this.getEditors(document, null);
    }

    public abstract Editor @NotNull [] getAllEditors();

    @Deprecated
    public abstract void addEditorFactoryListener(@NotNull EditorFactoryListener var1);

    public abstract void addEditorFactoryListener(@NotNull EditorFactoryListener var1, @NotNull Disposable var2);

    @Deprecated
    public abstract void removeEditorFactoryListener(@NotNull EditorFactoryListener var1);

    @NotNull
    public abstract EditorEventMulticaster getEventMulticaster();

    public abstract void refreshAllEditors();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/EditorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/EditorFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "editors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "editors";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

