/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTypeRegistry {
    public static Getter<FileTypeRegistry> ourInstanceGetter;

    public abstract boolean isFileIgnored(@NotNull VirtualFile var1);

    public boolean isFileOfType(@NotNull VirtualFile file, @NotNull FileType type) {
        FileType actualType;
        if (file == null) {
            FileTypeRegistry.$$$reportNull$$$0(0);
        }
        if (type == null) {
            FileTypeRegistry.$$$reportNull$$$0(1);
        }
        return (actualType = file.getFileType()) == type || "Scratch".equals(actualType.getName()) && type == this.getFileTypeByFileName(file.getNameSequence());
    }

    @Nullable
    public LanguageFileType findFileTypeByLanguage(@NotNull Language language) {
        if (language == null) {
            FileTypeRegistry.$$$reportNull$$$0(2);
        }
        return language.findMyFileType(this.getRegisteredFileTypes());
    }

    public static FileTypeRegistry getInstance() {
        if (ourInstanceGetter == null) {
            return (FileTypeRegistry)ApplicationManager.getApplication().getPicoContainer().getComponentInstance((Object)"com.intellij.openapi.fileTypes.FileTypeManager");
        }
        return (FileTypeRegistry)ourInstanceGetter.get();
    }

    public abstract FileType @NotNull [] getRegisteredFileTypes();

    @NotNull
    public abstract FileType getFileTypeByFile(@NotNull VirtualFile var1);

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file, byte @Nullable [] content) {
        if (file == null) {
            FileTypeRegistry.$$$reportNull$$$0(3);
        }
        FileType fileType = this.getFileTypeByFile(file);
        if (fileType == null) {
            FileTypeRegistry.$$$reportNull$$$0(4);
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull @NonNls CharSequence fileNameSeq) {
        if (fileNameSeq == null) {
            FileTypeRegistry.$$$reportNull$$$0(5);
        }
        FileType fileType = this.getFileTypeByFileName(fileNameSeq.toString());
        if (fileType == null) {
            FileTypeRegistry.$$$reportNull$$$0(6);
        }
        return fileType;
    }

    @NotNull
    public abstract FileType getFileTypeByFileName(@NotNull @NonNls String var1);

    @NotNull
    public abstract FileType getFileTypeByExtension(@NonNls @NotNull String var1);

    @Nullable
    public abstract FileType findFileTypeByName(@NonNls @NotNull String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/FileTypeRegistry";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameSeq";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/FileTypeRegistry";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFileOfType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFile";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface FileTypeDetector {
        public static final ExtensionPointName<FileTypeDetector> EP_NAME = ExtensionPointName.create((String)"com.intellij.fileTypeDetector");

        @Nullable
        public FileType detect(@NotNull VirtualFile var1, @NotNull ByteSequence var2, @Nullable CharSequence var3);

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
        @Nullable
        default public Collection<? extends FileType> getDetectedFileTypes() {
            return null;
        }

        default public int getDesiredContentPrefixLength() {
            return 1024;
        }

        @Deprecated
        default public int getVersion() {
            return 0;
        }
    }
}

