/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumbService {
    public static final Topic<DumbModeListener> DUMB_MODE = new Topic("dumb mode", DumbModeListener.class);
    private static final NotNullLazyKey<DumbService, Project> INSTANCE_KEY = ServiceManager.createLazyKey(DumbService.class);

    public abstract ModificationTracker getModificationTracker();

    public abstract boolean isDumb();

    public static boolean isDumb(@NotNull Project project) {
        if (project == null) {
            DumbService.$$$reportNull$$$0(0);
        }
        return DumbService.getInstance(project).isDumb();
    }

    @NotNull
    public static <T> List<T> getDumbAwareExtensions(@NotNull Project project, @NotNull ExtensionPointName<T> extensionPoint) {
        List list;
        if (project == null) {
            DumbService.$$$reportNull$$$0(1);
        }
        if (extensionPoint == null) {
            DumbService.$$$reportNull$$$0(2);
        }
        if ((list = extensionPoint.getExtensionList()).isEmpty()) {
            List list2 = list;
            if (list2 == null) {
                DumbService.$$$reportNull$$$0(3);
            }
            return list2;
        }
        DumbService dumbService = DumbService.getInstance(project);
        List<T> list3 = dumbService.filterByDumbAwareness(list);
        if (list3 == null) {
            DumbService.$$$reportNull$$$0(4);
        }
        return list3;
    }

    @NotNull
    public static <T> List<T> getDumbAwareExtensions(@NotNull Project project, @NotNull ProjectExtensionPointName<T> extensionPoint) {
        if (project == null) {
            DumbService.$$$reportNull$$$0(5);
        }
        if (extensionPoint == null) {
            DumbService.$$$reportNull$$$0(6);
        }
        DumbService dumbService = DumbService.getInstance(project);
        List<T> list = dumbService.filterByDumbAwareness(extensionPoint.getExtensions((AreaInstance)project));
        if (list == null) {
            DumbService.$$$reportNull$$$0(7);
        }
        return list;
    }

    public abstract void runWhenSmart(@NotNull Runnable var1);

    public abstract void waitForSmartMode();

    public <T> T runReadActionInSmartMode(@NotNull Computable<T> r) {
        if (r == null) {
            DumbService.$$$reportNull$$$0(8);
        }
        Ref result = new Ref();
        this.runReadActionInSmartMode(() -> result.set(r.compute()));
        return (T)result.get();
    }

    @Nullable
    public <T> T tryRunReadActionInSmartMode(@NotNull Computable<T> task, @Nullable String notification) {
        if (task == null) {
            DumbService.$$$reportNull$$$0(9);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            try {
                return (T)task.compute();
            }
            catch (IndexNotReadyException e) {
                if (notification != null) {
                    this.showDumbModeNotification(notification);
                }
                return null;
            }
        }
        return this.runReadActionInSmartMode(task);
    }

    public void runReadActionInSmartMode(@NotNull Runnable r) {
        boolean success;
        if (r == null) {
            DumbService.$$$reportNull$$$0(10);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            r.run();
            return;
        }
        do {
            this.waitForSmartMode();
        } while (!(success = ((Boolean)ReadAction.compute(() -> {
            if (this.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (this.isDumb()) {
                return false;
            }
            r.run();
            return true;
        })).booleanValue()));
    }

    @Deprecated
    public void repeatUntilPassesInSmartMode(@NotNull Runnable r) {
        if (r == null) {
            DumbService.$$$reportNull$$$0(11);
        }
        while (true) {
            this.waitForSmartMode();
            try {
                r.run();
                return;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                continue;
            }
            break;
        }
    }

    public abstract void smartInvokeLater(@NotNull Runnable var1);

    public abstract void smartInvokeLater(@NotNull Runnable var1, @NotNull ModalityState var2);

    public static DumbService getInstance(@NotNull Project project) {
        if (project == null) {
            DumbService.$$$reportNull$$$0(12);
        }
        return (DumbService)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    @NotNull
    public <T> List<T> filterByDumbAwareness(T @NotNull [] array) {
        if (array == null) {
            DumbService.$$$reportNull$$$0(13);
        }
        List<T> list = this.filterByDumbAwareness(Arrays.asList(array));
        if (list == null) {
            DumbService.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public <T> List<T> filterByDumbAwareness(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            DumbService.$$$reportNull$$$0(15);
        }
        if (this.isDumb()) {
            ArrayList<T> result = new ArrayList<T>(collection.size());
            for (T element : collection) {
                if (!DumbService.isDumbAware(element)) continue;
                result.add(element);
            }
            ArrayList<T> arrayList = result;
            if (arrayList == null) {
                DumbService.$$$reportNull$$$0(16);
            }
            return arrayList;
        }
        return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
    }

    public abstract void queueTask(@NotNull DumbModeTask var1);

    public abstract void cancelTask(@NotNull DumbModeTask var1);

    @ApiStatus.Internal
    public abstract void cancelAllTasksAndWait();

    public abstract void completeJustSubmittedTasks();

    public abstract JComponent wrapGently(@NotNull JComponent var1, @NotNull Disposable var2);

    public abstract JComponent wrapWithSpoiler(@NotNull JComponent var1, @NotNull Runnable var2, @NotNull Disposable var3);

    public void makeDumbAware(final @NotNull JComponent componentToDisable, @NotNull Disposable parentDisposable) {
        if (componentToDisable == null) {
            DumbService.$$$reportNull$$$0(17);
        }
        if (parentDisposable == null) {
            DumbService.$$$reportNull$$$0(18);
        }
        componentToDisable.setEnabled(!this.isDumb());
        this.getProject().getMessageBus().connect(parentDisposable).subscribe(DUMB_MODE, (Object)new DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                componentToDisable.setEnabled(false);
            }

            @Override
            public void exitDumbMode() {
                componentToDisable.setEnabled(true);
            }
        });
    }

    public abstract void showDumbModeNotification(@NotNull @NlsContexts.PopupContent String var1);

    public abstract void showDumbModeActionBalloon(@NotNull @NlsContexts.PopupContent String var1, @NotNull Runnable var2);

    public abstract Project getProject();

    @Contract(value="null -> false", pure=true)
    public static boolean isDumbAware(Object o) {
        if (o instanceof PossiblyDumbAware) {
            return ((PossiblyDumbAware)o).isDumbAware();
        }
        return o instanceof DumbAware;
    }

    @Deprecated
    public abstract void setAlternativeResolveEnabled(boolean var1);

    public void withAlternativeResolveEnabled(@NotNull Runnable runnable) {
        if (runnable == null) {
            DumbService.$$$reportNull$$$0(19);
        }
        this.setAlternativeResolveEnabled(true);
        try {
            runnable.run();
        }
        finally {
            this.setAlternativeResolveEnabled(false);
        }
    }

    public <T, E extends Throwable> T computeWithAlternativeResolveEnabled(@NotNull ThrowableComputable<T, E> runnable) throws E {
        if (runnable == null) {
            DumbService.$$$reportNull$$$0(20);
        }
        this.setAlternativeResolveEnabled(true);
        try {
            Object object = runnable.compute();
            return (T)object;
        }
        finally {
            this.setAlternativeResolveEnabled(false);
        }
    }

    public <E extends Throwable> void runWithAlternativeResolveEnabled(@NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            DumbService.$$$reportNull$$$0(21);
        }
        this.setAlternativeResolveEnabled(true);
        try {
            runnable.run();
        }
        finally {
            this.setAlternativeResolveEnabled(false);
        }
    }

    public abstract boolean isAlternativeResolveEnabled();

    @Deprecated
    public static void allowStartingDumbModeInside(@NotNull DumbModePermission permission, @NotNull Runnable runnable) {
        if (permission == null) {
            DumbService.$$$reportNull$$$0(22);
        }
        if (runnable == null) {
            DumbService.$$$reportNull$$$0(23);
        }
        runnable.run();
    }

    public abstract void suspendIndexingAndRun(@NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String var1, @NotNull Runnable var2);

    public abstract boolean isSuspendedDumbMode();

    @ApiStatus.Internal
    public abstract void unsafeRunWhenSmart(@NotNull Runnable var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/DumbService";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentToDisable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permission";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/DumbService";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDumbAwareExtensions";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByDumbAwareness";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDumb";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDumbAwareExtensions";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 14: 
            case 16: {
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runReadActionInSmartMode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryRunReadActionInSmartMode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "repeatUntilPassesInSmartMode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterByDumbAwareness";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "makeDumbAware";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "withAlternativeResolveEnabled";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "computeWithAlternativeResolveEnabled";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "runWithAlternativeResolveEnabled";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "allowStartingDumbModeInside";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DumbModeListener {
        default public void enteredDumbMode() {
        }

        default public void exitDumbMode() {
        }
    }
}

