/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StdArrangementSettings
implements ArrangementSettings {
    @NotNull
    private final List<ArrangementSectionRule> mySectionRules;
    @NotNull
    private final List<ArrangementGroupingRule> myGroupings;
    @NotNull
    protected final List<StdArrangementMatchRule> myRulesByPriority;

    public StdArrangementSettings() {
        this.mySectionRules = new ArrayList<ArrangementSectionRule>();
        this.myGroupings = new ArrayList<ArrangementGroupingRule>();
        this.myRulesByPriority = Collections.synchronizedList(new ArrayList());
    }

    public StdArrangementSettings(@NotNull List<? extends ArrangementSectionRule> rules) {
        if (rules == null) {
            StdArrangementSettings.$$$reportNull$$$0(0);
        }
        this(Collections.emptyList(), rules);
    }

    public StdArrangementSettings(@NotNull List<? extends ArrangementGroupingRule> groupingRules, @NotNull List<? extends ArrangementSectionRule> sectionRules) {
        if (groupingRules == null) {
            StdArrangementSettings.$$$reportNull$$$0(1);
        }
        if (sectionRules == null) {
            StdArrangementSettings.$$$reportNull$$$0(2);
        }
        this.mySectionRules = new ArrayList<ArrangementSectionRule>();
        this.myGroupings = new ArrayList<ArrangementGroupingRule>();
        this.myRulesByPriority = Collections.synchronizedList(new ArrayList());
        this.myGroupings.addAll(groupingRules);
        this.mySectionRules.addAll(sectionRules);
    }

    public static StdArrangementSettings createByMatchRules(@NotNull List<? extends ArrangementGroupingRule> groupingRules, @NotNull List<? extends StdArrangementMatchRule> matchRules) {
        if (groupingRules == null) {
            StdArrangementSettings.$$$reportNull$$$0(3);
        }
        if (matchRules == null) {
            StdArrangementSettings.$$$reportNull$$$0(4);
        }
        ArrayList<ArrangementSectionRule> sectionRules = new ArrayList<ArrangementSectionRule>();
        for (StdArrangementMatchRule stdArrangementMatchRule : matchRules) {
            sectionRules.add(ArrangementSectionRule.create(stdArrangementMatchRule));
        }
        return new StdArrangementSettings(groupingRules, sectionRules);
    }

    @NotNull
    protected List<ArrangementGroupingRule> cloneGroupings() {
        ArrayList<ArrangementGroupingRule> groupings = new ArrayList<ArrangementGroupingRule>();
        for (ArrangementGroupingRule grouping : this.myGroupings) {
            groupings.add(grouping.clone());
        }
        ArrayList<ArrangementGroupingRule> arrayList = groupings;
        if (arrayList == null) {
            StdArrangementSettings.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    protected List<ArrangementSectionRule> cloneSectionRules() {
        ArrayList<ArrangementSectionRule> rules = new ArrayList<ArrangementSectionRule>();
        for (ArrangementSectionRule rule : this.mySectionRules) {
            rules.add(rule.clone());
        }
        ArrayList<ArrangementSectionRule> arrayList = rules;
        if (arrayList == null) {
            StdArrangementSettings.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public ArrangementSettings clone() {
        return new StdArrangementSettings(this.cloneGroupings(), this.cloneSectionRules());
    }

    @Override
    @NotNull
    public List<ArrangementGroupingRule> getGroupings() {
        List<ArrangementGroupingRule> list = this.myGroupings;
        if (list == null) {
            StdArrangementSettings.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public List<ArrangementSectionRule> getSections() {
        List<ArrangementSectionRule> list = this.mySectionRules;
        if (list == null) {
            StdArrangementSettings.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<StdArrangementMatchRule> getRules() {
        List<StdArrangementMatchRule> list = ArrangementUtil.collectMatchRules(this.mySectionRules);
        if (list == null) {
            StdArrangementSettings.$$$reportNull$$$0(9);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<? extends ArrangementMatchRule> getRulesSortedByPriority() {
        List<StdArrangementMatchRule> list = this.myRulesByPriority;
        synchronized (list) {
            if (this.myRulesByPriority.isEmpty()) {
                for (ArrangementSectionRule rule : this.mySectionRules) {
                    this.myRulesByPriority.addAll(rule.getMatchRules());
                }
                ContainerUtil.sort(this.myRulesByPriority);
            }
        }
        List<StdArrangementMatchRule> list2 = this.myRulesByPriority;
        if (list2 == null) {
            StdArrangementSettings.$$$reportNull$$$0(10);
        }
        return list2;
    }

    public void addRule(@NotNull StdArrangementMatchRule rule) {
        if (rule == null) {
            StdArrangementSettings.$$$reportNull$$$0(11);
        }
        this.addSectionRule(rule);
        this.myRulesByPriority.clear();
    }

    public void addSectionRule(@NotNull StdArrangementMatchRule rule) {
        if (rule == null) {
            StdArrangementSettings.$$$reportNull$$$0(12);
        }
        this.mySectionRules.add(ArrangementSectionRule.create(rule));
    }

    public void addGrouping(@NotNull ArrangementGroupingRule rule) {
        if (rule == null) {
            StdArrangementSettings.$$$reportNull$$$0(13);
        }
        this.myGroupings.add(rule);
    }

    public int hashCode() {
        int result = this.mySectionRules.hashCode();
        result = 31 * result + this.myGroupings.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StdArrangementSettings settings = (StdArrangementSettings)o;
        if (!this.myGroupings.equals(settings.myGroupings)) {
            return false;
        }
        return this.mySectionRules.equals(settings.mySectionRules);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupingRules";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionRules";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchRules";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/std/StdArrangementSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneGroupings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneSectionRules";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSections";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRules";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRulesSortedByPriority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createByMatchRules";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addRule";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addSectionRule";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addGrouping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

