/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.grazie.async;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.spellchecker.grazie.async.AsyncUtils;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/spellchecker/grazie/async/AsyncUtils;", "", "()V", "isNonAsyncMode", "", "restartInspection", "", "application", "Lcom/intellij/openapi/application/Application;", "run", "project", "Lcom/intellij/openapi/project/Project;", "body", "Lkotlin/Function0;", "intellij.spellchecker"})
public final class AsyncUtils {
    public static final AsyncUtils INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isNonAsyncMode() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) return true;
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
        if (!application2.isHeadlessEnvironment()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void restartInspection(@NotNull Application application) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        if (application.isDisposed()) {
            return;
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
        Project[] projectArray = projectManager.getOpenProjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
        Project[] $this$filter$iv = projectArray;
        boolean $i$f$filter = false;
        Project[] projectArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var9_7 = $this$filterTo$iv$iv;
        int n = ((void)var9_7).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var9_7[i];
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            if (!(v2.isInitialized() && it.isOpen() && !it.isDefault())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Project project : (List)destination$iv$iv) {
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
            if (daemonCodeAnalyzer == null) continue;
            daemonCodeAnalyzer.restart();
        }
    }

    public final void run(@NotNull Project project, @NotNull Function0<Unit> body) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        if (this.isNonAsyncMode()) {
            body.invoke();
        } else {
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(body){
                final /* synthetic */ Function0 $body;

                public final void run() {
                    Application app = ApplicationManager.getApplication();
                    app.executeOnPooledThread(new Runnable(this, app){
                        final /* synthetic */ run.1 this$0;
                        final /* synthetic */ Application $app;

                        public final void run() {
                            Application application = this.$app;
                            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                            if (application.isDisposed()) {
                                return;
                            }
                            this.this$0.$body.invoke();
                            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
                                final /* synthetic */ run.1 this$0;

                                public final void run() {
                                    Application application = this.this$0.$app;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                                    AsyncUtils.INSTANCE.restartInspection(application);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            });
                        }
                        {
                            this.this$0 = var1_1;
                            this.$app = application;
                        }
                    });
                }
                {
                    this.$body = function0;
                }
            });
        }
    }

    private AsyncUtils() {
    }

    static {
        AsyncUtils asyncUtils;
        INSTANCE = asyncUtils = new AsyncUtils();
    }
}

