/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.filters.LogEventFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventWhitelistFilter;
import com.intellij.internal.statistic.service.fus.EventLogMetadataParseException;
import com.intellij.internal.statistic.service.fus.StatisticsWhitelistConditions;
import com.intellij.internal.statistic.service.fus.StatisticsWhitelistLoader;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestParseEventsSchemeDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(TestParseEventsSchemeDialog.class);
    private static final int IN_DIVIDER_LOCATION = 650;
    private static final int IN_OUT_DIVIDER_LOCATION = 300;
    private JPanel myMainPanel;
    private JPanel myEventsSchemePanel;
    private JPanel myResultPanel;
    private JEditorPane myEventLogPanel;
    private JSplitPane myInputDataSplitPane;
    private JSplitPane myInputOutputSplitPane;
    private final Project myProject;
    private final EditorEx myEventsSchemeEditor;
    private final EditorEx myResultEditor;
    private final List<PsiFile> myTempFiles;

    protected TestParseEventsSchemeDialog(@NotNull Project project, @Nullable Editor selectedEditor) {
        if (project == null) {
            TestParseEventsSchemeDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.$$$setupUI$$$();
        this.myTempFiles = new ArrayList<PsiFile>();
        this.myProject = project;
        this.setOKButtonText("&Filter Event Log");
        this.setCancelButtonText("&Close");
        Disposer.register((Disposable)this.myProject, (Disposable)this.getDisposable());
        VirtualFile selectedFile = selectedEditor == null ? null : FileDocumentManager.getInstance().getFile(selectedEditor.getDocument());
        this.setTitle(selectedFile == null ? "Event Log Filter" : "Event Log Filter by: " + selectedFile.getName());
        this.myEventsSchemeEditor = this.initEditor(selectedEditor, "events-scheme", "{\"groups\":[]}");
        this.myEventsSchemeEditor.getSettings().setLineMarkerAreaShown(false);
        this.myResultEditor = this.initEditor(null, "event-log-filter-result", "{}");
        this.myResultEditor.getSettings().setLineMarkerAreaShown(false);
        this.init();
        if (selectedEditor != null) {
            this.doOKAction();
            ApplicationManager.getApplication().invokeLater(() -> {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEventsSchemeEditor.getContentComponent(), true));
                this.myEventsSchemeEditor.getCaretModel().moveToOffset(selectedEditor.getCaretModel().getOffset());
                this.myEventsSchemeEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }, ModalityState.stateForComponent((Component)this.myMainPanel));
        }
    }

    @NotNull
    private EditorEx initEditor(@Nullable Editor selectedEditor, @NotNull String fileName, @NotNull String templateText) {
        if (fileName == null) {
            TestParseEventsSchemeDialog.$$$reportNull$$$0(1);
        }
        if (templateText == null) {
            TestParseEventsSchemeDialog.$$$reportNull$$$0(2);
        }
        if (selectedEditor != null) {
            EditorEx editorEx = (EditorEx)EditorFactory.getInstance().createEditor(selectedEditor.getDocument(), this.myProject);
            if (editorEx == null) {
                TestParseEventsSchemeDialog.$$$reportNull$$$0(3);
            }
            return editorEx;
        }
        PsiFile file = TestParseEventsSchemeDialog.createTempFile(this.myProject, fileName, templateText);
        assert (file != null);
        this.myTempFiles.add(file);
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        if (document == null) {
            document = EditorFactory.getInstance().createDocument((CharSequence)templateText);
        }
        EditorEx editor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.myProject, file.getVirtualFile(), false);
        editor.setFile(file.getVirtualFile());
        EditorEx editorEx = editor;
        if (editorEx == null) {
            TestParseEventsSchemeDialog.$$$reportNull$$$0(4);
        }
        return editorEx;
    }

    @Nullable
    public static PsiFile createTempFile(@NotNull Project project, @NotNull String filename, @NotNull String request) {
        if (project == null) {
            TestParseEventsSchemeDialog.$$$reportNull$$$0(5);
        }
        if (filename == null) {
            TestParseEventsSchemeDialog.$$$reportNull$$$0(6);
        }
        if (request == null) {
            TestParseEventsSchemeDialog.$$$reportNull$$$0(7);
        }
        String fileName = PathUtil.makeFileName((String)filename, (String)"json");
        try {
            ThrowableComputable computable = () -> {
                Document document;
                ScratchFileService fileService = ScratchFileService.getInstance();
                VirtualFile file = fileService.findFile(RootType.findById((String)"scratches"), fileName, ScratchFileService.Option.create_if_missing);
                fileService.getScratchesMapping().setMapping(file, (Object)Language.findLanguageByID((String)"JSON"));
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                Document document2 = document = psiFile != null ? PsiDocumentManager.getInstance((Project)project).getDocument(psiFile) : null;
                if (document == null) {
                    return null;
                }
                document.insertString(document.getTextLength(), (CharSequence)request);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                return psiFile;
            };
            return (PsiFile)WriteCommandAction.writeCommandAction((Project)project).withName("Creating temp JSON file for event log").withGlobalUndo().shouldRecordActionForActiveDocument(false).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).compute(computable);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void init() {
        TestParseEventsSchemeDialog.configEditorPanel(this.myProject, this.myEventsSchemePanel, this.myEventsSchemeEditor);
        TestParseEventsSchemeDialog.configEditorPanel(this.myProject, this.myResultPanel, this.myResultEditor);
        this.myInputDataSplitPane.setDividerLocation(650);
        this.myInputOutputSplitPane.setDividerLocation(300);
        super.init();
    }

    private static void configEditorPanel(@NotNull Project project, @NotNull JPanel panel2, @NotNull EditorEx editor) {
        if (project == null) {
            TestParseEventsSchemeDialog.$$$reportNull$$$0(8);
        }
        if (panel2 == null) {
            TestParseEventsSchemeDialog.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            TestParseEventsSchemeDialog.$$$reportNull$$$0(10);
        }
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)editor.getComponent(), "Center");
        editor.getSettings().setFoldingOutlineShown(false);
        FileType fileType = FileTypeManager.getInstance().findFileTypeByName("JSON");
        LightVirtualFile lightFile = new LightVirtualFile("Dummy.json", fileType, (CharSequence)"");
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, (VirtualFile)lightFile);
        try {
            editor.setHighlighter(highlighter);
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = TestParseEventsSchemeDialog.class.getCanonicalName();
        if (string == null) {
            TestParseEventsSchemeDialog.$$$reportNull$$$0(11);
        }
        return string;
    }

    protected void doOKAction() {
        this.myEventsSchemeEditor.getSelectionModel().removeSelection();
        this.myResultEditor.getSelectionModel().removeSelection();
        this.updateResultRequest("{}");
        try {
            StatisticsWhitelistConditions scheme = StatisticsWhitelistLoader.parseApprovedGroups((String)this.myEventsSchemeEditor.getDocument().getText());
            String parsed = TestParseEventsSchemeDialog.parseLogAndFilter((LogEventFilter)new LogEventWhitelistFilter(scheme), this.myEventLogPanel.getText());
            this.updateResultRequest(parsed.trim());
        }
        catch (EventLogMetadataParseException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)"Failed Parsing Events Scheme");
        }
        catch (ParseEventLogWhitelistException | IOException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)"Failed Applying Events Scheme to Event Log");
        }
    }

    private void updateResultRequest(@NotNull String text) {
        if (text == null) {
            TestParseEventsSchemeDialog.$$$reportNull$$$0(12);
        }
        WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
            DocumentEx document = this.myResultEditor.getDocument();
            document.setText((CharSequence)text);
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument((Document)this.myResultEditor.getDocument());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static String parseLogAndFilter(@NotNull LogEventFilter filter2, @NotNull String text) throws IOException, ParseEventLogWhitelistException {
        if (filter2 == null) {
            TestParseEventsSchemeDialog.$$$reportNull$$$0(13);
        }
        if (text == null) {
            TestParseEventsSchemeDialog.$$$reportNull$$$0(14);
        }
        File log = FileUtil.createTempFile((String)"feature-event-log", (String)".log");
        FileUtil.writeToFile((File)log, (String)text);
        String deviceId = EventLogConfiguration.INSTANCE.getDeviceId();
        String productCode = ApplicationInfo.getInstance().getBuild().getProductCode();
        TestDataCollectorDebugLogger logger = new TestDataCollectorDebugLogger();
        LogEventRecordRequest request = LogEventRecordRequest.Companion.create(log, "FUS", productCode, deviceId, filter2, true, (DataCollectorDebugLogger)logger);
        if (request == null) {
            throw new ParseEventLogWhitelistException("Failed parsing event log");
        }
        String string = LogEventSerializer.INSTANCE.toString(request);
        String string2 = string;
        if (string2 == null) {
            TestParseEventsSchemeDialog.$$$reportNull$$$0(15);
        }
        return string2;
        finally {
            FileUtil.delete((File)log);
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEventLogPanel;
    }

    public void dispose() {
        WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
            for (PsiFile file : this.myTempFiles) {
                try {
                    file.delete();
                }
                catch (IncorrectOperationException e) {
                    LOG.warn((Throwable)e);
                }
            }
        });
        if (!this.myEventsSchemeEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEventsSchemeEditor);
        }
        if (!this.myResultEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myResultEditor);
        }
        super.dispose();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JSplitPane jSplitPane;
        JEditorPane jEditorPane;
        JSplitPane jSplitPane2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myInputOutputSplitPane = jSplitPane2 = new JSplitPane();
        jSplitPane2.setOrientation(0);
        jPanel3.add((Component)jSplitPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jSplitPane2.setRightComponent((Component)jBScrollPane);
        this.myEventLogPanel = jEditorPane = new JEditorPane();
        jEditorPane.setText("Add event log to filter here, one event per line");
        jBScrollPane.setViewportView(jEditorPane);
        this.myInputDataSplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerLocation(230);
        jSplitPane.setDividerSize(2);
        jSplitPane2.setLeftComponent(jSplitPane);
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jSplitPane.setLeftComponent((Component)jBScrollPane2);
        this.myEventsSchemePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane2.setViewportView(jPanel2);
        JBScrollPane jBScrollPane3 = new JBScrollPane();
        jSplitPane.setRightComponent((Component)jBScrollPane3);
        this.myResultPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane3.setViewportView(jPanel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateText";
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/actions/TestParseEventsSchemeDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/actions/TestParseEventsSchemeDialog";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "initEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLogAndFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initEditor";
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 15: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "configEditorPanel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateResultRequest";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseLogAndFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TestDataCollectorDebugLogger
    implements DataCollectorDebugLogger {
        private TestDataCollectorDebugLogger() {
        }

        public void info(String message) {
        }

        public void info(String message, Throwable t) {
        }

        public void warn(String message) {
        }

        public void warn(String message, Throwable t) {
        }

        public void trace(String message) {
        }

        public boolean isTraceEnabled() {
            return false;
        }
    }

    public static class ParseEventLogWhitelistException
    extends Exception {
        public ParseEventLogWhitelistException(String s) {
            super(s);
        }
    }
}

