/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.rename;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.sh.rename.TextOccurrencesRenamer;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlTagUtilBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShRenameDialog
extends RefactoringDialog {
    private final JLabel myNameLabel;
    private final NameSuggestionsField myNameSuggestionsField;
    private final TextOccurrencesRenamer myRenamer;

    ShRenameDialog(@NotNull Project project, final @NotNull TextOccurrencesRenamer renamer) {
        if (project == null) {
            ShRenameDialog.$$$reportNull$$$0(0);
        }
        if (renamer == null) {
            ShRenameDialog.$$$reportNull$$$0(1);
        }
        super(project, false);
        this.myRenamer = renamer;
        String nameLabelText = RefactoringBundle.message((String)"rename.0.and.its.usages.to", (Object[])new Object[]{"'" + renamer.getOldName() + "'"});
        this.myNameLabel = new JLabel(XmlTagUtilBase.escapeString((String)nameLabelText, (boolean)false));
        this.myNameSuggestionsField = new NameSuggestionsField(new String[]{renamer.getOldName()}, this.myProject, (FileType)FileTypes.PLAIN_TEXT, renamer.getEditor()){

            protected boolean shouldSelectAll() {
                return renamer.getEditor().getSettings().isPreselectRename();
            }
        };
        this.setTitle(RefactoringBundle.message((String)"rename.title"));
        this.init();
    }

    protected void doAction() {
        this.close(0);
        this.myRenamer.renameTo(this.getNewName());
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameSuggestionsField.getFocusableComponent();
    }

    @Nullable
    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.myNameLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, (Insets)JBUI.insetsBottom((int)4), 0, 0));
        panel.add((Component)this.myNameSuggestionsField.getComponent(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, (Insets)JBUI.insetsBottom((int)8), 0, 0));
        return panel;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return null;
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    protected boolean hasHelpAction() {
        return false;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
    }

    @NotNull
    private String getNewName() {
        String string = this.myNameSuggestionsField.getEnteredName().trim();
        if (string == null) {
            ShRenameDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void canRun() throws ConfigurationException {
        super.canRun();
        if (this.myRenamer.getOldName().equals(this.getNewName())) {
            throw new ConfigurationException(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renamer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/rename/ShRenameDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/rename/ShRenameDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

