/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/ui/WrapLayout;", "Ljava/awt/FlowLayout;", "()V", "align", "", "(I)V", "hgap", "vgap", "(III)V", "addRow", "", "dim", "Ljava/awt/Dimension;", "rowWidth", "rowHeight", "layoutSize", "target", "Ljava/awt/Container;", "preferred", "", "minimumLayoutSize", "preferredLayoutSize", "intellij.platform.util.ui"})
public final class WrapLayout
extends FlowLayout {
    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return this.layoutSize(target, true);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Dimension minimum = this.layoutSize(target, false);
        minimum.width -= this.getHgap() + 1;
        return minimum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Dimension layoutSize(Container target, boolean preferred) {
        Object object = target.getTreeLock();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"target.treeLock");
        Object object2 = object;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object2) {
            boolean bl3 = false;
            Container container = target;
            while (container.getSize().width == 0 && container.getParent() != null) {
                Intrinsics.checkExpressionValueIsNotNull((Object)container.getParent(), (String)"container.parent");
            }
            int targetWidth = container.getSize().width;
            if (targetWidth == 0) {
                targetWidth = Integer.MAX_VALUE;
            }
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            Insets insets = target.getInsets();
            int horizontalInsetsAndGap = insets.left + insets.right + hgap * 2;
            int maxWidth = targetWidth - horizontalInsetsAndGap;
            Dimension dim = new Dimension(0, 0);
            int rowWidth = 0;
            int rowHeight = 0;
            int nmembers = target.getComponentCount();
            int n = 0;
            int n2 = nmembers;
            while (n < n2) {
                void i;
                Component m;
                Component component = m = target.getComponent((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)component, (String)"m");
                if (component.isVisible()) {
                    Dimension d;
                    Dimension dimension = d = preferred ? m.getPreferredSize() : m.getMinimumSize();
                    if (rowWidth + hgap + d.width > maxWidth) {
                        this.addRow(dim, rowWidth, rowHeight);
                        rowWidth = 0;
                        rowHeight = 0;
                    }
                    if (rowWidth != 0) {
                        rowWidth += hgap;
                    }
                    rowWidth += d.width;
                    rowHeight = Math.max(rowHeight, d.height);
                }
                ++i;
            }
            this.addRow(dim, rowWidth, rowHeight);
            dim.width += horizontalInsetsAndGap;
            dim.height += insets.top + insets.bottom + vgap * 2;
            Container scrollPane = SwingUtilities.getAncestorOfClass(JScrollPane.class, target);
            if (scrollPane != null && target.isValid()) {
                dim.width -= hgap + 1;
            }
            Dimension dimension = dim;
            return dimension;
        }
    }

    private final void addRow(Dimension dim, int rowWidth, int rowHeight) {
        dim.width = Math.max(dim.width, rowWidth);
        if (dim.height > 0) {
            dim.height += this.getVgap();
        }
        dim.height += rowHeight;
    }

    public WrapLayout() {
    }

    public WrapLayout(int align) {
        super(align);
    }

    public WrapLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }
}

