/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.util.Function;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.NamedEnum;
import java.util.Objects;

public class NamedEnumUtil {
    private static final Function<Enum, String> NAMED_SHOW = s -> ((NamedEnum)((Object)s)).getValue();
    private static final Function<Enum, String> SIMPLE_SHOW = s -> s.name();

    public static <T extends Enum> T getEnumElementByValue(Class<T> enumClass, String value, Function<? super Enum, String> show) {
        for (Enum t : (Enum[])enumClass.getEnumConstants()) {
            if (!Objects.equals(value, show.fun((Object)t))) continue;
            return (T)t;
        }
        return null;
    }

    public static <T extends Enum> T getEnumElementByValue(Class<T> enumClass, String value) {
        return NamedEnumUtil.getEnumElementByValue(enumClass, value, NamedEnumUtil.getShow(enumClass));
    }

    private static <T extends Enum> Function<Enum, String> getShow(Class<T> enumClass) {
        return ReflectionUtil.isAssignable(NamedEnum.class, enumClass) ? NAMED_SHOW : SIMPLE_SHOW;
    }

    public static <T extends Enum> String getEnumValueByElement(T element) {
        return element == null ? null : (String)NamedEnumUtil.getShow(element.getClass()).fun(element);
    }
}

