/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.ProgressBarLoadingDecorator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
class BuildProgressStripe
extends JBPanel {
    @NotNull
    private final JBPanel myPanel;
    private final NotNullLazyValue<ProgressBarLoadingDecorator> myCreateLoadingDecorator;
    private ProgressBarLoadingDecorator myDecorator;

    BuildProgressStripe(@NotNull JComponent targetComponent, @NotNull Disposable parent, int startDelayMs) {
        if (targetComponent == null) {
            BuildProgressStripe.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            BuildProgressStripe.$$$reportNull$$$0(1);
        }
        super((LayoutManager)new BorderLayout());
        this.myPanel = new JBPanel((LayoutManager)new BorderLayout());
        this.myPanel.setOpaque(false);
        this.myPanel.add((Component)targetComponent);
        this.myCreateLoadingDecorator = NotNullLazyValue.createValue(() -> new ProgressBarLoadingDecorator((JPanel)this.myPanel, parent, startDelayMs));
        this.createLoadingDecorator();
    }

    public void updateProgress(long total, long progress2) {
        if (total == progress2) {
            this.stopLoading();
            return;
        }
        boolean isDeterminate = total > 0L && progress2 > 0L;
        JProgressBar progressBar = this.getProgressBar();
        boolean isProgressBarIndeterminate = progressBar.isIndeterminate();
        if (isDeterminate) {
            this.startLoading();
            progressBar.setValue(Math.toIntExact(progress2 * 100L / total));
            if (isProgressBarIndeterminate) {
                progressBar.setIndeterminate(false);
            }
        } else if (!isProgressBarIndeterminate) {
            progressBar.setIndeterminate(true);
        }
    }

    void startLoading() {
        this.myDecorator.startLoading();
    }

    void stopLoading() {
        JProgressBar progressBar = this.getProgressBar();
        if (!progressBar.isIndeterminate()) {
            progressBar.setValue(100);
        }
        this.myDecorator.stopLoading();
    }

    private JProgressBar getProgressBar() {
        return ((ProgressBarLoadingDecorator)this.myCreateLoadingDecorator.getValue()).getProgressBar();
    }

    private void createLoadingDecorator() {
        this.myDecorator = (ProgressBarLoadingDecorator)this.myCreateLoadingDecorator.getValue();
        this.add(this.myDecorator.getComponent(), "Center");
        this.myDecorator.setLoadingText("");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "targetComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
        }
        objectArray[1] = "com/intellij/build/BuildProgressStripe";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

