/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.LastRunReformatCodeOptionsProvider;
import com.intellij.codeInsight.actions.ReformatFilesOptions;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutProjectCodeDialog
extends DialogWrapper
implements ReformatFilesOptions {
    @NonNls
    private static final String HELP_ID = "Reformat Code on Directory Dialog";
    private final Project myProject;
    private final String myText;
    private final boolean myEnableOnlyVCSChangedTextCb;
    private final LastRunReformatCodeOptionsProvider myLastRunOptions;
    private JLabel myTitle;
    protected JCheckBox myIncludeSubdirsCb;
    private JCheckBox myUseScopeFilteringCb;
    private ScopeChooserCombo myScopeCombo;
    private JCheckBox myEnableFileNameFilterCb;
    private ComboBox<String> myFileFilter;
    private JCheckBox myCbOptimizeImports;
    private JCheckBox myCbRearrangeEntries;
    private JCheckBox myCbOnlyVcsChangedRegions;
    private JPanel myWholePanel;
    private JPanel myOptionsPanel;
    private JPanel myFiltersPanel;
    private JLabel myMaskWarningLabel;
    private JCheckBox myCbCleanupCode;

    public LayoutProjectCodeDialog(@NotNull Project project, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Label String text, boolean enableOnlyVCSChangedTextCb) {
        if (project == null) {
            LayoutProjectCodeDialog.$$$reportNull$$$0(0);
        }
        if (title == null) {
            LayoutProjectCodeDialog.$$$reportNull$$$0(1);
        }
        if (text == null) {
            LayoutProjectCodeDialog.$$$reportNull$$$0(2);
        }
        super(project, false);
        this.myText = text;
        this.myProject = project;
        this.myEnableOnlyVCSChangedTextCb = enableOnlyVCSChangedTextCb;
        this.$$$setupUI$$$();
        this.myLastRunOptions = new LastRunReformatCodeOptionsProvider(PropertiesComponent.getInstance());
        this.setOKButtonText(CodeInsightBundle.message((String)"reformat.code.accept.button.text", (Object[])new Object[0]));
        this.setTitle(title);
        this.init();
    }

    protected JComponent createCenterPanel() {
        this.myTitle.setText(this.myText);
        this.myOptionsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)CodeInsightBundle.message((String)"reformat.directory.dialog.options", (Object[])new Object[0])));
        this.myFiltersPanel.setBorder(IdeBorderFactory.createTitledBorder((String)CodeInsightBundle.message((String)"reformat.directory.dialog.filters", (Object[])new Object[0])));
        this.myMaskWarningLabel.setIcon(AllIcons.General.Warning);
        this.myMaskWarningLabel.setVisible(false);
        this.myIncludeSubdirsCb.setVisible(this.shouldShowIncludeSubdirsCb());
        this.initFileTypeFilter();
        this.initScopeFilter();
        this.restoreCbsStates();
        return this.myWholePanel;
    }

    private void restoreCbsStates() {
        this.myCbOptimizeImports.setSelected(this.myLastRunOptions.getLastOptimizeImports());
        this.myCbRearrangeEntries.setSelected(this.myLastRunOptions.getLastRearrangeCode());
        this.myCbCleanupCode.setSelected(this.myLastRunOptions.getLastCodeCleanup());
        this.myCbOnlyVcsChangedRegions.setEnabled(this.myEnableOnlyVCSChangedTextCb);
        this.myCbOnlyVcsChangedRegions.setSelected(this.myEnableOnlyVCSChangedTextCb && this.myLastRunOptions.getLastTextRangeType() == TextRangeType.VCS_CHANGED_TEXT);
    }

    private void initScopeFilter() {
        this.myUseScopeFilteringCb.setSelected(false);
        this.myScopeCombo.setEnabled(false);
        this.myUseScopeFilteringCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutProjectCodeDialog.this.myScopeCombo.setEnabled(LayoutProjectCodeDialog.this.myUseScopeFilteringCb.isSelected());
            }
        });
    }

    private void initFileTypeFilter() {
        FindInProjectUtil.initFileFilter(this.myFileFilter, this.myEnableFileNameFilterCb);
        this.myEnableFileNameFilterCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutProjectCodeDialog.this.updateMaskWarning();
            }
        });
        this.myFileFilter.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                LayoutProjectCodeDialog.this.updateMaskWarning();
            }
        });
    }

    private void updateMaskWarning() {
        String mask;
        if (this.myEnableFileNameFilterCb.isSelected() && ((mask = (String)this.myFileFilter.getEditor().getItem()) == null || !LayoutProjectCodeDialog.isMaskValid(mask))) {
            this.showWarningAndDisableOK();
            return;
        }
        if (this.myMaskWarningLabel.isVisible()) {
            this.clearWarningAndEnableOK();
        }
    }

    private void showWarningAndDisableOK() {
        this.myMaskWarningLabel.setVisible(true);
        this.setOKActionEnabled(false);
    }

    private void clearWarningAndEnableOK() {
        this.myMaskWarningLabel.setVisible(false);
        this.setOKActionEnabled(true);
    }

    private static boolean isMaskValid(@NotNull String mask) {
        if (mask == null) {
            LayoutProjectCodeDialog.$$$reportNull$$$0(3);
        }
        try {
            FindInProjectUtil.createFileMaskCondition(mask);
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    @Override
    public boolean isRearrangeCode() {
        return this.myCbRearrangeEntries.isSelected();
    }

    @Override
    public boolean isCodeCleanup() {
        return this.myCbCleanupCode.isSelected();
    }

    protected String getHelpId() {
        return HELP_ID;
    }

    protected void doOKAction() {
        super.doOKAction();
        this.myLastRunOptions.saveOptimizeImportsState(this.isOptimizeImports());
        this.myLastRunOptions.saveRearrangeCodeState(this.isRearrangeCode());
        if (this.myEnableOnlyVCSChangedTextCb) {
            this.myLastRunOptions.saveProcessVcsChangedTextState(this.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT);
        }
    }

    @Override
    public boolean isOptimizeImports() {
        return this.myCbOptimizeImports.isSelected();
    }

    @Override
    @Nullable
    public String getFileTypeMask() {
        if (this.myEnableFileNameFilterCb.isSelected()) {
            return (String)this.myFileFilter.getSelectedItem();
        }
        return null;
    }

    protected void createUIComponents() {
        this.myScopeCombo = new ScopeChooserCombo(this.myProject, false, false, FindSettings.getInstance().getDefaultScopeName());
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScopeCombo);
    }

    @Override
    @Nullable
    public SearchScope getSearchScope() {
        if (this.myUseScopeFilteringCb.isSelected()) {
            return this.myScopeCombo.getSelectedScope();
        }
        return null;
    }

    protected boolean shouldShowIncludeSubdirsCb() {
        return false;
    }

    @Override
    public TextRangeType getTextRangeType() {
        return this.myCbOnlyVcsChangedRegions.isEnabled() && this.myCbOnlyVcsChangedRegions.isSelected() ? TextRangeType.VCS_CHANGED_TEXT : TextRangeType.WHOLE_FILE;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JCheckBox jCheckBox;
        ComboBox comboBox2;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myWholePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCbOptimizeImports = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/CodeInsightBundle", LayoutProjectCodeDialog.class).getString("checkbox.optimize.imports"));
        jPanel3.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbRearrangeEntries = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/CodeInsightBundle", LayoutProjectCodeDialog.class).getString("checkbox.rearrange.entries"));
        jPanel3.add((Component)jCheckBox5, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbOnlyVcsChangedRegions = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/CodeInsightBundle", LayoutProjectCodeDialog.class).getString("radio.button.reformat.only.vcs.changed.text"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myIncludeSubdirsCb = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/CodeInsightBundle", LayoutProjectCodeDialog.class).getString("checkbox.reformat.project.include.subdirectories"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbCleanupCode = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/CodeInsightBundle", LayoutProjectCodeDialog.class).getString("checkbox.reformat.project.cleanup.code"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(2, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myFiltersPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBCheckBox jBCheckBox = new JBCheckBox();
        this.myEnableFileNameFilterCb = jBCheckBox;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/CodeInsightBundle", LayoutProjectCodeDialog.class).getString("checkbox.reformat.project.file.masks"));
        jPanel7.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myFileFilter = comboBox2 = new ComboBox();
        jPanel7.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel7.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel8, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myUseScopeFilteringCb = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/CodeInsightBundle", LayoutProjectCodeDialog.class).getString("checkbox.reformat.project.scope"));
        jPanel8.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel8.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ScopeChooserCombo scopeChooserCombo = this.myScopeCombo;
        jPanel8.add((Component)((Object)scopeChooserCombo), new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myMaskWarningLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/CodeInsightBundle", LayoutProjectCodeDialog.class).getString("label.file.mask.is.invalid"));
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        Spacer spacer6 = new Spacer();
        jPanel2.add((Component)spacer6, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTitle = jLabel = new JLabel();
        jLabel.setText("");
        jPanel4.add((Component)jLabel, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel9, new GridConstraints(4, 0, 1, 4, 0, 3, 3, 3, new Dimension(-1, 5), null, null));
        ButtonGroup buttonGroup2 = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mask";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/actions/LayoutProjectCodeDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isMaskValid";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

