/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TemplateManagerListener;
import com.intellij.codeInsight.template.TemplateSubstitutor;
import com.intellij.codeInsight.template.impl.ListTemplatesHandler;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.TemplateSubstitutionContext;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateManagerImpl
extends TemplateManager
implements Disposable {
    static final NotNullLazyValue<ExtensionPoint<TemplateContextType>> TEMPLATE_CONTEXT_EP = NotNullLazyValue.createValue(() -> TemplateContextType.EP_NAME.getPoint());
    @NotNull
    private final Project myProject;
    private static final Key<Boolean> ourTemplateTesting = Key.create((String)"TemplateTesting");
    private static final Key<TemplateState> TEMPLATE_STATE_KEY = Key.create((String)"TEMPLATE_STATE_KEY");
    private final TemplateManagerListener myEventPublisher;
    private static final OffsetKey START_OFFSET = OffsetKey.create((String)"start", (boolean)false);
    private static final OffsetKey END_OFFSET = OffsetKey.create((String)"end", (boolean)true);

    public TemplateManagerImpl(@NotNull Project project) {
        if (project == null) {
            TemplateManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myEventPublisher = (TemplateManagerListener)project.getMessageBus().syncPublisher(TEMPLATE_STARTED_TOPIC);
        EditorFactoryListener myEditorFactoryListener = new EditorFactoryListener(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                TemplateState prevState;
                Editor editor;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((editor = event.getEditor()).getProject() != null && editor.getProject() != TemplateManagerImpl.this.myProject) {
                    return;
                }
                if (TemplateManagerImpl.this.myProject.isDisposed() || !TemplateManagerImpl.this.myProject.isOpen()) {
                    return;
                }
                TemplateState state = TemplateManagerImpl.getTemplateState(editor);
                if (state != null) {
                    state.gotoEnd();
                }
                if ((prevState = TemplateManagerImpl.clearTemplateState(editor)) != null) {
                    Disposer.dispose((Disposable)prevState);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/template/impl/TemplateManagerImpl$1", "editorReleased"));
            }
        };
        EditorFactory.getInstance().addEditorFactoryListener(myEditorFactoryListener, (Disposable)this.myProject);
        TemplateContextType.EP_NAME.addChangeListener(() -> {
            for (TemplateContextType type : TemplateManagerImpl.getAllContextTypes()) {
                type.clearCachedBaseContextType();
            }
        }, (Disposable)this);
    }

    public void dispose() {
    }

    public static void setTemplateTesting(Disposable parentDisposable) {
        TestModeFlags.set(ourTemplateTesting, (Object)true, (Disposable)parentDisposable);
    }

    @Override
    public Template createTemplate(@NotNull String key, @NotNull String group) {
        if (key == null) {
            TemplateManagerImpl.$$$reportNull$$$0(1);
        }
        if (group == null) {
            TemplateManagerImpl.$$$reportNull$$$0(2);
        }
        return new TemplateImpl(key, group);
    }

    @Override
    public Template createTemplate(@NotNull String key, @NotNull String group, String text) {
        if (key == null) {
            TemplateManagerImpl.$$$reportNull$$$0(3);
        }
        if (group == null) {
            TemplateManagerImpl.$$$reportNull$$$0(4);
        }
        return new TemplateImpl(key, text, group);
    }

    @Nullable
    public static TemplateState getTemplateState(@NotNull Editor editor) {
        Editor stateHolder;
        TemplateState templateState;
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(5);
        }
        if ((templateState = (TemplateState)(stateHolder = InjectedLanguageUtil.getTopLevelEditor(editor)).getUserData(TEMPLATE_STATE_KEY)) != null && templateState.isDisposed()) {
            stateHolder.putUserData(TEMPLATE_STATE_KEY, null);
            return null;
        }
        return templateState;
    }

    @Nullable
    static TemplateState clearTemplateState(@NotNull Editor editor) {
        Editor stateEditor;
        TemplateState prevState;
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(6);
        }
        if ((prevState = TemplateManagerImpl.getTemplateState(editor)) != null && (stateEditor = prevState.getEditor()) != null) {
            stateEditor.putUserData(TEMPLATE_STATE_KEY, null);
        }
        return prevState;
    }

    @NotNull
    private TemplateState initTemplateState(@NotNull Editor editor) {
        Editor topLevelEditor;
        TemplateState prevState;
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(7);
        }
        if ((prevState = TemplateManagerImpl.clearTemplateState(topLevelEditor = InjectedLanguageUtil.getTopLevelEditor(editor))) != null) {
            Disposer.dispose((Disposable)prevState);
        }
        TemplateState state = new TemplateState(this.myProject, topLevelEditor);
        Disposer.register((Disposable)this, (Disposable)state);
        topLevelEditor.putUserData(TEMPLATE_STATE_KEY, (Object)state);
        TemplateState templateState = state;
        if (templateState == null) {
            TemplateManagerImpl.$$$reportNull$$$0(8);
        }
        return templateState;
    }

    @Override
    public boolean startTemplate(@NotNull Editor editor, char shortcutChar) {
        Runnable runnable2;
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(9);
        }
        if ((runnable2 = this.prepareTemplate(editor, shortcutChar, null)) != null) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
            runnable2.run();
        }
        return runnable2 != null;
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template) {
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(10);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(11);
        }
        this.startTemplate(editor, template, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor, String selectionString, @NotNull Template template) {
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(12);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(13);
        }
        this.startTemplate(editor, selectionString, template, true, null, null, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template, TemplateEditingListener listener2, PairProcessor<? super String, ? super String> processor2) {
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(14);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(15);
        }
        this.startTemplate(editor, null, template, true, listener2, processor2, null);
    }

    private void startTemplate(Editor editor, String selectionString, Template template, boolean inSeparateCommand, TemplateEditingListener listener2, PairProcessor<? super String, ? super String> processor2, Map<String, String> predefinedVarValues) {
        TemplateState templateState = this.initTemplateState(editor);
        templateState.getProperties().put(ExpressionContext.SELECTION, selectionString);
        if (listener2 != null) {
            templateState.addTemplateStateListener(listener2);
        }
        Runnable r = () -> {
            if (selectionString != null) {
                ApplicationManager.getApplication().runWriteAction(() -> EditorModificationUtil.deleteSelectedText((Editor)editor));
            } else {
                editor.getSelectionModel().removeSelection();
            }
            templateState.start(this.substituteTemplate((TemplateImpl)template, editor), processor2, predefinedVarValues);
            this.myEventPublisher.templateStarted(templateState);
        };
        if (inSeparateCommand) {
            CommandProcessor.getInstance().executeCommand(this.myProject, r, CodeInsightBundle.message((String)"insert.code.template.command", (Object[])new Object[0]), null);
        } else {
            r.run();
        }
        if (this.shouldSkipInTests() && !templateState.isFinished()) {
            templateState.gotoEnd(false);
        }
    }

    public boolean shouldSkipInTests() {
        return ApplicationManager.getApplication().isUnitTestMode() && !TestModeFlags.is(ourTemplateTesting);
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template, TemplateEditingListener listener2) {
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(16);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(17);
        }
        this.startTemplate(editor, null, template, true, listener2, null, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template, boolean inSeparateCommand, Map<String, String> predefinedVarValues, TemplateEditingListener listener2) {
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(18);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(19);
        }
        this.startTemplate(editor, null, template, inSeparateCommand, listener2, null, predefinedVarValues);
    }

    private static int passArgumentBack(CharSequence text, int caretOffset) {
        char c;
        int i2;
        for (i2 = caretOffset - 1; i2 >= 0 && !TemplateManagerImpl.isDelimiter(c = text.charAt(i2)); --i2) {
        }
        return i2 + 1;
    }

    private static boolean isDelimiter(char c) {
        return !Character.isJavaIdentifierPart(c);
    }

    private static <T, U> void addToMap(@NotNull Map<T, U> map2, @NotNull Collection<? extends T> keys2, U value2) {
        if (map2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(20);
        }
        if (keys2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(21);
        }
        for (T key : keys2) {
            map2.put(key, value2);
        }
    }

    private static boolean containsTemplateStartingBefore(Map<TemplateImpl, String> template2argument, int offset, int caretOffset, CharSequence text) {
        for (TemplateImpl template : template2argument.keySet()) {
            String argument;
            int templateStart = TemplateManagerImpl.getTemplateStart(template, argument = template2argument.get(template), caretOffset, text);
            if (templateStart >= offset) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Runnable prepareTemplate(Editor editor, char shortcutChar, @Nullable PairProcessor<? super String, ? super String> processor2) {
        if (editor.getSelectionModel().hasSelection()) {
            return null;
        }
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)this.myProject);
        if (file2 == null || file2 instanceof PsiCompiledElement) {
            return null;
        }
        Map<TemplateImpl, String> template2argument = this.findMatchingTemplates(file2, editor, Character.valueOf(shortcutChar), TemplateSettings.getInstance());
        TemplateActionContext templateActionContext = TemplateActionContext.expanding((PsiFile)file2, (Editor)editor);
        List customCandidates = ContainerUtil.findAll((Object[])((CustomLiveTemplate[])CustomLiveTemplate.EP_NAME.getExtensions()), customLiveTemplate -> shortcutChar == customLiveTemplate.getShortcut() && (editor.getCaretModel().getCaretCount() <= 1 || TemplateManagerImpl.supportsMultiCaretMode(customLiveTemplate)) && TemplateManagerImpl.isApplicable(customLiveTemplate, templateActionContext));
        if (!customCandidates.isEmpty()) {
            int caretOffset = editor.getCaretModel().getOffset();
            CustomTemplateCallback templateCallback = new CustomTemplateCallback(editor, file2);
            for (CustomLiveTemplate customLiveTemplate2 : customCandidates) {
                String key = customLiveTemplate2.computeTemplateKey(templateCallback);
                if (key == null) continue;
                int offsetBeforeKey = caretOffset - key.length();
                CharSequence text = editor.getDocument().getImmutableCharSequence();
                if (template2argument != null && TemplateManagerImpl.containsTemplateStartingBefore(template2argument, offsetBeforeKey, caretOffset, text)) continue;
                return () -> customLiveTemplate2.expand(key, templateCallback);
            }
        }
        return this.startNonCustomTemplates(template2argument, editor, processor2);
    }

    private static boolean supportsMultiCaretMode(CustomLiveTemplate customLiveTemplate) {
        return !(customLiveTemplate instanceof CustomLiveTemplateBase) || ((CustomLiveTemplateBase)customLiveTemplate).supportsMultiCaret();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static boolean isApplicable(@NotNull CustomLiveTemplate customLiveTemplate, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (customLiveTemplate == null) {
            TemplateManagerImpl.$$$reportNull$$$0(22);
        }
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(23);
        }
        if (file2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(24);
        }
        return TemplateManagerImpl.isApplicable(customLiveTemplate, TemplateActionContext.expanding((PsiFile)file2, (Editor)editor));
    }

    public static boolean isApplicable(@NotNull CustomLiveTemplate customLiveTemplate, @NotNull TemplateActionContext templateActionContext) {
        if (customLiveTemplate == null) {
            TemplateManagerImpl.$$$reportNull$$$0(25);
        }
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(26);
        }
        CustomTemplateCallback callback2 = new CustomTemplateCallback(Objects.requireNonNull(templateActionContext.getEditor()), templateActionContext.getFile());
        return customLiveTemplate.isApplicable(callback2, callback2.getOffset(), templateActionContext.isSurrounding());
    }

    private static int getArgumentOffset(int caretOffset, String argument, CharSequence text) {
        int argumentOffset = caretOffset - argument.length();
        if (argumentOffset > 0 && text.charAt(argumentOffset - 1) == ' ' && argumentOffset - 2 >= 0 && Character.isJavaIdentifierPart(text.charAt(argumentOffset - 2))) {
            --argumentOffset;
        }
        return argumentOffset;
    }

    private static int getTemplateStart(TemplateImpl template, String argument, int caretOffset, CharSequence text) {
        int templateStart;
        if (argument == null) {
            templateStart = caretOffset - template.getKey().length();
        } else {
            int argOffset = TemplateManagerImpl.getArgumentOffset(caretOffset, argument, text);
            templateStart = argOffset - template.getKey().length();
        }
        return templateStart;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static boolean isApplicable(@NotNull CustomLiveTemplate customLiveTemplate, @NotNull Editor editor, @NotNull PsiFile file2, boolean wrapping) {
        if (customLiveTemplate == null) {
            TemplateManagerImpl.$$$reportNull$$$0(27);
        }
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(28);
        }
        if (file2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(29);
        }
        return TemplateManagerImpl.isApplicable(customLiveTemplate, wrapping ? TemplateActionContext.surrounding((PsiFile)file2, (Editor)editor) : TemplateActionContext.expanding((PsiFile)file2, (Editor)editor));
    }

    public Map<TemplateImpl, String> findMatchingTemplates(PsiFile file2, Editor editor, @Nullable Character shortcutChar, TemplateSettings templateSettings) {
        List<TemplateImpl> candidatesWithArgument;
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int caretOffset = editor.getCaretModel().getOffset();
        List<TemplateImpl> candidatesWithoutArgument = TemplateManagerImpl.findMatchingTemplates(text, caretOffset, shortcutChar, templateSettings, false);
        int argumentOffset = TemplateManagerImpl.passArgumentBack(text, caretOffset);
        String argument = null;
        if (argumentOffset >= 0) {
            argument = text.subSequence(argumentOffset, caretOffset).toString();
            if (argumentOffset > 0 && text.charAt(argumentOffset - 1) == ' ' && argumentOffset - 2 >= 0 && Character.isJavaIdentifierPart(text.charAt(argumentOffset - 2))) {
                --argumentOffset;
            }
        }
        if ((candidatesWithArgument = TemplateManagerImpl.findMatchingTemplates(text, argumentOffset, shortcutChar, templateSettings, true)).isEmpty() && candidatesWithoutArgument.isEmpty()) {
            return null;
        }
        candidatesWithoutArgument = TemplateManagerImpl.filterApplicableCandidates(TemplateActionContext.expanding((PsiFile)file2, (int)caretOffset), candidatesWithoutArgument);
        candidatesWithArgument = TemplateManagerImpl.filterApplicableCandidates(TemplateActionContext.expanding((PsiFile)file2, (int)argumentOffset), candidatesWithArgument);
        HashMap<TemplateImpl, String> candidate2Argument = new HashMap<TemplateImpl, String>();
        TemplateManagerImpl.addToMap(candidate2Argument, candidatesWithoutArgument, null);
        TemplateManagerImpl.addToMap(candidate2Argument, candidatesWithArgument, argument);
        return candidate2Argument;
    }

    @Nullable
    public Runnable startNonCustomTemplates(Map<TemplateImpl, String> template2argument, Editor editor, @Nullable PairProcessor<? super String, ? super String> processor2) {
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        if (template2argument == null || template2argument.isEmpty()) {
            return null;
        }
        return () -> {
            if (template2argument.size() == 1) {
                TemplateImpl template = (TemplateImpl)template2argument.keySet().iterator().next();
                String argument = (String)template2argument.get(template);
                int templateStart = TemplateManagerImpl.getTemplateStart(template, argument, caretOffset, text);
                this.startTemplateWithPrefix(editor, template, templateStart, processor2, argument);
            } else {
                ListTemplatesHandler.showTemplatesLookup(this.myProject, editor, template2argument);
            }
        };
    }

    private static List<TemplateImpl> findMatchingTemplates(CharSequence text, int caretOffset, @Nullable Character shortcutChar, TemplateSettings settings, boolean hasArgument) {
        String key;
        int wordStart;
        List<TemplateImpl> candidates = Collections.emptyList();
        for (int i2 = settings.getMaxKeyLength(); i2 >= 1 && ((wordStart = caretOffset - i2) < 0 || Character.isJavaIdentifierStart((key = text.subSequence(wordStart, caretOffset).toString()).charAt(0)) && wordStart > 0 && Character.isJavaIdentifierPart(text.charAt(wordStart - 1)) || (candidates = settings.collectMatchingCandidates(key, shortcutChar, hasArgument)).isEmpty()); --i2) {
        }
        return candidates;
    }

    public void startTemplateWithPrefix(Editor editor, TemplateImpl template, @Nullable PairProcessor<? super String, ? super String> processor2, @Nullable String argument) {
        int caretOffset = editor.getCaretModel().getOffset();
        String key = template.getKey();
        int startOffset = caretOffset - key.length();
        if (argument != null) {
            if (!TemplateManagerImpl.isDelimiter(key.charAt(key.length() - 1))) {
                --startOffset;
            }
            startOffset -= argument.length();
        }
        this.startTemplateWithPrefix(editor, template, startOffset, processor2, argument);
    }

    @NotNull
    private TemplateImpl substituteTemplate(@NotNull TemplateImpl template, @NotNull Editor editor) {
        PsiFile psiFile;
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(30);
        }
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(31);
        }
        if ((psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument())) == null) {
            TemplateImpl templateImpl = template;
            if (templateImpl == null) {
                TemplateManagerImpl.$$$reportNull$$$0(32);
            }
            return templateImpl;
        }
        for (TemplateSubstitutor substitutor : TemplateSubstitutor.EP_NAME.getExtensionList()) {
            TemplateImpl substituted = substitutor.substituteTemplate(new TemplateSubstitutionContext(this.myProject, editor), template);
            if (substituted == null) continue;
            template = substituted;
        }
        TemplateImpl templateImpl = template;
        if (templateImpl == null) {
            TemplateManagerImpl.$$$reportNull$$$0(33);
        }
        return templateImpl;
    }

    public void startTemplateWithPrefix(Editor editor, TemplateImpl template, int templateStart, @Nullable PairProcessor<? super String, ? super String> processor2, @Nullable String argument) {
        int caretOffset = editor.getCaretModel().getOffset();
        TemplateState templateState = this.initTemplateState(editor);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, () -> {
            editor.getDocument().deleteString(templateStart, caretOffset);
            editor.getCaretModel().moveToOffset(templateStart);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
            HashMap<String, String> predefinedVarValues = null;
            if (argument != null) {
                predefinedVarValues = new HashMap<String, String>();
                predefinedVarValues.put("ARG", argument);
            }
            templateState.start(this.substituteTemplate(template, editor), processor2, predefinedVarValues);
            this.myEventPublisher.templateStarted(templateState);
        }, CodeInsightBundle.message((String)"insert.code.template.command", (Object[])new Object[0]), null);
    }

    private static List<TemplateImpl> filterApplicableCandidates(@NotNull TemplateActionContext templateActionContext, @NotNull List<TemplateImpl> candidates) {
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(34);
        }
        if (candidates == null) {
            TemplateManagerImpl.$$$reportNull$$$0(35);
        }
        if (candidates.isEmpty()) {
            return candidates;
        }
        PsiFile copy2 = TemplateManagerImpl.insertDummyIdentifierWithCache(templateActionContext).getFile();
        ArrayList<TemplateImpl> result2 = new ArrayList<TemplateImpl>();
        for (TemplateImpl candidate : candidates) {
            if (!TemplateManagerImpl.isApplicable(candidate, TemplateActionContext.expanding((PsiFile)copy2, (int)(templateActionContext.getStartOffset() - candidate.getKey().length())))) continue;
            result2.add(candidate);
        }
        return result2;
    }

    private static List<TemplateContextType> getBases(TemplateContextType type) {
        ArrayList<TemplateContextType> list2 = new ArrayList<TemplateContextType>();
        while ((type = type.getBaseContextType()) != null) {
            list2.add(type);
        }
        return list2;
    }

    private static Set<TemplateContextType> getDirectlyApplicableContextTypes(@NotNull TemplateActionContext templateActionContext) {
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(36);
        }
        LinkedHashSet<TemplateContextType> set = new LinkedHashSet<TemplateContextType>();
        for (TemplateContextType contextType : TemplateManagerImpl.getAllContextTypes()) {
            if (!contextType.isInContext(templateActionContext)) continue;
            set.add(contextType);
        }
        block1: while (true) {
            for (TemplateContextType type : set) {
                if (!set.removeAll(TemplateManagerImpl.getBases(type))) continue;
                continue block1;
            }
            break;
        }
        return set;
    }

    @NotNull
    public static List<TemplateContextType> getAllContextTypes() {
        List list2 = ((ExtensionPoint)TEMPLATE_CONTEXT_EP.getValue()).getExtensionList();
        if (list2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(37);
        }
        return list2;
    }

    @Override
    @Nullable
    public Template getActiveTemplate(@NotNull Editor editor) {
        TemplateState templateState;
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(38);
        }
        return (templateState = TemplateManagerImpl.getTemplateState(editor)) != null ? templateState.getTemplate() : null;
    }

    @Override
    public boolean finishTemplate(@NotNull Editor editor) {
        TemplateState state;
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(39);
        }
        if ((state = TemplateManagerImpl.getTemplateState(editor)) != null) {
            state.gotoEnd();
            return true;
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static boolean isApplicable(PsiFile file2, int offset, TemplateImpl template) {
        return TemplateManagerImpl.isApplicable(template, TemplateActionContext.expanding((PsiFile)file2, (int)offset));
    }

    public static boolean isApplicable(TemplateImpl template, @NotNull TemplateActionContext templateActionContext) {
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(40);
        }
        return TemplateManagerImpl.isApplicable(template, TemplateManagerImpl.getApplicableContextTypes(templateActionContext));
    }

    public static boolean isApplicable(TemplateImpl template, Set<? extends TemplateContextType> contextTypes) {
        for (TemplateContextType templateContextType : contextTypes) {
            if (!template.getTemplateContext().isEnabled(templateContextType)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static List<TemplateImpl> listApplicableTemplates(PsiFile file2, int offset, boolean selectionOnly) {
        return TemplateManagerImpl.listApplicableTemplates(TemplateActionContext.create((PsiFile)file2, null, (int)offset, (int)offset, (boolean)selectionOnly));
    }

    public static List<TemplateImpl> listApplicableTemplates(@NotNull TemplateActionContext templateActionContext) {
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(41);
        }
        Set<TemplateContextType> contextTypes = TemplateManagerImpl.getApplicableContextTypes(templateActionContext);
        ArrayList<TemplateImpl> result2 = new ArrayList<TemplateImpl>();
        for (TemplateImpl template : TemplateSettings.getInstance().getTemplates()) {
            if (template.isDeactivated() || templateActionContext.isSurrounding() && !template.isSelectionTemplate() || !TemplateManagerImpl.isApplicable(template, contextTypes)) continue;
            result2.add(template);
        }
        return result2;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static List<TemplateImpl> listApplicableTemplateWithInsertingDummyIdentifier(Editor editor, PsiFile file2, boolean selectionOnly) {
        return TemplateManagerImpl.listApplicableTemplateWithInsertingDummyIdentifier(selectionOnly ? TemplateActionContext.surrounding((PsiFile)file2, (Editor)editor) : TemplateActionContext.expanding((PsiFile)file2, (Editor)editor));
    }

    public static List<TemplateImpl> listApplicableTemplateWithInsertingDummyIdentifier(@NotNull TemplateActionContext templateActionContext) {
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(42);
        }
        OffsetsInFile offsets2 = TemplateManagerImpl.insertDummyIdentifierWithCache(templateActionContext);
        return TemplateManagerImpl.listApplicableTemplates(TemplateActionContext.create((PsiFile)offsets2.getFile(), null, (int)TemplateManagerImpl.getStartOffset(offsets2), (int)TemplateManagerImpl.getEndOffset(offsets2), (boolean)templateActionContext.isSurrounding()));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static List<CustomLiveTemplate> listApplicableCustomTemplates(@NotNull Editor editor, @NotNull PsiFile file2, boolean selectionOnly) {
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(43);
        }
        if (file2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(44);
        }
        return TemplateManagerImpl.listApplicableCustomTemplates(selectionOnly ? TemplateActionContext.surrounding((PsiFile)file2, (Editor)editor) : TemplateActionContext.expanding((PsiFile)file2, (Editor)editor));
    }

    public static List<CustomLiveTemplate> listApplicableCustomTemplates(@NotNull TemplateActionContext templateActionContext) {
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(45);
        }
        ArrayList<CustomLiveTemplate> result2 = new ArrayList<CustomLiveTemplate>();
        for (CustomLiveTemplate template : (CustomLiveTemplate[])CustomLiveTemplate.EP_NAME.getExtensions()) {
            if (templateActionContext.isSurrounding() && !template.supportsWrapping() || !TemplateManagerImpl.isApplicable(template, templateActionContext)) continue;
            result2.add(template);
        }
        return result2;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static Set<TemplateContextType> getApplicableContextTypes(PsiFile file2, int offset) {
        return TemplateManagerImpl.getApplicableContextTypes(TemplateActionContext.expanding((PsiFile)file2, (int)offset));
    }

    public static Set<TemplateContextType> getApplicableContextTypes(@NotNull TemplateActionContext templateActionContext) {
        PsiFile basePsi;
        Language languageAtOffset;
        PsiFile basePsi2;
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(46);
        }
        Set<TemplateContextType> result2 = TemplateManagerImpl.getDirectlyApplicableContextTypes(templateActionContext);
        PsiFile file2 = templateActionContext.getFile();
        Language baseLanguage = file2.getViewProvider().getBaseLanguage();
        if (baseLanguage != file2.getLanguage() && (basePsi2 = file2.getViewProvider().getPsi(baseLanguage)) != null) {
            result2.addAll(TemplateManagerImpl.getDirectlyApplicableContextTypes(templateActionContext.withFile(basePsi2)));
        }
        if ((languageAtOffset = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)templateActionContext.getStartOffset())) != file2.getLanguage() && languageAtOffset != baseLanguage && (basePsi = file2.getViewProvider().getPsi(languageAtOffset)) != null) {
            result2.addAll(TemplateManagerImpl.getDirectlyApplicableContextTypes(templateActionContext.withFile(basePsi)));
        }
        return result2;
    }

    private static int getStartOffset(OffsetsInFile offsets2) {
        return offsets2.getOffsets().getOffset(START_OFFSET);
    }

    private static int getEndOffset(OffsetsInFile offsets2) {
        return offsets2.getOffsets().getOffset(END_OFFSET);
    }

    private static OffsetsInFile insertDummyIdentifierWithCache(@NotNull TemplateActionContext templateActionContext) {
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(47);
        }
        ProperTextRange editRange = ProperTextRange.create((int)templateActionContext.getStartOffset(), (int)templateActionContext.getEndOffset());
        PsiFile file2 = templateActionContext.getFile();
        TemplateManagerImpl.assertRangeWithinDocument(editRange, Objects.requireNonNull(file2.getViewProvider().getDocument()));
        ConcurrentMap map2 = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)file2, () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(key -> TemplateManagerImpl.copyWithDummyIdentifier(new OffsetsInFile(file2), ((ProperTextRange)key.first).getStartOffset(), ((ProperTextRange)key.first).getEndOffset(), (String)key.second)), (Object[])new Object[]{file2, file2.getViewProvider().getDocument()}));
        return (OffsetsInFile)map2.get(Pair.create((Object)editRange, (Object)CompletionUtil.DUMMY_IDENTIFIER_TRIMMED));
    }

    private static void assertRangeWithinDocument(ProperTextRange editRange, Document document) {
        TextRange docRange = TextRange.from((int)0, (int)document.getTextLength());
        assert (docRange.contains((TextRange)editRange)) : docRange + " doesn't contain " + editRange;
    }

    @NotNull
    public static OffsetsInFile copyWithDummyIdentifier(OffsetsInFile offsetMap, int startOffset, int endOffset, String replacement) {
        offsetMap.getOffsets().addOffset(START_OFFSET, startOffset);
        offsetMap.getOffsets().addOffset(END_OFFSET, endOffset);
        Document document = offsetMap.getFile().getViewProvider().getDocument();
        assert (document != null);
        if (replacement.isEmpty() && startOffset == endOffset && PsiDocumentManager.getInstance((Project)offsetMap.getFile().getProject()).isCommitted(document)) {
            OffsetsInFile offsetsInFile = offsetMap;
            if (offsetsInFile == null) {
                TemplateManagerImpl.$$$reportNull$$$0(48);
            }
            return offsetsInFile;
        }
        OffsetsInFile hostOffsets = offsetMap.toTopLevelFile();
        OffsetsInFile hostCopy = hostOffsets.copyWithReplacement(TemplateManagerImpl.getStartOffset(hostOffsets), TemplateManagerImpl.getEndOffset(hostOffsets), replacement);
        OffsetsInFile offsetsInFile = hostCopy.toInjectedIfAny(TemplateManagerImpl.getStartOffset(hostCopy));
        if (offsetsInFile == null) {
            TemplateManagerImpl.$$$reportNull$$$0(49);
        }
        return offsetsInFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 32: 
            case 33: 
            case 37: 
            case 48: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 32: 
            case 33: 
            case 37: 
            case 48: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 23: 
            case 28: 
            case 31: 
            case 38: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 32: 
            case 33: 
            case 37: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateManagerImpl";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 22: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customLiveTemplate";
                break;
            }
            case 24: 
            case 29: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: 
            case 34: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateActionContext";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateManagerImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "initTemplateState";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteTemplate";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContextTypes";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithDummyIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "clearTemplateState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initTemplateState";
                break;
            }
            case 8: 
            case 32: 
            case 33: 
            case 37: 
            case 48: 
            case 49: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "startTemplate";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addToMap";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "substituteTemplate";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "filterApplicableCandidates";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getDirectlyApplicableContextTypes";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getActiveTemplate";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "finishTemplate";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "listApplicableTemplates";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "listApplicableTemplateWithInsertingDummyIdentifier";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "listApplicableCustomTemplates";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getApplicableContextTypes";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "insertDummyIdentifierWithCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 32: 
            case 33: 
            case 37: 
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

