/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.analysis;

import com.intellij.diagnostic.hprof.analysis.AnalysisConfig;
import com.intellij.diagnostic.hprof.analysis.AnalysisContext;
import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.classstore.InstanceField;
import com.intellij.diagnostic.hprof.navigator.ObjectNavigator;
import com.intellij.diagnostic.hprof.navigator.RootReason;
import com.intellij.diagnostic.hprof.util.HeapReportUtils;
import com.intellij.diagnostic.hprof.util.IntList;
import com.intellij.diagnostic.hprof.util.TruncatingPrintBuffer;
import com.intellij.diagnostic.hprof.util.UByteList;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\b\u001c\u001d\u001e\u001f !\"#B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree;", "", "analysisContext", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;", "treeDisplayOptions", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisConfig$TreeDisplayOptions;", "allObjectsOfClass", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "(Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;Lcom/intellij/diagnostic/hprof/analysis/AnalysisConfig$TreeDisplayOptions;Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;)V", "getAnalysisContext", "()Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;", "countOfIgnoredObjects", "", "objectSizeStrategy", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "topNode", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RootNode;", "getTreeDisplayOptions", "()Lcom/intellij/diagnostic/hprof/analysis/AnalysisConfig$TreeDisplayOptions;", "getDisposedDominatorNodes", "", "", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;", "printTree", "", "registerObject", "", "objectId", "AllObjectsSameSizeStrategy", "DirectByteBufferNativeSizeStrategy", "Edge", "Node", "ObjectSizeCalculationStrategy", "RegularNode", "RootNode", "SizeFromObjectNavigatorStrategy", "intellij.platform.ide.impl"})
public final class GCRootPathsTree {
    private final RootNode topNode;
    private int countOfIgnoredObjects;
    private final ObjectSizeCalculationStrategy objectSizeStrategy;
    @NotNull
    private final AnalysisContext analysisContext;
    @NotNull
    private final AnalysisConfig.TreeDisplayOptions treeDisplayOptions;

    /*
     * WARNING - void declaration
     */
    public final void registerObject(int objectId) {
        ObjectNavigator nav = this.analysisContext.getNavigator();
        IntList parentMapping = this.analysisContext.getParentList();
        UByteList refIndexMapping = this.analysisContext.getRefIndexList();
        IntList sizesMapping = this.analysisContext.getSizesList();
        TIntHashSet disposedObjectsIDsSet = this.analysisContext.getDisposedObjectsIDs();
        TIntArrayList gcPath = new TIntArrayList();
        TIntArrayList fieldsPath = new TIntArrayList();
        int objectIterationId = objectId;
        int parentId = parentMapping.get(objectIterationId);
        fieldsPath.add(0);
        int maxTreeDepth = this.treeDisplayOptions.getMaximumTreeDepth();
        for (int count = 0; count < maxTreeDepth && parentId != objectIterationId; ++count) {
            gcPath.add(objectIterationId);
            if (this.treeDisplayOptions.getShowFieldNames()) {
                fieldsPath.add(refIndexMapping.get(objectIterationId));
            } else {
                fieldsPath.add(0);
            }
            objectIterationId = parentId;
            parentId = parentMapping.get(objectIterationId);
        }
        if (parentId != objectIterationId) {
            int n = this.countOfIgnoredObjects;
            this.countOfIgnoredObjects = n + 1;
            return;
        }
        gcPath.add(objectIterationId);
        boolean bl = gcPath.size() == fieldsPath.size();
        boolean bl2 = false;
        int n = 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int size = this.objectSizeStrategy.calculateObjectSize(nav, objectId);
        Node currentNode = this.topNode;
        n = gcPath.size() - 1;
        boolean bl4 = false;
        while (n >= 0) {
            void i2;
            int id2 = gcPath.get((int)i2);
            ClassDefinition classDefinition = nav.getClassForObjectId(id2);
            InstanceField field = null;
            if (fieldsPath.get((int)i2) != 0) {
                field = classDefinition.getRefField(nav.getClassStore(), fieldsPath.get((int)i2) - 1);
            }
            currentNode = currentNode.addEdge(id2, size, sizesMapping.get(id2), classDefinition, field, disposedObjectsIDsSet.contains(id2));
            --i2;
        }
    }

    @NotNull
    public final String printTree() {
        StringBuilder result2 = new StringBuilder();
        if (this.countOfIgnoredObjects > 0) {
            result2.append("Ignored " + this.countOfIgnoredObjects + " too-deep objects\n");
        }
        Function1 rootReasonGetter2 = (Function1)new Function1<Integer, String>(this){
            final /* synthetic */ GCRootPathsTree this$0;

            @NotNull
            public final String invoke(int id2) {
                Object object = this.this$0.getAnalysisContext().getNavigator().getRootReasonForObjectId(id2);
                if (object == null || (object = ((RootReason)object).getDescription()) == null) {
                    object = "<Couldn't find root description>";
                }
                return object;
            }
            {
                this.this$0 = gCRootPathsTree;
                super(1);
            }
        };
        result2.append(this.topNode.createHotPathReport(this.treeDisplayOptions, (Function1<? super Integer, String>)rootReasonGetter2));
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    @NotNull
    public final Map<ClassDefinition, List<RegularNode>> getDisposedDominatorNodes() {
        HashMap result2 = new HashMap();
        this.topNode.collectDisposedDominatorNodes(result2);
        return result2;
    }

    @NotNull
    public final AnalysisContext getAnalysisContext() {
        return this.analysisContext;
    }

    @NotNull
    public final AnalysisConfig.TreeDisplayOptions getTreeDisplayOptions() {
        return this.treeDisplayOptions;
    }

    public GCRootPathsTree(@NotNull AnalysisContext analysisContext, @NotNull AnalysisConfig.TreeDisplayOptions treeDisplayOptions, @Nullable ClassDefinition allObjectsOfClass) {
        Intrinsics.checkParameterIsNotNull((Object)analysisContext, (String)"analysisContext");
        Intrinsics.checkParameterIsNotNull((Object)treeDisplayOptions, (String)"treeDisplayOptions");
        this.analysisContext = analysisContext;
        this.treeDisplayOptions = treeDisplayOptions;
        this.topNode = new RootNode(this.analysisContext.getClassStore());
        this.objectSizeStrategy = ObjectSizeCalculationStrategy.Companion.getBestStrategyForClass(allObjectsOfClass);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\b"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "", "calculateObjectSize", "", "nav", "Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;", "id", "Companion", "intellij.platform.ide.impl"})
    public static interface ObjectSizeCalculationStrategy {
        public static final Companion Companion = Companion.$$INSTANCE;

        public int calculateObjectSize(@NotNull ObjectNavigator var1, int var2);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy$Companion;", "", "()V", "getBestStrategyForClass", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "intellij.platform.ide.impl"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            @NotNull
            public final ObjectSizeCalculationStrategy getBestStrategyForClass(@Nullable ClassDefinition classDefinition) {
                if (classDefinition == null || classDefinition.isArray()) {
                    return new SizeFromObjectNavigatorStrategy();
                }
                if (Intrinsics.areEqual((Object)classDefinition.getName(), (Object)"java.nio.DirectByteBuffer")) {
                    return new DirectByteBufferNativeSizeStrategy(classDefinition);
                }
                return new AllObjectsSameSizeStrategy(classDefinition.getInstanceSize() + ClassDefinition.Companion.getOBJECT_PREAMBLE_SIZE());
            }

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$AllObjectsSameSizeStrategy;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "size", "", "(I)V", "objectSize", "calculateObjectSize", "nav", "Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;", "id", "intellij.platform.ide.impl"})
    private static final class AllObjectsSameSizeStrategy
    implements ObjectSizeCalculationStrategy {
        private final int objectSize;

        @Override
        public int calculateObjectSize(@NotNull ObjectNavigator nav, int id2) {
            Intrinsics.checkParameterIsNotNull((Object)nav, (String)"nav");
            return this.objectSize;
        }

        public AllObjectsSameSizeStrategy(int size) {
            this.objectSize = size;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$SizeFromObjectNavigatorStrategy;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "()V", "calculateObjectSize", "", "nav", "Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;", "id", "intellij.platform.ide.impl"})
    private static final class SizeFromObjectNavigatorStrategy
    implements ObjectSizeCalculationStrategy {
        @Override
        public int calculateObjectSize(@NotNull ObjectNavigator nav, int id2) {
            Intrinsics.checkParameterIsNotNull((Object)nav, (String)"nav");
            nav.goTo(id2, ObjectNavigator.ReferenceResolution.NO_REFERENCES);
            return nav.getObjectSize();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$DirectByteBufferNativeSizeStrategy;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "(Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;)V", "calculateObjectSize", "", "nav", "Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;", "id", "intellij.platform.ide.impl"})
    private static final class DirectByteBufferNativeSizeStrategy
    implements ObjectSizeCalculationStrategy {
        private final ClassDefinition classDefinition;

        @Override
        public int calculateObjectSize(@NotNull ObjectNavigator nav, int id2) {
            Intrinsics.checkParameterIsNotNull((Object)nav, (String)"nav");
            nav.goTo(id2, ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
            boolean bl = Intrinsics.areEqual((Object)nav.getClass(), (Object)this.classDefinition);
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            return nav.getExtraData() + nav.getObjectSize();
        }

        public DirectByteBufferNativeSizeStrategy(@NotNull ClassDefinition classDefinition) {
            Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
            this.classDefinition = classDefinition;
            boolean bl = Intrinsics.areEqual((Object)this.classDefinition.getName(), (Object)"java.nio.DirectByteBuffer");
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J:\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\r"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Node;", "", "addEdge", "objectId", "", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "field", "Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "disposed", "", "intellij.platform.ide.impl"})
    public static interface Node {
        @NotNull
        public Node addEdge(int var1, int var2, int var3, @NotNull ClassDefinition var4, @Nullable InstanceField var5, boolean var6);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;", "", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "field", "Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "disposed", "", "(Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;Lcom/intellij/diagnostic/hprof/classstore/InstanceField;Z)V", "getClassDefinition", "()Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "getDisposed", "()Z", "getField", "()Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    public static final class Edge {
        @NotNull
        private final ClassDefinition classDefinition;
        @Nullable
        private final InstanceField field;
        private final boolean disposed;

        @NotNull
        public final ClassDefinition getClassDefinition() {
            return this.classDefinition;
        }

        @Nullable
        public final InstanceField getField() {
            return this.field;
        }

        public final boolean getDisposed() {
            return this.disposed;
        }

        public Edge(@NotNull ClassDefinition classDefinition, @Nullable InstanceField field, boolean disposed) {
            Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
            this.classDefinition = classDefinition;
            this.field = field;
            this.disposed = disposed;
        }

        @NotNull
        public final ClassDefinition component1() {
            return this.classDefinition;
        }

        @Nullable
        public final InstanceField component2() {
            return this.field;
        }

        public final boolean component3() {
            return this.disposed;
        }

        @NotNull
        public final Edge copy(@NotNull ClassDefinition classDefinition, @Nullable InstanceField field, boolean disposed) {
            Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
            return new Edge(classDefinition, field, disposed);
        }

        public static /* synthetic */ Edge copy$default(Edge edge, ClassDefinition classDefinition, InstanceField instanceField, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                classDefinition = edge.classDefinition;
            }
            if ((n & 2) != 0) {
                instanceField = edge.field;
            }
            if ((n & 4) != 0) {
                bl = edge.disposed;
            }
            return edge.copy(classDefinition, instanceField, bl);
        }

        @NotNull
        public String toString() {
            return "Edge(classDefinition=" + this.classDefinition + ", field=" + this.field + ", disposed=" + this.disposed + ")";
        }

        public int hashCode() {
            ClassDefinition classDefinition = this.classDefinition;
            InstanceField instanceField = this.field;
            int n = ((classDefinition != null ? ((Object)classDefinition).hashCode() : 0) * 31 + (instanceField != null ? instanceField.hashCode() : 0)) * 31;
            int n2 = this.disposed ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Edge)) break block3;
                    Edge edge = (Edge)object;
                    if (!Intrinsics.areEqual((Object)this.classDefinition, (Object)edge.classDefinition) || !Intrinsics.areEqual((Object)this.field, (Object)edge.field) || this.disposed != edge.disposed) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020%2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000(0'R(\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Node;", "()V", "edges", "Ljava/util/HashMap;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;", "getEdges", "()Ljava/util/HashMap;", "setEdges", "(Ljava/util/HashMap;)V", "instances", "Lgnu/trove/TIntHashSet;", "getInstances", "()Lgnu/trove/TIntHashSet;", "pathsCount", "", "getPathsCount", "()I", "setPathsCount", "(I)V", "pathsSize", "getPathsSize", "setPathsSize", "totalSizeInDwords", "getTotalSizeInDwords", "setTotalSizeInDwords", "addEdge", "objectId", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "field", "Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "disposed", "", "collectDisposedDominatorNodes", "", "result", "", "", "intellij.platform.ide.impl"})
    public static final class RegularNode
    implements Node {
        @Nullable
        private HashMap<Edge, RegularNode> edges;
        private int pathsCount;
        private int pathsSize;
        private int totalSizeInDwords;
        @NotNull
        private final TIntHashSet instances = new TIntHashSet(1);

        @Nullable
        public final HashMap<Edge, RegularNode> getEdges() {
            return this.edges;
        }

        public final void setEdges(@Nullable HashMap<Edge, RegularNode> hashMap) {
            this.edges = hashMap;
        }

        public final int getPathsCount() {
            return this.pathsCount;
        }

        public final void setPathsCount(int n) {
            this.pathsCount = n;
        }

        public final int getPathsSize() {
            return this.pathsSize;
        }

        public final void setPathsSize(int n) {
            this.pathsSize = n;
        }

        public final int getTotalSizeInDwords() {
            return this.totalSizeInDwords;
        }

        public final void setTotalSizeInDwords(int n) {
            this.totalSizeInDwords = n;
        }

        @NotNull
        public final TIntHashSet getInstances() {
            return this.instances;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Node addEdge(int objectId, int objectSize, int subgraphSizeInDwords, @NotNull ClassDefinition classDefinition, @Nullable InstanceField field, boolean disposed) {
            Object object;
            void $this$getOrPut$iv22;
            Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
            HashMap<Edge, RegularNode> localEdges = this.edges;
            if (localEdges == null) {
                this.edges = localEdges = new HashMap(1);
            }
            Map map2 = localEdges;
            Edge key$iv = new Edge(classDefinition, field, disposed);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv22.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                RegularNode answer$iv = new RegularNode();
                $this$getOrPut$iv22.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            RegularNode node = (RegularNode)object;
            int $this$getOrPut$iv22 = node.pathsCount;
            node.pathsCount = $this$getOrPut$iv22 + 1;
            node.pathsSize = (long)node.pathsSize + (long)objectSize > (long)Integer.MAX_VALUE ? Integer.MAX_VALUE : (node.pathsSize += objectSize);
            boolean added = node.instances.add(objectId);
            if (added) {
                node.totalSizeInDwords = (long)node.totalSizeInDwords + (long)subgraphSizeInDwords > (long)Integer.MAX_VALUE ? Integer.MAX_VALUE : (node.totalSizeInDwords += subgraphSizeInDwords);
            }
            return node;
        }

        /*
         * WARNING - void declaration
         */
        public final void collectDisposedDominatorNodes(@NotNull Map<ClassDefinition, List<RegularNode>> result2) {
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            ArrayDeque<RegularNode> stack = new ArrayDeque<RegularNode>();
            stack.push(this);
            block0: while (true) {
                Collection collection = stack;
                boolean bl = false;
                if (!(!collection.isEmpty())) break;
                RegularNode currentNode = (RegularNode)stack.pop();
                HashMap<Edge, RegularNode> hashMap = currentNode.edges;
                if (hashMap == null) continue;
                Map $this$forEach$iv = hashMap;
                boolean $i$f$forEach = false;
                Map map2 = $this$forEach$iv;
                boolean bl2 = false;
                Iterator iterator2 = map2.entrySet().iterator();
                while (true) {
                    void edge;
                    Map.Entry element$iv;
                    if (!iterator2.hasNext()) continue block0;
                    Map.Entry $dstr$edge$childNode = element$iv = iterator2.next();
                    boolean bl3 = false;
                    Object object = $dstr$edge$childNode;
                    boolean bl4 = false;
                    Edge edge2 = (Edge)object.getKey();
                    object = $dstr$edge$childNode;
                    bl4 = false;
                    RegularNode childNode = (RegularNode)object.getValue();
                    if (edge.getDisposed()) {
                        Object object2;
                        void $this$getOrPut$iv;
                        object = result2;
                        ClassDefinition key$iv = edge.getClassDefinition();
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl5 = false;
                            boolean bl6 = false;
                            List answer$iv = new ArrayList();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = value$iv;
                        }
                        ((List)object2).add(childNode);
                        continue;
                    }
                    stack.push(childNode);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\n\u0018\u00002\u00020\u0001:\u000223B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0002J \u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001c0\u001bJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001e0\"J\u0089\u0001\u0010#\u001a\u00020\u00192\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020%0\"2\b\u0010&\u001a\u0004\u0018\u00010\u000e2\b\u0010'\u001a\u0004\u0018\u00010\u000e2\b\u0010(\u001a\u0004\u0018\u00010\u000e2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010\u000e2\u0006\u0010,\u001a\u00020\u00162\b\u0010-\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010.\u001a\u0004\u0018\u00010\u001e2\u0006\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u00101R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00064"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RootNode;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Node;", "classStore", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "(Lcom/intellij/diagnostic/hprof/classstore/ClassStore;)V", "edges", "Lgnu/trove/TIntObjectHashMap;", "Lkotlin/Pair;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;", "getEdges", "()Lgnu/trove/TIntObjectHashMap;", "addEdge", "objectId", "", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "field", "Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "disposed", "", "calculateTotalInstanceCount", "collectDisposedDominatorNodes", "", "result", "", "", "createHotPathReport", "", "treeDisplayOptions", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisConfig$TreeDisplayOptions;", "rootReasonGetter", "Lkotlin/Function1;", "printReportLine", "printFunc", "", "pathsCount", "percent", "instanceSize", "subgraphSize", "", "instanceCount", "lastInPath", "softWeakDescriptor", "fieldName", "indent", "text", "(Lkotlin/jvm/functions/Function1;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Long;Ljava/lang/Integer;ZLjava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "SoftWeakClassCache", "StackEntry", "intellij.platform.ide.impl"})
    public static final class RootNode
    implements Node {
        @NotNull
        private final TIntObjectHashMap<Pair<RegularNode, Edge>> edges;
        private final ClassStore classStore;

        @NotNull
        public final TIntObjectHashMap<Pair<RegularNode, Edge>> getEdges() {
            return this.edges;
        }

        @Override
        @NotNull
        public Node addEdge(int objectId, int objectSize, int subgraphSizeInDwords, @NotNull ClassDefinition classDefinition, @Nullable InstanceField field, boolean disposed) {
            Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
            Pair pair = (Pair)this.edges.get(objectId);
            RegularNode nullableNode = pair != null ? (RegularNode)pair.getFirst() : null;
            RegularNode node = null;
            if (nullableNode != null) {
                node = nullableNode;
            } else {
                RegularNode newNode = new RegularNode();
                Pair pair2 = new Pair((Object)newNode, (Object)new Edge(classDefinition, field, disposed));
                newNode.getInstances().add(objectId);
                this.edges.put(objectId, (Object)pair2);
                node = newNode;
                node.setTotalSizeInDwords(subgraphSizeInDwords);
            }
            RegularNode regularNode = node;
            int n = regularNode.getPathsCount();
            regularNode.setPathsCount(n + 1);
            if ((long)node.getPathsSize() + (long)objectSize > (long)Integer.MAX_VALUE) {
                node.setPathsSize(Integer.MAX_VALUE);
            } else {
                RegularNode regularNode2 = node;
                regularNode2.setPathsSize(regularNode2.getPathsSize() + objectSize);
            }
            return node;
        }

        /*
         * WARNING - void declaration
         */
        private final int calculateTotalInstanceCount() {
            void result2;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            this.edges.forEachValue((TObjectProcedure)new TObjectProcedure<Pair<? extends RegularNode, ? extends Edge>>((Ref.IntRef)result2){
                final /* synthetic */ Ref.IntRef $result;

                public final boolean execute(Pair<RegularNode, Edge> $dstr$node$_u24__u24) {
                    RegularNode node = (RegularNode)$dstr$node$_u24__u24.component1();
                    this.$result.element += node.getPathsCount();
                    return true;
                }
                {
                    this.$result = intRef;
                }
            });
            return result2.element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final String createHotPathReport(@NotNull AnalysisConfig.TreeDisplayOptions treeDisplayOptions, @NotNull Function1<? super Integer, String> rootReasonGetter2) {
            Object object;
            int n;
            Iterable $this$filterIndexedTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)treeDisplayOptions, (String)"treeDisplayOptions");
            Intrinsics.checkParameterIsNotNull(rootReasonGetter2, (String)"rootReasonGetter");
            boolean bl = false;
            List rootList = new ArrayList();
            StringBuilder result2 = new StringBuilder();
            Function1 printFunc2 = (Function1)new Function1<String, Unit>(result2){
                final /* synthetic */ StringBuilder $result;

                public final void invoke(@NotNull String s) {
                    Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                    StringBuilder stringBuilder = this.$result;
                    boolean bl = false;
                    StringBuilder stringBuilder2 = stringBuilder.append(s);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder2);
                }
                {
                    this.$result = stringBuilder;
                    super(1);
                }
            };
            this.edges.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Pair<? extends RegularNode, ? extends Edge>>(rootList){
                final /* synthetic */ List $rootList;

                /*
                 * WARNING - void declaration
                 */
                public final boolean execute(int objectId, Pair<RegularNode, Edge> $dstr$node$edge) {
                    void node;
                    RegularNode regularNode = (RegularNode)$dstr$node$edge.component1();
                    Edge edge = (Edge)$dstr$node$edge.component2();
                    return this.$rootList.add(new Triple((Object)objectId, (Object)node, (Object)edge));
                }
                {
                    this.$rootList = list2;
                }
            });
            int totalInstanceCount = this.calculateTotalInstanceCount();
            int minimumObjectsForReport = Math.min(treeDisplayOptions.getMinimumObjectCount(), (int)(Math.ceil((double)totalInstanceCount / 100.0) * (double)treeDisplayOptions.getMinimumObjectCountPercent()));
            SoftWeakClassCache softWeakClassCache = new SoftWeakClassCache(this.classStore);
            Iterable $this$filterIndexed$iv = rootList;
            boolean $i$f$filterIndexed = false;
            Iterable iterable = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo22 = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void $dstr$_u24__u24$node$_u24__u24;
                void element$iv$iv;
                int n2 = index$iv$iv$iv++;
                n = 0;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n3 = n2;
                Object t = item$iv$iv$iv;
                int index$iv$iv = n3;
                boolean bl2 = false;
                object = (Triple)element$iv$iv;
                int index = index$iv$iv;
                boolean bl3 = false;
                RegularNode node = (RegularNode)$dstr$_u24__u24$node$_u24__u24.component2();
                if (!(index < treeDisplayOptions.getMinimumPaths() || node.getPathsCount() >= minimumObjectsForReport || node.getPathsSize() >= treeDisplayOptions.getMinimumObjectSize())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            $this$filterIndexedTo$iv$iv = $this$sortedByDescending$iv;
            boolean bl4 = false;
            Comparator $i$f$filterIndexedTo22 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Triple it = (Triple)b;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(((RegularNode)it.getSecond()).getPathsSize());
                    it = (Triple)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = ((RegularNode)it.getSecond()).getPathsSize();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            Iterable $this$forEachIndexed$iv = CollectionsKt.sortedWith((Iterable)$this$filterIndexedTo$iv$iv, (Comparator)$i$f$filterIndexedTo22);
            boolean $i$f$forEachIndexed2 = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void rootNode;
                void rootObjectId;
                void $dstr$rootObjectId$rootNode$rootEdge;
                int n4 = index$iv++;
                boolean bl5 = false;
                if (n4 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n5 = n4;
                Triple triple = (Triple)item$iv;
                int index = n5;
                boolean bl6 = false;
                n = ((Number)$dstr$rootObjectId$rootNode$rootEdge.component1()).intValue();
                RegularNode regularNode = (RegularNode)$dstr$rootObjectId$rootNode$rootEdge.component2();
                Edge rootEdge = (Edge)$dstr$rootObjectId$rootNode$rootEdge.component3();
                String rootReasonString = (String)rootReasonGetter2.invoke((Object)((int)rootObjectId));
                int rootPercent = (int)(100.0 * (double)rootNode.getPathsCount() / (double)totalInstanceCount);
                object = result2;
                String string = "Root " + (index + 1) + ':';
                boolean bl7 = false;
                StringBuilder stringBuilder = ((StringBuilder)object).append(string);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder);
                this.printReportLine((Function1<? super String, ? extends Object>)printFunc2, rootNode.getPathsCount(), rootPercent, rootNode.getPathsSize(), (long)rootNode.getTotalSizeInDwords() * (long)4, 1, false, null, false, null, "", "ROOT: " + rootReasonString);
                object = new TruncatingPrintBuffer(treeDisplayOptions.getHeadLimit(), treeDisplayOptions.getTailLimit(), (Function1<? super String, ? extends Object>)printFunc2);
                boolean bl8 = false;
                Throwable throwable = null;
                try {
                    TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)object;
                    boolean bl9 = false;
                    ArrayDeque<StackEntry> stack = new ArrayDeque<StackEntry>();
                    stack.push(new StackEntry(rootEdge, (RegularNode)rootNode, "", ""));
                    while (!stack.isEmpty()) {
                        void $this$filterIndexedTo$iv$iv2;
                        HashMap<Edge, RegularNode> currentNodeEdges;
                        void indent;
                        void node;
                        void classDefinition;
                        void field;
                        void edge;
                        Object object2 = (StackEntry)stack.pop();
                        Edge edge2 = ((StackEntry)object2).component1();
                        RegularNode regularNode2 = ((StackEntry)object2).component2();
                        String string2 = ((StackEntry)object2).component3();
                        String nextIndent = ((StackEntry)object2).component4();
                        void var36_49 = edge;
                        object2 = var36_49.component1();
                        InstanceField instanceField = var36_49.component2();
                        boolean disposed = var36_49.component3();
                        String softWeakDescriptor = field == null ? softWeakClassCache.getSoftWeakDescriptor((ClassDefinition)classDefinition) : null;
                        void v1 = field;
                        this.printReportLine((Function1<? super String, ? extends Object>)((Function1)new Function1<String, Unit>(buffer){

                            public final void invoke(@NotNull String p1) {
                                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                                ((TruncatingPrintBuffer)this.receiver).println(p1);
                            }

                            public final KDeclarationContainer getOwner() {
                                return Reflection.getOrCreateKotlinClass(TruncatingPrintBuffer.class);
                            }

                            public final String getName() {
                                return "println";
                            }

                            public final String getSignature() {
                                return "println(Ljava/lang/String;)V";
                            }
                        }), node.getPathsCount(), (int)(100.0 * (double)node.getPathsCount() / (double)totalInstanceCount), node.getPathsSize(), (long)node.getTotalSizeInDwords() * (long)4, node.getInstances().size(), node.getEdges() == null, softWeakDescriptor, disposed, v1 != null ? v1.getName() : null, (String)indent, classDefinition.getPrettyName());
                        if (node.getEdges() == null) {
                            continue;
                        }
                        Set<Map.Entry<Edge, RegularNode>> set = currentNodeEdges.entrySet();
                        Intrinsics.checkExpressionValueIsNotNull(set, (String)"currentNodeEdges\n                  .entries");
                        Iterable $this$sortedByDescending$iv2 = set;
                        boolean $i$f$sortedByDescending2 = false;
                        Iterable iterable2 = $this$sortedByDescending$iv2;
                        boolean bl10 = false;
                        Comparator comparator2 = new Comparator<T>(){

                            public final int compare(T a, T b) {
                                boolean bl = false;
                                Map.Entry it = (Map.Entry)b;
                                boolean bl2 = false;
                                Comparable comparable = Integer.valueOf(((RegularNode)it.getValue()).getPathsSize());
                                it = (Map.Entry)a;
                                Comparable comparable2 = comparable;
                                bl2 = false;
                                Integer n = ((RegularNode)it.getValue()).getPathsSize();
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                            }
                        };
                        Iterable $this$filterIndexed$iv2 = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator2);
                        boolean $i$f$filterIndexed2 = false;
                        iterable2 = $this$filterIndexed$iv2;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterIndexedTo = false;
                        void $this$forEachIndexed$iv$iv$iv2 = $this$filterIndexedTo$iv$iv2;
                        boolean $i$f$forEachIndexed3 = false;
                        int index$iv$iv$iv2 = 0;
                        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv2) {
                            void e;
                            void element$iv$iv;
                            int n6 = index$iv$iv$iv2++;
                            boolean bl11 = false;
                            if (n6 < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            int n7 = n6;
                            Object t = item$iv$iv$iv;
                            int index$iv$iv = n7;
                            boolean bl12 = false;
                            Map.Entry entry = (Map.Entry)element$iv$iv;
                            int index2 = index$iv$iv;
                            boolean bl13 = false;
                            if (!(index2 == 0 || ((RegularNode)e.getValue()).getPathsCount() >= minimumObjectsForReport || ((RegularNode)e.getValue()).getPathsSize() >= treeDisplayOptions.getMinimumObjectSize() || (long)((RegularNode)e.getValue()).getTotalSizeInDwords() * (long)4 >= treeDisplayOptions.getMinimumSubgraphSize())) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        List childrenToReport = CollectionsKt.asReversed((List)((List)destination$iv$iv2));
                        if (childrenToReport.size() == 1 && treeDisplayOptions.getSmartIndent()) {
                            Object k = ((Map.Entry)childrenToReport.get(0)).getKey();
                            Intrinsics.checkExpressionValueIsNotNull(k, (String)"childrenToReport[0].key");
                            Edge edge3 = (Edge)k;
                            Object v = ((Map.Entry)childrenToReport.get(0)).getValue();
                            Intrinsics.checkExpressionValueIsNotNull(v, (String)"childrenToReport[0].value");
                            stack.push(new StackEntry(edge3, (RegularNode)v, nextIndent, nextIndent));
                            continue;
                        }
                        if (nextIndent.length() >= treeDisplayOptions.getMaximumIndent()) {
                            this.printReportLine((Function1<? super String, ? extends Object>)((Function1)new Function1<String, Unit>(buffer){

                                public final void invoke(@NotNull String p1) {
                                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                                    ((TruncatingPrintBuffer)this.receiver).println(p1);
                                }

                                public final KDeclarationContainer getOwner() {
                                    return Reflection.getOrCreateKotlinClass(TruncatingPrintBuffer.class);
                                }

                                public final String getName() {
                                    return "println";
                                }

                                public final String getSignature() {
                                    return "println(Ljava/lang/String;)V";
                                }
                            }), null, null, null, null, null, true, null, null, null, nextIndent, "\\-[...]");
                            continue;
                        }
                        Iterable $this$forEachIndexed$iv2 = childrenToReport;
                        boolean $i$f$forEachIndexed4 = false;
                        int index$iv2 = 0;
                        for (Object item$iv2 : $this$forEachIndexed$iv2) {
                            void e;
                            int n8 = index$iv2++;
                            boolean bl14 = false;
                            if (n8 < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            int n9 = n8;
                            Map.Entry entry = (Map.Entry)item$iv2;
                            int index3 = n9;
                            boolean bl15 = false;
                            if (index3 == 0) {
                                Object k = e.getKey();
                                Intrinsics.checkExpressionValueIsNotNull(k, (String)"e.key");
                                Edge edge4 = (Edge)k;
                                Object v = e.getValue();
                                Intrinsics.checkExpressionValueIsNotNull(v, (String)"e.value");
                                stack.push(new StackEntry(edge4, (RegularNode)v, nextIndent + "\\-", nextIndent + "  "));
                                continue;
                            }
                            Object k = e.getKey();
                            Intrinsics.checkExpressionValueIsNotNull(k, (String)"e.key");
                            Edge edge5 = (Edge)k;
                            Object v = e.getValue();
                            Intrinsics.checkExpressionValueIsNotNull(v, (String)"e.value");
                            stack.push(new StackEntry(edge5, (RegularNode)v, nextIndent + "+-", nextIndent + "| "));
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            String string = result2.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
            return string;
        }

        private final void printReportLine(Function1<? super String, ? extends Object> printFunc2, Integer pathsCount, Integer percent, Integer instanceSize, Long subgraphSize, Integer instanceCount, boolean lastInPath, String softWeakDescriptor, Boolean disposed, String fieldName, String indent, String text) {
            Object object;
            String softWeakString;
            String disposedString;
            String fieldNameString;
            String status;
            String instanceCountString;
            String instanceSizeString;
            String percentString;
            String pathsCountString;
            block20: {
                block19: {
                    Object object2;
                    block18: {
                        block17: {
                            int it;
                            Object object3;
                            int it2;
                            block16: {
                                block15: {
                                    boolean bl;
                                    Object object4;
                                    block14: {
                                        block13: {
                                            object4 = pathsCount;
                                            if (object4 == null) break block13;
                                            Integer n = object4;
                                            boolean bl2 = false;
                                            bl = false;
                                            it2 = ((Number)n).intValue();
                                            boolean bl3 = false;
                                            object4 = HeapReportUtils.INSTANCE.toShortStringAsCount(it2);
                                            if (object4 != null) break block14;
                                        }
                                        object4 = "";
                                    }
                                    pathsCountString = StringsKt.padStart$default((String)object4, (int)5, (char)'\u0000', (int)2, null);
                                    object3 = percent;
                                    if (object3 == null) break block15;
                                    Integer n = object3;
                                    bl = false;
                                    it2 = 0;
                                    it = ((Number)n).intValue();
                                    boolean bl4 = false;
                                    object3 = "" + it + '%';
                                    if (object3 != null) break block16;
                                }
                                object3 = "";
                            }
                            percentString = StringsKt.padStart$default((String)object3, (int)4, (char)'\u0000', (int)2, null);
                            object2 = instanceSize;
                            if (object2 == null) break block17;
                            Integer n = object2;
                            it2 = 0;
                            it = 0;
                            int it3 = ((Number)n).intValue();
                            boolean bl = false;
                            object2 = HeapReportUtils.INSTANCE.toShortStringAsSize(it3);
                            if (object2 != null) break block18;
                        }
                        object2 = "";
                    }
                    instanceSizeString = StringsKt.padStart$default((String)object2, (int)6, (char)'\u0000', (int)2, null);
                    Object object5 = instanceCount;
                    if (object5 == null) {
                        object5 = "";
                    }
                    instanceCountString = StringsKt.padStart$default((String)object5.toString(), (int)10, (char)'\u0000', (int)2, null);
                    status = lastInPath ? "*" : (softWeakDescriptor != null || Intrinsics.areEqual((Object)disposed, (Object)true) ? "!" : " ");
                    fieldNameString = fieldName != null ? '.' + fieldName : "";
                    disposedString = Intrinsics.areEqual((Object)disposed, (Object)true) ? " (disposed)" : "";
                    softWeakString = softWeakDescriptor != null ? " (" + softWeakDescriptor + ')' : "";
                    object = subgraphSize;
                    if (object == null) break block19;
                    Long l = object;
                    boolean bl = false;
                    boolean bl5 = false;
                    long it = ((Number)l).longValue();
                    boolean bl6 = false;
                    object = HeapReportUtils.INSTANCE.toShortStringAsSize(it);
                    if (object != null) break block20;
                }
                object = "";
            }
            String subgraphSizeString = StringsKt.padStart$default((String)object, (int)6, (char)'\u0000', (int)2, null);
            printFunc2.invoke((Object)('[' + pathsCountString + '/' + percentString + '/' + instanceSizeString + "] " + subgraphSizeString + ' ' + instanceCountString + ' ' + status + ' ' + indent + text + fieldNameString + disposedString + softWeakString));
        }

        public final void collectDisposedDominatorNodes(@NotNull Map<ClassDefinition, List<RegularNode>> result2) {
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            this.edges.forEachValue((TObjectProcedure)new TObjectProcedure<Pair<? extends RegularNode, ? extends Edge>>(result2){
                final /* synthetic */ Map $result;

                public final boolean execute(Pair<RegularNode, Edge> $dstr$node$_u24__u24) {
                    RegularNode node = (RegularNode)$dstr$node$_u24__u24.component1();
                    node.collectDisposedDominatorNodes(this.$result);
                    return true;
                }
                {
                    this.$result = map2;
                }
            });
        }

        public RootNode(@NotNull ClassStore classStore) {
            Intrinsics.checkParameterIsNotNull((Object)classStore, (String)"classStore");
            this.classStore = classStore;
            this.edges = new TIntObjectHashMap();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RootNode$StackEntry;", "", "edge", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;", "node", "Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;", "indent", "", "nextIndent", "(Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;Ljava/lang/String;Ljava/lang/String;)V", "getEdge", "()Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$Edge;", "getIndent", "()Ljava/lang/String;", "getNextIndent", "getNode", "()Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RegularNode;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
        public static final class StackEntry {
            @NotNull
            private final Edge edge;
            @NotNull
            private final RegularNode node;
            @NotNull
            private final String indent;
            @NotNull
            private final String nextIndent;

            @NotNull
            public final Edge getEdge() {
                return this.edge;
            }

            @NotNull
            public final RegularNode getNode() {
                return this.node;
            }

            @NotNull
            public final String getIndent() {
                return this.indent;
            }

            @NotNull
            public final String getNextIndent() {
                return this.nextIndent;
            }

            public StackEntry(@NotNull Edge edge, @NotNull RegularNode node, @NotNull String indent, @NotNull String nextIndent) {
                Intrinsics.checkParameterIsNotNull((Object)edge, (String)"edge");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
                Intrinsics.checkParameterIsNotNull((Object)nextIndent, (String)"nextIndent");
                this.edge = edge;
                this.node = node;
                this.indent = indent;
                this.nextIndent = nextIndent;
            }

            @NotNull
            public final Edge component1() {
                return this.edge;
            }

            @NotNull
            public final RegularNode component2() {
                return this.node;
            }

            @NotNull
            public final String component3() {
                return this.indent;
            }

            @NotNull
            public final String component4() {
                return this.nextIndent;
            }

            @NotNull
            public final StackEntry copy(@NotNull Edge edge, @NotNull RegularNode node, @NotNull String indent, @NotNull String nextIndent) {
                Intrinsics.checkParameterIsNotNull((Object)edge, (String)"edge");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
                Intrinsics.checkParameterIsNotNull((Object)nextIndent, (String)"nextIndent");
                return new StackEntry(edge, node, indent, nextIndent);
            }

            public static /* synthetic */ StackEntry copy$default(StackEntry stackEntry, Edge edge, RegularNode regularNode, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    edge = stackEntry.edge;
                }
                if ((n & 2) != 0) {
                    regularNode = stackEntry.node;
                }
                if ((n & 4) != 0) {
                    string = stackEntry.indent;
                }
                if ((n & 8) != 0) {
                    string2 = stackEntry.nextIndent;
                }
                return stackEntry.copy(edge, regularNode, string, string2);
            }

            @NotNull
            public String toString() {
                return "StackEntry(edge=" + this.edge + ", node=" + this.node + ", indent=" + this.indent + ", nextIndent=" + this.nextIndent + ")";
            }

            public int hashCode() {
                Edge edge = this.edge;
                RegularNode regularNode = this.node;
                String string = this.indent;
                String string2 = this.nextIndent;
                return (((edge != null ? ((Object)edge).hashCode() : 0) * 31 + (regularNode != null ? regularNode.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof StackEntry)) break block3;
                        StackEntry stackEntry = (StackEntry)object;
                        if (!Intrinsics.areEqual((Object)this.edge, (Object)stackEntry.edge) || !Intrinsics.areEqual((Object)this.node, (Object)stackEntry.node) || !Intrinsics.areEqual((Object)this.indent, (Object)stackEntry.indent) || !Intrinsics.areEqual((Object)this.nextIndent, (Object)stackEntry.nextIndent)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/GCRootPathsTree$RootNode$SoftWeakClassCache;", "", "classStore", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "(Lcom/intellij/diagnostic/hprof/classstore/ClassStore;)V", "nonSoftWeakClasses", "", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "getNonSoftWeakClasses", "()Ljava/util/Set;", "softClasses", "getSoftClasses", "weakClasses", "getWeakClasses", "getSoftWeakDescriptor", "", "classDefinition", "intellij.platform.ide.impl"})
        private static final class SoftWeakClassCache {
            @NotNull
            private final Set<ClassDefinition> softClasses;
            @NotNull
            private final Set<ClassDefinition> weakClasses;
            @NotNull
            private final Set<ClassDefinition> nonSoftWeakClasses;
            private final ClassStore classStore;

            @NotNull
            public final Set<ClassDefinition> getSoftClasses() {
                return this.softClasses;
            }

            @NotNull
            public final Set<ClassDefinition> getWeakClasses() {
                return this.weakClasses;
            }

            @NotNull
            public final Set<ClassDefinition> getNonSoftWeakClasses() {
                return this.nonSoftWeakClasses;
            }

            @Nullable
            public final String getSoftWeakDescriptor(@NotNull ClassDefinition classDefinition) {
                Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
                if (this.softClasses.contains(classDefinition)) {
                    return "soft";
                }
                if (this.weakClasses.contains(classDefinition)) {
                    return "weak";
                }
                if (this.nonSoftWeakClasses.contains(classDefinition)) {
                    return null;
                }
                ClassDefinition definition = classDefinition;
                while (!this.classStore.isSoftOrWeakReferenceClass(definition)) {
                    ClassDefinition superclassDefinition = definition.getSuperClass(this.classStore);
                    if (superclassDefinition == null) {
                        this.nonSoftWeakClasses.add(classDefinition);
                        return null;
                    }
                    definition = superclassDefinition;
                }
                if (Intrinsics.areEqual((Object)definition, (Object)this.classStore.getWeakReferenceClass())) {
                    this.weakClasses.add(classDefinition);
                    return "weak";
                }
                boolean bl = Intrinsics.areEqual((Object)definition, (Object)this.classStore.getSoftReferenceClass());
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                this.softClasses.add(classDefinition);
                return "soft";
            }

            public SoftWeakClassCache(@NotNull ClassStore classStore) {
                Set set;
                Intrinsics.checkParameterIsNotNull((Object)classStore, (String)"classStore");
                this.classStore = classStore;
                SoftWeakClassCache softWeakClassCache = this;
                boolean bl = false;
                softWeakClassCache.softClasses = set = (Set)new LinkedHashSet();
                softWeakClassCache = this;
                bl = false;
                softWeakClassCache.weakClasses = set = (Set)new LinkedHashSet();
                softWeakClassCache = this;
                bl = false;
                softWeakClassCache.nonSoftWeakClasses = set = (Set)new LinkedHashSet();
            }
        }
    }
}

