/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import gnu.trove.TIntFunction;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingModelSupport {
    private static final Logger LOG = Logger.getInstance(FoldingModelSupport.class);
    private static final String PLACEHOLDER = "     ";
    private static final Key<FoldingCache> CACHE_KEY = Key.create((String)"Diff.FoldingUtil.Cache");
    protected final int myCount;
    @Nullable
    protected final Project myProject;
    protected final EditorEx @NotNull [] myEditors;
    @NotNull
    protected final List<FoldedGroup> myFoldings;
    private boolean myDuringSynchronize;
    private final boolean[] myShouldUpdateLineNumbers;

    public FoldingModelSupport(@Nullable Project project, EditorEx @NotNull [] editors, @NotNull Disposable disposable2) {
        if (disposable2 == null) {
            FoldingModelSupport.$$$reportNull$$$0(0);
        }
        if (editors == null) {
            FoldingModelSupport.$$$reportNull$$$0(1);
        }
        this.myFoldings = new ArrayList<FoldedGroup>();
        this.myProject = project;
        this.myEditors = editors;
        this.myCount = this.myEditors.length;
        this.myShouldUpdateLineNumbers = new boolean[this.myCount];
        MyDocumentListener documentListener = new MyDocumentListener();
        List documents = ContainerUtil.map((Object[])this.myEditors, EditorEx::getDocument);
        TextDiffViewerUtil.installDocumentListeners(documentListener, documents, disposable2);
        for (int i2 = 0; i2 < this.myCount; ++i2) {
            if (this.myCount <= 1) continue;
            this.myEditors[i2].getFoldingModel().addListener(new MyFoldingListener(i2), disposable2);
        }
    }

    public int getCount() {
        return this.myCount;
    }

    @Nullable
    protected Data computeFoldedRanges(@Nullable Iterator<int[]> changedLines, @NotNull Settings settings) {
        if (settings == null) {
            FoldingModelSupport.$$$reportNull$$$0(2);
        }
        if (changedLines == null || settings.range == -1) {
            return null;
        }
        FoldingBuilder builder2 = new FoldingBuilder(this.myEditors, settings);
        return builder2.build(changedLines);
    }

    protected void install(@Nullable Iterator<int[]> changedLines, @Nullable UserDataHolder context, @NotNull Settings settings) {
        if (settings == null) {
            FoldingModelSupport.$$$reportNull$$$0(3);
        }
        Data data2 = this.computeFoldedRanges(changedLines, settings);
        this.install(data2, context, settings);
    }

    public void install(@Nullable Data data2, @Nullable UserDataHolder context, @NotNull Settings settings) {
        if (settings == null) {
            FoldingModelSupport.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (FoldedBlock folding2 : this.getFoldedBlocks()) {
            folding2.destroyHighlighter();
        }
        this.runBatchOperation(() -> {
            for (FoldedBlock folding2 : this.getFoldedBlocks()) {
                folding2.destroyFolding();
            }
            this.myFoldings.clear();
            if (data2 != null) {
                FoldingInstaller installer = new FoldingInstaller(context, settings);
                installer.install(data2);
            }
        });
        this.updateLineNumbers(true);
    }

    protected static int[] countLines(EditorEx @NotNull [] editors) {
        if (editors == null) {
            FoldingModelSupport.$$$reportNull$$$0(5);
        }
        return (int[])ReadAction.compute(() -> {
            int[] lineCount = new int[editors.length];
            for (int i2 = 0; i2 < editors.length; ++i2) {
                lineCount[i2] = DiffUtil.getLineCount(editors[i2].getDocument());
            }
            return lineCount;
        });
    }

    @Nullable
    private static String getRangeDescription(@NotNull Project project, int startLine, int endLine, int index, @NotNull DescriptionComputer computer) {
        if (project == null) {
            FoldingModelSupport.$$$reportNull$$$0(6);
        }
        if (computer == null) {
            FoldingModelSupport.$$$reportNull$$$0(7);
        }
        if (startLine == endLine) {
            return null;
        }
        FoldedRangeDescription endDescription = computer.computeDescription(project, endLine, index);
        if (endDescription == null) {
            return null;
        }
        FoldedRangeDescription startDescription = computer.computeDescription(project, startLine, index);
        if (Comparing.equal((Object)startDescription, (Object)endDescription) && (endDescription.anchorLine == -1 || startLine > endDescription.anchorLine)) {
            return null;
        }
        return endDescription.description;
    }

    @Nullable
    protected static FoldedRangeDescription getLineSeparatorDescription(@NotNull Project project, @NotNull Document document, int lineNumber) {
        PsiFile psiFile;
        if (project == null) {
            FoldingModelSupport.$$$reportNull$$$0(8);
        }
        if (document == null) {
            FoldingModelSupport.$$$reportNull$$$0(9);
        }
        if ((psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (document.getLineCount() <= lineNumber) {
            return null;
        }
        int offset = document.getLineStartOffset(lineNumber);
        FileBreadcrumbsCollector collector = FileBreadcrumbsCollector.findBreadcrumbsCollector((Project)project, (VirtualFile)virtualFile);
        ArrayList crumbs = ContainerUtil.newArrayList((Iterable)collector.computeCrumbs(virtualFile, document, offset, Boolean.valueOf(true)));
        if (crumbs.isEmpty()) {
            return null;
        }
        String description = StringUtil.join((Collection)crumbs, it -> it.getText(), (String)" > ");
        Crumb lastCrumb = (Crumb)crumbs.get(crumbs.size() - 1);
        int anchorOffset = lastCrumb instanceof NavigatableCrumb ? ((NavigatableCrumb)lastCrumb).getAnchorOffset() : -1;
        int anchorLine = anchorOffset != -1 ? document.getLineNumber(anchorOffset) : -1;
        return new FoldedRangeDescription(description, anchorLine);
    }

    @Nullable
    public static FoldRegion addFolding(@NotNull EditorEx editor, int start2, int end, boolean expanded) {
        if (editor == null) {
            FoldingModelSupport.$$$reportNull$$$0(10);
        }
        DocumentEx document = editor.getDocument();
        int startOffset = document.getLineStartOffset(start2);
        int endOffset = document.getLineEndOffset(end - 1);
        FoldRegion value2 = editor.getFoldingModel().addFoldRegion(startOffset, endOffset, PLACEHOLDER);
        if (value2 != null) {
            value2.setExpanded(expanded);
            value2.setInnerHighlightersMuted(true);
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBatchOperation(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            FoldingModelSupport.$$$reportNull$$$0(11);
        }
        Runnable lastRunnable = runnable2;
        for (EditorEx editor : this.myEditors) {
            Runnable finalRunnable = lastRunnable;
            lastRunnable = () -> {
                if (DiffUtil.isFocusedComponent(editor.getComponent())) {
                    editor.getFoldingModel().runBatchFoldingOperationDoNotCollapseCaret(finalRunnable);
                } else {
                    editor.getFoldingModel().runBatchFoldingOperation(finalRunnable);
                }
            };
        }
        this.myDuringSynchronize = true;
        try {
            lastRunnable.run();
        }
        finally {
            this.myDuringSynchronize = false;
        }
    }

    public void destroy() {
        for (FoldedBlock folding2 : this.getFoldedBlocks()) {
            folding2.destroyHighlighter();
        }
        this.runBatchOperation(() -> {
            for (FoldedBlock folding2 : this.getFoldedBlocks()) {
                folding2.destroyFolding();
            }
            this.myFoldings.clear();
        });
    }

    @NotNull
    public TIntFunction getLineConvertor(int index) {
        TIntFunction tIntFunction = value2 -> {
            this.updateLineNumbers(false);
            for (FoldedBlock folding2 : this.getFoldedBlocks()) {
                int line = folding2.getLine(index);
                if (line == -1) continue;
                if (line > value2) break;
                FoldRegion region = folding2.getRegion(index);
                if (line != value2 || region == null || region.isExpanded()) continue;
                return -1;
            }
            return value2;
        };
        if (tIntFunction == null) {
            FoldingModelSupport.$$$reportNull$$$0(12);
        }
        return tIntFunction;
    }

    private void updateLineNumbers(boolean force) {
        for (int i2 = 0; i2 < this.myCount; ++i2) {
            if (!this.myShouldUpdateLineNumbers[i2] && !force) continue;
            this.myShouldUpdateLineNumbers[i2] = false;
            ApplicationManager.getApplication().assertReadAccessAllowed();
            for (FoldedBlock folding2 : this.getFoldedBlocks()) {
                folding2.updateLineNumber(i2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandAll(boolean expanded) {
        if (this.myDuringSynchronize) {
            return;
        }
        this.myDuringSynchronize = true;
        try {
            int i2 = 0;
            while (i2 < this.myCount) {
                int index = i2++;
                FoldingModelEx model = this.myEditors[index].getFoldingModel();
                model.runBatchFoldingOperation(() -> {
                    for (FoldedBlock folding2 : this.getFoldedBlocks()) {
                        FoldRegion region = folding2.getRegion(index);
                        if (region == null) continue;
                        region.setExpanded(expanded);
                    }
                });
            }
        }
        finally {
            this.myDuringSynchronize = false;
        }
    }

    public void updateContext(@NotNull UserDataHolder context, @NotNull Settings settings) {
        if (context == null) {
            FoldingModelSupport.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            FoldingModelSupport.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myFoldings.isEmpty()) {
            return;
        }
        context.putUserData(CACHE_KEY, (Object)this.getFoldingCache(settings));
    }

    @NotNull
    private FoldingCache getFoldingCache(@NotNull Settings settings) {
        if (settings == null) {
            FoldingModelSupport.$$$reportNull$$$0(15);
        }
        List[] result2 = new List[this.myCount];
        for (int i2 = 0; i2 < this.myCount; ++i2) {
            result2[i2] = this.collectFoldedGroupsStates(i2);
        }
        return new FoldingCache(result2, settings.defaultExpanded);
    }

    @NotNull
    private List<FoldedGroupState> collectFoldedGroupsStates(int index) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<FoldedGroupState> ranges = new ArrayList<FoldedGroupState>();
        DocumentEx document = this.myEditors[index].getDocument();
        for (FoldedGroup group : this.myFoldings) {
            LineRange expanded = null;
            LineRange collapsed = null;
            String[] collapsedDescription = null;
            for (FoldedBlock folding2 : group.blocks) {
                int line2;
                int line1;
                FoldRegion region = folding2.getRegion(index);
                if (region == null || !region.isValid()) continue;
                if (region.isExpanded()) {
                    if (expanded != null) continue;
                    line1 = document.getLineNumber(region.getStartOffset());
                    line2 = document.getLineNumber(region.getEndOffset()) + 1;
                    expanded = new LineRange(line1, line2);
                    continue;
                }
                line1 = document.getLineNumber(region.getStartOffset());
                line2 = document.getLineNumber(region.getEndOffset()) + 1;
                collapsed = new LineRange(line1, line2);
                collapsedDescription = (String[])ContainerUtil.map((Object[])folding2.myDescriptions, it -> it != null ? it.get() : null, (Object[])ArrayUtil.EMPTY_STRING_ARRAY);
                break;
            }
            if (expanded == null && collapsed == null) continue;
            ranges.add(new FoldedGroupState(expanded, collapsed, collapsedDescription));
        }
        ArrayList<FoldedGroupState> arrayList = ranges;
        if (arrayList == null) {
            FoldingModelSupport.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private Iterable<FoldedBlock> getFoldedBlocks() {
        Iterable<FoldedBlock> iterable = () -> new Iterator<FoldedBlock>(){
            private int myGroupIndex = 0;
            private int myBlockIndex = 0;

            @Override
            public boolean hasNext() {
                return this.myGroupIndex < FoldingModelSupport.this.myFoldings.size();
            }

            @Override
            public FoldedBlock next() {
                FoldedGroup group = FoldingModelSupport.this.myFoldings.get(this.myGroupIndex);
                FoldedBlock folding2 = group.blocks.get(this.myBlockIndex);
                if (group.blocks.size() > this.myBlockIndex + 1) {
                    ++this.myBlockIndex;
                } else {
                    ++this.myGroupIndex;
                    this.myBlockIndex = 0;
                }
                return folding2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterable == null) {
            FoldingModelSupport.$$$reportNull$$$0(17);
        }
        return iterable;
    }

    private static int getRangeShift(int range2, int number) {
        switch (number) {
            case 0: {
                return range2;
            }
            case 1: {
                return range2 * 2;
            }
            case 2: {
                return range2 * 4;
            }
        }
        return -1;
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    protected static <T, V> Iterator<V> map(@Nullable List<T> list2, final @NotNull Function<? super T, ? extends V> mapping2) {
        if (mapping2 == null) {
            FoldingModelSupport.$$$reportNull$$$0(18);
        }
        if (list2 == null) {
            return null;
        }
        final Iterator<T> it = list2.iterator();
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public V next() {
                return mapping2.fun(it.next());
            }

            @Override
            public void remove() {
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/FoldingModelSupport";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineConvertor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFoldedGroupsStates";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldedBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeFoldedRanges";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "countLines";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRangeDescription";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparatorDescription";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFolding";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runBatchOperation";
                break;
            }
            case 12: 
            case 16: 
            case 17: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateContext";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingCache";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Settings {
        public final int range;
        public final boolean defaultExpanded;

        public Settings(int range2, boolean defaultExpanded) {
            this.range = range2;
            this.defaultExpanded = defaultExpanded;
        }
    }

    private static class RangeDescription {
        @Nullable
        public final String description;

        private RangeDescription(@Nullable String description) {
            this.description = description;
        }
    }

    protected class FoldedBlock {
        private final FoldRegion @NotNull [] myRegions;
        private final int @NotNull [] myLines;
        @NotNull
        private final List<RangeHighlighter> myHighlighters;
        private final LazyDescription @NotNull [] myDescriptions;
        private final ProgressIndicator myDescriptionsIndicator;

        public FoldedBlock(@NotNull FoldRegion[] regions, @Nullable DescriptionComputer descriptionComputer, String[] cachedDescriptions) {
            if (descriptionComputer == null) {
                FoldedBlock.$$$reportNull$$$0(0);
            }
            if (regions == null) {
                FoldedBlock.$$$reportNull$$$0(1);
            }
            this.myHighlighters = new ArrayList<RangeHighlighter>(FoldingModelSupport.this.myCount);
            this.myDescriptionsIndicator = new EmptyProgressIndicator();
            assert (regions.length == FoldingModelSupport.this.myCount);
            assert (cachedDescriptions == null || cachedDescriptions.length == FoldingModelSupport.this.myCount);
            this.myRegions = regions;
            this.myLines = new int[FoldingModelSupport.this.myCount];
            this.myDescriptions = new LazyDescription[FoldingModelSupport.this.myCount];
            if (FoldingModelSupport.this.myProject != null) {
                for (int i2 = 0; i2 < FoldingModelSupport.this.myCount; ++i2) {
                    String cachedDescription = cachedDescriptions != null ? cachedDescriptions[i2] : null;
                    this.myDescriptions[i2] = new LazyDescription(FoldingModelSupport.this.myProject, i2, descriptionComputer, cachedDescription);
                }
            }
        }

        public void installHighlighter(@NotNull FoldedGroup group) {
            if (group == null) {
                FoldedBlock.$$$reportNull$$$0(2);
            }
            assert (this.myHighlighters.isEmpty());
            for (int i2 = 0; i2 < FoldingModelSupport.this.myCount; ++i2) {
                FoldRegion region = this.myRegions[i2];
                if (region == null || !region.isValid()) continue;
                this.myHighlighters.addAll(DiffDrawUtil.createLineSeparatorHighlighter(FoldingModelSupport.this.myEditors[i2], region.getStartOffset(), region.getEndOffset(), this.getHighlighterCondition(group, i2), this.myDescriptions[i2]));
            }
        }

        public void destroyFolding() {
            for (int i2 = 0; i2 < FoldingModelSupport.this.myCount; ++i2) {
                FoldRegion region = this.myRegions[i2];
                if (region == null) continue;
                FoldingModelSupport.this.myEditors[i2].getFoldingModel().removeFoldRegion(region);
            }
            this.myDescriptionsIndicator.cancel();
        }

        public void destroyHighlighter() {
            for (RangeHighlighter highlighter : this.myHighlighters) {
                highlighter.dispose();
            }
            this.myHighlighters.clear();
        }

        public void updateLineNumber(int index) {
            FoldRegion region = this.myRegions[index];
            this.myLines[index] = region == null || !region.isValid() ? -1 : FoldingModelSupport.this.myEditors[index].getDocument().getLineNumber(region.getStartOffset());
        }

        @Nullable
        public FoldRegion getRegion(int index) {
            return this.myRegions[index];
        }

        public int getLine(int index) {
            return this.myLines[index];
        }

        @NotNull
        private BooleanGetter getHighlighterCondition(@NotNull FoldedGroup group, int index) {
            if (group == null) {
                FoldedBlock.$$$reportNull$$$0(3);
            }
            BooleanGetter booleanGetter = () -> {
                if (!FoldingModelSupport.this.myEditors[index].getFoldingModel().isFoldingEnabled()) {
                    return false;
                }
                for (FoldedBlock folding2 : group.blocks) {
                    boolean visible;
                    FoldRegion region = folding2.getRegion(index);
                    boolean bl = visible = region != null && region.isValid() && !region.isExpanded();
                    if (folding2 == this) {
                        return visible;
                    }
                    if (!visible) continue;
                    return false;
                }
                return false;
            };
            if (booleanGetter == null) {
                FoldedBlock.$$$reportNull$$$0(4);
            }
            return booleanGetter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptionComputer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/FoldingModelSupport$FoldedBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport$FoldedBlock";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlighterCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "installHighlighter";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getHighlighterCondition";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class LazyDescription
        implements Computable<String> {
            @NotNull
            private final Project myProject;
            private final int myIndex;
            @NotNull
            private final DescriptionComputer myDescriptionComputer;
            @NotNull
            private RangeDescription myDescription;
            private boolean myLoadingStarted;

            LazyDescription(Project project, @NotNull int index, @Nullable DescriptionComputer descriptionComputer, String cachedValue) {
                if (project == null) {
                    LazyDescription.$$$reportNull$$$0(0);
                }
                if (descriptionComputer == null) {
                    LazyDescription.$$$reportNull$$$0(1);
                }
                this.myLoadingStarted = false;
                this.myProject = project;
                this.myIndex = index;
                this.myDescriptionComputer = descriptionComputer;
                this.myDescription = new RangeDescription(cachedValue);
            }

            public String compute() {
                if (!this.myLoadingStarted) {
                    this.myLoadingStarted = true;
                    ReadAction.nonBlocking(() -> new RangeDescription(this.computeDescription())).finishOnUiThread(ModalityState.any(), result2 -> {
                        this.myDescription = result2;
                        if (result2.description != null) {
                            this.repaintEditor();
                        }
                    }).withDocumentsCommitted(this.myProject).wrapProgress(FoldedBlock.this.myDescriptionsIndicator).submit((Executor)NonUrgentExecutor.getInstance());
                }
                return this.myDescription.description;
            }

            private void repaintEditor() {
                FoldRegion region = FoldedBlock.this.myRegions[this.myIndex];
                if (region == null || !region.isValid()) {
                    return;
                }
                if (FoldingModelSupport.this.myEditors[this.myIndex].isDisposed()) {
                    return;
                }
                FoldingModelSupport.this.myEditors[this.myIndex].repaint(region.getStartOffset(), region.getEndOffset());
            }

            @Nullable
            private String computeDescription() {
                try {
                    ProgressManager.checkCanceled();
                    FoldRegion region = FoldedBlock.this.myRegions[this.myIndex];
                    if (region == null) {
                        return null;
                    }
                    int startOffset = region.getStartOffset();
                    int endOffset = region.getEndOffset();
                    if (startOffset == -1 || endOffset == -1) {
                        return null;
                    }
                    if (!region.isValid()) {
                        return null;
                    }
                    int startLine = FoldingModelSupport.this.myEditors[this.myIndex].getDocument().getLineNumber(startOffset);
                    int endLine = FoldingModelSupport.this.myEditors[this.myIndex].getDocument().getLineNumber(endOffset);
                    return FoldingModelSupport.getRangeDescription(this.myProject, startLine, endLine, this.myIndex, this.myDescriptionComputer);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                    return null;
                }
            }

            @Nullable
            public String get() {
                return this.myDescription.description;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "descriptionComputer";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/diff/tools/util/FoldingModelSupport$FoldedBlock$LazyDescription";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class FoldedGroup {
        @NotNull
        public final List<FoldedBlock> blocks;

        FoldedGroup(@NotNull List<FoldedBlock> blocks) {
            if (blocks == null) {
                FoldedGroup.$$$reportNull$$$0(0);
            }
            this.blocks = blocks;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/diff/tools/util/FoldingModelSupport$FoldedGroup", "<init>"));
        }
    }

    private static class FoldedGroupState {
        @Nullable
        public final LineRange expanded;
        @Nullable
        public final LineRange collapsed;
        public final String @Nullable [] collapsedDescription;

        FoldedGroupState(@Nullable LineRange expanded, @Nullable LineRange collapsed, String @Nullable [] collapsedDescription) {
            assert (expanded != null || collapsed != null);
            this.expanded = expanded;
            this.collapsed = collapsed;
            this.collapsedDescription = collapsedDescription;
        }

        @NotNull
        public LineRange getLineRange() {
            LineRange lineRange = this.expanded != null ? this.expanded : this.collapsed;
            if (lineRange == null) {
                FoldedGroupState.$$$reportNull$$$0(0);
            }
            return lineRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport$FoldedGroupState", "getLineRange"));
        }
    }

    private static interface DescriptionComputer {
        @Nullable
        public FoldedRangeDescription computeDescription(@NotNull Project var1, int var2, int var3);
    }

    public static class Data {
        @NotNull
        private final List<Group> groups;
        @NotNull
        private final DescriptionComputer descriptionComputer;

        private Data(@NotNull List<Group> groups, @NotNull DescriptionComputer descriptionComputer) {
            if (groups == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (descriptionComputer == null) {
                Data.$$$reportNull$$$0(1);
            }
            this.groups = groups;
            this.descriptionComputer = descriptionComputer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "groups";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptionComputer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/util/FoldingModelSupport$Data";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class Block {
            public final LineRange @NotNull [] ranges;

            private Block(LineRange @NotNull [] ranges) {
                if (ranges == null) {
                    Block.$$$reportNull$$$0(0);
                }
                this.ranges = ranges;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/util/FoldingModelSupport$Data$Block", "<init>"));
            }
        }

        private static class Group {
            @NotNull
            public final List<Block> blocks;

            private Group(@NotNull List<Block> blocks) {
                if (blocks == null) {
                    Group.$$$reportNull$$$0(0);
                }
                this.blocks = blocks;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/diff/tools/util/FoldingModelSupport$Data$Group", "<init>"));
            }
        }
    }

    private static class FoldingCache {
        public final boolean expandByDefault;
        public final List<FoldedGroupState> @NotNull [] ranges;

        FoldingCache(List<FoldedGroupState> @NotNull [] ranges, boolean expandByDefault) {
            if (ranges == null) {
                FoldingCache.$$$reportNull$$$0(0);
            }
            this.ranges = ranges;
            this.expandByDefault = expandByDefault;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingCache", "<init>"));
        }
    }

    private class ExpandSuggester {
        @Nullable
        private final FoldingCache myCache;
        private final int[] myIndex;
        private final boolean myDefault;

        ExpandSuggester(FoldingCache cache, boolean defaultValue) {
            this.myIndex = new int[FoldingModelSupport.this.myCount];
            this.myCache = cache;
            this.myDefault = defaultValue;
        }

        public boolean isExpanded(@NotNull Data.Block block) {
            if (block == null) {
                ExpandSuggester.$$$reportNull$$$0(0);
            }
            if (this.myCache == null || this.myCache.ranges.length != FoldingModelSupport.this.myCount) {
                return this.myDefault;
            }
            if (this.myDefault != this.myCache.expandByDefault) {
                return this.myDefault;
            }
            Boolean state = null;
            for (int index = 0; index < FoldingModelSupport.this.myCount; ++index) {
                Boolean sideState;
                LineRange range2 = block.ranges[index];
                if (range2 == null || (sideState = this.getCachedExpanded(range2.start, range2.end, index)) == null) continue;
                if (state == null) {
                    state = sideState;
                    continue;
                }
                if (state == sideState) continue;
                return this.myDefault;
            }
            return state == null ? this.myDefault : state;
        }

        @Nullable
        private Boolean getCachedExpanded(int start2, int end, int index) {
            if (start2 == end) {
                return null;
            }
            FoldedGroupState range2 = this.getCachedState(start2, end, index);
            if (range2 == null) {
                return null;
            }
            if (range2.collapsed != null && range2.collapsed.contains(start2, end)) {
                return false;
            }
            if (range2.expanded != null && range2.expanded.contains(start2, end)) {
                return true;
            }
            assert (false) : "Invalid LineRange" + range2.expanded + ", " + range2.collapsed + ", " + new LineRange(start2, end);
            return null;
        }

        @Nullable
        public String getCachedDescription(int start2, int end, int index) {
            if (this.myCache == null || this.myCache.ranges.length != FoldingModelSupport.this.myCount) {
                return null;
            }
            FoldedGroupState range2 = this.getCachedState(start2, end, index);
            if (range2 == null) {
                return null;
            }
            if (range2.collapsed != null && range2.collapsed.contains(start2, end)) {
                return range2.collapsedDescription != null ? range2.collapsedDescription[index] : null;
            }
            return null;
        }

        @Nullable
        private FoldedGroupState getCachedState(int start2, int end, int index) {
            if (start2 == end) {
                return null;
            }
            List<FoldedGroupState> ranges = this.myCache.ranges[index];
            while (this.myIndex[index] < ranges.size()) {
                FoldedGroupState range2 = ranges.get(this.myIndex[index]);
                LineRange lineRange = range2.getLineRange();
                if (lineRange.end > start2) {
                    if (lineRange.contains(start2, end)) {
                        return range2;
                    }
                    if (lineRange.start >= start2) {
                        return null;
                    }
                }
                int n = index;
                this.myIndex[n] = this.myIndex[n] + 1;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/diff/tools/util/FoldingModelSupport$ExpandSuggester", "isExpanded"));
        }
    }

    protected class MyPaintable
    implements DiffDividerDrawUtil.DividerSeparatorPaintable {
        private final int myLeft;
        private final int myRight;

        public MyPaintable(int left, int right) {
            this.myLeft = left;
            this.myRight = right;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerSeparatorPaintable.Handler handler2) {
            if (handler2 == null) {
                MyPaintable.$$$reportNull$$$0(0);
            }
            block0: for (FoldedGroup group : FoldingModelSupport.this.myFoldings) {
                for (FoldedBlock folding2 : group.blocks) {
                    int line2;
                    FoldRegion region1 = folding2.getRegion(this.myLeft);
                    FoldRegion region2 = folding2.getRegion(this.myRight);
                    if (region1 == null || !region1.isValid() || region1.isExpanded() || region2 == null || !region2.isValid() || region2.isExpanded()) continue;
                    int line1 = FoldingModelSupport.this.myEditors[this.myLeft].getDocument().getLineNumber(region1.getStartOffset());
                    if (handler2.process(line1, line2 = FoldingModelSupport.this.myEditors[this.myRight].getDocument().getLineNumber(region2.getStartOffset()))) continue block0;
                    return;
                }
            }
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider) {
            if (gg == null) {
                MyPaintable.$$$reportNull$$$0(1);
            }
            if (divider == null) {
                MyPaintable.$$$reportNull$$$0(2);
            }
            DiffDividerDrawUtil.paintSeparators(gg, divider.getWidth(), FoldingModelSupport.this.myEditors[this.myLeft], FoldingModelSupport.this.myEditors[this.myRight], this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gg";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport$MyPaintable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintOnDivider";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFoldingListener
    implements FoldingListener {
        private final int myIndex;
        @NotNull
        private final Set<FoldRegion> myModifiedRegions = new HashSet<FoldRegion>();

        MyFoldingListener(int index) {
            this.myIndex = index;
        }

        @Override
        public void onFoldRegionStateChange(@NotNull FoldRegion region) {
            if (region == null) {
                MyFoldingListener.$$$reportNull$$$0(0);
            }
            if (FoldingModelSupport.this.myDuringSynchronize) {
                return;
            }
            this.myModifiedRegions.add(region);
        }

        @Override
        public void onFoldProcessingEnd() {
            if (this.myModifiedRegions.isEmpty()) {
                return;
            }
            FoldingModelSupport.this.myDuringSynchronize = true;
            try {
                for (int i2 = 0; i2 < FoldingModelSupport.this.myCount; ++i2) {
                    if (i2 == this.myIndex) continue;
                    int pairedIndex = i2;
                    FoldingModelSupport.this.myEditors[pairedIndex].getFoldingModel().runBatchFoldingOperation(() -> {
                        for (FoldedBlock folding2 : FoldingModelSupport.this.getFoldedBlocks()) {
                            FoldRegion pairedRegion;
                            FoldRegion region = folding2.getRegion(this.myIndex);
                            if (region == null || !region.isValid() || !this.myModifiedRegions.contains(region) || (pairedRegion = folding2.getRegion(pairedIndex)) == null || !pairedRegion.isValid()) continue;
                            pairedRegion.setExpanded(region.isExpanded());
                        }
                    });
                }
                this.myModifiedRegions.clear();
            }
            finally {
                FoldingModelSupport.this.myDuringSynchronize = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/diff/tools/util/FoldingModelSupport$MyFoldingListener", "onFoldRegionStateChange"));
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (StringUtil.indexOf((CharSequence)e.getOldFragment(), (char)'\n') != -1 || StringUtil.indexOf((CharSequence)e.getNewFragment(), (char)'\n') != -1) {
                for (int i2 = 0; i2 < FoldingModelSupport.this.myCount; ++i2) {
                    if (FoldingModelSupport.this.myEditors[i2].getDocument() != e.getDocument()) continue;
                    ((FoldingModelSupport)FoldingModelSupport.this).myShouldUpdateLineNumbers[i2] = true;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/FoldingModelSupport$MyDocumentListener", "documentChanged"));
        }
    }

    private class FoldingInstaller {
        @NotNull
        private final ExpandSuggester myExpandSuggester;

        FoldingInstaller(@NotNull UserDataHolder context, Settings settings) {
            if (settings == null) {
                FoldingInstaller.$$$reportNull$$$0(0);
            }
            FoldingCache cache = context != null ? (FoldingCache)context.getUserData(CACHE_KEY) : null;
            this.myExpandSuggester = new ExpandSuggester(cache, settings.defaultExpanded);
        }

        public void install(@NotNull Data data2) {
            if (data2 == null) {
                FoldingInstaller.$$$reportNull$$$0(1);
            }
            for (Data.Group group : data2.groups) {
                ArrayList<FoldedBlock> blocks = new ArrayList<FoldedBlock>(3);
                for (Data.Block block : group.blocks) {
                    ContainerUtil.addIfNotNull(blocks, (Object)this.createBlock(data2, block, this.myExpandSuggester.isExpanded(block)));
                }
                if (blocks.size() <= 0) continue;
                FoldedGroup foldedGroup = new FoldedGroup(blocks);
                for (FoldedBlock folding2 : foldedGroup.blocks) {
                    folding2.installHighlighter(foldedGroup);
                }
                FoldingModelSupport.this.myFoldings.add(foldedGroup);
            }
        }

        @Nullable
        private FoldedBlock createBlock(@NotNull Data data2, @NotNull Data.Block block, boolean expanded) {
            if (data2 == null) {
                FoldingInstaller.$$$reportNull$$$0(2);
            }
            if (block == null) {
                FoldingInstaller.$$$reportNull$$$0(3);
            }
            Object[] regions = new FoldRegion[FoldingModelSupport.this.myCount];
            String[] cachedDescriptions = null;
            for (int i2 = 0; i2 < FoldingModelSupport.this.myCount; ++i2) {
                LineRange range2 = block.ranges[i2];
                if (range2 == null) continue;
                regions[i2] = FoldingModelSupport.addFolding(FoldingModelSupport.this.myEditors[i2], range2.start, range2.end, expanded);
            }
            boolean hasFolding = ContainerUtil.or((Object[])regions, Objects::nonNull);
            boolean hasExpanded = ContainerUtil.or((Object[])regions, region -> region != null && region.isExpanded());
            if (hasExpanded && !expanded) {
                for (Object region2 : regions) {
                    if (region2 == null) continue;
                    region2.setExpanded(true);
                }
            }
            if (!hasExpanded && !expanded) {
                cachedDescriptions = new String[FoldingModelSupport.this.myCount];
                for (int i3 = 0; i3 < FoldingModelSupport.this.myCount; ++i3) {
                    LineRange range3 = block.ranges[i3];
                    if (range3 == null) continue;
                    cachedDescriptions[i3] = this.myExpandSuggester.getCachedDescription(range3.start, range3.end, i3);
                }
            }
            return hasFolding ? new FoldedBlock((FoldRegion[])regions, data2.descriptionComputer, cachedDescriptions) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport$FoldingInstaller";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "install";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createBlock";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class FoldedRangeDescription {
        @NotNull
        private final String description;
        private final int anchorLine;

        private FoldedRangeDescription(@NotNull String description, int anchorLine) {
            if (description == null) {
                FoldedRangeDescription.$$$reportNull$$$0(0);
            }
            this.description = description;
            this.anchorLine = anchorLine;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FoldedRangeDescription that = (FoldedRangeDescription)o;
            return Objects.equals(this.description, that.description) && Objects.equals(this.anchorLine, that.anchorLine);
        }

        public int hashCode() {
            return Objects.hash(this.description, this.anchorLine);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/diff/tools/util/FoldingModelSupport$FoldedRangeDescription", "<init>"));
        }
    }

    protected static abstract class FoldingBuilderBase {
        @NotNull
        private final Settings mySettings;
        private final int @NotNull [] myLineCount;
        private final int myCount;
        @NotNull
        private final List<Data.Group> myGroups;

        public FoldingBuilderBase(int[] lineCount, @NotNull Settings settings) {
            if (settings == null) {
                FoldingBuilderBase.$$$reportNull$$$0(0);
            }
            this.myGroups = new ArrayList<Data.Group>();
            this.mySettings = settings;
            this.myLineCount = lineCount;
            this.myCount = lineCount.length;
        }

        @NotNull
        public Data build(@NotNull Iterator<int[]> changedLines) {
            int i2;
            if (changedLines == null) {
                FoldingBuilderBase.$$$reportNull$$$0(1);
            }
            int[] starts = new int[this.myCount];
            int[] ends = new int[this.myCount];
            int[] last = new int[this.myCount];
            for (i2 = 0; i2 < this.myCount; ++i2) {
                last[i2] = Integer.MIN_VALUE;
            }
            while (changedLines.hasNext()) {
                int[] offsets2 = changedLines.next();
                for (int i3 = 0; i3 < this.myCount; ++i3) {
                    starts[i3] = last[i3];
                    ends[i3] = offsets2[i3 * 2];
                    last[i3] = offsets2[i3 * 2 + 1];
                }
                this.addGroup(starts, ends);
            }
            for (i2 = 0; i2 < this.myCount; ++i2) {
                starts[i2] = last[i2];
                ends[i2] = Integer.MAX_VALUE;
            }
            this.addGroup(starts, ends);
            return new Data(this.myGroups, (project, line, index) -> this.getDescription(project, line, index));
        }

        private void addGroup(int[] starts, int[] ends) {
            int shift;
            ArrayList result2 = new ArrayList(3);
            int[] rangeStarts = new int[this.myCount];
            int[] rangeEnds = new int[this.myCount];
            int number = 0;
            while ((shift = FoldingModelSupport.getRangeShift(this.mySettings.range, number)) != -1) {
                for (int i2 = 0; i2 < this.myCount; ++i2) {
                    rangeStarts[i2] = DiffUtil.bound(starts[i2] + shift, 0, this.myLineCount[i2]);
                    rangeEnds[i2] = DiffUtil.bound(ends[i2] - shift, 0, this.myLineCount[i2]);
                }
                ContainerUtil.addIfNotNull(result2, (Object)this.createBlock(rangeStarts, rangeEnds));
                ++number;
            }
            if (result2.size() > 0) {
                this.myGroups.add(new Data.Group(result2));
            }
        }

        @Nullable
        private Data.Block createBlock(int[] starts, int[] ends) {
            Object[] regions = new LineRange[this.myCount];
            for (int i2 = 0; i2 < this.myCount; ++i2) {
                if (ends[i2] - starts[i2] < 2) continue;
                regions[i2] = new LineRange(starts[i2], ends[i2]);
            }
            boolean hasFolding = ContainerUtil.or((Object[])regions, Objects::nonNull);
            if (!hasFolding) {
                return null;
            }
            return new Data.Block((LineRange[])regions);
        }

        @Nullable
        protected abstract FoldedRangeDescription getDescription(@NotNull Project var1, int var2, int var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changedLines";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport$FoldingBuilderBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "build";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FoldingBuilder
    extends FoldingBuilderBase {
        private final EditorEx @NotNull [] myEditors;

        private FoldingBuilder(EditorEx @NotNull [] editors, @NotNull Settings settings) {
            if (settings == null) {
                FoldingBuilder.$$$reportNull$$$0(0);
            }
            if (editors == null) {
                FoldingBuilder.$$$reportNull$$$0(1);
            }
            super(FoldingModelSupport.countLines(editors), settings);
            this.myEditors = editors;
        }

        @Override
        @Nullable
        protected FoldedRangeDescription getDescription(@NotNull Project project, int lineNumber, int index) {
            if (project == null) {
                FoldingBuilder.$$$reportNull$$$0(2);
            }
            return FoldingModelSupport.getLineSeparatorDescription(project, this.myEditors[index].getDocument(), lineNumber);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/FoldingModelSupport$FoldingBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDescription";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

