/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.tools.util.KeyboardModifierListener;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffGutterOperation {
    @NotNull
    private final RangeHighlighter myHighlighter;

    public DiffGutterOperation(@NotNull Editor editor, int offset) {
        if (editor == null) {
            DiffGutterOperation.$$$reportNull$$$0(0);
        }
        this.myHighlighter = editor.getMarkupModel().addRangeHighlighter(null, offset, offset, 3000, HighlighterTargetArea.LINES_IN_RANGE);
    }

    public void dispose() {
        this.myHighlighter.dispose();
    }

    public void update(boolean force) {
        if (!this.myHighlighter.isValid()) {
            return;
        }
        this.myHighlighter.setGutterIconRenderer(this.createRenderer());
    }

    protected abstract GutterIconRenderer createRenderer();

    public static int lineToOffset(@NotNull Editor editor, int line) {
        Document document;
        if (editor == null) {
            DiffGutterOperation.$$$reportNull$$$0(1);
        }
        return line == DiffUtil.getLineCount(document = editor.getDocument()) ? document.getTextLength() : document.getLineStartOffset(line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/diff/util/DiffGutterOperation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lineToOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ModifiersRendererBuilder {
        @Nullable
        public GutterIconRenderer createRenderer(boolean var1, boolean var2, boolean var3);
    }

    public static interface RendererBuilder {
        @Nullable
        public GutterIconRenderer createRenderer();
    }

    public static final class WithModifiers
    extends DiffGutterOperation {
        @NotNull
        private final ModifiersRendererBuilder myBuilder;
        @NotNull
        private final KeyboardModifierListener myModifierProvider;
        private boolean myCtrlPressed;
        private boolean myShiftPressed;
        private boolean myAltPressed;

        public WithModifiers(@NotNull Editor editor, int offset, @NotNull KeyboardModifierListener modifierProvider, @NotNull ModifiersRendererBuilder builder2) {
            if (editor == null) {
                WithModifiers.$$$reportNull$$$0(0);
            }
            if (modifierProvider == null) {
                WithModifiers.$$$reportNull$$$0(1);
            }
            if (builder2 == null) {
                WithModifiers.$$$reportNull$$$0(2);
            }
            super(editor, offset);
            this.myBuilder = builder2;
            this.myModifierProvider = modifierProvider;
            this.update(true);
        }

        @Override
        public void update(boolean force) {
            boolean shouldUpdate;
            boolean bl = shouldUpdate = force || this.myCtrlPressed == this.myModifierProvider.isCtrlPressed() || this.myShiftPressed == this.myModifierProvider.isShiftPressed() || this.myAltPressed == this.myModifierProvider.isAltPressed();
            if (!shouldUpdate) {
                return;
            }
            this.myCtrlPressed = this.myModifierProvider.isCtrlPressed();
            this.myShiftPressed = this.myModifierProvider.isShiftPressed();
            this.myAltPressed = this.myModifierProvider.isAltPressed();
            super.update(force);
        }

        @Override
        protected GutterIconRenderer createRenderer() {
            return this.myBuilder.createRenderer(this.myCtrlPressed, this.myShiftPressed, this.myAltPressed);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modifierProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "builder";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/util/DiffGutterOperation$WithModifiers";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Simple
    extends DiffGutterOperation {
        @NotNull
        private final RendererBuilder myBuilder;

        public Simple(@NotNull Editor editor, int offset, @NotNull RendererBuilder builder2) {
            if (editor == null) {
                Simple.$$$reportNull$$$0(0);
            }
            if (builder2 == null) {
                Simple.$$$reportNull$$$0(1);
            }
            super(editor, offset);
            this.myBuilder = builder2;
            this.update(true);
        }

        @Override
        protected GutterIconRenderer createRenderer() {
            return this.myBuilder.createRenderer();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "builder";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/util/DiffGutterOperation$Simple";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

