/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.mixed;

import com.intellij.ide.actions.searcheverywhere.mixed.SearchEverywhereUIMixedResults;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

class SEListSelectionTracker
implements ListSelectionListener {
    private final JBList<?> myList;
    private final SearchEverywhereUIMixedResults.SearchListModel myListModel;
    private int myLockCounter;
    private final List<Object> mySelectedItems;
    private boolean myMoreSelected;

    SEListSelectionTracker(@NotNull JBList<?> list2, @NotNull SearchEverywhereUIMixedResults.SearchListModel model) {
        if (list2 == null) {
            SEListSelectionTracker.$$$reportNull$$$0(0);
        }
        if (model == null) {
            SEListSelectionTracker.$$$reportNull$$$0(1);
        }
        this.mySelectedItems = new ArrayList<Object>();
        this.myList = list2;
        this.myListModel = model;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.isLocked()) {
            return;
        }
        if (this.myList.getSelectedIndices().length == 0) {
            return;
        }
        this.saveSelection();
    }

    void saveSelection() {
        List<Object> selectedItemsList;
        this.mySelectedItems.clear();
        int[] indices = this.myList.getSelectedIndices();
        if (indices.length == 1 && this.myListModel.isMoreElement(indices[0])) {
            this.myMoreSelected = true;
            selectedItemsList = Collections.singletonList(this.myListModel.getElementAt(indices[0] - 1));
        } else {
            this.myMoreSelected = false;
            selectedItemsList = Arrays.stream(indices).filter(i2 -> !this.myListModel.isMoreElement(i2)).mapToObj(i2 -> this.myListModel.getElementAt(i2)).collect(Collectors.toList());
        }
        this.mySelectedItems.addAll(selectedItemsList);
    }

    void restoreSelection() {
        if (this.isLocked()) {
            return;
        }
        this.lock();
        try {
            int[] indicesToSelect = this.calcIndicesToSelect();
            if (this.myMoreSelected && indicesToSelect.length == 1) {
                indicesToSelect[0] = indicesToSelect[0] + 1;
            }
            if (indicesToSelect.length == 0) {
                indicesToSelect = new int[]{0};
            }
            this.myList.setSelectedIndices(indicesToSelect);
            ScrollingUtil.ensureRangeIsVisible(this.myList, (int)indicesToSelect[0], (int)indicesToSelect[indicesToSelect.length - 1]);
        }
        finally {
            this.unlock();
        }
    }

    void resetSelectionIfNeeded() {
        int[] indices = this.calcIndicesToSelect();
        if (indices.length == 0) {
            this.mySelectedItems.clear();
        }
    }

    void lock() {
        ++this.myLockCounter;
    }

    void unlock() {
        if (this.myLockCounter > 0) {
            --this.myLockCounter;
        }
    }

    private boolean isLocked() {
        return this.myLockCounter > 0;
    }

    private int[] calcIndicesToSelect() {
        List<Object> items = this.myListModel.getItems();
        if (items.isEmpty()) {
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        return IntStream.range(0, items.size()).filter(i2 -> this.mySelectedItems.contains(items.get(i2))).toArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "list";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/actions/searcheverywhere/mixed/SEListSelectionTracker";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

