/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.ExtensionInstantiationException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginUtilImpl
implements PluginUtil {
    private static final Logger LOG = Logger.getInstance(PluginUtilImpl.class);

    @Nullable
    public PluginId getCallerPlugin(int stackFrameCount) {
        Class aClass = ReflectionUtil.getCallerClass((int)(stackFrameCount + 1));
        if (aClass == null) {
            return null;
        }
        ClassLoader classLoader = aClass.getClassLoader();
        return classLoader instanceof PluginClassLoader ? ((PluginClassLoader)((Object)classLoader)).getPluginId() : null;
    }

    @Nullable
    public PluginId findPluginId(@NotNull Throwable t) {
        if (t == null) {
            PluginUtilImpl.$$$reportNull$$$0(0);
        }
        return PluginUtilImpl.doFindPluginId(t);
    }

    @Nullable
    public static PluginId doFindPluginId(@NotNull Throwable t) {
        Throwable cause;
        PluginId id2;
        CharSequence className;
        if (t == null) {
            PluginUtilImpl.$$$reportNull$$$0(1);
        }
        if (t instanceof PluginException) {
            return ((PluginException)t).getPluginId();
        }
        if (t instanceof ExtensionInstantiationException) {
            return ((ExtensionInstantiationException)t).getExtensionOwnerId();
        }
        HashSet<String> visitedClassNames = new HashSet<String>();
        for (StackTraceElement element2 : t.getStackTrace()) {
            PluginId id3;
            String className2;
            if (element2 == null || !visitedClassNames.add(className2 = element2.getClassName()) || (id3 = PluginManagerCore.getPluginByClassName(className2)) == null) continue;
            PluginUtilImpl.logPluginDetection(className2, id3);
            return id3;
        }
        if (t instanceof NoSuchMethodException) {
            if (t.getMessage() != null) {
                className = new StringBuilder();
                StringTokenizer tok = new StringTokenizer(t.getMessage(), ".");
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (token.isEmpty() || !Character.isJavaIdentifierStart(token.charAt(0))) continue;
                    ((StringBuilder)className).append(token);
                }
                PluginId pluginId = PluginManagerCore.getPluginByClassName(((StringBuilder)className).toString());
                if (pluginId != null) {
                    return pluginId;
                }
            }
        } else if (t instanceof ClassNotFoundException) {
            PluginId id4;
            if (t.getMessage() != null && (id4 = PluginManagerCore.getPluginByClassName(t.getMessage())) != null) {
                return id4;
            }
        } else if (t instanceof NoClassDefFoundError && t.getMessage() != null) {
            PluginId id5;
            className = StringUtil.substringAfterLast((String)t.getMessage(), (String)" ");
            if (className == null) {
                className = t.getMessage();
            }
            if (((String)className).indexOf(47) > 0) {
                className = ((String)className).replace('/', '.');
            }
            if ((id5 = PluginManagerCore.getPluginByClassName((String)className)) != null) {
                return PluginManagerCore.getPluginByClassName((String)className);
            }
        } else if (t instanceof AbstractMethodError && t.getMessage() != null) {
            PluginId id6;
            String s = t.getMessage();
            int pos = s.indexOf(40);
            if (pos >= 0 && (pos = (s = s.substring(0, pos)).lastIndexOf(46)) >= 0 && (id6 = PluginManagerCore.getPluginByClassName(s = s.substring(0, pos))) != null) {
                return id6;
            }
        } else if (t instanceof ExtensionException && (id2 = PluginManagerCore.getPluginByClassName((String)(className = ((ExtensionException)t).getExtensionClass().getName()))) != null) {
            return id2;
        }
        return (cause = t.getCause()) == null ? null : PluginUtilImpl.doFindPluginId(cause);
    }

    private static void logPluginDetection(String className, PluginId id2) {
        if (LOG.isDebugEnabled()) {
            String message = "Detected a plugin " + id2 + " by class " + className;
            IdeaPluginDescriptor descriptor2 = PluginManagerCore.getPlugin(id2);
            if (descriptor2 != null) {
                ClassLoader loader = descriptor2.getPluginClassLoader();
                message = message + "; loader=" + loader + '/' + loader.getClass();
                if (loader instanceof PluginClassLoader) {
                    message = message + "; loaded class: " + ((PluginClassLoader)((Object)loader)).hasLoadedClass(className);
                }
            }
            LOG.debug(message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "t";
        objectArray2[1] = "com/intellij/ide/plugins/PluginUtilImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findPluginId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doFindPluginId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

