/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.util.SVGLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class UIThemeBasedLookAndFeelInfo
extends UIManager.LookAndFeelInfo {
    private static final String RELAUNCH_PROPERTY = "UITheme.relaunch";
    private final UITheme myTheme;
    private boolean myInitialised;

    public UIThemeBasedLookAndFeelInfo(UITheme theme) {
        super(theme.getName(), theme.isDark() ? DarculaLaf.class.getName() : IntelliJLaf.class.getName());
        this.myTheme = theme;
    }

    public UITheme getTheme() {
        return this.myTheme;
    }

    public void installTheme(UIDefaults defaults, boolean lockEditorScheme) {
        SVGLoader.SvgElementColorPatcherProvider colorPatcher;
        this.myTheme.applyProperties(defaults);
        IconPathPatcher patcher = this.myTheme.getPatcher();
        if (patcher != null) {
            IconLoader.installPathPatcher((IconPathPatcher)patcher);
        }
        if ((colorPatcher = this.myTheme.getColorPatcher()) != null) {
            SVGLoader.setColorPatcherProvider((SVGLoader.SvgElementColorPatcherProvider)colorPatcher);
        }
        this.installBackgroundImage();
        if (!lockEditorScheme) {
            this.installEditorScheme();
        }
        this.myInitialised = true;
    }

    public boolean isInitialised() {
        return this.myInitialised;
    }

    protected void installEditorScheme() {
        String name = this.myTheme.getEditorSchemeName();
        if (name != null) {
            EditorColorsManager cm = EditorColorsManager.getInstance();
            EditorColorsScheme scheme = cm.getScheme(name);
            if (scheme != null) {
                cm.setGlobalScheme(scheme);
            }
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                String themeName = this.myTheme.getEditorSchemeName();
                if (StringUtil.isNotEmpty((String)themeName)) {
                    EditorColorsScheme scheme;
                    EditorColorsManager cm = EditorColorsManager.getInstance();
                    EditorColorsScheme globalScheme = cm.getGlobalScheme();
                    PropertiesComponent properties = PropertiesComponent.getInstance();
                    EditorColorsScheme baseScheme = cm.getScheme(SchemeManager.getBaseName((Scheme)globalScheme));
                    if (!properties.getBoolean(RELAUNCH_PROPERTY) && !SchemeManager.getBaseName((Scheme)globalScheme).equals(themeName) && "Default".equals(baseScheme.getName()) && (scheme = cm.getScheme(themeName)) != null) {
                        cm.setGlobalScheme(scheme);
                    }
                    properties.setValue(RELAUNCH_PROPERTY, true);
                }
            });
        }
    }

    private void installBackgroundImage() {
        this.installBackgroundImage(this.myTheme.getBackground(), "idea.background.editor");
        this.installBackgroundImage(this.myTheme.getEmptyFrameBackground(), "idea.background.frame");
    }

    private void installBackgroundImage(Map<String, Object> backgroundProps, String bgImageProperty) {
        block14: {
            try {
                Object path;
                if (backgroundProps == null || !((path = backgroundProps.get("image")) instanceof String)) break block14;
                File tmpImage = FileUtil.createTempFile((String)"ijBackgroundImage", (String)path.toString().substring(((String)path).lastIndexOf(".")), (boolean)true);
                URL resource = this.myTheme.getResource((String)path);
                if (resource != null) {
                    try (InputStream input = this.myTheme.getResourceAsStream((String)path);
                         FileOutputStream output = new FileOutputStream(tmpImage);){
                        FileUtil.copy((InputStream)input, (OutputStream)output);
                    }
                    String image = tmpImage.getPath();
                    Object transparency = backgroundProps.get("transparency");
                    String alpha = String.valueOf(transparency instanceof Integer ? (Integer)transparency : 15);
                    String fill = UIThemeBasedLookAndFeelInfo.parseEnumValue(backgroundProps.get("fill"), IdeBackgroundUtil.Fill.SCALE);
                    String anchor2 = UIThemeBasedLookAndFeelInfo.parseEnumValue(backgroundProps.get("anchor"), IdeBackgroundUtil.Anchor.CENTER);
                    String spec = StringUtil.join((String[])new String[]{image, alpha, fill, anchor2}, (String)",");
                    String currentSpec = PropertiesComponent.getInstance().getValue(bgImageProperty);
                    PropertiesComponent.getInstance().setValue("old." + bgImageProperty, currentSpec);
                    PropertiesComponent.getInstance().setValue(bgImageProperty, spec);
                    IdeBackgroundUtil.repaintAllWindows();
                    break block14;
                }
                throw new IllegalArgumentException("Can't load background: " + path);
            }
            catch (IOException e) {
                Logger.getInstance(this.getClass()).error((Throwable)e);
            }
        }
    }

    private static <T extends Enum<T>> String parseEnumValue(Object value2, T defaultValue) {
        if (value2 instanceof String) {
            String name = StringUtil.toUpperCase((String)((String)value2));
            for (Enum t : (Enum[])defaultValue.getClass().getEnumConstants()) {
                if (!t.name().equals(name)) continue;
                return StringUtil.toLowerCase((String)value2.toString());
            }
        }
        return StringUtil.toLowerCase((String)defaultValue.name());
    }

    public void dispose() {
        IconPathPatcher patcher = this.myTheme.getPatcher();
        if (patcher != null) {
            IconLoader.removePathPatcher((IconPathPatcher)patcher);
        }
        SVGLoader.setColorPatcherProvider(null);
        this.unsetBackgroundProperties("idea.background.editor");
        this.unsetBackgroundProperties("idea.background.frame");
    }

    private void unsetBackgroundProperties(String backgroundPropertyKey) {
        PropertiesComponent propertyManager = PropertiesComponent.getInstance();
        String value2 = propertyManager.getValue("old." + backgroundPropertyKey);
        propertyManager.unsetValue("old." + backgroundPropertyKey);
        if (value2 == null) {
            if (this.myTheme.getBackground() != null) {
                propertyManager.unsetValue(backgroundPropertyKey);
            }
        } else {
            propertyManager.setValue(backgroundPropertyKey, value2);
        }
    }
}

