/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.search.ConfigurableHit;
import com.intellij.ide.ui.search.IndexedCharsInterner;
import com.intellij.ide.ui.search.MySearchableOptionProcessor;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionContributor;
import com.intellij.ide.ui.search.SearchableOptionProcessor;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.ResourceUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.event.DocumentEvent;
import kotlin.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchableOptionsRegistrarImpl
extends SearchableOptionsRegistrar {
    private static final ExtensionPointName<SearchableOptionContributor> EP_NAME = new ExtensionPointName("com.intellij.search.optionContributor");
    private volatile Map<CharSequence, long[]> storage = Collections.emptyMap();
    private final Set<String> stopWords;
    @NotNull
    private volatile Map<Pair<String, String>, Set<String>> highlightOptionToSynonym = Collections.emptyMap();
    private final AtomicBoolean isInitialized = new AtomicBoolean();
    private volatile IndexedCharsInterner identifierTable = new IndexedCharsInterner();
    private static final Logger LOG = Logger.getInstance(SearchableOptionsRegistrarImpl.class);
    @NonNls
    private static final Pattern REG_EXP = Pattern.compile("[\\W&&[^-]]+");

    public SearchableOptionsRegistrarImpl() {
        Application app = ApplicationManager.getApplication();
        if (app.isCommandLine() || app.isHeadlessEnvironment()) {
            this.stopWords = Collections.emptySet();
            return;
        }
        this.stopWords = SearchableOptionsRegistrarImpl.loadStopWords();
        app.getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                SearchableOptionsRegistrarImpl.this.dropStorage();
            }

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                SearchableOptionsRegistrarImpl.this.dropStorage();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginUnloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private static Set<String> loadStopWords() {
        try {
            InputStream stream = ResourceUtil.getResourceAsStream(SearchableOptionsRegistrarImpl.class, (String)"/search/", (String)"ignore.txt");
            if (stream == null) {
                throw new IOException("Broken installation: IDE does not provide /search/ignore.txt");
            }
            return new THashSet(Arrays.asList(ResourceUtil.loadText((InputStream)stream).split("[\\W]")));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            Set<String> set = Collections.emptySet();
            if (set == null) {
                SearchableOptionsRegistrarImpl.$$$reportNull$$$0(0);
            }
            return set;
        }
    }

    private synchronized void dropStorage() {
        this.storage = Collections.emptyMap();
        this.isInitialized.set(false);
    }

    public boolean isInitialized() {
        return this.isInitialized.get();
    }

    @ApiStatus.Internal
    public void initialize() {
        if (!this.isInitialized.compareAndSet(false, true)) {
            return;
        }
        CompletableFuture<Set> searchableOptionFileUrlsFuture = CompletableFuture.supplyAsync(() -> {
            try {
                Set<URL> searchableOptions = SearchableOptionsRegistrarImpl.findSearchableOptions();
                if (searchableOptions.isEmpty()) {
                    LOG.info("No /search/searchableOptions.xml found, settings search won't work!");
                    return null;
                }
                return searchableOptions;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return null;
            }
        }, AppExecutorUtil.getAppExecutorService());
        MySearchableOptionProcessor processor2 = new MySearchableOptionProcessor(this.stopWords);
        EP_NAME.forEachExtensionSafe(contributor -> contributor.processOptions((SearchableOptionProcessor)processor2));
        Set searchableOptions = searchableOptionFileUrlsFuture.join();
        this.highlightOptionToSynonym = searchableOptions == null ? Collections.emptyMap() : processor2.computeHighlightOptionToSynonym(searchableOptions);
        this.storage = processor2.getStorage();
        this.identifierTable = processor2.getIdentifierTable();
    }

    @NotNull
    private static Set<URL> findSearchableOptions() throws IOException, URISyntaxException {
        THashSet urls = new THashSet();
        THashSet visited = new THashSet();
        for (IdeaPluginDescriptor ideaPluginDescriptor : PluginManagerCore.getLoadedPlugins()) {
            ClassLoader classLoader = ideaPluginDescriptor.getPluginClassLoader();
            if (!visited.add(classLoader)) continue;
            Enumeration<URL> resources = classLoader.getResources("search");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if ("jar".equals(url.getProtocol())) {
                    com.intellij.openapi.util.Pair parts = Objects.requireNonNull(URLUtil.splitJarUrl((String)url.getFile()));
                    File file2 = new File((String)parts.first);
                    ZipFile jar = new ZipFile(file2);
                    try {
                        Enumeration<? extends ZipEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            String name = entries.nextElement().getName();
                            if (!name.startsWith("search/") || !name.endsWith("searchableOptions.xml") || StringUtil.countChars((CharSequence)name, (char)'/') != 1) continue;
                            urls.add(URLUtil.getJarEntryURL((File)file2, (String)name));
                        }
                        continue;
                    }
                    finally {
                        jar.close();
                        continue;
                    }
                }
                Path file3 = Paths.get(url.toURI());
                try {
                    DirectoryStream<Path> paths = Files.newDirectoryStream(file3);
                    try {
                        for (Path xml : paths) {
                            if (!xml.getFileName().toString().endsWith("searchableOptions.xml") || !Files.isRegularFile(xml, new LinkOption[0])) continue;
                            urls.add(xml.toUri().toURL());
                        }
                    }
                    finally {
                        if (paths == null) continue;
                        paths.close();
                    }
                }
                catch (NotDirectoryException notDirectoryException) {}
            }
        }
        THashSet tHashSet = urls;
        if (tHashSet == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(1);
        }
        return tHashSet;
    }

    static long pack(@NotNull String id2, @Nullable String hit, @Nullable String path, @Nullable String groupName, @NotNull IndexedCharsInterner identifierTable) {
        long _groupName;
        if (id2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(2);
        }
        if (identifierTable == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(3);
        }
        long _id = identifierTable.toId(id2.trim());
        long _hit = hit == null ? 32767L : (long)identifierTable.toId(hit.trim());
        long _path = path == null ? 32767L : (long)identifierTable.toId(path.trim());
        long l = _groupName = groupName == null ? 32767L : (long)identifierTable.toId(groupName.trim());
        assert (_id >= 0L && _id < 32767L);
        assert (_hit >= 0L && _hit <= 32767L);
        assert (_path >= 0L && _path <= 32767L);
        assert (_groupName >= 0L && _groupName <= 32767L);
        return _groupName << 48 | _id << 32 | _hit << 16 | _path;
    }

    private OptionDescription unpack(long data2) {
        int _groupName = (int)(data2 >> 48 & 0xFFFFL);
        int _id = (int)(data2 >> 32 & 0xFFFFL);
        int _hit = (int)(data2 >> 16 & 0xFFFFL);
        int _path = (int)(data2 & 0xFFFFL);
        assert (_id < Short.MAX_VALUE);
        assert (_hit <= Short.MAX_VALUE);
        assert (_path <= Short.MAX_VALUE);
        assert (_groupName <= Short.MAX_VALUE);
        String groupName = _groupName == Short.MAX_VALUE ? null : this.identifierTable.fromId(_groupName).toString();
        String configurableId = this.identifierTable.fromId(_id).toString();
        String hit = _hit == Short.MAX_VALUE ? null : this.identifierTable.fromId(_hit).toString();
        String path = _path == Short.MAX_VALUE ? null : this.identifierTable.fromId(_path).toString();
        return new OptionDescription(null, configurableId, hit, path, groupName);
    }

    @NotNull
    public ConfigurableHit getConfigurables(@NotNull List<? extends ConfigurableGroup> groups, DocumentEvent.EventType type, @Nullable Set<? extends Configurable> configurables, @NotNull String option2, @Nullable Project project) {
        if (groups == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(4);
        }
        if (option2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(5);
        }
        return this.findConfigurables(groups, type, configurables, option2, project);
    }

    @NotNull
    private ConfigurableHit findConfigurables(@NotNull List<? extends ConfigurableGroup> groups, DocumentEvent.EventType type, @Nullable Collection<Configurable> configurables, @NotNull String option2, @Nullable Project project) {
        THashSet currentConfigurables;
        Collection<Configurable> effectiveConfigurables;
        if (groups == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(6);
        }
        if (option2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(7);
        }
        if (ContainerUtil.isEmpty(configurables)) {
            configurables = null;
        }
        if (configurables == null) {
            effectiveConfigurables = new LinkedHashSet<Configurable>();
            CollectConsumer consumer = new CollectConsumer(effectiveConfigurables);
            for (ConfigurableGroup configurableGroup : groups) {
                SearchUtil.processExpandedGroups(configurableGroup, (Consumer<? super Configurable>)consumer);
            }
        } else {
            effectiveConfigurables = configurables;
        }
        String optionToCheck = StringUtil.toLowerCase((String)option2.trim());
        Set<String> options2 = this.getProcessedWordsWithoutStemming(optionToCheck);
        LinkedHashSet<Configurable> linkedHashSet = new LinkedHashSet<Configurable>();
        LinkedHashSet<Configurable> nameFullHits = new LinkedHashSet<Configurable>();
        for (Configurable each : effectiveConfigurables) {
            if (each.getDisplayName() == null) continue;
            String displayName = StringUtil.toLowerCase((String)each.getDisplayName());
            List allWords = StringUtil.getWordsIn((String)displayName);
            if (displayName.contains(optionToCheck)) {
                nameFullHits.add(each);
                linkedHashSet.add(each);
            }
            Iterator iterator2 = allWords.iterator();
            while (iterator2.hasNext()) {
                String eachWord = (String)iterator2.next();
                if (!eachWord.startsWith(optionToCheck)) continue;
                linkedHashSet.add(each);
                break;
            }
            if (!options2.isEmpty()) continue;
            linkedHashSet.add(each);
            nameFullHits.add(each);
        }
        THashSet tHashSet = currentConfigurables = type == DocumentEvent.EventType.CHANGE ? new THashSet(effectiveConfigurables) : null;
        if (options2.isEmpty()) {
            String[] components = REG_EXP.split(optionToCheck);
            if (components.length > 0) {
                Collections.addAll(options2, components);
            } else {
                options2.add(option2);
            }
        }
        LinkedHashSet<Configurable> contentHits = configurables == null ? (LinkedHashSet<Configurable>)effectiveConfigurables : new LinkedHashSet<Configurable>(effectiveConfigurables);
        HashSet<String> helpIds = null;
        for (String opt : options2) {
            Set<OptionDescription> optionIds = this.getAcceptableDescriptions(opt);
            if (optionIds == null) {
                contentHits.clear();
                return new ConfigurableHit(linkedHashSet, nameFullHits, contentHits);
            }
            HashSet<String> ids = new HashSet<String>();
            for (OptionDescription id2 : optionIds) {
                ids.add(id2.getConfigurableId());
            }
            if (helpIds == null) {
                helpIds = ids;
            }
            helpIds.retainAll(ids);
        }
        if (helpIds != null) {
            Iterator it = contentHits.iterator();
            while (it.hasNext()) {
                Configurable configurable2 = (Configurable)it.next();
                boolean needToRemove = true;
                if (configurable2 instanceof SearchableConfigurable && helpIds.contains(((SearchableConfigurable)configurable2).getId())) {
                    needToRemove = false;
                }
                if (configurable2 instanceof SearchableConfigurable.Merged) {
                    List mergedConfigurables = ((SearchableConfigurable.Merged)configurable2).getMergedConfigurables();
                    for (Configurable mergedConfigurable : mergedConfigurables) {
                        if (!(mergedConfigurable instanceof SearchableConfigurable) || !helpIds.contains(((SearchableConfigurable)mergedConfigurable).getId())) continue;
                        needToRemove = false;
                        break;
                    }
                }
                if (!needToRemove) continue;
                it.remove();
            }
        }
        if (type == DocumentEvent.EventType.CHANGE && configurables != null && currentConfigurables.equals(contentHits)) {
            ConfigurableHit configurableHit = this.getConfigurables(groups, DocumentEvent.EventType.CHANGE, null, option2, project);
            if (configurableHit == null) {
                SearchableOptionsRegistrarImpl.$$$reportNull$$$0(8);
            }
            return configurableHit;
        }
        return new ConfigurableHit(linkedHashSet, nameFullHits, contentHits);
    }

    @Nullable
    public synchronized Set<OptionDescription> getAcceptableDescriptions(@Nullable String prefix) {
        if (prefix == null) {
            return null;
        }
        String stemmedPrefix = PorterStemmerUtil.stem(prefix);
        if (StringUtil.isEmptyOrSpaces((String)stemmedPrefix)) {
            return null;
        }
        this.initialize();
        THashSet result2 = null;
        for (Map.Entry<CharSequence, long[]> entry : this.storage.entrySet()) {
            String stemmedOption;
            long[] descriptions = entry.getValue();
            CharSequence option2 = entry.getKey();
            if (!StringUtil.startsWith((CharSequence)option2, (CharSequence)prefix) && !StringUtil.startsWith((CharSequence)option2, (CharSequence)stemmedPrefix) && (stemmedOption = PorterStemmerUtil.stem(option2.toString())) != null && !stemmedOption.startsWith(prefix) && !stemmedOption.startsWith(stemmedPrefix)) continue;
            if (result2 == null) {
                result2 = new THashSet();
            }
            for (long description : descriptions) {
                OptionDescription desc = this.unpack(description);
                result2.add(desc);
            }
        }
        return result2;
    }

    @Nullable
    private Set<OptionDescription> getOptionDescriptionsByWords(SearchableConfigurable configurable2, Set<String> words) {
        HashSet<OptionDescription> path = null;
        for (String word : words) {
            Set<OptionDescription> configs = this.getAcceptableDescriptions(word);
            if (configs == null) {
                return null;
            }
            HashSet<OptionDescription> paths = new HashSet<OptionDescription>();
            for (OptionDescription config2 : configs) {
                if (!Comparing.strEqual((String)config2.getConfigurableId(), (String)configurable2.getId())) continue;
                paths.add(config2);
            }
            if (path == null) {
                path = paths;
            }
            path.retainAll(paths);
        }
        return path;
    }

    @NotNull
    public Set<String> getInnerPaths(SearchableConfigurable configurable2, String option2) {
        this.initialize();
        Set<String> words = this.getProcessedWordsWithoutStemming(option2);
        Set<OptionDescription> path = this.getOptionDescriptionsByWords(configurable2, words);
        HashSet<String> resultSet = new HashSet<String>();
        if (path != null && !path.isEmpty()) {
            OptionDescription theOnlyResult = null;
            for (OptionDescription description : path) {
                String hit = description.getHit();
                if (hit != null) {
                    boolean theBest = true;
                    for (String word : words) {
                        if (StringUtil.containsIgnoreCase((String)hit, (String)word)) continue;
                        theBest = false;
                        break;
                    }
                    if (theBest) {
                        resultSet.add(description.getPath());
                    }
                }
                theOnlyResult = description;
            }
            if (resultSet.isEmpty()) {
                resultSet.add(theOnlyResult.getPath());
            }
        }
        HashSet<String> hashSet = resultSet;
        if (hashSet == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    public boolean isStopWord(String word) {
        return this.stopWords.contains(word);
    }

    public Set<String> getProcessedWordsWithoutStemming(@NotNull String text) {
        if (text == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(10);
        }
        THashSet result2 = new THashSet();
        SearchableOptionsRegistrarImpl.collectProcessedWordsWithoutStemming(text, (Set<String>)result2, this.stopWords);
        return result2;
    }

    static void collectProcessedWordsWithoutStemming(@NotNull String text, @NotNull Set<String> result2, @NotNull Set<String> stopWords) {
        if (text == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(11);
        }
        if (result2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(12);
        }
        if (stopWords == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(13);
        }
        for (String opt : REG_EXP.split(StringUtil.toLowerCase((String)text))) {
            String processed2;
            if (stopWords.contains(opt) || stopWords.contains(processed2 = PorterStemmerUtil.stem(opt))) continue;
            result2.add(opt);
        }
    }

    public Set<String> getProcessedWords(@NotNull String text) {
        if (text == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(14);
        }
        THashSet result2 = new THashSet();
        SearchableOptionsRegistrarImpl.collectProcessedWords(text, (Set<String>)result2, this.stopWords);
        return result2;
    }

    static void collectProcessedWords(@NotNull String text, @NotNull Set<String> result2, @NotNull Set<String> stopWords) {
        String[] options2;
        if (text == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(15);
        }
        if (result2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(16);
        }
        if (stopWords == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(17);
        }
        String toLowerCase = StringUtil.toLowerCase((String)text);
        for (String opt : options2 = REG_EXP.split(toLowerCase)) {
            if (stopWords.contains(opt) || (opt = PorterStemmerUtil.stem(opt)) == null) continue;
            result2.add(opt);
        }
    }

    @NotNull
    public Set<String> replaceSynonyms(@NotNull Set<String> options2, @NotNull SearchableConfigurable configurable2) {
        if (options2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(18);
        }
        if (configurable2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(19);
        }
        if (this.highlightOptionToSynonym.isEmpty()) {
            Set<String> set = options2;
            if (set == null) {
                SearchableOptionsRegistrarImpl.$$$reportNull$$$0(20);
            }
            return set;
        }
        THashSet result2 = new THashSet(options2);
        this.initialize();
        for (String option2 : options2) {
            Set<String> synonyms = this.highlightOptionToSynonym.get(new Pair((Object)option2, (Object)configurable2.getId()));
            if (synonyms != null) {
                result2.addAll(synonyms);
                continue;
            }
            result2.add(option2);
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(21);
        }
        return tHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifierTable";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopWords";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadStopWords";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findSearchableOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigurables";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerPaths";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSynonyms";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "pack";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurables";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurables";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedWordsWithoutStemming";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedWordsWithoutStemming";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedWords";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedWords";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replaceSynonyms";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

