/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.ClassMemberWithElement;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.MemberChooserObjectBase;
import com.intellij.codeInsight.generation.PsiElementMemberChooserObject;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.PlatformEditorBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemberChooser<T extends ClassMember>
extends DialogWrapper
implements TypeSafeDataProvider {
    protected Tree myTree;
    private DefaultTreeModel myTreeModel;
    protected JComponent[] myOptionControls;
    private JCheckBox myCopyJavadocCheckbox;
    private JCheckBox myInsertOverrideAnnotationCheckbox;
    private final ArrayList<MemberNode> mySelectedNodes;
    private final SortEmAction mySortAction;
    private boolean myAlphabeticallySorted;
    private boolean myShowClasses;
    protected boolean myAllowEmptySelection;
    private final boolean myAllowMultiSelection;
    private final boolean myIsInsertOverrideVisible;
    private final JComponent myHeaderPanel;
    protected T[] myElements;
    protected Comparator<ElementNode> myComparator;
    protected final HashMap<MemberNode, ParentNode> myNodeToParentMap;
    protected final HashMap<ClassMember, MemberNode> myElementToNodeMap;
    protected final ArrayList<ContainerNode> myContainerNodes;
    protected LinkedHashSet<T> mySelectedElements;
    @NonNls
    private static final String PROP_SORTED = "MemberChooser.sorted";
    @NonNls
    private static final String PROP_SHOWCLASSES = "MemberChooser.showClasses";
    @NonNls
    private static final String PROP_COPYJAVADOC = "MemberChooser.copyJavadoc";

    public MemberChooser(T[] elements2, boolean allowEmptySelection, boolean allowMultiSelection, @NotNull Project project, @Nullable JComponent headerPanel, JComponent[] optionControls) {
        if (project == null) {
            MemberChooser.$$$reportNull$$$0(0);
        }
        this(allowEmptySelection, allowMultiSelection, project, false, headerPanel, optionControls);
        this.resetElements((ClassMember[])elements2);
        this.init();
    }

    public MemberChooser(T[] elements2, boolean allowEmptySelection, boolean allowMultiSelection, @NotNull Project project) {
        if (project == null) {
            MemberChooser.$$$reportNull$$$0(1);
        }
        this((ClassMember[])elements2, allowEmptySelection, allowMultiSelection, project, false);
    }

    public MemberChooser(T[] elements2, boolean allowEmptySelection, boolean allowMultiSelection, @NotNull Project project, boolean isInsertOverrideVisible) {
        if (project == null) {
            MemberChooser.$$$reportNull$$$0(2);
        }
        this((ClassMember[])elements2, allowEmptySelection, allowMultiSelection, project, isInsertOverrideVisible, null);
    }

    public MemberChooser(T[] elements2, boolean allowEmptySelection, boolean allowMultiSelection, @NotNull Project project, boolean isInsertOverrideVisible, @Nullable JComponent headerPanel) {
        if (project == null) {
            MemberChooser.$$$reportNull$$$0(3);
        }
        this(allowEmptySelection, allowMultiSelection, project, isInsertOverrideVisible, headerPanel, null);
        this.resetElements((ClassMember[])elements2);
        this.init();
    }

    protected MemberChooser(boolean allowEmptySelection, boolean allowMultiSelection, @NotNull Project project, boolean isInsertOverrideVisible, @Nullable JComponent headerPanel, JComponent @Nullable [] optionControls) {
        if (project == null) {
            MemberChooser.$$$reportNull$$$0(4);
        }
        super(project, true);
        this.mySelectedNodes = new ArrayList();
        this.myAlphabeticallySorted = false;
        this.myShowClasses = true;
        this.myComparator = new OrderComparator();
        this.myNodeToParentMap = new HashMap();
        this.myElementToNodeMap = new HashMap();
        this.myContainerNodes = new ArrayList();
        this.myAllowEmptySelection = allowEmptySelection;
        this.myAllowMultiSelection = allowMultiSelection;
        this.myIsInsertOverrideVisible = isInsertOverrideVisible;
        this.myHeaderPanel = headerPanel;
        this.myTree = this.createTree();
        this.myOptionControls = optionControls;
        this.mySortAction = new SortEmAction();
        this.mySortAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(65, 8)), (JComponent)this.myTree);
    }

    protected void resetElementsWithDefaultComparator(T[] elements2) {
        this.myComparator = this.myAlphabeticallySorted ? new AlphaComparator() : new OrderComparator();
        this.resetElements((ClassMember[])elements2, null, true);
    }

    public void resetElements(T[] elements2) {
        this.resetElements((ClassMember[])elements2, null, false);
    }

    public void resetElements(T[] elements2, @Nullable Comparator<T> sortComparator, boolean restoreSelectedElements) {
        ArrayList<ClassMember> selectedElements = restoreSelectedElements && this.mySelectedElements != null ? new ArrayList<ClassMember>(this.mySelectedElements) : null;
        this.myElements = elements2;
        if (sortComparator != null) {
            this.myComparator = new ElementNodeComparatorWrapper<T>(sortComparator);
        }
        this.mySelectedNodes.clear();
        this.myNodeToParentMap.clear();
        this.myElementToNodeMap.clear();
        this.myContainerNodes.clear();
        ApplicationManager.getApplication().runReadAction(() -> {
            this.myTreeModel = this.buildModel();
        });
        this.myTree.setModel((TreeModel)this.myTreeModel);
        this.myTree.setRootVisible(false);
        this.doSort();
        this.defaultExpandTree();
        if (this.myOptionControls == null) {
            this.myCopyJavadocCheckbox = new NonFocusableCheckBox(IdeBundle.message((String)"checkbox.copy.javadoc", (Object[])new Object[0]));
            if (this.myIsInsertOverrideVisible) {
                this.myInsertOverrideAnnotationCheckbox = new NonFocusableCheckBox(IdeBundle.message((String)"checkbox.insert.at.override", (Object[])new Object[0]));
                this.myOptionControls = new JCheckBox[]{this.myCopyJavadocCheckbox, this.myInsertOverrideAnnotationCheckbox};
            } else {
                this.myOptionControls = new JCheckBox[]{this.myCopyJavadocCheckbox};
            }
        }
        this.myTree.doLayout();
        this.setOKActionEnabled(this.myAllowEmptySelection || this.myElements != null && this.myElements.length > 0);
        if (selectedElements != null) {
            this.selectElements(selectedElements.toArray(ClassMember.EMPTY_ARRAY));
        }
        if (this.mySelectedElements == null || this.mySelectedElements.isEmpty()) {
            this.expandFirst();
        }
    }

    private DefaultTreeModel buildModel() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        Ref count = new Ref((Object)0);
        Ref mapRef = new Ref();
        mapRef.set((Object)FactoryMap.create(key -> {
            MemberChooserObject parentNodeDelegate;
            ParentNode node = null;
            DefaultMutableTreeNode parentNode1 = rootNode;
            if (this.supportsNestedContainers() && key instanceof ClassMember && (parentNodeDelegate = ((ClassMember)key).getParentNodeDelegate()) != null) {
                parentNode1 = (DefaultMutableTreeNode)((Map)mapRef.get()).get(parentNodeDelegate);
            }
            if (this.isContainerNode((MemberChooserObject)key)) {
                ContainerNode containerNode;
                node = containerNode = new ContainerNode(parentNode1, (MemberChooserObject)key, (Ref<Integer>)count);
                this.myContainerNodes.add(containerNode);
            }
            if (node == null) {
                node = new ParentNode(parentNode1, (MemberChooserObject)key, (Ref<Integer>)count);
            }
            return node;
        }));
        Map map2 = (Map)mapRef.get();
        for (T object : this.myElements) {
            ParentNode parentNode = (ParentNode)map2.get(object.getParentNodeDelegate());
            MemberNode elementNode = this.createMemberNode((Ref<Integer>)count, object, parentNode);
            this.myNodeToParentMap.put(elementNode, parentNode);
            this.myElementToNodeMap.put((ClassMember)object, elementNode);
        }
        return new DefaultTreeModel(rootNode);
    }

    protected MemberNode createMemberNode(Ref<Integer> count, @NotNull T object, ParentNode parentNode) {
        if (object == null) {
            MemberChooser.$$$reportNull$$$0(5);
        }
        return new MemberNodeImpl(parentNode, (ClassMember)object, count);
    }

    protected boolean supportsNestedContainers() {
        return false;
    }

    protected void defaultExpandTree() {
        TreeUtil.expandAll((JTree)this.myTree);
    }

    protected boolean isContainerNode(MemberChooserObject key) {
        return key instanceof PsiElementMemberChooserObject;
    }

    public void selectElements(ClassMember[] elements2) {
        ArrayList<TreePath> selectionPaths = new ArrayList<TreePath>();
        for (ClassMember element2 : elements2) {
            MemberNode treeNode = this.myElementToNodeMap.get(element2);
            if (treeNode == null) continue;
            selectionPaths.add(new TreePath(((DefaultMutableTreeNode)((Object)treeNode)).getPath()));
        }
        TreePath[] paths = TreePathUtil.toTreePathArray(selectionPaths);
        this.myTree.setSelectionPaths(paths);
        if (paths.length > 0) {
            TreeUtil.showRowCentered((JTree)this.myTree, (int)this.myTree.getRowForPath(paths[0]), (boolean)true, (boolean)true);
        }
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        if (this.myAllowEmptySelection) {
            actions.add(new SelectNoneAction());
        }
        actions.add(this.getCancelAction());
        if (this.getHelpId() != null) {
            actions.add(this.getHelpAction());
        }
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            MemberChooser.$$$reportNull$$$0(6);
        }
        return actionArray;
    }

    protected void customizeOptionsPanel() {
        if (this.myInsertOverrideAnnotationCheckbox != null && this.myIsInsertOverrideVisible) {
            this.myInsertOverrideAnnotationCheckbox.setSelected(this.isInsertOverrideAnnotationSelected());
        }
        if (this.myCopyJavadocCheckbox != null) {
            this.myCopyJavadocCheckbox.setSelected(PropertiesComponent.getInstance().isTrueValue(PROP_COPYJAVADOC));
        }
    }

    protected boolean isInsertOverrideAnnotationSelected() {
        return false;
    }

    protected JComponent createSouthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        this.customizeOptionsPanel();
        JPanel optionsPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        for (JComponent component2 : this.myOptionControls) {
            optionsPanel.add(component2);
        }
        panel2.add((Component)optionsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsRight((int)5), 0, 0));
        if (!(this.myAllowEmptySelection || this.myElements != null && this.myElements.length != 0)) {
            this.setOKActionEnabled(false);
        }
        panel2.add((Component)super.createSouthPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 15, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel2;
    }

    protected JComponent createNorthPanel() {
        return this.myHeaderPanel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        this.fillToolbarActions(group);
        group.addSeparator();
        ExpandAllAction expandAllAction = new ExpandAllAction();
        expandAllAction.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ExpandAll"), (JComponent)this.myTree);
        group.add((AnAction)expandAllAction);
        CollapseAllAction collapseAllAction = new CollapseAllAction();
        collapseAllAction.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CollapseAll"), (JComponent)this.myTree);
        group.add((AnAction)collapseAllAction);
        panel2.add((Component)ActionManager.getInstance().createActionToolbar("MemberChooser", (ActionGroup)group, true).getComponent(), "North");
        this.expandFirst();
        this.defaultExpandTree();
        this.installSpeedSearch();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)350, (int)450));
        panel2.add((Component)scrollPane, "Center");
        return panel2;
    }

    private void expandFirst() {
        if (this.getRootNode().getChildCount() > 0) {
            this.myTree.expandRow(0);
            this.myTree.setSelectionRow(1);
        }
    }

    protected Tree createTree() {
        final Tree tree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        tree.setCellRenderer(this.getTreeCellRenderer());
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.addKeyListener((KeyListener)new TreeKeyListener());
        tree.addTreeSelectionListener((TreeSelectionListener)new MyTreeSelectionListener());
        if (!this.myAllowMultiSelection) {
            tree.getSelectionModel().setSelectionMode(1);
        }
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (tree.getPathForLocation(e.getX(), e.getY()) != null) {
                    MemberChooser.this.doOKAction();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/MemberChooser$1", "onDoubleClick"));
            }
        }.installOn((Component)tree);
        TreeUtil.installActions((JTree)tree);
        return tree;
    }

    protected TreeCellRenderer getTreeCellRenderer() {
        return new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value2 instanceof ElementNode) {
                    ((ElementNode)value2).getDelegate().renderTreeNode((SimpleColoredComponent)this, tree);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/MemberChooser$2", "customizeCellRenderer"));
            }
        };
    }

    @NotNull
    protected String convertElementText(@NotNull String originalElementText) {
        if (originalElementText == null) {
            MemberChooser.$$$reportNull$$$0(7);
        }
        String string = originalElementText;
        if (string == null) {
            MemberChooser.$$$reportNull$$$0(8);
        }
        return string;
    }

    protected void installSpeedSearch() {
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch(this.myTree, (Convertor<? super TreePath, String>)((Convertor)path -> {
            ElementNode lastPathComponent = (ElementNode)path.getLastPathComponent();
            if (lastPathComponent == null) {
                return null;
            }
            String text = lastPathComponent.getDelegate().getText();
            if (text != null) {
                text = this.convertElementText(text);
            }
            return text;
        }));
        treeSpeedSearch.setComparator(this.getSpeedSearchComparator());
    }

    protected SpeedSearchComparator getSpeedSearchComparator() {
        return new SpeedSearchComparator(false);
    }

    protected void disableAlphabeticalSorting(@NotNull AnActionEvent event) {
        if (event == null) {
            MemberChooser.$$$reportNull$$$0(9);
        }
        this.mySortAction.setSelected(event, false);
    }

    protected void onAlphabeticalSortingEnabled(AnActionEvent event) {
    }

    protected void fillToolbarActions(DefaultActionGroup group) {
        boolean alphabeticallySorted = PropertiesComponent.getInstance().isTrueValue(PROP_SORTED);
        if (alphabeticallySorted) {
            this.setSortComparator(new AlphaComparator());
        }
        this.myAlphabeticallySorted = alphabeticallySorted;
        group.add((AnAction)this.mySortAction);
        if (!this.supportsNestedContainers()) {
            ShowContainersAction showContainersAction = this.getShowContainersAction();
            showContainersAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(67, 8)), (JComponent)this.myTree);
            this.setShowClasses(PropertiesComponent.getInstance().getBoolean(PROP_SHOWCLASSES, true));
            group.add((AnAction)showContainersAction);
        }
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.MemberChooser";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    public JComponent[] getOptionControls() {
        return this.myOptionControls;
    }

    @Nullable
    private LinkedHashSet<T> getSelectedElementsList() {
        return this.getExitCode() == 0 ? this.mySelectedElements : null;
    }

    @Nullable
    public List<T> getSelectedElements() {
        LinkedHashSet<T> list2 = this.getSelectedElementsList();
        return list2 == null ? null : new ArrayList<T>(list2);
    }

    public T @Nullable [] getSelectedElements(T[] a) {
        LinkedHashSet<T> list2 = this.getSelectedElementsList();
        if (list2 == null) {
            return null;
        }
        return (ClassMember[])list2.toArray(a);
    }

    protected final boolean areElementsSelected() {
        return this.mySelectedElements != null && !this.mySelectedElements.isEmpty();
    }

    public void setCopyJavadocVisible(boolean state) {
        if (this.myCopyJavadocCheckbox != null) {
            this.myCopyJavadocCheckbox.setVisible(state);
        }
    }

    public boolean isCopyJavadoc() {
        return this.myCopyJavadocCheckbox != null && this.myCopyJavadocCheckbox.isSelected();
    }

    public boolean isInsertOverrideAnnotation() {
        return this.myIsInsertOverrideVisible && this.myInsertOverrideAnnotationCheckbox.isSelected();
    }

    private boolean isAlphabeticallySorted() {
        return this.myAlphabeticallySorted;
    }

    protected void changeSortComparator(Comparator<T> comparator2) {
        this.setSortComparator(new ElementNodeComparatorWrapper<T>(comparator2));
    }

    private void setSortComparator(Comparator<ElementNode> sortComparator) {
        if (this.myComparator.equals(sortComparator)) {
            return;
        }
        this.myComparator = sortComparator;
        this.doSort();
    }

    protected void doSort() {
        Pair<ElementNode, List<ElementNode>> pair = this.storeSelection();
        Enumeration<TreeNode> children2 = this.getRootNodeChildren();
        while (children2.hasMoreElements()) {
            ParentNode classNode = (ParentNode)children2.nextElement();
            MemberChooser.sortNode(classNode, this.myComparator);
            this.myTreeModel.nodeStructureChanged(classNode);
        }
        this.restoreSelection(pair);
    }

    private static void sortNode(ParentNode node, Comparator<? super ElementNode> sortComparator) {
        ArrayList<? super ElementNode> arrayList = new ArrayList<ElementNode>();
        Enumeration<TreeNode> children2 = node.children();
        while (children2.hasMoreElements()) {
            arrayList.add((ElementNode)children2.nextElement());
        }
        arrayList.sort(sortComparator);
        MemberChooser.replaceChildren(node, arrayList);
    }

    private static void replaceChildren(DefaultMutableTreeNode node, Collection<? extends ElementNode> arrayList) {
        node.removeAllChildren();
        for (ElementNode elementNode : arrayList) {
            node.add(elementNode);
        }
    }

    protected void restoreTree() {
        Pair<ElementNode, List<ElementNode>> selection = this.storeSelection();
        DefaultMutableTreeNode root = this.getRootNode();
        if (!this.myShowClasses || this.myContainerNodes.isEmpty()) {
            ArrayList<ParentNode> otherObjects = new ArrayList<ParentNode>();
            Enumeration<TreeNode> children2 = this.getRootNodeChildren();
            ParentNode newRoot = new ParentNode(null, (MemberChooserObject)new MemberChooserObjectBase(this.getAllContainersNodeName()), (Ref<Integer>)new Ref((Object)0));
            while (children2.hasMoreElements()) {
                ParentNode nextElement = (ParentNode)children2.nextElement();
                if (nextElement instanceof ContainerNode) {
                    ContainerNode containerNode = (ContainerNode)nextElement;
                    Enumeration<TreeNode> enumeration = containerNode.children();
                    ArrayList<MemberNode> memberNodesList = new ArrayList<MemberNode>();
                    while (enumeration.hasMoreElements()) {
                        memberNodesList.add((MemberNode)enumeration.nextElement());
                    }
                    for (MemberNode memberNode : memberNodesList) {
                        newRoot.add(memberNode);
                    }
                    continue;
                }
                otherObjects.add(nextElement);
            }
            MemberChooser.replaceChildren(root, otherObjects);
            MemberChooser.sortNode(newRoot, this.myComparator);
            if (newRoot.children().hasMoreElements()) {
                root.add(newRoot);
            }
        } else {
            Enumeration<TreeNode> children3 = this.getRootNodeChildren();
            while (children3.hasMoreElements()) {
                ParentNode allClassesNode = (ParentNode)children3.nextElement();
                Enumeration<TreeNode> memberNodes = allClassesNode.children();
                ArrayList<ElementNode> arrayList = new ArrayList<ElementNode>();
                while (memberNodes.hasMoreElements()) {
                    arrayList.add((MemberNode)memberNodes.nextElement());
                }
                arrayList.sort(this.myComparator);
                for (MemberNode memberNode : arrayList) {
                    this.myNodeToParentMap.get(memberNode).add(memberNode);
                }
            }
            MemberChooser.replaceChildren(root, this.myContainerNodes);
        }
        this.myTreeModel.nodeStructureChanged(root);
        this.defaultExpandTree();
        this.restoreSelection(selection);
    }

    protected void setShowClasses(boolean showClasses) {
        this.myShowClasses = showClasses;
        this.restoreTree();
    }

    protected String getAllContainersNodeName() {
        return IdeBundle.message((String)"node.memberchooser.all.classes", (Object[])new Object[0]);
    }

    private Enumeration<TreeNode> getRootNodeChildren() {
        return this.getRootNode().children();
    }

    protected DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.myTreeModel.getRoot();
    }

    private Pair<ElementNode, List<ElementNode>> storeSelection() {
        TreePath leadSelectionPath;
        ArrayList<ElementNode> selectedNodes = new ArrayList<ElementNode>();
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                selectedNodes.add((ElementNode)path.getLastPathComponent());
            }
        }
        return Pair.create((Object)((leadSelectionPath = this.myTree.getLeadSelectionPath()) != null ? (ElementNode)leadSelectionPath.getLastPathComponent() : null), selectedNodes);
    }

    private void restoreSelection(Pair<? extends ElementNode, ? extends List<ElementNode>> pair) {
        ElementNode leadNode;
        List selectedNodes = (List)pair.second;
        DefaultMutableTreeNode root = this.getRootNode();
        ArrayList<TreePath> toSelect2 = new ArrayList<TreePath>();
        for (ElementNode node : selectedNodes) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)((Object)node);
            if (!root.isNodeDescendant(treeNode)) continue;
            toSelect2.add(new TreePath(treeNode.getPath()));
        }
        if (!toSelect2.isEmpty()) {
            this.myTree.setSelectionPaths(TreePathUtil.toTreePathArray(toSelect2));
        }
        if ((leadNode = (ElementNode)pair.first) != null) {
            this.myTree.setLeadSelectionPath(new TreePath(((DefaultMutableTreeNode)((Object)leadNode)).getPath()));
        }
    }

    public void dispose() {
        Container contentPane;
        PropertiesComponent instance = PropertiesComponent.getInstance();
        instance.setValue(PROP_SORTED, this.isAlphabeticallySorted());
        instance.setValue(PROP_SHOWCLASSES, this.myShowClasses);
        if (this.myCopyJavadocCheckbox != null) {
            instance.setValue(PROP_COPYJAVADOC, Boolean.toString(this.myCopyJavadocCheckbox.isSelected()));
        }
        if ((contentPane = this.getContentPane()) != null) {
            contentPane.removeAll();
        }
        this.mySelectedNodes.clear();
        this.myElements = null;
        super.dispose();
    }

    public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
        ClassMember selectedElement;
        if (key == null) {
            MemberChooser.$$$reportNull$$$0(10);
        }
        if (sink == null) {
            MemberChooser.$$$reportNull$$$0(11);
        }
        if (key.equals(CommonDataKeys.PSI_ELEMENT) && this.mySelectedElements != null && !this.mySelectedElements.isEmpty() && (selectedElement = (ClassMember)this.mySelectedElements.iterator().next()) instanceof ClassMemberWithElement) {
            sink.put(CommonDataKeys.PSI_ELEMENT, (Object)((ClassMemberWithElement)selectedElement).getElement());
        }
    }

    protected ShowContainersAction getShowContainersAction() {
        return new ShowContainersAction(IdeBundle.message((String)"action.show.classes", (Object[])new Object[0]), PlatformIcons.CLASS_ICON);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/MemberChooser";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElementText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/MemberChooser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertElementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMemberNode";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertElementText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "disableAlphabeticalSorting";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calcData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ElementNodeComparatorWrapper<T>
    implements Comparator<ElementNode> {
        private final Comparator<? super T> myDelegate;

        ElementNodeComparatorWrapper(Comparator<? super T> delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public int compare(ElementNode o1, ElementNode o2) {
            return this.myDelegate.compare(o1.getDelegate(), o2.getDelegate());
        }
    }

    protected static class OrderComparator
    implements Comparator<ElementNode> {
        @Override
        public int compare(ElementNode n1, ElementNode n2) {
            if (n1.getDelegate() instanceof ClassMemberWithElement && n2.getDelegate() instanceof ClassMemberWithElement) {
                PsiElement element1 = ((ClassMemberWithElement)n1.getDelegate()).getElement();
                PsiElement element2 = ((ClassMemberWithElement)n2.getDelegate()).getElement();
                if (Comparing.equal((Object)element1.getContainingFile(), (Object)element2.getContainingFile()) && !(element1 instanceof PsiCompiledElement) && !(element2 instanceof PsiCompiledElement)) {
                    return element1.getTextOffset() - element2.getTextOffset();
                }
            }
            return n1.getOrder() - n2.getOrder();
        }
    }

    private static class AlphaComparator
    implements Comparator<ElementNode> {
        private AlphaComparator() {
        }

        @Override
        public int compare(ElementNode n1, ElementNode n2) {
            return n1.getDelegate().getText().compareToIgnoreCase(n2.getDelegate().getText());
        }
    }

    private class CollapseAllAction
    extends AnAction {
        CollapseAllAction() {
            super(IdeBundle.messagePointer((String)"action.collapse.all", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.collapse.all", (Object[])new Object[0]), AllIcons.Actions.Collapseall);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CollapseAllAction.$$$reportNull$$$0(0);
            }
            TreeUtil.collapseAll((JTree)MemberChooser.this.myTree, (int)1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/MemberChooser$CollapseAllAction", "actionPerformed"));
        }
    }

    private class ExpandAllAction
    extends AnAction {
        ExpandAllAction() {
            super(IdeBundle.messagePointer((String)"action.expand.all", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.expand.all", (Object[])new Object[0]), AllIcons.Actions.Expandall);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ExpandAllAction.$$$reportNull$$$0(0);
            }
            TreeUtil.expandAll((JTree)MemberChooser.this.myTree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/MemberChooser$ExpandAllAction", "actionPerformed"));
        }
    }

    protected class ShowContainersAction
    extends ToggleAction {
        public ShowContainersAction(String text, Icon icon2) {
            super(text, text, icon2);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                ShowContainersAction.$$$reportNull$$$0(0);
            }
            return MemberChooser.this.myShowClasses;
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                ShowContainersAction.$$$reportNull$$$0(1);
            }
            MemberChooser.this.setShowClasses(flag);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowContainersAction.$$$reportNull$$$0(2);
            }
            super.update(e);
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(MemberChooser.this.myContainerNodes.size() > 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/MemberChooser$ShowContainersAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SortEmAction
    extends ToggleAction {
        SortEmAction() {
            super(PlatformEditorBundle.messagePointer((String)"action.sort.alphabetically", (Object[])new Object[0]), PlatformEditorBundle.messagePointer((String)"action.sort.alphabetically", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                SortEmAction.$$$reportNull$$$0(0);
            }
            return MemberChooser.this.isAlphabeticallySorted();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                SortEmAction.$$$reportNull$$$0(1);
            }
            MemberChooser.this.myAlphabeticallySorted = flag;
            MemberChooser.this.setSortComparator(flag ? new AlphaComparator() : new OrderComparator());
            if (flag) {
                MemberChooser.this.onAlphabeticalSortingEnabled(event);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ide/util/MemberChooser$SortEmAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class TreeKeyListener
    extends KeyAdapter {
        private TreeKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TreePath path = MemberChooser.this.myTree.getLeadSelectionPath();
            if (path == null) {
                return;
            }
            Object lastComponent = path.getLastPathComponent();
            if (e.getKeyCode() == 10) {
                if (lastComponent instanceof ParentNode) {
                    return;
                }
                MemberChooser.this.doOKAction();
                e.consume();
            } else if (e.getKeyCode() == 155 && lastComponent instanceof ElementNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastComponent;
                if (!MemberChooser.this.mySelectedNodes.contains(node)) {
                    if (node.getNextNode() != null) {
                        MemberChooser.this.myTree.setSelectionPath(new TreePath(node.getNextNode().getPath()));
                    }
                } else if (node.getNextNode() != null) {
                    MemberChooser.this.myTree.removeSelectionPath(new TreePath(node.getPath()));
                    MemberChooser.this.myTree.setSelectionPath(new TreePath(node.getNextNode().getPath()));
                    MemberChooser.this.myTree.repaint();
                }
                e.consume();
            }
        }
    }

    private class SelectNoneAction
    extends AbstractAction {
        SelectNoneAction() {
            super(IdeBundle.message((String)"action.select.none", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MemberChooser.this.myTree.clearSelection();
            MemberChooser.this.doOKAction();
        }
    }

    protected static class ContainerNode
    extends ParentNode {
        public ContainerNode(DefaultMutableTreeNode parent, MemberChooserObject delegate, Ref<Integer> order) {
            super(parent, delegate, order);
        }
    }

    protected static class ParentNode
    extends ElementNodeImpl {
        public ParentNode(@Nullable DefaultMutableTreeNode parent, MemberChooserObject delegate, Ref<Integer> order) {
            super(parent, delegate, order);
        }
    }

    protected static class MemberNodeImpl
    extends ElementNodeImpl
    implements MemberNode {
        public MemberNodeImpl(ParentNode parent, @NotNull ClassMember delegate, Ref<Integer> order) {
            if (delegate == null) {
                MemberNodeImpl.$$$reportNull$$$0(0);
            }
            super(parent, (MemberChooserObject)delegate, order);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/ide/util/MemberChooser$MemberNodeImpl", "<init>"));
        }
    }

    protected static abstract class ElementNodeImpl
    extends DefaultMutableTreeNode
    implements ElementNode {
        private final int myOrder;
        @NotNull
        private final MemberChooserObject myDelegate;

        public ElementNodeImpl(@Nullable DefaultMutableTreeNode parent, @NotNull MemberChooserObject delegate, Ref<Integer> order) {
            if (delegate == null) {
                ElementNodeImpl.$$$reportNull$$$0(0);
            }
            this.myOrder = (Integer)order.get();
            order.set((Object)(this.myOrder + 1));
            this.myDelegate = delegate;
            if (parent != null) {
                parent.add(this);
            }
        }

        @Override
        @NotNull
        public MemberChooserObject getDelegate() {
            MemberChooserObject memberChooserObject = this.myDelegate;
            if (memberChooserObject == null) {
                ElementNodeImpl.$$$reportNull$$$0(1);
            }
            return memberChooserObject;
        }

        @Override
        public int getOrder() {
            return this.myOrder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/MemberChooser$ElementNodeImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/MemberChooser$ElementNodeImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static interface MemberNode
    extends ElementNode {
    }

    protected static interface ElementNode
    extends MutableTreeNode {
        @NotNull
        public MemberChooserObject getDelegate();

        public int getOrder();
    }

    private class MyTreeSelectionListener
    implements TreeSelectionListener {
        private MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] paths = e.getPaths();
            if (paths == null) {
                return;
            }
            for (int i2 = 0; i2 < paths.length; ++i2) {
                Object node = paths[i2].getLastPathComponent();
                if (!(node instanceof MemberNode)) continue;
                MemberNode memberNode = (MemberNode)node;
                if (e.isAddedPath(i2)) {
                    if (MemberChooser.this.mySelectedNodes.contains(memberNode)) continue;
                    MemberChooser.this.mySelectedNodes.add(memberNode);
                    continue;
                }
                MemberChooser.this.mySelectedNodes.remove(memberNode);
            }
            MemberChooser.this.mySelectedNodes.sort(new OrderComparator());
            MemberChooser.this.mySelectedElements = new LinkedHashSet();
            for (MemberNode selectedNode : MemberChooser.this.mySelectedNodes) {
                MemberChooser.this.mySelectedElements.add((ClassMember)selectedNode.getDelegate());
            }
            if (!MemberChooser.this.myAllowEmptySelection) {
                MemberChooser.this.setOKActionEnabled(!MemberChooser.this.mySelectedElements.isEmpty());
            }
        }
    }
}

