/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.BitUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import org.jetbrains.annotations.NotNull;

public class ActionButtonWithText
extends ActionButton {
    private static final int ICON_TEXT_SPACE = 2;
    private static final int TEXT_ARROW_SPACE = 1;
    private int myHorizontalTextPosition = 11;
    private int myHorizontalTextAlignment = 0;

    public ActionButtonWithText(AnAction action2, Presentation presentation2, String place, Dimension minimumSize) {
        super(action2, presentation2, place, minimumSize);
        this.setFont((Font)(action2.useSmallerFontForTextInToolbar() ? JBUI.Fonts.toolbarSmallComboBoxFont() : UIUtil.getLabelFont()));
        this.setForeground(UIUtil.getLabelForeground());
        this.myPresentation.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("mnemonicKey")) {
                    int oldValue = evt.getOldValue() instanceof Integer ? (Integer)evt.getOldValue() : 0;
                    int newValue2 = evt.getNewValue() instanceof Integer ? (Integer)evt.getNewValue() : 0;
                    ActionButtonWithText.this.updateMnemonic(oldValue, newValue2);
                }
            }
        });
        this.getActionMap().put("doClick", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionButtonWithText.this.click();
            }
        });
        this.updateMnemonic(0, this.myPresentation.getMnemonic());
        ComponentUtil.putClientProperty((JComponent)this, (Key)MnemonicHelper.MNEMONIC_CHECKER, keyCode -> this.getMnemonic() == keyCode);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myPlace == "EditorToolbar") {
            this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            this.setForeground(ColorUtil.dimmer((Color)JBColor.BLACK));
        } else {
            AnAction action2 = this.getAction();
            this.setFont((Font)(action2 != null && action2.useSmallerFontForTextInToolbar() ? JBUI.Fonts.toolbarSmallComboBoxFont() : UIUtil.getLabelFont()));
        }
    }

    @Override
    @NotNull
    protected Icon getFallbackIcon(boolean enabled) {
        Icon icon2 = EmptyIcon.ICON_0;
        if (icon2 == null) {
            ActionButtonWithText.$$$reportNull$$$0(0);
        }
        return icon2;
    }

    private void updateMnemonic(int lastMnemonic, int mnemonic) {
        int mask;
        if (mnemonic == lastMnemonic) {
            return;
        }
        InputMap windowInputMap = SwingUtilities.getUIInputMap(this, 2);
        int n = mask = SystemInfo.isMac ? 10 : 8;
        if (lastMnemonic != 0 && windowInputMap != null) {
            windowInputMap.remove(KeyStroke.getKeyStroke(lastMnemonic, mask, false));
        }
        if (mnemonic != 0) {
            if (windowInputMap == null) {
                windowInputMap = new ComponentInputMapUIResource(this);
                SwingUtilities.replaceUIInputMap(this, 2, windowInputMap);
            }
            windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, mask, false), "doClick");
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension basicSize = super.getPreferredSize();
        Icon icon2 = this.getIcon();
        int position = this.horizontalTextPosition();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Rectangle viewRect = new Rectangle(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        Insets insets = this.getInsets();
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        SwingUtilities.layoutCompoundLabel(this, fm, this.getText(), icon2, 0, this.horizontalTextAlignment(), 0, position, viewRect, iconR, textR, this.iconTextSpace());
        int x1 = Math.min(iconR.x, textR.x);
        int x2 = Math.max(iconR.x + iconR.width, textR.x + textR.width);
        int y1 = Math.min(iconR.y, textR.y);
        int y2 = Math.max(iconR.y + iconR.height, textR.y + textR.height);
        Dimension rv = new Dimension(x2 - x1 + dx, y2 - y1 + dy);
        rv.width += Math.max(basicSize.height - rv.height, 0);
        if (this.shallPaintDownArrow()) {
            rv.width += AllIcons.General.LinkDropTriangle.getIconWidth() + JBUI.scale((int)1);
        }
        rv.width = Math.max(rv.width, basicSize.width);
        rv.height = Math.max(rv.height, basicSize.height);
        return rv;
    }

    @Override
    protected void updateToolTipText() {
        String description = this.myPresentation.getDescription();
        if (Registry.is((String)"ide.helptooltip.enabled")) {
            HelpTooltip.dispose((Component)this);
            if (StringUtil.isNotEmpty((String)description)) {
                new HelpTooltip().setDescription(description).installOn((JComponent)this);
            }
        } else {
            this.setToolTipText(description);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Icon icon2 = this.getIcon();
        Icon arrowIcon = this.shallPaintDownArrow() ? AllIcons.General.LinkDropTriangle : null;
        UISettings.setupAntialiasing((Graphics)g);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Rectangle viewRect = this.getButtonRect();
        JBInsets.removeFrom((Rectangle)viewRect, (Insets)this.getInsets());
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        String text = SwingUtilities.layoutCompoundLabel(this, fm, this.getText(), icon2, 0, this.horizontalTextAlignment(), 0, this.horizontalTextPosition(), viewRect, iconRect, textRect, this.iconTextSpace());
        if (arrowIcon != null) {
            int alignment = this.horizontalTextAlignment();
            int dx = alignment == 0 ? arrowIcon.getIconWidth() / 2 - 2 : (alignment == 4 ? arrowIcon.getIconWidth() : 0);
            iconRect.x -= dx;
            textRect.x -= dx;
        }
        ActionButtonLook look = ActionButtonLook.SYSTEM_LOOK;
        look.paintBackground(g, this);
        look.paintIcon(g, this, icon2, iconRect.x, iconRect.y);
        look.paintBorder(g, this);
        g.setColor(this.isButtonEnabled() ? this.getForeground() : this.getInactiveTextColor());
        UIUtilities.drawStringUnderlineCharAt((JComponent)this, (Graphics)g, (String)text, (int)this.getMnemonicCharIndex(text), (int)textRect.x, (int)(textRect.y + fm.getAscent()));
        if (arrowIcon != null) {
            int x = Math.max(iconRect.x + iconRect.width, textRect.x + textRect.width) + JBUI.scale((int)1);
            int y = textRect.y + (textRect.height - arrowIcon.getIconHeight()) / 2 + 1;
            arrowIcon.paintIcon(this, g, x, y);
        }
    }

    protected Rectangle getButtonRect() {
        return new Rectangle(this.getSize());
    }

    @Override
    protected void presentationPropertyChanged(@NotNull PropertyChangeEvent e) {
        if (e == null) {
            ActionButtonWithText.$$$reportNull$$$0(1);
        }
        super.presentationPropertyChanged(e);
        if ("text".equals(e.getPropertyName())) {
            this.revalidate();
        }
    }

    public Color getInactiveTextColor() {
        return UIUtil.getInactiveTextColor();
    }

    public void setHorizontalTextPosition(int position) {
        this.myHorizontalTextPosition = position;
    }

    public void setHorizontalTextAlignment(int alignment) {
        this.myHorizontalTextAlignment = alignment;
    }

    protected int horizontalTextPosition() {
        return this.myHorizontalTextPosition;
    }

    protected int horizontalTextAlignment() {
        return this.myHorizontalTextAlignment;
    }

    protected int iconTextSpace() {
        Icon icon2 = this.getIcon();
        return icon2 instanceof EmptyIcon || icon2 == null ? 0 : JBUI.scale((int)2);
    }

    private int getMnemonicCharIndex(String text) {
        Shortcut[] shortcuts;
        int mnemonicIndex = this.myPresentation.getDisplayedMnemonicIndex();
        if (mnemonicIndex != -1) {
            return mnemonicIndex;
        }
        ShortcutSet shortcutSet = this.myAction.getShortcutSet();
        for (Shortcut shortcut : shortcuts = shortcutSet.getShortcuts()) {
            KeyStroke keyStroke;
            int modifiers;
            KeyboardShortcut keyboardShortcut;
            if (!(shortcut instanceof KeyboardShortcut) || (keyboardShortcut = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null || !BitUtil.isSet((int)(modifiers = (keyStroke = keyboardShortcut.getFirstKeyStroke()).getModifiers()), (int)8)) continue;
            return keyStroke.getKeyChar() != '\uffff' ? text.indexOf(keyStroke.getKeyChar()) : text.indexOf(KeyEvent.getKeyText(keyStroke.getKeyCode()));
        }
        return -1;
    }

    @NotNull
    private String getText() {
        String text = this.myPresentation.getText();
        return text != null ? text : "";
    }

    public int getMnemonic() {
        return KeyEvent.getExtendedKeyCodeForChar(this.myPresentation.getMnemonic());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionButtonWithText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFallbackIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionButtonWithText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "presentationPropertyChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

