/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.openapi.editor.ex.util.SegmentArrayWithData;
import com.intellij.psi.tree.IElementType;

public class IntBasedStorage
implements DataStorage {
    int[] myData;

    public IntBasedStorage() {
        this.myData = new int[64];
    }

    private IntBasedStorage(int[] data2) {
        this.myData = data2;
    }

    @Override
    public void setData(int segmentIndex, int data2) {
        this.myData = SegmentArrayWithData.reallocateArray(this.myData, segmentIndex + 1);
        this.myData[segmentIndex] = data2;
    }

    @Override
    public void remove(int startIndex, int endIndex, int mySegmentCount) {
        if (endIndex < mySegmentCount) {
            System.arraycopy(this.myData, endIndex, this.myData, startIndex, mySegmentCount - endIndex);
        }
    }

    @Override
    public void replace(DataStorage storage, int startOffset, int len) {
        assert (storage instanceof IntBasedStorage);
        System.arraycopy(((IntBasedStorage)storage).myData, 0, this.myData, startOffset, len);
    }

    @Override
    public void insert(DataStorage storageToInsert, int startIndex, int segmentCountToInsert, int segmentCount) {
        assert (storageToInsert instanceof IntBasedStorage);
        this.myData = SegmentArray.insert(this.myData, ((IntBasedStorage)storageToInsert).myData, startIndex, segmentCountToInsert, segmentCount);
    }

    @Override
    public int getData(int index) {
        return this.myData[index];
    }

    @Override
    public int packData(IElementType tokenType, int state, boolean isRestartableState) {
        return (state & 0xFFFF) << 16 | tokenType.getIndex() & 0xFFFF;
    }

    @Override
    public int unpackStateFromData(int data2) {
        return data2 >> 16;
    }

    @Override
    public IElementType unpackTokenFromData(int data2) {
        return IElementType.find((short)((short)(data2 & 0xFFFF)));
    }

    @Override
    public DataStorage copy() {
        return new IntBasedStorage(this.myData);
    }

    @Override
    public DataStorage createStorage() {
        return new IntBasedStorage();
    }
}

