/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildBundle;
import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTreeFilters;
import com.intellij.build.BuildView;
import com.intellij.build.BuildViewSettingsProvider;
import com.intellij.build.BuildViewSettingsProviderAdapter;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemEventDispatcher;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationExtension;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemRunnableState
extends UserDataHolderBase
implements RunProfileState {
    @ApiStatus.Internal
    public static final Key<Integer> DEBUGGER_DISPATCH_PORT_KEY = Key.create((String)"DEBUGGER_DISPATCH_PORT");
    @ApiStatus.Internal
    public static final Key<Integer> BUILD_PROCESS_DEBUGGER_PORT_KEY = Key.create((String)"BUILD_PROCESS_DEBUGGER_PORT");
    @NotNull
    private final ExternalSystemTaskExecutionSettings mySettings;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalSystemRunConfiguration myConfiguration;
    @NotNull
    private final ExecutionEnvironment myEnv;
    @Nullable
    private RunContentDescriptor myContentDescriptor;
    private final int myDebugPort;
    private ServerSocket myForkSocket;

    public ExternalSystemRunnableState(@NotNull ExternalSystemTaskExecutionSettings settings, @NotNull Project project, boolean debug, @NotNull ExternalSystemRunConfiguration configuration, @NotNull ExecutionEnvironment env) {
        int port;
        if (settings == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(2);
        }
        if (env == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(3);
        }
        this.myForkSocket = null;
        this.mySettings = settings;
        this.myProject = project;
        this.myConfiguration = configuration;
        this.myEnv = env;
        if (debug) {
            try {
                port = NetUtils.findAvailableSocketPort();
            }
            catch (IOException e) {
                ExternalSystemRunConfiguration.LOG.warn("Unexpected I/O exception occurred on attempt to find a free port to use for external system task debugging", (Throwable)e);
                port = 0;
            }
        } else {
            port = 0;
        }
        this.myDebugPort = port;
    }

    public int getDebugPort() {
        return this.myDebugPort;
    }

    @Nullable
    public ServerSocket getForkSocket() {
        if (this.myForkSocket == null && !ExternalSystemRunConfiguration.DISABLE_FORK_DEBUGGER) {
            try {
                this.myForkSocket = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            }
            catch (IOException e) {
                ExternalSystemRunConfiguration.LOG.error((Throwable)e);
            }
        }
        return this.myForkSocket;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        AnAction[] restartActions;
        if (runner == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(4);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        String jvmParametersSetup = this.getJvmParametersSetup();
        ApplicationManager.getApplication().assertIsWriteThread();
        FileDocumentManager.getInstance().saveAllDocuments();
        ExternalSystemExecuteTaskTask task2 = new ExternalSystemExecuteTaskTask(this.myProject, this.mySettings, jvmParametersSetup);
        this.copyUserDataTo(task2);
        this.addDebugUserDataTo(task2);
        final String executionName = StringUtil.isNotEmpty((String)this.mySettings.getExecutionName()) ? this.mySettings.getExecutionName() : (StringUtil.isNotEmpty((String)this.myConfiguration.getName()) ? this.myConfiguration.getName() : AbstractExternalSystemTaskConfigurationType.generateName(this.myProject, this.mySettings.getExternalSystemId(), this.mySettings.getExternalProjectPath(), this.mySettings.getTaskNames(), this.mySettings.getExecutionName(), ": ", ""));
        final ExternalSystemProcessHandler processHandler2 = new ExternalSystemProcessHandler(task2, executionName);
        final ExternalSystemExecutionConsoleManager<ExecutionConsole, ProcessHandler> consoleManager = ExternalSystemUtil.getConsoleManagerFor(task2);
        final ExecutionConsole consoleView = consoleManager.attachExecutionConsole(this.myProject, (ExternalSystemTask)task2, this.myEnv, (ProcessHandler)processHandler2);
        if (consoleView == null) {
            restartActions = AnAction.EMPTY_ARRAY;
            Disposer.register((Disposable)this.myProject, (Disposable)processHandler2);
        } else {
            Disposer.register((Disposable)this.myProject, (Disposable)consoleView);
            Disposer.register((Disposable)consoleView, (Disposable)processHandler2);
            restartActions = consoleManager.getRestartActions(consoleView);
        }
        final DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor(task2.getId(), executionName, task2.getExternalProjectPath(), System.currentTimeMillis());
        Class progressListenerClazz = (Class)task2.getUserData(ExternalSystemRunConfiguration.PROGRESS_LISTENER_KEY);
        Filter[] filters = consoleManager.getCustomExecutionFilters(this.myProject, (ExternalSystemTask)task2, this.myEnv);
        Arrays.stream(filters).forEach(buildDescriptor::withExecutionFilter);
        final BuildView progressListener = progressListenerClazz != null ? (BuildProgressListener)ServiceManager.getService((Project)this.myProject, (Class)progressListenerClazz) : this.createBuildView(buildDescriptor, consoleView);
        ExternalSystemRunConfiguration.EP_NAME.forEachExtensionSafe(extension -> extension.attachToProcess(this.myConfiguration, processHandler2, this.myEnv.getRunnerSettings()));
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            String startDateTime = DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
            final String settingsDescription = StringUtil.isEmpty((String)this.mySettings.toString()) ? "" : String.format(" '%s'", this.mySettings.toString());
            final String greeting = this.mySettings.getTaskNames().size() > 1 ? ExternalSystemBundle.message((String)"run.text.starting.multiple.task", (Object[])new Object[]{startDateTime, settingsDescription}) + "\n" : ExternalSystemBundle.message((String)"run.text.starting.single.task", (Object[])new Object[]{startDateTime, settingsDescription}) + "\n";
            processHandler2.notifyTextAvailable(greeting + "\n", ProcessOutputTypes.SYSTEM);
            try (final ExternalSystemEventDispatcher eventDispatcher = new ExternalSystemEventDispatcher(task2.getId(), progressListener, false);){
                ExternalSystemTaskNotificationListenerAdapter taskListener = new ExternalSystemTaskNotificationListenerAdapter(){

                    public void onStart(@NotNull ExternalSystemTaskId id2, String workingDir) {
                        if (id2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (progressListener != null) {
                            ExternalSystemRunConfiguration.MyTaskRerunAction rerunTaskAction = new ExternalSystemRunConfiguration.MyTaskRerunAction(progressListener, ExternalSystemRunnableState.this.myEnv, ExternalSystemRunnableState.this.myContentDescriptor);
                            BuildViewSettingsProviderAdapter viewSettingsProvider = consoleView instanceof BuildViewSettingsProvider ? new BuildViewSettingsProviderAdapter((BuildViewSettingsProvider)consoleView) : null;
                            buildDescriptor.withProcessHandler(processHandler2, (Consumer<ConsoleView>)((Consumer)view -> ExternalSystemRunConfiguration.foldGreetingOrFarewell(consoleView, greeting, true))).withContentDescriptor(() -> ExternalSystemRunnableState.this.myContentDescriptor).withRestartAction(rerunTaskAction).withRestartActions(restartActions).withExecutionEnvironment(ExternalSystemRunnableState.this.myEnv);
                            progressListener.onEvent((Object)id2, (BuildEvent)new StartBuildEventImpl(buildDescriptor, BuildBundle.message("build.status.running", new Object[0])).withBuildViewSettingsProvider(viewSettingsProvider));
                        }
                    }

                    public void onTaskOutput(@NotNull ExternalSystemTaskId id2, @NotNull String text, boolean stdOut) {
                        if (id2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (text == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (consoleView != null) {
                            consoleManager.onOutput(consoleView, (ProcessHandler)processHandler2, text, stdOut ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR);
                        } else {
                            processHandler2.notifyTextAvailable(text, stdOut ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR);
                        }
                        eventDispatcher.setStdOut(stdOut);
                        eventDispatcher.append(text);
                    }

                    public void onFailure(@NotNull ExternalSystemTaskId id2, @NotNull Exception e) {
                        if (id2 == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (e == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        DataProvider dataProvider = BuildConsoleUtils.getDataProvider((Object)id2, progressListener);
                        FailureResultImpl failureResult = ExternalSystemUtil.createFailureResult(executionName + " failed", e, id2.getProjectSystemId(), ExternalSystemRunnableState.this.myProject, dataProvider);
                        eventDispatcher.onEvent(id2, new FinishBuildEventImpl(id2, null, System.currentTimeMillis(), BuildBundle.message("build.status.failed", new Object[0]), (EventResult)failureResult));
                        processHandler2.notifyProcessTerminated(1);
                    }

                    public void onSuccess(@NotNull ExternalSystemTaskId id2) {
                        if (id2 == null) {
                            1.$$$reportNull$$$0(5);
                        }
                        eventDispatcher.onEvent(id2, new FinishBuildEventImpl(id2, null, System.currentTimeMillis(), BuildBundle.message("build.event.message.successful", new Object[0]), (EventResult)new SuccessResultImpl()));
                    }

                    public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(6);
                        }
                        if (event instanceof ExternalSystemBuildEvent) {
                            eventDispatcher.onEvent(event.getId(), ((ExternalSystemBuildEvent)event).getBuildEvent());
                        } else if (event instanceof ExternalSystemTaskExecutionEvent) {
                            BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)event);
                            eventDispatcher.onEvent(event.getId(), buildEvent);
                        }
                    }

                    public void onEnd(@NotNull ExternalSystemTaskId id2) {
                        if (id2 == null) {
                            1.$$$reportNull$$$0(7);
                        }
                        String endDateTime = DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
                        String farewell = ExternalSystemRunnableState.this.mySettings.getTaskNames().size() > 1 ? ExternalSystemBundle.message((String)"run.text.ended.multiple.task", (Object[])new Object[]{endDateTime, settingsDescription}) : ExternalSystemBundle.message((String)"run.text.ended.single.task", (Object[])new Object[]{endDateTime, settingsDescription});
                        processHandler2.notifyTextAvailable(farewell + "\n", ProcessOutputTypes.SYSTEM);
                        ExternalSystemRunConfiguration.foldGreetingOrFarewell(consoleView, farewell, false);
                        processHandler2.notifyProcessTerminated(0);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "id";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "text";
                                break;
                            }
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "e";
                                break;
                            }
                            case 6: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunnableState$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onStart";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTaskOutput";
                                break;
                            }
                            case 3: 
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onFailure";
                                break;
                            }
                            case 5: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onSuccess";
                                break;
                            }
                            case 6: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onStatusChange";
                                break;
                            }
                            case 7: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onEnd";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                task2.execute(new ExternalSystemTaskNotificationListener[]{taskListener});
                Throwable taskError = task2.getError();
                if (taskError != null && !(taskError instanceof Exception)) {
                    FinishBuildEventImpl failureEvent = new FinishBuildEventImpl(task2.getId(), null, System.currentTimeMillis(), BuildBundle.message("build.status.failed", new Object[0]), (EventResult)new FailureResultImpl(taskError));
                    eventDispatcher.onEvent(task2.getId(), failureEvent);
                }
            }
        });
        ExecutionConsole executionConsole = progressListener instanceof ExecutionConsole ? (ExecutionConsole)progressListener : consoleView;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        if (executionConsole instanceof BuildView) {
            actionGroup.addAll(((BuildView)executionConsole).getSwitchActions());
            actionGroup.add((AnAction)BuildTreeFilters.createFilteringActionsGroup((BuildView)executionConsole));
        }
        DefaultExecutionResult executionResult = new DefaultExecutionResult(executionConsole, (ProcessHandler)processHandler2, actionGroup.getChildren(null));
        executionResult.setRestartActions(restartActions);
        return executionResult;
    }

    private void addDebugUserDataTo(UserDataHolderBase holder) {
        if (this.myDebugPort > 0) {
            holder.putUserData(BUILD_PROCESS_DEBUGGER_PORT_KEY, (Object)this.myDebugPort);
            if (this.getForkSocket() != null) {
                holder.putUserData(DEBUGGER_DISPATCH_PORT_KEY, (Object)this.getForkSocket().getLocalPort());
            }
        }
    }

    @Nullable
    private String getJvmParametersSetup() throws ExecutionException {
        SimpleJavaParameters extensionsJP = new SimpleJavaParameters();
        for (ExternalSystemRunConfigurationExtension extension : ExternalSystemRunConfiguration.EP_NAME.getExtensionList()) {
            extension.updateVMParameters(this.myConfiguration, extensionsJP, this.myEnv.getRunnerSettings(), this.myEnv.getExecutor());
        }
        String jvmParametersSetup = "";
        if (this.myDebugPort <= 0) {
            ParametersList allVMParameters = new ParametersList();
            ParametersList data2 = (ParametersList)this.myEnv.getUserData(ExternalSystemTaskExecutionSettings.JVM_AGENT_SETUP_KEY);
            if (data2 != null) {
                for (String parameter : data2.getList()) {
                    if (parameter.startsWith("-agentlib:") || parameter.startsWith("-agentpath:") || parameter.startsWith("-javaagent:")) continue;
                    throw new ExecutionException(ExternalSystemBundle.message((String)"run.invalid.jvm.agent.configuration", (Object[])new Object[]{parameter}));
                }
                allVMParameters.addAll(data2.getParameters());
            }
            allVMParameters.addAll(extensionsJP.getVMParametersList().getParameters());
            jvmParametersSetup = allVMParameters.getParametersString();
        }
        return StringUtil.nullize((String)jvmParametersSetup);
    }

    private BuildView createBuildView(DefaultBuildDescriptor buildDescriptor, ExecutionConsole executionConsole) {
        return new BuildView(this.myProject, executionConsole, buildDescriptor, "build.toolwindow.run.selection.state", new ViewManager(){

            public boolean isConsoleEnabledByDefault() {
                return true;
            }

            public boolean isBuildContentView() {
                return false;
            }
        });
    }

    public void setContentDescriptor(@Nullable RunContentDescriptor contentDescriptor) {
        this.myContentDescriptor = contentDescriptor;
        if (contentDescriptor != null) {
            contentDescriptor.setExecutionId(this.myEnv.getExecutionId());
            RunnerAndConfigurationSettings settings = this.myEnv.getRunnerAndConfigurationSettings();
            if (settings != null) {
                contentDescriptor.setActivateToolWindowWhenAdded(settings.isActivateToolWindowBeforeRun());
            }
        }
    }

    @Nullable
    public XDebugProcess startDebugProcess(@NotNull XDebugSession session2, @NotNull ExecutionEnvironment env) {
        if (session2 == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(5);
        }
        if (env == null) {
            ExternalSystemRunnableState.$$$reportNull$$$0(6);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunnableState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "startDebugProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

