/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.HTMLFileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "Companion", "intellij.platform.ide.impl"})
public final class HTMLEditorProvider
implements FileEditorProvider,
DumbAware {
    private static final Key<String> URL_KEY;
    private static final Key<String> HTML_KEY;
    @NotNull
    private static final Key<String> TIMEOUT_CALLBACK;
    public static final Companion Companion;

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return new HTMLFileEditor((String)file2.getUserData(URL_KEY), (String)file2.getUserData(HTML_KEY), (String)file2.getUserData(TIMEOUT_CALLBACK));
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return Companion.isHTMLEditor(file2);
    }

    @NotNull
    public String getEditorTypeId() {
        return "html-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"URL_KEY");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"URL_KEY\")");
        URL_KEY = key;
        Key key2 = Key.create((String)"HTML_KEY");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create(\"HTML_KEY\")");
        HTML_KEY = key2;
        Key key3 = Key.create((String)"TIMEOUT_CALLBACK");
        Intrinsics.checkExpressionValueIsNotNull((Object)key3, (String)"Key.create(\"TIMEOUT_CALLBACK\")");
        TIMEOUT_CALLBACK = key3;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ:\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$Companion;", "", "()V", "HTML_KEY", "Lcom/intellij/openapi/util/Key;", "", "TIMEOUT_CALLBACK", "getTIMEOUT_CALLBACK", "()Lcom/intellij/openapi/util/Key;", "URL_KEY", "isHTMLEditor", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "openEditor", "", "project", "Lcom/intellij/openapi/project/Project;", "title", "url", "html", "timeoutCallback", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final Key<String> getTIMEOUT_CALLBACK() {
            return TIMEOUT_CALLBACK;
        }

        public final void openEditor(@NotNull Project project, @NotNull String title, @Nullable String url, @Nullable String html, @Nullable String timeoutCallback) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            LightVirtualFile file2 = new LightVirtualFile(title);
            if (url == null && html == null) {
                return;
            }
            if (url != null) {
                file2.putUserData(URL_KEY, (Object)url);
            }
            if (html != null) {
                file2.putUserData(HTML_KEY, (Object)html);
            }
            if (timeoutCallback != null) {
                file2.putUserData(this.getTIMEOUT_CALLBACK(), (Object)timeoutCallback);
            }
            FileEditorManager.getInstance((Project)project).openFile((VirtualFile)file2, true);
        }

        public static /* synthetic */ void openEditor$default(Companion companion, Project project, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                string4 = null;
            }
            companion.openEditor(project, string, string2, string3, string4);
        }

        public final boolean isHTMLEditor(@NotNull VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            return file2.getUserData(URL_KEY) != null || file2.getUserData(HTML_KEY) != null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

