/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.KeymapImplKt;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\u001a\u001c\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00012\f\u0010)\u001a\b\u0012\u0004\u0012\u00020'0*\u001a$\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\f\u00100\u001a\b\u0012\u0004\u0012\u00020/0.H\u0002\u001a \u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00012\u0006\u00104\u001a\u00020\u00012\u0006\u00105\u001a\u00020,H\u0000\u001a\u0016\u00106\u001a\u0002022\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000108H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\"\u000e\u0010\u0015\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001e\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\"\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010#\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010$\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010%\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"ACTION", "", "FIRST_KEYSTROKE_ATTRIBUTE", "ID_ATTRIBUTE", "KEYBOARD_GESTURE_KEY", "KEYBOARD_GESTURE_MODIFIER", "KEYBOARD_GESTURE_SHORTCUT", "KEYBOARD_SHORTCUT", "KEYSTROKE_ATTRIBUTE", "KEY_MAP", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MOUSE_SHORTCUT", "NAME_ATTRIBUTE", "NOTIFICATION_MANAGER", "Lcom/intellij/notification/SingletonNotificationManager;", "getNOTIFICATION_MANAGER", "()Lcom/intellij/notification/SingletonNotificationManager;", "NOTIFICATION_MANAGER$delegate", "Lkotlin/Lazy;", "PARENT_ATTRIBUTE", "SECOND_KEYSTROKE_ATTRIBUTE", "VERSION_ATTRIBUTE", "eclipseKeymap", "emacsKeymap", "gnomeKeymap", "kdeKeymap", "macOSKeymap", "netbeansKeymap", "resharperKeymap", "riderKeymap", "sublimeKeymap", "visualAssistKeymap", "visualStudioKeymap", "vsCodeKeymap", "xcodeKeymap", "xwinKeymap", "KeymapImpl", "Lcom/intellij/openapi/keymap/impl/KeymapImpl;", "name", "dataHolder", "Lcom/intellij/configurationStore/SchemeDataHolder;", "areShortcutsEqual", "", "shortcuts1", "", "Lcom/intellij/openapi/actionSystem/Shortcut;", "shortcuts2", "notifyAboutMissingKeymap", "", "keymapName", "message", "isParent", "sortInRegistrationOrder", "ids", "", "intellij.platform.ide.impl"})
public final class KeymapImplKt {
    private static final String KEY_MAP = "keymap";
    private static final String KEYBOARD_SHORTCUT = "keyboard-shortcut";
    private static final String KEYBOARD_GESTURE_SHORTCUT = "keyboard-gesture-shortcut";
    private static final String KEYBOARD_GESTURE_KEY = "keystroke";
    private static final String KEYBOARD_GESTURE_MODIFIER = "modifier";
    private static final String KEYSTROKE_ATTRIBUTE = "keystroke";
    private static final String FIRST_KEYSTROKE_ATTRIBUTE = "first-keystroke";
    private static final String SECOND_KEYSTROKE_ATTRIBUTE = "second-keystroke";
    private static final String ACTION = "action";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String PARENT_ATTRIBUTE = "parent";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ID_ATTRIBUTE = "id";
    private static final String MOUSE_SHORTCUT = "mouse-shortcut";
    private static final Logger LOG;
    private static final Lazy NOTIFICATION_MANAGER$delegate;
    private static final String macOSKeymap = "com.intellij.plugins.macoskeymap";
    private static final String gnomeKeymap = "com.intellij.plugins.gnomekeymap";
    private static final String kdeKeymap = "com.intellij.plugins.kdekeymap";
    private static final String xwinKeymap = "com.intellij.plugins.xwinkeymap";
    private static final String eclipseKeymap = "com.intellij.plugins.eclipsekeymap";
    private static final String emacsKeymap = "com.intellij.plugins.emacskeymap";
    private static final String netbeansKeymap = "com.intellij.plugins.netbeanskeymap";
    private static final String resharperKeymap = "com.intellij.plugins.resharperkeymap";
    private static final String sublimeKeymap = "com.intellij.plugins.sublimetextkeymap";
    private static final String visualStudioKeymap = "com.intellij.plugins.visualstudiokeymap";
    private static final String xcodeKeymap = "com.intellij.plugins.xcodekeymap";
    private static final String visualAssistKeymap = "com.intellij.plugins.visualassistkeymap";
    private static final String riderKeymap = "com.intellij.plugins.riderkeymap";
    private static final String vsCodeKeymap = "com.intellij.plugins.vscodekeymap";

    @NotNull
    public static final KeymapImpl KeymapImpl(@NotNull String name, @NotNull SchemeDataHolder<? super KeymapImpl> dataHolder) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)NAME_ATTRIBUTE);
        Intrinsics.checkParameterIsNotNull(dataHolder, (String)"dataHolder");
        KeymapImpl result2 = new KeymapImpl(dataHolder);
        result2.setName(name);
        result2.schemeState = SchemeState.UNCHANGED;
        return result2;
    }

    private static final SingletonNotificationManager getNOTIFICATION_MANAGER() {
        Lazy lazy = NOTIFICATION_MANAGER$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (SingletonNotificationManager)lazy.getValue();
    }

    private static final void sortInRegistrationOrder(List<String> ids) {
        ActionManagerEx actionManagerEx = ActionManagerEx.getInstanceEx();
        Intrinsics.checkExpressionValueIsNotNull((Object)actionManagerEx, (String)"ActionManagerEx.getInstanceEx()");
        Comparator comparator2 = actionManagerEx.getRegistrationOrderComparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)comparator2, (String)"ActionManagerEx.getInsta\u2026gistrationOrderComparator");
        CollectionsKt.sortWith(ids, (Comparator)comparator2);
    }

    private static final boolean areShortcutsEqual(List<? extends Shortcut> shortcuts1, List<? extends Shortcut> shortcuts2) {
        if (shortcuts1.size() != shortcuts2.size()) {
            return false;
        }
        for (Shortcut shortcut : shortcuts1) {
            if (shortcuts2.contains(shortcut)) continue;
            return false;
        }
        return true;
    }

    public static final void notifyAboutMissingKeymap(@NotNull String keymapName, @NotNull String message, boolean isParent) {
        Intrinsics.checkParameterIsNotNull((Object)keymapName, (String)"keymapName");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBusConnection messageBusConnection = application.getMessageBus().connect();
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"ApplicationManager.getAp\u2026on().messageBus.connect()");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(connection, keymapName, isParent, message){
            final /* synthetic */ MessageBusConnection $connection;
            final /* synthetic */ String $keymapName;
            final /* synthetic */ boolean $isParent;
            final /* synthetic */ String $message;

            public void projectOpened(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                this.$connection.disconnect();
                ApplicationManager.getApplication().invokeLater(new Runnable(this, project){
                    final /* synthetic */ notifyAboutMissingKeymap.1 this$0;
                    final /* synthetic */ Project $project;

                    public final void run() {
                        String pluginId;
                        String string;
                        switch (this.this$0.$keymapName) {
                            case "Mac OS X": 
                            case "Mac OS X 10.5+": {
                                string = KeymapImplKt.access$getMacOSKeymap$p();
                                break;
                            }
                            case "Default for GNOME": {
                                string = KeymapImplKt.access$getGnomeKeymap$p();
                                break;
                            }
                            case "Default for KDE": {
                                string = KeymapImplKt.access$getKdeKeymap$p();
                                break;
                            }
                            case "Default for XWin": {
                                string = KeymapImplKt.access$getXwinKeymap$p();
                                break;
                            }
                            case "Eclipse": 
                            case "Eclipse (Mac OS X)": {
                                string = KeymapImplKt.access$getEclipseKeymap$p();
                                break;
                            }
                            case "Emacs": {
                                string = KeymapImplKt.access$getEmacsKeymap$p();
                                break;
                            }
                            case "NetBeans 6.5": {
                                string = KeymapImplKt.access$getNetbeansKeymap$p();
                                break;
                            }
                            case "ReSharper": 
                            case "ReSharper OSX": {
                                string = KeymapImplKt.access$getResharperKeymap$p();
                                break;
                            }
                            case "Sublime Text (Mac OS X)": 
                            case "Sublime Text": {
                                string = KeymapImplKt.access$getSublimeKeymap$p();
                                break;
                            }
                            case "Visual Studio OSX": 
                            case "Visual Studio": {
                                string = KeymapImplKt.access$getVisualStudioKeymap$p();
                                break;
                            }
                            case "Visual Assist OSX": 
                            case "Visual Assist": {
                                string = KeymapImplKt.access$getVisualAssistKeymap$p();
                                break;
                            }
                            case "Xcode": {
                                string = KeymapImplKt.access$getXcodeKeymap$p();
                                break;
                            }
                            case "Rider OSX": 
                            case "Rider": {
                                string = KeymapImplKt.access$getRiderKeymap$p();
                                break;
                            }
                            case "VSCode": 
                            case "VSCode OSX": {
                                string = KeymapImplKt.access$getVsCodeKeymap$p();
                                break;
                            }
                            default: {
                                string = null;
                            }
                        }
                        String string2 = pluginId = string;
                        AnAction action2 = string2 == null ? (AnAction)new NotificationAction(this, IdeBundle.message((String)"action.text.search.for.keymap", (Object[])new Object[]{this.this$0.$keymapName})){
                            final /* synthetic */ notifyAboutMissingKeymap.projectOpened.1 this$0;

                            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                                Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                                ShowSettingsUtil.getInstance().showSettingsDialog(e.getProject(), PluginManagerConfigurable.class);
                            }
                            {
                                this.this$0 = $outer;
                                super($super_call_param$1);
                            }
                        } : (AnAction)new NotificationAction(this, pluginId, IdeBundle.message((String)"action.text.install.keymap", (Object[])new Object[]{this.this$0.$keymapName})){
                            final /* synthetic */ notifyAboutMissingKeymap.projectOpened.1 this$0;
                            final /* synthetic */ String $pluginId;

                            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                                Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                                Application application = ApplicationManager.getApplication();
                                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                                MessageBusConnection messageBusConnection = application.getMessageBus().connect();
                                Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"ApplicationManager.getAp\u2026on().messageBus.connect()");
                                MessageBusConnection connect = messageBusConnection;
                                connect.subscribe(KeymapManagerListener.TOPIC, (Object)new KeymapManagerListener(this, connect){
                                    final /* synthetic */ notifyAboutMissingKeymap.projectOpened.action.2 this$0;
                                    final /* synthetic */ MessageBusConnection $connect;

                                    public void keymapAdded(@NotNull Keymap keymap2) {
                                        Intrinsics.checkParameterIsNotNull((Object)keymap2, (String)"keymap");
                                        ApplicationManager.getApplication().invokeLater(new Runnable(this, keymap2){
                                            final /* synthetic */ notifyAboutMissingKeymap.projectOpened.action.actionPerformed.1 this$0;
                                            final /* synthetic */ Keymap $keymap;

                                            public final void run() {
                                                if (Intrinsics.areEqual((Object)this.$keymap.getName(), (Object)this.this$0.this$0.this$0.this$0.$keymapName)) {
                                                    this.this$0.$connect.disconnect();
                                                    String successMessage = IdeBundle.message((String)"notification.content.keymap.successfully.installed", (Object[])new Object[]{this.this$0.this$0.this$0.this$0.$keymapName});
                                                    if (!this.this$0.this$0.this$0.this$0.$isParent) {
                                                        KeymapManagerEx keymapManagerEx = KeymapManagerEx.getInstanceEx();
                                                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)keymapManagerEx), (String)"KeymapManagerEx.getInstanceEx()");
                                                        keymapManagerEx.setActiveKeymap(this.$keymap);
                                                        successMessage = IdeBundle.message((String)"notification.content.keymap.successfully.activated", (Object[])new Object[]{this.this$0.this$0.this$0.this$0.$keymapName});
                                                    }
                                                    NotificationGroup group = new NotificationGroup("Keymap", NotificationDisplayType.BALLOON, true, null, null, 24, null);
                                                    SingletonNotificationManager notificationManager2 = new SingletonNotificationManager(group, NotificationType.INFORMATION, null, 4, null);
                                                    String string = successMessage;
                                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"successMessage");
                                                    notificationManager2.notify(string, this.this$0.this$0.this$0.$project);
                                                }
                                            }
                                            {
                                                this.this$0 = var1_1;
                                                this.$keymap = keymap2;
                                            }
                                        });
                                    }
                                    {
                                        this.this$0 = $outer;
                                        this.$connect = $captured_local_variable$1;
                                    }
                                });
                                PluginsAdvertiser.installAndEnable(this.this$0.$project, this.getPluginIdWithDependencies(this.$pluginId), false, notifyAboutMissingKeymap.projectOpened.action.actionPerformed.2.INSTANCE);
                                notification.expire();
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Set<PluginId> toPluginIds(String ... ids) {
                                void $this$mapTo$iv$iv;
                                Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
                                String[] $this$map$iv = ids;
                                boolean $i$f$map = false;
                                String[] stringArray = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                                boolean $i$f$mapTo = false;
                                void var7_7 = $this$mapTo$iv$iv;
                                int n = ((void)var7_7).length;
                                for (int j = 0; j < n; ++j) {
                                    void it;
                                    void item$iv$iv;
                                    void var11_11 = item$iv$iv = var7_7[j];
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    PluginId pluginId = PluginId.getId((String)it);
                                    collection.add(pluginId);
                                }
                                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                            }

                            private final Set<PluginId> getPluginIdWithDependencies(String pluginId) {
                                String string = pluginId;
                                return Intrinsics.areEqual((Object)string, (Object)KeymapImplKt.access$getGnomeKeymap$p()) ? this.toPluginIds(KeymapImplKt.access$getGnomeKeymap$p(), KeymapImplKt.access$getXwinKeymap$p()) : (Intrinsics.areEqual((Object)string, (Object)KeymapImplKt.access$getKdeKeymap$p()) ? this.toPluginIds(KeymapImplKt.access$getKdeKeymap$p(), KeymapImplKt.access$getXwinKeymap$p()) : (Intrinsics.areEqual((Object)string, (Object)KeymapImplKt.access$getResharperKeymap$p()) ? this.toPluginIds(KeymapImplKt.access$getResharperKeymap$p(), KeymapImplKt.access$getVisualStudioKeymap$p()) : (Intrinsics.areEqual((Object)string, (Object)KeymapImplKt.access$getXcodeKeymap$p()) ? this.toPluginIds(KeymapImplKt.access$getXcodeKeymap$p(), KeymapImplKt.access$getMacOSKeymap$p()) : this.toPluginIds(pluginId))));
                            }
                            {
                                this.this$0 = $outer;
                                this.$pluginId = $captured_local_variable$1;
                                super($super_call_param$2);
                            }
                        };
                        SingletonNotificationManager singletonNotificationManager = KeymapImplKt.access$getNOTIFICATION_MANAGER$p();
                        String string3 = IdeBundle.message((String)"notification.group.missing.keymap", (Object[])new Object[0]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"IdeBundle.message(\"notif\u2026on.group.missing.keymap\")");
                        SingletonNotificationManager.notify$default(singletonNotificationManager, string3, this.this$0.$message, null, null, action2, 12, null);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$project = project;
                    }
                }, ModalityState.NON_MODAL);
            }
            {
                this.$connection = $captured_local_variable$0;
                this.$keymapName = $captured_local_variable$1;
                this.$isParent = $captured_local_variable$2;
                this.$message = $captured_local_variable$3;
            }
        });
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KeymapImpl.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        NOTIFICATION_MANAGER$delegate = LazyKt.lazy((Function0)NOTIFICATION_MANAGER.2.INSTANCE);
        macOSKeymap = macOSKeymap;
        gnomeKeymap = gnomeKeymap;
        kdeKeymap = kdeKeymap;
        xwinKeymap = xwinKeymap;
        eclipseKeymap = eclipseKeymap;
        emacsKeymap = emacsKeymap;
        netbeansKeymap = netbeansKeymap;
        resharperKeymap = resharperKeymap;
        sublimeKeymap = sublimeKeymap;
        visualStudioKeymap = visualStudioKeymap;
        xcodeKeymap = xcodeKeymap;
        visualAssistKeymap = visualAssistKeymap;
        riderKeymap = riderKeymap;
        vsCodeKeymap = vsCodeKeymap;
    }

    public static final /* synthetic */ boolean access$areShortcutsEqual(List shortcuts1, List shortcuts2) {
        return KeymapImplKt.areShortcutsEqual(shortcuts1, shortcuts2);
    }

    public static final /* synthetic */ void access$sortInRegistrationOrder(List ids) {
        KeymapImplKt.sortInRegistrationOrder(ids);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ String access$getMacOSKeymap$p() {
        return macOSKeymap;
    }

    public static final /* synthetic */ String access$getGnomeKeymap$p() {
        return gnomeKeymap;
    }

    public static final /* synthetic */ String access$getKdeKeymap$p() {
        return kdeKeymap;
    }

    public static final /* synthetic */ String access$getXwinKeymap$p() {
        return xwinKeymap;
    }

    public static final /* synthetic */ String access$getEclipseKeymap$p() {
        return eclipseKeymap;
    }

    public static final /* synthetic */ String access$getEmacsKeymap$p() {
        return emacsKeymap;
    }

    public static final /* synthetic */ String access$getNetbeansKeymap$p() {
        return netbeansKeymap;
    }

    public static final /* synthetic */ String access$getResharperKeymap$p() {
        return resharperKeymap;
    }

    public static final /* synthetic */ String access$getSublimeKeymap$p() {
        return sublimeKeymap;
    }

    public static final /* synthetic */ String access$getVisualStudioKeymap$p() {
        return visualStudioKeymap;
    }

    public static final /* synthetic */ String access$getVisualAssistKeymap$p() {
        return visualAssistKeymap;
    }

    public static final /* synthetic */ String access$getXcodeKeymap$p() {
        return xcodeKeymap;
    }

    public static final /* synthetic */ String access$getRiderKeymap$p() {
        return riderKeymap;
    }

    public static final /* synthetic */ String access$getVsCodeKeymap$p() {
        return vsCodeKeymap;
    }

    public static final /* synthetic */ SingletonNotificationManager access$getNOTIFICATION_MANAGER$p() {
        return KeymapImplKt.getNOTIFICATION_MANAGER();
    }
}

