/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.DynamicBundle;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerComponent;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class UpdateSettingsConfigurable
implements SearchableConfigurable {
    private final UpdateSettings mySettings = UpdateSettings.getInstance();
    private final boolean myCheckNowEnabled;
    private UpdatesSettingsPanel myPanel;

    UpdateSettingsConfigurable() {
        this(true);
    }

    public UpdateSettingsConfigurable(boolean checkNowEnabled) {
        this.myCheckNowEnabled = checkNowEnabled;
    }

    public JComponent createComponent() {
        this.myPanel = new UpdatesSettingsPanel(this.myCheckNowEnabled);
        return this.myPanel.myPanel;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"updates.settings.title", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return "preferences.updates";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            UpdateSettingsConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void apply() throws ConfigurationException {
        UpdateCheckerComponent checker;
        boolean wasEnabled = this.mySettings.isCheckNeeded();
        this.mySettings.setCheckNeeded(this.myPanel.myCheckForUpdates.isSelected());
        if (wasEnabled != this.mySettings.isCheckNeeded() && (checker = UpdateCheckerComponent.getInstance()) != null) {
            if (wasEnabled) {
                checker.cancelChecks();
            } else {
                checker.queueNextCheck();
            }
        }
        this.mySettings.setSelectedChannelStatus(this.myPanel.getSelectedChannelType());
    }

    public void reset() {
        this.myPanel.myCheckForUpdates.setSelected(this.mySettings.isCheckNeeded());
        this.myPanel.updateLastCheckedLabel();
        this.myPanel.setSelectedChannelType(this.mySettings.getSelectedActiveChannel());
    }

    public boolean isModified() {
        return this.myPanel != null && (this.myPanel.myCheckForUpdates.isSelected() != this.mySettings.isCheckNeeded() || this.myPanel.myUpdateChannels.getSelectedItem() != this.mySettings.getSelectedActiveChannel());
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettingsConfigurable", "getId"));
    }

    private static class UpdatesSettingsPanel {
        private final UpdateSettings mySettings;
        private JPanel myPanel;
        private JCheckBox myCheckForUpdates;
        private JComboBox<ChannelStatus> myUpdateChannels;
        private JButton myCheckNow;
        private JBLabel myChannelWarning;
        private JLabel myBuildNumber;
        private JLabel myVersionNumber;
        private JLabel myLastCheckedDate;
        private ActionLink myIgnoredBuildsLink;

        UpdatesSettingsPanel(boolean checkNowEnabled) {
            this.$$$setupUI$$$();
            this.mySettings = UpdateSettings.getInstance();
            ChannelStatus current2 = this.mySettings.getSelectedActiveChannel();
            this.myUpdateChannels.setModel((ComboBoxModel<ChannelStatus>)new CollectionComboBoxModel(this.mySettings.getActiveChannels(), (Object)current2));
            ExternalUpdateManager manager = ExternalUpdateManager.ACTUAL;
            if (manager != null) {
                this.myCheckForUpdates.setText(IdeBundle.message((String)"updates.settings.checkbox.external", (Object[])new Object[0]));
                this.myUpdateChannels.setVisible(false);
                this.myChannelWarning.setText(IdeBundle.message((String)"updates.settings.external", (Object[])new Object[]{manager.toolName}));
                this.myChannelWarning.setForeground((Color)JBColor.GRAY);
                this.myChannelWarning.setVisible(true);
                this.myChannelWarning.setBorder((Border)new JBEmptyBorder(0, 0, 10, 0));
            } else if (ApplicationInfoEx.getInstanceEx().isMajorEAP() && UpdateStrategyCustomization.getInstance().forceEapUpdateChannelForEapBuilds()) {
                this.myUpdateChannels.setEnabled(false);
                this.myUpdateChannels.setToolTipText(IdeBundle.message((String)"updates.settings.channel.locked", (Object[])new Object[0]));
            } else {
                this.myUpdateChannels.addActionListener(e -> {
                    boolean lessStable = current2.compareTo(this.getSelectedChannelType()) > 0;
                    this.myChannelWarning.setVisible(lessStable);
                });
                this.myChannelWarning.setForeground((Color)JBColor.RED);
            }
            if (checkNowEnabled) {
                this.myCheckNow.addActionListener(e -> {
                    Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myCheckNow));
                    UpdateSettings settings = new UpdateSettings();
                    settings.loadState(this.mySettings.getState());
                    settings.setSelectedChannelStatus(this.getSelectedChannelType());
                    UpdateChecker.updateAndShowResult(project, settings);
                    this.updateLastCheckedLabel();
                });
            } else {
                this.myCheckNow.setVisible(false);
            }
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            this.myVersionNumber.setText(ApplicationNamesInfo.getInstance().getFullProductName() + ' ' + appInfo.getFullVersion());
            this.myBuildNumber.setText(appInfo.getBuild().asString());
        }

        private void createUIComponents() {
            this.myIgnoredBuildsLink = new ActionLink(IdeBundle.message((String)"updates.settings.ignored", (Object[])new Object[0]), new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List<String> buildNumbers = mySettings.getIgnoredBuildNumbers();
                    String text = StringUtil.join(buildNumbers, (String)"\n");
                    String result2 = Messages.showMultilineInputDialog(null, null, (String)IdeBundle.message((String)"updates.settings.ignored.title", (Object[])new Object[0]), (String)text, null, null);
                    if (result2 != null) {
                        buildNumbers.clear();
                        buildNumbers.addAll(StringUtil.split((String)result2, (String)"\n"));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/updateSettings/impl/UpdateSettingsConfigurable$UpdatesSettingsPanel$1", "actionPerformed"));
                }
            });
        }

        private void updateLastCheckedLabel() {
            long time = this.mySettings.getLastTimeChecked();
            if (time <= 0L) {
                this.myLastCheckedDate.setText(IdeBundle.message((String)"updates.last.check.never", (Object[])new Object[0]));
            } else {
                this.myLastCheckedDate.setText(DateFormatUtil.formatPrettyDateTime((long)time));
                this.myLastCheckedDate.setToolTipText(DateFormatUtil.formatDate((long)time) + ' ' + DateFormatUtil.formatTimeWithSeconds((long)time));
            }
        }

        public ChannelStatus getSelectedChannelType() {
            return (ChannelStatus)((Object)this.myUpdateChannels.getSelectedItem());
        }

        public void setSelectedChannelType(ChannelStatus channelType) {
            this.myUpdateChannels.setSelectedItem((Object)(channelType != null ? channelType : ChannelStatus.RELEASE));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JLabel jLabel;
            JLabel jLabel2;
            JLabel jLabel3;
            JBLabel jBLabel;
            JButton jButton;
            JCheckBox jCheckBox;
            JPanel jPanel2;
            this.createUIComponents();
            this.myPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(9, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myCheckForUpdates = jCheckBox = new JCheckBox();
            jCheckBox.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/IdeBundle", UpdatesSettingsPanel.class).getString("updates.settings.checkbox"));
            jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
            JComboBox jComboBox = new JComboBox();
            this.myUpdateChannels = jComboBox;
            jPanel2.add(jComboBox, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myCheckNow = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/IdeBundle", UpdatesSettingsPanel.class).getString("updates.settings.check.now.button"));
            jPanel2.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myChannelWarning = jBLabel = new JBLabel();
            this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/IdeBundle", UpdatesSettingsPanel.class).getString("updates.settings.unstable"));
            jBLabel.setVisible(false);
            jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 5, 8, 0, 0, 0, null, null, null));
            JLabel jLabel4 = new JLabel();
            jLabel4.setText(" ");
            jPanel2.add((Component)jLabel4, new GridConstraints(2, 0, 1, 4, 8, 0, 0, 0, null, null, null));
            JLabel jLabel5 = new JLabel();
            this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/IdeBundle", UpdatesSettingsPanel.class).getString("updates.settings.last.check"));
            jPanel2.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
            this.myLastCheckedDate = jLabel3 = new JLabel();
            jLabel3.setText("01.05.2005");
            jPanel2.add((Component)jLabel3, new GridConstraints(3, 1, 1, 3, 8, 1, 0, 0, null, null, null));
            JLabel jLabel6 = new JLabel();
            this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/IdeBundle", UpdatesSettingsPanel.class).getString("updates.settings.current.version"));
            jPanel2.add((Component)jLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
            this.myVersionNumber = jLabel2 = new JLabel();
            jLabel2.setText("4.5.4");
            jPanel2.add((Component)jLabel2, new GridConstraints(4, 1, 1, 3, 8, 1, 0, 0, null, null, null));
            JLabel jLabel7 = new JLabel();
            this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/IdeBundle", UpdatesSettingsPanel.class).getString("updates.settings.build.number"));
            jPanel2.add((Component)jLabel7, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
            this.myBuildNumber = jLabel = new JLabel();
            jLabel.setText("3352");
            jPanel2.add((Component)jLabel, new GridConstraints(5, 1, 1, 3, 8, 1, 0, 0, null, null, null));
            JLabel jLabel8 = new JLabel();
            jLabel8.setText(" ");
            jPanel2.add((Component)jLabel8, new GridConstraints(6, 0, 1, 4, 8, 0, 0, 0, null, null, null));
            ActionLink actionLink = this.myIgnoredBuildsLink;
            this.$$$loadLabelText$$$((JLabel)actionLink, DynamicBundle.getBundle((String)"messages/IdeBundle", UpdatesSettingsPanel.class).getString("updates.settings.ignored"));
            jPanel2.add((Component)actionLink, new GridConstraints(7, 0, 1, 4, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(8, 0, 1, 5, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '&') {
                    if (++j == string.length()) break;
                    if (!bl && string.charAt(j) != '&') {
                        bl = true;
                        c = string.charAt(j);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(j));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '&') {
                    if (++j == string.length()) break;
                    if (!bl && string.charAt(j) != '&') {
                        bl = true;
                        c = string.charAt(j);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(j));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

