/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.FileIntPropertyPusher;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataLanguagePusher
implements FileIntPropertyPusher<Language> {
    public static final Key<Language> KEY = Key.create((String)"TEMPLATE_DATA_LANGUAGE");
    private static final VfsDependentEnum<String> ourLanguagesEnumerator = new VfsDependentEnum("languages", EnumeratorStringDescriptor.INSTANCE, 1);
    private static final FileAttribute PERSISTENCE = new FileAttribute("template_language", 2, true);

    @NotNull
    public Key<Language> getFileDataKey() {
        Key<Language> key = KEY;
        if (key == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(0);
        }
        return key;
    }

    public boolean pushDirectoriesOnly() {
        return false;
    }

    @NotNull
    public Language getDefaultValue() {
        Language language = Language.ANY;
        if (language == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(1);
        }
        return language;
    }

    @Nullable
    public Language getImmediateValue(@NotNull Project project, @Nullable VirtualFile file2) {
        if (project == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(2);
        }
        return (Language)TemplateDataLanguageMappings.getInstance(project).getImmediateMapping(file2);
    }

    @Nullable
    public Language getImmediateValue(@NotNull Module module) {
        if (module == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(3);
        }
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file2, @NotNull Project project) {
        FileType type;
        if (file2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(4);
        }
        if (project == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(5);
        }
        return (type = file2.getFileType()) instanceof LanguageFileType && ((LanguageFileType)type).getLanguage() instanceof TemplateLanguage;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(6);
        }
        if (project == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(7);
        }
        return true;
    }

    @NotNull
    public FileAttribute getAttribute() {
        FileAttribute fileAttribute = PERSISTENCE;
        if (fileAttribute == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(8);
        }
        return fileAttribute;
    }

    public int toInt(@NotNull Language property) throws IOException {
        if (property == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(9);
        }
        return ourLanguagesEnumerator.getId(property.getID());
    }

    @NotNull
    public Language fromInt(int val) throws IOException {
        String id2 = ourLanguagesEnumerator.getById(val);
        Language lang = Language.findLanguageByID((String)id2);
        Language language = (Language)ObjectUtils.notNull((Object)lang, (Object)Language.ANY);
        if (language == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(10);
        }
        return language;
    }

    public void propertyChanged(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull Language actualProperty) {
        if (project == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(11);
        }
        if (fileOrDir == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(12);
        }
        if (actualProperty == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(13);
        }
        PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, file2 -> this.acceptsFile((VirtualFile)file2, project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDataKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttribute";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fromInt";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toInt";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

