/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.BaseToolManager;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolSelectDialog;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsGroup;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseToolSelectComboBox<T extends Tool>
extends ComboboxWithBrowseButton {
    public static final Object NONE_TOOL = ObjectUtils.sentinel((String)"NONE_TOOL");

    public BaseToolSelectComboBox() {
        final JComboBox comboBox2 = this.getComboBox();
        comboBox2.setModel(new CollectionComboBoxModel(this.getComboBoxElements(), null){

            public void setSelectedItem(@Nullable Object item) {
                if (item instanceof ToolsGroup) {
                    return;
                }
                super.setSelectedItem(item);
            }
        });
        comboBox2.setRenderer(new ColoredListCellRenderer<Object>(){

            public Component getListCellRendererComponent(JList<?> list2, Object value2, int index, boolean selected2, boolean hasFocus) {
                if (value2 instanceof ToolsGroup) {
                    SeparatorWithText separator = new SeparatorWithText();
                    separator.setCaption(StringUtil.notNullize((String)((ToolsGroup)value2).getName(), (String)ToolsBundle.message("tools.unnamed.group", new Object[0])));
                    separator.setCaptionCentered(false);
                    return separator;
                }
                return super.getListCellRendererComponent(list2, value2, index, selected2, hasFocus);
            }

            protected void customizeCellRenderer(@NotNull JList<?> list2, Object value2, int index, boolean selected2, boolean hasFocus) {
                if (list2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!(value2 instanceof ToolsGroup)) {
                    if (value2 instanceof Tool) {
                        this.append(StringUtil.notNullize((String)((Tool)value2).getName()), ((Tool)value2).isEnabled() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    } else {
                        this.append(ToolsBundle.message("tools.list.item.none", new Object[0]));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/tools/BaseToolSelectComboBox$2", "customizeCellRenderer"));
            }
        });
        this.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolSelectDialog dialog2;
                Object item = comboBox2.getSelectedItem();
                String id2 = null;
                if (item instanceof Tool) {
                    id2 = ((Tool)item).getActionId();
                }
                if (!(dialog2 = BaseToolSelectComboBox.this.getToolSelectDialog(id2)).showAndGet()) {
                    return;
                }
                comboBox2.setModel(new CollectionComboBoxModel(BaseToolSelectComboBox.this.getComboBoxElements(), (Object)dialog2.getSelectedTool()));
            }
        });
    }

    @NotNull
    protected abstract BaseToolManager<T> getToolManager();

    @NotNull
    protected abstract ToolSelectDialog getToolSelectDialog(@Nullable String var1);

    @NotNull
    protected List<Object> getComboBoxElements() {
        SmartList result2 = new SmartList();
        BaseToolManager<T> manager = this.getToolManager();
        result2.add(NONE_TOOL);
        for (ToolsGroup<T> group : manager.getGroups()) {
            result2.add(group);
            result2.addAll(manager.getTools(group.getName()));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            BaseToolSelectComboBox.$$$reportNull$$$0(0);
        }
        return smartList;
    }

    public int getValuableItemCount() {
        JComboBox comboBox2 = this.getComboBox();
        int itemCount = comboBox2.getItemCount();
        if (itemCount == 0) {
            return 0;
        }
        int valuableCount = 0;
        for (int i2 = 0; i2 < itemCount; ++i2) {
            if (comboBox2.getItemAt(i2) == NONE_TOOL) continue;
            ++valuableCount;
        }
        return valuableCount;
    }

    @Nullable
    public Tool selectTool(@Nullable String toolId) {
        JComboBox comboBox2 = this.getComboBox();
        if (toolId == null) {
            comboBox2.setSelectedIndex(-1);
            return null;
        }
        for (int i2 = 0; i2 < comboBox2.getItemCount(); ++i2) {
            Object itemAt = comboBox2.getItemAt(i2);
            if (!(itemAt instanceof Tool) || !toolId.equals(((Tool)itemAt).getActionId())) continue;
            comboBox2.setSelectedIndex(i2);
            return (Tool)itemAt;
        }
        return null;
    }

    @Nullable
    public Tool getSelectedTool() {
        Object item = this.getComboBox().getSelectedItem();
        return item instanceof Tool ? (Tool)item : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/BaseToolSelectComboBox", "getComboBoxElements"));
    }
}

