/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.flavor.FileIndexingFlavorProvider;
import com.intellij.util.indexing.flavor.HashBuilder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IndexedHashesSupport {
    private static final HashFunction INDEXED_FILE_CONTENT_HASHER = Hashing.sha1();

    public static int getVersion() {
        return 3;
    }

    public static byte @NotNull [] getOrInitIndexedHash(@NotNull FileContentImpl content2) {
        byte[] hash;
        if (content2 == null) {
            IndexedHashesSupport.$$$reportNull$$$0(0);
        }
        if ((hash = content2.getHash()) == null) {
            hash = IndexedHashesSupport.calculateIndexedHashForFileContent(content2);
            content2.setHashes(hash);
        }
        if (hash == null) {
            IndexedHashesSupport.$$$reportNull$$$0(1);
        }
        return hash;
    }

    public static byte @NotNull [] getBinaryContentHash(byte @NotNull [] content2) {
        if (content2 == null) {
            IndexedHashesSupport.$$$reportNull$$$0(2);
        }
        MessageDigest digest = FSRecords.getContentHashDigest();
        digest.update(String.valueOf(content2.length).getBytes(StandardCharsets.UTF_8));
        digest.update("\u0000".getBytes(StandardCharsets.UTF_8));
        digest.update(content2);
        byte[] byArray = digest.digest();
        if (byArray == null) {
            IndexedHashesSupport.$$$reportNull$$$0(3);
        }
        return byArray;
    }

    private static byte @NotNull [] calculateIndexedHashForFileContent(@NotNull FileContentImpl content2) {
        if (content2 == null) {
            IndexedHashesSupport.$$$reportNull$$$0(4);
        }
        final Hasher hasher = INDEXED_FILE_CONTENT_HASHER.newHasher();
        byte[] contentHash = PersistentFSImpl.getContentHashIfStored(content2.getFile());
        if (contentHash == null) {
            contentHash = IndexedHashesSupport.getBinaryContentHash(content2.getContent());
        }
        hasher.putBytes(contentHash);
        if (!content2.getFileTypeWithoutSubstitution().isBinary()) {
            hasher.putString((CharSequence)content2.getCharset().name(), StandardCharsets.UTF_8);
        }
        hasher.putString((CharSequence)content2.getFileName(), StandardCharsets.UTF_8);
        FileType fileType = content2.getFileType();
        hasher.putString((CharSequence)fileType.getName(), StandardCharsets.UTF_8);
        @Nullable FileIndexingFlavorProvider provider = (FileIndexingFlavorProvider)FileIndexingFlavorProvider.INSTANCE.forFileType(fileType);
        if (provider != null) {
            IndexedHashesSupport.buildFlavorHash((FileContent)content2, provider, new HashBuilder(){

                @NotNull
                public HashBuilder putInt(int val) {
                    hasher.putInt(val);
                    1 v0 = this;
                    if (v0 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return v0;
                }

                @NotNull
                public HashBuilder putBoolean(boolean val) {
                    hasher.putBoolean(val);
                    1 v0 = this;
                    if (v0 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return v0;
                }

                @NotNull
                public HashBuilder putString(@NotNull CharSequence charSequence) {
                    if (charSequence == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    hasher.putString(charSequence, StandardCharsets.UTF_8);
                    1 v0 = this;
                    if (v0 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return v0;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 2: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 2: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/util/indexing/IndexedHashesSupport$1";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "charSequence";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "putInt";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "putBoolean";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/util/indexing/IndexedHashesSupport$1";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "putString";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "putString";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
        byte[] byArray = hasher.hash().asBytes();
        if (byArray == null) {
            IndexedHashesSupport.$$$reportNull$$$0(5);
        }
        return byArray;
    }

    private static <F> void buildFlavorHash(@NotNull FileContent content2, @NotNull FileIndexingFlavorProvider<F> flavorProvider, @NotNull HashBuilder hashBuilder) {
        if (content2 == null) {
            IndexedHashesSupport.$$$reportNull$$$0(6);
        }
        if (flavorProvider == null) {
            IndexedHashesSupport.$$$reportNull$$$0(7);
        }
        if (hashBuilder == null) {
            IndexedHashesSupport.$$$reportNull$$$0(8);
        }
        Object flavor = flavorProvider.getFlavor((IndexedFile)content2);
        hashBuilder.putString((CharSequence)flavorProvider.getId());
        hashBuilder.putInt(flavorProvider.getVersion());
        if (flavor != null) {
            flavorProvider.buildHash(flavor, hashBuilder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexedHashesSupport";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavorProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexedHashesSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrInitIndexedHash";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryContentHash";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateIndexedHashForFileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrInitIndexedHash";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryContentHash";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculateIndexedHashForFileContent";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildFlavorHash";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

