/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump.paths.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.providers.PortableFilePathProvider;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/providers/JdkPortableFilePathProvider;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/providers/PortableFilePathProvider;", "()V", "getRelativePortableFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$RelativePath;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.lang.impl"})
public final class JdkPortableFilePathProvider
implements PortableFilePathProvider {
    public static final JdkPortableFilePathProvider INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public PortableFilePath.RelativePath getRelativePortableFilePath(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        OrderEntry orderEntry = LibraryUtil.findLibraryEntry((VirtualFile)virtualFile, (Project)project);
        if (!(orderEntry instanceof JdkOrderEntry)) {
            return null;
        }
        String jdkName = ((JdkOrderEntry)orderEntry).getJdkName();
        if (jdkName == null) {
            return null;
        }
        for (OrderRootType rootType : CollectionsKt.listOf((Object[])new OrderRootType[]{OrderRootType.CLASSES, OrderRootType.SOURCES})) {
            boolean inClassFiles = Intrinsics.areEqual((Object)rootType, (Object)OrderRootType.CLASSES);
            VirtualFile[] jdkRoots = ((JdkOrderEntry)orderEntry).getRootFiles(rootType);
            Intrinsics.checkExpressionValueIsNotNull((Object)jdkRoots, (String)"jdkRoots");
            VirtualFile[] virtualFileArray = jdkRoots;
            int n = virtualFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                void rootIndex;
                VirtualFile rootFile = virtualFileArray[n2];
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)rootFile);
                if (relativePath != null) {
                    return new PortableFilePath.RelativePath(new PortableFilePath.JdkRoot(jdkName, (int)rootIndex, inClassFiles), relativePath);
                }
                ++rootIndex;
            }
        }
        return null;
    }

    private JdkPortableFilePathProvider() {
    }

    static {
        JdkPortableFilePathProvider jdkPortableFilePathProvider;
        INSTANCE = jdkPortableFilePathProvider = new JdkPortableFilePathProvider();
    }
}

