/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.jps.serialization;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.workspaceModel.ide.JpsEntitySourcesKt;
import com.intellij.workspaceModel.ide.JpsFileEntitySource;
import com.intellij.workspaceModel.ide.JpsImportedEntitySource;
import com.intellij.workspaceModel.ide.JpsProjectConfigLocation;
import com.intellij.workspaceModel.ide.NonPersistentEntitySource;
import com.intellij.workspaceModel.ide.impl.jps.serialization.CachingJpsFileContentReader;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ExternalModuleListSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsArtifactsDirectorySerializerFactory;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsArtifactsFileSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsDirectoryEntitiesSerializerFactory;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsExternalStorageMapping;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsExternalStorageMappingImpl;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentReader;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsLibrariesDirectorySerializerFactory;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsLibrariesExternalFileSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsLibrariesFileSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectSerializers;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ModuleImlFileEntitiesSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ModuleListSerializerImpl;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.VirtualFileUrl;
import com.intellij.workspaceModel.storage.VirtualFileUrlKt;
import com.intellij.workspaceModel.storage.VirtualFileUrlManager;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J0\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u001dJ0\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\"\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0002J5\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0005\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b-J&\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010.\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006/"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsProjectEntitiesLoader;", "", "()V", "createDirectoryProjectSerializers", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsProjectSerializers;", "configLocation", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation$DirectoryBased;", "reader", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentReader;", "externalStorageMapping", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsExternalStorageMapping;", "serializeArtifacts", "", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/VirtualFileUrlManager;", "createEntitySourceForModule", "Lcom/intellij/workspaceModel/storage/EntitySource;", "project", "Lcom/intellij/openapi/project/Project;", "baseModuleDir", "Lcom/intellij/workspaceModel/storage/VirtualFileUrl;", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "createEntitySourceForProjectLibrary", "createIprProjectSerializers", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation$FileBased;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsExternalStorageMappingImpl;", "createJpsEntitySourceForProjectLibrary", "Lcom/intellij/workspaceModel/ide/JpsFileEntitySource;", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation;", "createProjectEntitiesSerializers", "externalStoragePath", "Ljava/nio/file/Path;", "createProjectSerializers", "isExternalStorageEnabled", "projectDirUrl", "", "loadModule", "", "moduleFile", "Ljava/io/File;", "source", "Lcom/intellij/workspaceModel/ide/JpsFileEntitySource$FileInDirectory;", "builder", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "loadModule$intellij_platform_workspaceModel_ide", "loadProject", "intellij.platform.workspaceModel.ide"})
public final class JpsProjectEntitiesLoader {
    public static final JpsProjectEntitiesLoader INSTANCE;

    @NotNull
    public final JpsProjectSerializers createProjectSerializers(@NotNull JpsProjectConfigLocation configLocation, @NotNull JpsFileContentReader reader, @NotNull Path externalStoragePath, boolean serializeArtifacts, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkParameterIsNotNull((Object)configLocation, (String)"configLocation");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull((Object)externalStoragePath, (String)"externalStoragePath");
        Intrinsics.checkParameterIsNotNull((Object)virtualFileManager, (String)"virtualFileManager");
        return this.createProjectEntitiesSerializers(configLocation, reader, externalStoragePath, serializeArtifacts, virtualFileManager);
    }

    @NotNull
    public final JpsProjectSerializers loadProject(@NotNull JpsProjectConfigLocation configLocation, @NotNull WorkspaceEntityStorageBuilder builder2, @NotNull Path externalStoragePath, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkParameterIsNotNull((Object)configLocation, (String)"configLocation");
        Intrinsics.checkParameterIsNotNull((Object)builder2, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)externalStoragePath, (String)"externalStoragePath");
        Intrinsics.checkParameterIsNotNull((Object)virtualFileManager, (String)"virtualFileManager");
        CachingJpsFileContentReader reader = new CachingJpsFileContentReader(configLocation.getBaseDirectoryUrlString());
        JpsProjectSerializers data2 = this.createProjectEntitiesSerializers(configLocation, reader, externalStoragePath, true, virtualFileManager);
        data2.loadAll(reader, builder2);
        return data2;
    }

    public final void loadModule(@NotNull File moduleFile, @NotNull JpsProjectConfigLocation configLocation, @NotNull WorkspaceEntityStorageBuilder builder2, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkParameterIsNotNull((Object)moduleFile, (String)"moduleFile");
        Intrinsics.checkParameterIsNotNull((Object)configLocation, (String)"configLocation");
        Intrinsics.checkParameterIsNotNull((Object)builder2, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)virtualFileManager, (String)"virtualFileManager");
        File file2 = moduleFile.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"moduleFile.parentFile");
        JpsFileEntitySource.FileInDirectory source = new JpsFileEntitySource.FileInDirectory(VirtualFileUrlKt.toVirtualFileUrl(file2, virtualFileManager), configLocation);
        this.loadModule$intellij_platform_workspaceModel_ide(moduleFile, source, configLocation, builder2, virtualFileManager);
    }

    public final void loadModule$intellij_platform_workspaceModel_ide(@NotNull File moduleFile, @NotNull JpsFileEntitySource.FileInDirectory source, @NotNull JpsProjectConfigLocation configLocation, @NotNull WorkspaceEntityStorageBuilder builder2, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkParameterIsNotNull((Object)moduleFile, (String)"moduleFile");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)configLocation, (String)"configLocation");
        Intrinsics.checkParameterIsNotNull((Object)builder2, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)virtualFileManager, (String)"virtualFileManager");
        CachingJpsFileContentReader reader = new CachingJpsFileContentReader(configLocation.getBaseDirectoryUrlString());
        ModuleImlFileEntitiesSerializer serializer = ModuleListSerializerImpl.Companion.createModuleEntitiesSerializer$intellij_platform_workspaceModel_ide(VirtualFileUrlKt.toVirtualFileUrl(moduleFile, virtualFileManager), source, null);
        serializer.loadEntities(builder2, reader, virtualFileManager);
    }

    private final JpsProjectSerializers createProjectEntitiesSerializers(JpsProjectConfigLocation configLocation, JpsFileContentReader reader, Path externalStoragePath, boolean serializeArtifacts, VirtualFileUrlManager virtualFileManager) {
        JpsProjectSerializers jpsProjectSerializers;
        VirtualFileUrl externalStorageRoot = VirtualFileUrlKt.toVirtualFileUrl(externalStoragePath, virtualFileManager);
        JpsExternalStorageMappingImpl externalStorageMapping = new JpsExternalStorageMappingImpl(externalStorageRoot, configLocation);
        JpsProjectConfigLocation jpsProjectConfigLocation = configLocation;
        if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.FileBased) {
            jpsProjectSerializers = this.createIprProjectSerializers((JpsProjectConfigLocation.FileBased)configLocation, reader, externalStorageMapping, serializeArtifacts, virtualFileManager);
        } else if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.DirectoryBased) {
            jpsProjectSerializers = this.createDirectoryProjectSerializers((JpsProjectConfigLocation.DirectoryBased)configLocation, reader, externalStorageMapping, serializeArtifacts, virtualFileManager);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jpsProjectSerializers;
    }

    private final JpsProjectSerializers createDirectoryProjectSerializers(JpsProjectConfigLocation.DirectoryBased configLocation, JpsFileContentReader reader, JpsExternalStorageMapping externalStorageMapping, boolean serializeArtifacts, VirtualFileUrlManager virtualFileManager) {
        String projectDirUrl = configLocation.getProjectDir().getUrl();
        ArrayList directorySerializersFactories = new ArrayList();
        String librariesDirectoryUrl = projectDirUrl + "/.idea/libraries";
        Collection collection = directorySerializersFactories;
        JpsDirectoryEntitiesSerializerFactory<LibraryEntity> jpsDirectoryEntitiesSerializerFactory = new JpsLibrariesDirectorySerializerFactory(librariesDirectoryUrl);
        boolean bl = false;
        collection.add(jpsDirectoryEntitiesSerializerFactory);
        if (serializeArtifacts) {
            collection = directorySerializersFactories;
            jpsDirectoryEntitiesSerializerFactory = new JpsArtifactsDirectorySerializerFactory(projectDirUrl + "/.idea/artifacts");
            bl = false;
            collection.add(jpsDirectoryEntitiesSerializerFactory);
        }
        VirtualFileUrl externalStorageRoot = externalStorageMapping.getExternalStorageRoot();
        VirtualFileUrl internalLibrariesDirUrl = virtualFileManager.fromUrl(librariesDirectoryUrl);
        boolean externalStorageEnabled = this.isExternalStorageEnabled(reader, projectDirUrl);
        JpsFileEntitySource.ExactFile librariesExternalStorageFile = new JpsFileEntitySource.ExactFile(VirtualFileUrlKt.append(externalStorageRoot, "project/libraries.xml"), configLocation);
        ExternalModuleListSerializer externalModuleListSerializer = new ExternalModuleListSerializer(externalStorageRoot);
        return JpsProjectSerializers.Companion.createSerializers(CollectionsKt.listOf((Object)new JpsLibrariesExternalFileSerializer(librariesExternalStorageFile, internalLibrariesDirUrl)), directorySerializersFactories, CollectionsKt.listOf((Object[])new ModuleListSerializerImpl[]{new ModuleListSerializerImpl(projectDirUrl + "/.idea/modules.xml", externalModuleListSerializer), externalModuleListSerializer}), configLocation, reader, externalStorageMapping, externalStorageEnabled, virtualFileManager);
    }

    private final boolean isExternalStorageEnabled(JpsFileContentReader reader, String projectDirUrl) {
        Element component2;
        Element element2 = component2 = JpsFileContentReader.DefaultImpls.loadComponent$default(reader, projectDirUrl + "/.idea/misc.xml", "ExternalStorageConfigurationManager", null, 4, null);
        return Intrinsics.areEqual((Object)(element2 != null ? element2.getAttributeValue("enabled") : null), (Object)"true");
    }

    private final JpsProjectSerializers createIprProjectSerializers(JpsProjectConfigLocation.FileBased configLocation, JpsFileContentReader reader, JpsExternalStorageMappingImpl externalStorageMapping, boolean serializeArtifacts, VirtualFileUrlManager virtualFileManager) {
        JpsFileEntitySource.ExactFile projectFileSource = new JpsFileEntitySource.ExactFile(configLocation.getIprFile(), configLocation);
        VirtualFileUrl projectFileUrl = projectFileSource.getFile();
        ArrayList entityTypeSerializers = new ArrayList();
        Collection collection = entityTypeSerializers;
        Object object = new JpsLibrariesFileSerializer(projectFileSource, LibraryTableId.ProjectLibraryTableId.INSTANCE);
        boolean bl = false;
        collection.add(object);
        if (serializeArtifacts) {
            collection = entityTypeSerializers;
            object = new JpsArtifactsFileSerializer(projectFileUrl, projectFileSource, virtualFileManager);
            bl = false;
            collection.add(object);
        }
        boolean bl2 = false;
        object = externalStorageMapping;
        VirtualFileUrlManager virtualFileUrlManager = virtualFileManager;
        return JpsProjectSerializers.Companion.createSerializers(entityTypeSerializers, CollectionsKt.emptyList(), CollectionsKt.listOf((Object)new ModuleListSerializerImpl(projectFileUrl.getUrl(), null)), configLocation, reader, (JpsExternalStorageMapping)object, bl2, virtualFileUrlManager);
    }

    @NotNull
    public final EntitySource createEntitySourceForModule(@NotNull Project project, @NotNull VirtualFileUrl baseModuleDir, @Nullable ProjectModelExternalSource externalSource) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)baseModuleDir, (String)"baseModuleDir");
        JpsProjectConfigLocation jpsProjectConfigLocation = JpsEntitySourcesKt.getConfigLocation(project);
        if (jpsProjectConfigLocation == null) {
            return NonPersistentEntitySource.INSTANCE;
        }
        JpsProjectConfigLocation location = jpsProjectConfigLocation;
        JpsFileEntitySource.FileInDirectory internalFile = new JpsFileEntitySource.FileInDirectory(baseModuleDir, location);
        if (externalSource == null) {
            return internalFile;
        }
        JpsFileEntitySource jpsFileEntitySource = internalFile;
        String string = externalSource.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"externalSource.id");
        return new JpsImportedEntitySource(jpsFileEntitySource, string, ProjectUtilCore.isExternalStorageEnabled((Project)project));
    }

    @NotNull
    public final EntitySource createEntitySourceForProjectLibrary(@NotNull Project project, @Nullable ProjectModelExternalSource externalSource) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        JpsProjectConfigLocation jpsProjectConfigLocation = JpsEntitySourcesKt.getConfigLocation(project);
        if (jpsProjectConfigLocation == null) {
            return NonPersistentEntitySource.INSTANCE;
        }
        JpsProjectConfigLocation location = jpsProjectConfigLocation;
        JpsFileEntitySource internalFile = this.createJpsEntitySourceForProjectLibrary(location);
        if (externalSource == null) {
            return internalFile;
        }
        String string = externalSource.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"externalSource.id");
        return new JpsImportedEntitySource(internalFile, string, ProjectUtilCore.isExternalStorageEnabled((Project)project));
    }

    @NotNull
    public final JpsFileEntitySource createJpsEntitySourceForProjectLibrary(@NotNull JpsProjectConfigLocation configLocation) {
        JpsFileEntitySource jpsFileEntitySource;
        Intrinsics.checkParameterIsNotNull((Object)configLocation, (String)"configLocation");
        JpsProjectConfigLocation jpsProjectConfigLocation = configLocation;
        if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.DirectoryBased) {
            jpsFileEntitySource = new JpsFileEntitySource.FileInDirectory(VirtualFileUrlKt.append(((JpsProjectConfigLocation.DirectoryBased)configLocation).getProjectDir(), ".idea/libraries"), configLocation);
        } else if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.FileBased) {
            jpsFileEntitySource = new JpsFileEntitySource.ExactFile(((JpsProjectConfigLocation.FileBased)configLocation).getIprFile(), configLocation);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jpsFileEntitySource;
    }

    private JpsProjectEntitiesLoader() {
    }

    static {
        JpsProjectEntitiesLoader jpsProjectEntitiesLoader;
        INSTANCE = jpsProjectEntitiesLoader = new JpsProjectEntitiesLoader();
    }
}

