/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.workspaceModel.storage.VirtualFileUrl;
import com.intellij.workspaceModel.storage.VirtualFileUrlManager;
import com.intellij.workspaceModel.storage.impl.IntIdGenerator;
import com.intellij.workspaceModel.storage.impl.VirtualFileNameStore;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0016\u0010\u0011\u001a\b\u0018\u00010\tR\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0012\u001a\b\u0018\u00010\tR\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0012\u001a\b\u0018\u00010\tR\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0014H\u0016J\u0006\u0010 \u001a\u00020\u000fJ\u0015\u0010!\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001d\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b*R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/workspaceModel/storage/impl/VirtualFileUrlManagerImpl;", "Lcom/intellij/workspaceModel/storage/VirtualFileUrlManager;", "()V", "EMPTY_URL", "Lcom/intellij/workspaceModel/storage/VirtualFileUrl;", "fileNameStore", "Lcom/intellij/workspaceModel/storage/impl/VirtualFileNameStore;", "id2NodeMapping", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lcom/intellij/workspaceModel/storage/impl/VirtualFileUrlManagerImpl$FilePathNode;", "idGenerator", "Lcom/intellij/workspaceModel/storage/impl/IntIdGenerator;", "rootNode", "add", "path", "", "add$intellij_platform_workspaceModel_storage", "findLatestFilePathNode", "findRootNode", "contentId", "", "segment", "fromPath", "fromUrl", "url", "getParentVirtualUrlById", "id", "getUrlById", "isEqualOrParentOf", "", "parentNodeId", "childNodeId", "print", "remove", "", "remove$intellij_platform_workspaceModel_storage", "removeNameUsage", "splitNames", "", "update", "oldPath", "newPath", "update$intellij_platform_workspaceModel_storage", "FilePathNode", "intellij.platform.workspaceModel.storage"})
public final class VirtualFileUrlManagerImpl
implements VirtualFileUrlManager {
    private final IntIdGenerator idGenerator = new IntIdGenerator();
    private final VirtualFileUrl EMPTY_URL = new VirtualFileUrl(0, this);
    private final VirtualFileNameStore fileNameStore = new VirtualFileNameStore();
    private final Int2ObjectOpenHashMap<FilePathNode> id2NodeMapping = new Int2ObjectOpenHashMap();
    private final FilePathNode rootNode = new FilePathNode(this, 0, 0, null, 4, null);

    @Override
    @NotNull
    public synchronized VirtualFileUrl fromUrl(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        CharSequence charSequence = url;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return this.EMPTY_URL;
        }
        return this.add$intellij_platform_workspaceModel_storage(url);
    }

    @Override
    @NotNull
    public VirtualFileUrl fromPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.fromUrl("file://" + FileUtil.toSystemIndependentName((String)path));
    }

    @Override
    @Nullable
    public synchronized VirtualFileUrl getParentVirtualUrlById(int id2) {
        VirtualFileUrl virtualFileUrl;
        FilePathNode filePathNode = (FilePathNode)this.id2NodeMapping.get(id2);
        if (filePathNode != null && (filePathNode = filePathNode.getParent()) != null) {
            FilePathNode filePathNode2 = filePathNode;
            boolean bl = false;
            boolean bl2 = false;
            FilePathNode it = filePathNode2;
            boolean bl3 = false;
            virtualFileUrl = new VirtualFileUrl(it.getNodeId(), this);
        } else {
            virtualFileUrl = null;
        }
        return virtualFileUrl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public synchronized String getUrlById(int id2) {
        IntArrayList contentIds;
        block7: {
            String string;
            block9: {
                block8: {
                    if (id2 <= 0) {
                        return "";
                    }
                    contentIds = new IntArrayList();
                    for (FilePathNode node = (FilePathNode)this.id2NodeMapping.get(id2); node != null; node = node.getParent()) {
                        contentIds.add(node.getContentId());
                    }
                    if (contentIds.size() != 1) break block7;
                    string = this.fileNameStore.getNameForId(contentIds.getInt(0));
                    if (string == null) break block8;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    CharSequence charSequence = it;
                    boolean bl4 = false;
                    string = charSequence.length() == 0 ? "/" : it;
                    if (string != null) break block9;
                }
                string = "";
            }
            return string;
        }
        StringBuilder builder2 = new StringBuilder();
        int n = contentIds.size() - 1;
        boolean bl = false;
        while (n >= 0) {
            void index;
            builder2.append(this.fileNameStore.getNameForId(contentIds.getInt((int)index)));
            if (index != false) {
                builder2.append("/");
            }
            --index;
        }
        String string = builder2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final VirtualFileUrl add$intellij_platform_workspaceModel_storage(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        List<String> segments = this.splitNames(path);
        FilePathNode latestNode = this.findRootNode((String)CollectionsKt.first(segments));
        int latestElement = segments.size() - 1;
        int n = 0;
        int n2 = ((Collection)segments).size();
        while (n < n2) {
            void index;
            int nameId = this.fileNameStore.generateIdForName(segments.get((int)index));
            if (latestNode == null) {
                int nodeId = this.idGenerator.generateId();
                FilePathNode newNode = new FilePathNode(this, nodeId, nameId, null, 4, null);
                ((Map)this.id2NodeMapping).put(nodeId, newNode);
                if (index == latestElement) {
                    this.rootNode.addChild(newNode);
                    return new VirtualFileUrl(nodeId, this);
                }
                latestNode = newNode;
                this.rootNode.addChild(newNode);
            } else if (latestNode == this.findRootNode(latestNode.getContentId()) && latestNode.getContentId() == nameId) {
                if (index == latestElement) {
                    return new VirtualFileUrl(latestNode.getNodeId(), this);
                }
            } else {
                FilePathNode node = latestNode.findChild(nameId);
                if (node == null) {
                    int nodeId = this.idGenerator.generateId();
                    FilePathNode newNode = new FilePathNode(this, nodeId, nameId, latestNode);
                    ((Map)this.id2NodeMapping).put(nodeId, newNode);
                    latestNode.addChild(newNode);
                    latestNode = newNode;
                    if (index == latestElement) {
                        return new VirtualFileUrl(nodeId, this);
                    }
                } else {
                    if (index == latestElement) {
                        return new VirtualFileUrl(node.getNodeId(), this);
                    }
                    latestNode = node;
                }
            }
            ++index;
        }
        return this.EMPTY_URL;
    }

    public final void remove$intellij_platform_workspaceModel_storage(@NotNull String path) {
        FilePathNode parent;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        FilePathNode node = this.findLatestFilePathNode(path);
        if (node == null) {
            String string = "File not found";
            boolean bl = false;
            System.out.println((Object)string);
            return;
        }
        if (!node.isEmpty()) {
            return;
        }
        FilePathNode currentNode = node;
        do {
            if ((parent = currentNode.getParent()) == null) {
                if (currentNode == this.findRootNode(currentNode.getContentId()) && currentNode.isEmpty()) {
                    this.removeNameUsage(currentNode.getContentId());
                    this.id2NodeMapping.remove(currentNode.getNodeId());
                    this.rootNode.removeChild(currentNode);
                }
                return;
            }
            parent.removeChild(currentNode);
            this.removeNameUsage(currentNode.getContentId());
            this.id2NodeMapping.remove(currentNode.getNodeId());
        } while ((currentNode = parent).isEmpty());
    }

    public final void update$intellij_platform_workspaceModel_storage(@NotNull String oldPath, @NotNull String newPath) {
        Intrinsics.checkParameterIsNotNull((Object)oldPath, (String)"oldPath");
        Intrinsics.checkParameterIsNotNull((Object)newPath, (String)"newPath");
        FilePathNode latestPathNode = this.findLatestFilePathNode(oldPath);
        if (latestPathNode == null) {
            return;
        }
        this.remove$intellij_platform_workspaceModel_storage(oldPath);
        this.add$intellij_platform_workspaceModel_storage(newPath);
    }

    private final void removeNameUsage(int contentId) {
        String name = this.fileNameStore.getNameForId(contentId);
        boolean bl = name != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String string = name;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.fileNameStore.removeName(string);
    }

    /*
     * WARNING - void declaration
     */
    private final FilePathNode findLatestFilePathNode(String path) {
        List<String> segments = this.splitNames(path);
        FilePathNode latestNode = this.findRootNode((String)CollectionsKt.first(segments));
        int latestElement = segments.size() - 1;
        int n = 0;
        int n2 = ((Collection)segments).size();
        while (n < n2) {
            void index;
            Integer n3 = this.fileNameStore.getIdForName(segments.get((int)index));
            if (n3 == null) {
                return null;
            }
            int nameId = n3;
            if (latestNode == null) {
                return null;
            }
            if (latestNode == this.findRootNode(latestNode.getContentId()) && latestNode.getContentId() == nameId) {
                if (index == latestElement) {
                    return latestNode;
                }
            } else if (latestNode.findChild(nameId) != null) {
                FilePathNode filePathNode;
                boolean bl = false;
                boolean bl2 = false;
                FilePathNode it = filePathNode;
                boolean bl3 = false;
                if (index == latestElement) {
                    return it;
                }
                latestNode = it;
            } else {
                return null;
            }
            ++index;
        }
        return null;
    }

    private final FilePathNode findRootNode(String segment) {
        Integer n = this.fileNameStore.getIdForName(segment);
        if (n == null) {
            return null;
        }
        int segmentId = n;
        return this.rootNode.findChild(segmentId);
    }

    private final FilePathNode findRootNode(int contentId) {
        return this.rootNode.findChild(contentId);
    }

    private final List<String> splitNames(String path) {
        return StringsKt.split$default((CharSequence)path, (char[])new char[]{'/', '\\'}, (boolean)false, (int)0, (int)6, null);
    }

    @NotNull
    public final String print() {
        return this.rootNode.print();
    }

    @Override
    public boolean isEqualOrParentOf(int parentNodeId, int childNodeId) {
        if (parentNodeId == 0 && childNodeId == 0) {
            return true;
        }
        int current2 = childNodeId;
        while (current2 > 0) {
            if (parentNodeId == current2) {
                return true;
            }
            FilePathNode filePathNode = (FilePathNode)this.id2NodeMapping.get(current2);
            if (filePathNode == null || (filePathNode = filePathNode.getParent()) == null) {
                return false;
            }
            current2 = filePathNode.getNodeId();
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0018\u00010\u0000R\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0000R\u00020\u0006J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0014\u0010\u0013\u001a\b\u0018\u00010\u0000R\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J$\u0010\u0017\u001a\u00020\u00102\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J\u0012\u0010\u001e\u001a\u00020\u00102\n\u0010\u001f\u001a\u00060\u0000R\u00020\u0006R\u001a\u0010\b\u001a\u000e\u0012\b\u0012\u00060\u0000R\u00020\u0006\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0018\u00010\u0000R\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/intellij/workspaceModel/storage/impl/VirtualFileUrlManagerImpl$FilePathNode;", "", "nodeId", "", "contentId", "parent", "Lcom/intellij/workspaceModel/storage/impl/VirtualFileUrlManagerImpl;", "(Lcom/intellij/workspaceModel/storage/impl/VirtualFileUrlManagerImpl;IILcom/intellij/workspaceModel/storage/impl/VirtualFileUrlManagerImpl$FilePathNode;)V", "children", "", "getContentId", "()I", "getNodeId", "getParent", "()Lcom/intellij/workspaceModel/storage/impl/VirtualFileUrlManagerImpl$FilePathNode;", "addChild", "", "newNode", "createChildrenList", "findChild", "nameId", "isEmpty", "", "print", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "prefix", "childrenPrefix", "removeChild", "node", "intellij.platform.workspaceModel.storage"})
    private final class FilePathNode {
        private List<FilePathNode> children;
        private final int nodeId;
        private final int contentId;
        @Nullable
        private final FilePathNode parent;
        final /* synthetic */ VirtualFileUrlManagerImpl this$0;

        @Nullable
        public final FilePathNode findChild(int nameId) {
            FilePathNode filePathNode;
            List<FilePathNode> list2 = this.children;
            if (list2 != null) {
                Object v1;
                block3: {
                    Iterable iterable = list2;
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object t : iterable2) {
                        FilePathNode it = (FilePathNode)t;
                        boolean bl3 = false;
                        if (!(it.contentId == nameId)) continue;
                        v1 = t;
                        break block3;
                    }
                    v1 = null;
                }
                filePathNode = v1;
            } else {
                filePathNode = null;
            }
            return filePathNode;
        }

        public final void addChild(@NotNull FilePathNode newNode) {
            Intrinsics.checkParameterIsNotNull((Object)newNode, (String)"newNode");
            this.createChildrenList();
            List<FilePathNode> list2 = this.children;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            list2.add(newNode);
        }

        public final void removeChild(@NotNull FilePathNode node) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                List<FilePathNode> list2 = this.children;
                if (list2 == null) break block0;
                list2.remove(node);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isEmpty() {
            if (this.children == null) return true;
            List<FilePathNode> list2 = this.children;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            if (!list2.isEmpty()) return false;
            return true;
        }

        private final void createChildrenList() {
            if (this.children == null) {
                this.children = (List)new SmartList();
            }
        }

        @NotNull
        public final String print() {
            StringBuilder buffer = new StringBuilder();
            this.print(buffer, "", "");
            String string = buffer.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
            return string;
        }

        private final void print(StringBuilder buffer, String prefix, String childrenPrefix) {
            Object object;
            String name = this.this$0.fileNameStore.getNameForId(this.contentId);
            if (name != null) {
                buffer.append(prefix + ' ' + name + '\n');
            }
            if ((object = this.children) == null || (object = object.iterator()) == null) {
                return;
            }
            Object iterator2 = object;
            while (iterator2.hasNext()) {
                FilePathNode next = (FilePathNode)iterator2.next();
                if (name == null) {
                    next.print(buffer, childrenPrefix, childrenPrefix);
                    continue;
                }
                if (iterator2.hasNext()) {
                    next.print(buffer, childrenPrefix + " |- ", childrenPrefix + " |   ");
                    continue;
                }
                next.print(buffer, childrenPrefix + " '- ", childrenPrefix + "     ");
            }
        }

        public final int getNodeId() {
            return this.nodeId;
        }

        public final int getContentId() {
            return this.contentId;
        }

        @Nullable
        public final FilePathNode getParent() {
            return this.parent;
        }

        public FilePathNode(VirtualFileUrlManagerImpl $outer, int nodeId, @Nullable int contentId, FilePathNode parent) {
            this.this$0 = $outer;
            this.nodeId = nodeId;
            this.contentId = contentId;
            this.parent = parent;
        }

        public /* synthetic */ FilePathNode(VirtualFileUrlManagerImpl virtualFileUrlManagerImpl, int n, int n2, FilePathNode filePathNode, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                filePathNode = null;
            }
            this(virtualFileUrlManagerImpl, n, n2, filePathNode);
        }
    }
}

