/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageTreeNode
extends XDebuggerTreeNode {
    private final boolean myEllipsis;
    private XDebuggerTreeNodeHyperlink myLink;

    private MessageTreeNode(XDebuggerTree tree, @Nullable XDebuggerTreeNode parent, String message, SimpleTextAttributes attributes, @Nullable Icon icon2) {
        this(tree, parent, message, attributes, icon2, null);
    }

    private MessageTreeNode(XDebuggerTree tree, XDebuggerTreeNode parent, String message, SimpleTextAttributes attributes, @Nullable Icon icon2, XDebuggerTreeNodeHyperlink link) {
        this(tree, parent, message, attributes, icon2, false, link);
    }

    private MessageTreeNode(XDebuggerTree tree, XDebuggerTreeNode parent, String message, SimpleTextAttributes attributes, @Nullable Icon icon2, boolean ellipsis, XDebuggerTreeNodeHyperlink link) {
        super(tree, parent, true);
        this.myEllipsis = ellipsis;
        this.myLink = link;
        this.setIcon(icon2);
        this.myText.append(message, attributes);
    }

    protected MessageTreeNode(XDebuggerTree tree, @Nullable XDebuggerTreeNode parent, boolean leaf) {
        super(tree, parent, leaf);
        this.myEllipsis = false;
    }

    @Override
    @NotNull
    public List<? extends TreeNode> getChildren() {
        List list2 = Collections.emptyList();
        if (list2 == null) {
            MessageTreeNode.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public boolean isEllipsis() {
        return this.myEllipsis;
    }

    @Override
    @Nullable
    public XDebuggerTreeNodeHyperlink getLink() {
        return this.myLink;
    }

    @Override
    @NotNull
    public List<? extends XDebuggerTreeNode> getLoadedChildren() {
        List list2 = Collections.emptyList();
        if (list2 == null) {
            MessageTreeNode.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    public void clearChildren() {
    }

    public static MessageTreeNode createEllipsisNode(XDebuggerTree tree, XDebuggerTreeNode parent, int remaining) {
        String message = remaining == -1 ? XDebuggerBundle.message((String)"node.text.ellipsis.0.unknown.more.nodes.double.click.to.show", (Object[])new Object[0]) : XDebuggerBundle.message((String)"node.text.ellipsis.0.more.nodes.double.click.to.show", (Object[])new Object[]{remaining});
        return new MessageTreeNode(tree, parent, message, SimpleTextAttributes.GRAYED_ATTRIBUTES, null, true, null);
    }

    public static MessageTreeNode createMessageNode(XDebuggerTree tree, XDebuggerTreeNode parent, String message, @Nullable Icon icon2) {
        return new MessageTreeNode(tree, parent, message, SimpleTextAttributes.REGULAR_ATTRIBUTES, icon2);
    }

    public static MessageTreeNode createLoadingMessage(XDebuggerTree tree, XDebuggerTreeNode parent) {
        return new MessageTreeNode(tree, parent, XDebuggerUIConstants.getCollectingDataMessage(), XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES, null);
    }

    public static MessageTreeNode createEvaluatingMessage(XDebuggerTree tree, @Nullable XDebuggerTreeNode parent) {
        return new MessageTreeNode(tree, parent, XDebuggerUIConstants.getEvaluatingExpressionMessage(), XDebuggerUIConstants.EVALUATING_EXPRESSION_HIGHLIGHT_ATTRIBUTES, null);
    }

    public static List<MessageTreeNode> createMessages(XDebuggerTree tree, XDebuggerTreeNode parent, @NotNull String errorMessage, XDebuggerTreeNodeHyperlink link, Icon icon2, SimpleTextAttributes attributes) {
        if (errorMessage == null) {
            MessageTreeNode.$$$reportNull$$$0(2);
        }
        SmartList messages = new SmartList();
        List lines = StringUtil.split((String)errorMessage, (String)"\n", (boolean)true, (boolean)false);
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            messages.add(new MessageTreeNode(tree, parent, (String)lines.get(i2), attributes, icon2, (XDebuggerTreeNodeHyperlink)(i2 == lines.size() - 1 ? link : null)));
        }
        return messages;
    }

    public static MessageTreeNode createInfoMessage(XDebuggerTree tree, @NotNull String message) {
        if (message == null) {
            MessageTreeNode.$$$reportNull$$$0(3);
        }
        return MessageTreeNode.createInfoMessage(tree, message, null);
    }

    public static MessageTreeNode createInfoMessage(XDebuggerTree tree, @NotNull String message, @Nullable HyperlinkListener hyperlinkListener) {
        if (message == null) {
            MessageTreeNode.$$$reportNull$$$0(4);
        }
        Matcher matcher = MessageTreeNodeWithLinks.HREF_PATTERN.matcher(message);
        if (hyperlinkListener == null || !matcher.find()) {
            return new MessageTreeNode(tree, null, message, SimpleTextAttributes.REGULAR_ATTRIBUTES, XDebuggerUIConstants.INFORMATION_MESSAGE_ICON);
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        int prev = 0;
        do {
            if (matcher.start() != prev) {
                objects.add(message.substring(prev, matcher.start()));
            }
            objects.add((Object)new HyperlinkListenerDelegator(matcher.group(2), matcher.group(1), hyperlinkListener));
            prev = matcher.end();
        } while (matcher.find());
        if (prev < message.length()) {
            objects.add(message.substring(prev));
        }
        return new MessageTreeNodeWithLinks(tree, objects);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/nodes/MessageTreeNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedChildren";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/MessageTreeNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createMessages";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInfoMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class HyperlinkListenerDelegator
    extends XDebuggerTreeNodeHyperlink {
        private final HyperlinkListener hyperlinkListener;
        private final String href;

        public HyperlinkListenerDelegator(@NotNull String linkText, @Nullable String href, @NotNull HyperlinkListener hyperlinkListener) {
            if (linkText == null) {
                HyperlinkListenerDelegator.$$$reportNull$$$0(0);
            }
            if (hyperlinkListener == null) {
                HyperlinkListenerDelegator.$$$reportNull$$$0(1);
            }
            super(linkText);
            this.hyperlinkListener = hyperlinkListener;
            this.href = href;
        }

        public void onClick(MouseEvent event) {
            this.hyperlinkListener.hyperlinkUpdate(IJSwingUtilities.createHyperlinkEvent(this.href, this.getLinkText()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "linkText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "hyperlinkListener";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/MessageTreeNode$HyperlinkListenerDelegator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MessageTreeNodeWithLinks
    extends MessageTreeNode {
        private static final Pattern HREF_PATTERN = Pattern.compile("<a(?:\\s+href\\s*=\\s*[\"']([^\"']*)[\"'])?\\s*>([^<]*)</a>");
        private final List<Object> objects;

        private MessageTreeNodeWithLinks(XDebuggerTree tree, List<Object> objects) {
            super(tree, null, true);
            this.setIcon(XDebuggerUIConstants.INFORMATION_MESSAGE_ICON);
            this.objects = objects;
        }

        @Override
        public void appendToComponent(@NotNull ColoredTextContainer component2) {
            if (component2 == null) {
                MessageTreeNodeWithLinks.$$$reportNull$$$0(0);
            }
            for (Object object : this.objects) {
                if (object instanceof String) {
                    component2.append((String)object, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    continue;
                }
                XDebuggerTreeNodeHyperlink hyperlink = (XDebuggerTreeNodeHyperlink)object;
                component2.append(hyperlink.getLinkText(), SimpleTextAttributes.LINK_ATTRIBUTES, (Object)hyperlink);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/xdebugger/impl/ui/tree/nodes/MessageTreeNode$MessageTreeNodeWithLinks", "appendToComponent"));
        }
    }
}

