/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.ecmascript;

import com.intellij.lang.Language;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import java.util.EnumSet;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.RegExpLexer;
import org.intellij.lang.regexp.RegExpParser;
import org.intellij.lang.regexp.RegExpParserDefinition;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.ecmascript.EcmaScriptRegexpLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EcmaScriptRegexpParserDefinition
extends RegExpParserDefinition {
    public static final IFileElementType JS_REGEXP_FILE = new IFileElementType("JS_REGEXP_FILE", (Language)EcmaScriptRegexpLanguage.INSTANCE);
    private final EnumSet<RegExpCapability> CAPABILITIES = EnumSet.of(RegExpCapability.OCTAL_NO_LEADING_ZERO, RegExpCapability.DANGLING_METACHARACTERS, RegExpCapability.ALLOW_EMPTY_CHARACTER_CLASS, RegExpCapability.PROPERTY_VALUES, RegExpCapability.MAX_OCTAL_377);

    @Override
    @NotNull
    public Lexer createLexer(Project project) {
        return new RegExpLexer(this.CAPABILITIES){

            @Nullable
            public IElementType getTokenType() {
                IElementType baseType = super.getTokenType();
                if (baseType == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN || baseType == StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN) {
                    return RegExpTT.REDUNDANT_ESCAPE;
                }
                if (baseType == RegExpTT.BAD_OCT_VALUE) {
                    return RegExpTT.OCT_CHAR;
                }
                return baseType;
            }
        };
    }

    @Override
    public PsiParser createParser(Project project) {
        return new RegExpParser(this.CAPABILITIES);
    }

    @Override
    public IFileElementType getFileNodeType() {
        return JS_REGEXP_FILE;
    }

    @Override
    public PsiFile createFile(FileViewProvider viewProvider) {
        return new RegExpFile(viewProvider, EcmaScriptRegexpLanguage.INSTANCE);
    }
}

