/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

public abstract class BreakpointTarget {
    public abstract <R> R accept(Visitor<R> var1);

    public abstract String toString();

    public static final class ScriptName
    extends BreakpointTarget {
        @NotNull
        private final String name;
        @Nullable
        private final Script script;

        public ScriptName(@NotNull String name) {
            if (name == null) {
                ScriptName.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.script = null;
        }

        public ScriptName(@NotNull Script script) {
            if (script == null) {
                ScriptName.$$$reportNull$$$0(1);
            }
            this.script = script;
            this.name = script.getUrl().toDecodedForm();
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                ScriptName.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public Script getScript() {
            return this.script;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public <R> R accept(@NotNull Visitor<R> visitor) {
            if (visitor == null) {
                ScriptName.$$$reportNull$$$0(3);
            }
            return visitor.visitScriptName(this.name, this.script);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.name.equals(((ScriptName)o).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "script";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/debugger/BreakpointTarget$ScriptName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/debugger/BreakpointTarget$ScriptName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class ScriptId
    extends BreakpointTarget {
        public final Script script;

        public ScriptId(@NotNull Script script) {
            if (script == null) {
                ScriptId.$$$reportNull$$$0(0);
            }
            this.script = script;
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visitScript(this.script);
        }

        @Override
        public String toString() {
            return this.script.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.script.equals(((ScriptId)o).script);
        }

        public int hashCode() {
            return this.script.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/debugger/BreakpointTarget$ScriptId", "<init>"));
        }
    }

    public static interface Visitor<R> {
        public R visitScriptName(String var1, @Nullable Script var2);

        public R visitScript(Script var1);

        public R visitUnknown(BreakpointTarget var1);
    }
}

