/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0016\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0018\u0010 \u001a\u00020\r2\b\u0010!\u001a\u0004\u0018\u00010\b2\u0006\u0010\"\u001a\u00020\u001eR\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lorg/jetbrains/io/fastCgi/FastCgiRequest;", "", "requestId", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "(ILio/netty/buffer/ByteBufAllocator;)V", "params", "Lio/netty/buffer/ByteBuf;", "kotlin.jvm.PlatformType", "getRequestId", "()I", "addHeader", "", "key", "", "value", "", "writeFileHeaders", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalRequestPath", "writeHeader", "buffer", "type", "length", "writeHeaders", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "clientChannel", "Lio/netty/channel/Channel;", "writeParamLength", "writeToServerChannel", "content", "fastCgiChannel", "intellij.platform.builtInServer.impl"})
public final class FastCgiRequest {
    private final ByteBuf params;
    private final int requestId;

    public final void writeFileHeaders(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalRequestPath) {
        Intrinsics.checkParameterIsNotNull((Object)pathInfo, (String)"pathInfo");
        Intrinsics.checkParameterIsNotNull((Object)canonicalRequestPath, (String)"canonicalRequestPath");
        VirtualFile root = pathInfo.getRoot();
        this.addHeader("DOCUMENT_ROOT", FileUtil.toSystemDependentName((String)root.getPath()));
        this.addHeader("SCRIPT_FILENAME", pathInfo.getFilePath());
        this.addHeader("SCRIPT_NAME", canonicalRequestPath);
    }

    private final void addHeader(String key, CharSequence value2) {
        int n;
        byte[] byArray;
        if (value2 == null) {
            return;
        }
        CharSequence charSequence = value2;
        if (!(charSequence instanceof String)) {
            charSequence = null;
        }
        String string = (String)charSequence;
        if (string != null) {
            String string2 = string;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string3.getBytes(charset);
            byArray = byArray2;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        } else {
            byArray = null;
        }
        byte[] valBytes = byArray;
        ByteBuffer valBuffer = value2 instanceof String ? null : Charsets.UTF_8.encode(CharBuffer.wrap(value2));
        int keyLength = key.length();
        if (valBytes != null) {
            n = valBytes.length;
        } else {
            ByteBuffer byteBuffer = valBuffer;
            if (byteBuffer == null) {
                Intrinsics.throwNpe();
            }
            n = byteBuffer.limit();
        }
        int valLength = n;
        this.writeParamLength(keyLength);
        this.writeParamLength(valLength);
        ByteBufUtil.writeAscii((ByteBuf)this.params, (CharSequence)key);
        if (valBuffer == null) {
            this.params.writeBytes(valBytes);
        } else {
            this.params.writeBytes(valBuffer);
        }
    }

    private final void writeParamLength(int length) {
        if (length > 127) {
            this.params.writeInt(length | (int)0x80000000L);
        } else {
            this.params.writeByte(length);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeHeaders(@NotNull FullHttpRequest request2, @NotNull Channel clientChannel) {
        String string;
        FastCgiRequest fastCgiRequest;
        CharSequence charSequence;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)clientChannel, (String)"clientChannel");
        this.addHeader("REQUEST_URI", request2.uri());
        this.addHeader("REQUEST_METHOD", request2.method().name());
        SocketAddress socketAddress = clientChannel.remoteAddress();
        if (socketAddress == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        InetSocketAddress remote = (InetSocketAddress)socketAddress;
        InetAddress inetAddress = remote.getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"remote.address");
        this.addHeader("REMOTE_ADDR", inetAddress.getHostAddress());
        this.addHeader("REMOTE_PORT", String.valueOf(remote.getPort()));
        SocketAddress socketAddress2 = clientChannel.localAddress();
        if (socketAddress2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        InetSocketAddress local = (InetSocketAddress)socketAddress2;
        InetAddress inetAddress2 = local.getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress2, (String)"local.address");
        this.addHeader("SERVER_ADDR", inetAddress2.getHostAddress());
        this.addHeader("SERVER_PORT", String.valueOf(local.getPort()));
        this.addHeader("GATEWAY_INTERFACE", "CGI/1.1");
        this.addHeader("SERVER_PROTOCOL", request2.protocolVersion().text());
        this.addHeader("REDIRECT_STATUS", "200");
        String queryString = "";
        String string2 = request2.uri();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"request.uri()");
        int queryIndex = StringsKt.indexOf$default((CharSequence)string2, (char)'?', (int)0, (boolean)false, (int)6, null);
        if (queryIndex != -1) {
            String string3 = request2.uri();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"request.uri()");
            object = string3;
            int n = queryIndex + 1;
            boolean bl = false;
            String string4 = object;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            queryString = string5;
            String string6 = request2.uri();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"request.uri()");
            object = string6;
            n = 0;
            charSequence = "DOCUMENT_URI";
            fastCgiRequest = this;
            bl = false;
            String string7 = object;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(n, queryIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string8;
            fastCgiRequest.addHeader((String)charSequence, string);
        } else {
            this.addHeader("DOCUMENT_URI", request2.uri());
        }
        this.addHeader("QUERY_STRING", queryString);
        this.addHeader("CONTENT_LENGTH", String.valueOf(request2.content().readableBytes()));
        String string9 = request2.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        this.addHeader("CONTENT_TYPE", string9 != null ? (CharSequence)string9 : (CharSequence)"");
        Iterator iterator2 = request2.headers().iteratorAsString();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator2, (String)"request.headers().iteratorAsString()");
        Object object2 = iterator2;
        boolean bl = false;
        Iterator iterator3 = object2;
        while (iterator3.hasNext()) {
            Locale locale;
            void key;
            Object object3 = object = (Map.Entry)iterator3.next();
            boolean bl2 = false;
            object2 = (String)object3.getKey();
            object3 = object;
            bl2 = false;
            String value2 = (String)object3.getValue();
            if (StringsKt.equals((String)key, (String)"keep-alive", (boolean)true) || StringsKt.equals((String)key, (String)"connection", (boolean)true)) continue;
            StringBuilder stringBuilder = new StringBuilder().append("HTTP_");
            void v14 = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"key");
            object3 = StringsKt.replace$default((String)v14, (char)'-', (char)'_', (boolean)false, (int)4, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)Locale.ENGLISH, (String)"Locale.ENGLISH");
            charSequence = stringBuilder;
            fastCgiRequest = this;
            boolean bl3 = false;
            Object object4 = object3;
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((String)object4).toUpperCase(locale), (String)"(this as java.lang.String).toUpperCase(locale)");
            fastCgiRequest.addHeader(((StringBuilder)charSequence).append(string).toString(), value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToServerChannel(@Nullable ByteBuf content2, @NotNull Channel fastCgiChannel) {
        Intrinsics.checkParameterIsNotNull((Object)fastCgiChannel, (String)"fastCgiChannel");
        if (fastCgiChannel.pipeline().first() == null) {
            throw (Throwable)new IllegalStateException("No handler in the pipeline");
        }
        try {
            ByteBuf buffer;
            ByteBuf byteBuf = buffer = fastCgiChannel.alloc().ioBuffer(4096);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"buffer");
            this.writeHeader(byteBuf, 1, 8);
            buffer.writeShort(1);
            buffer.writeByte(1);
            buffer.writeZero(5);
            this.writeHeader(buffer, 4, this.params.readableBytes());
            buffer.writeBytes(this.params);
            this.writeHeader(buffer, 4, 0);
            fastCgiChannel.write((Object)buffer);
            if (content2 != null) {
                ByteBuf headerBuffer;
                int position = content2.readerIndex();
                int toWrite = content2.readableBytes();
                while (toWrite > 0) {
                    ByteBuf headerBuffer2;
                    int n = 65535;
                    boolean bl = false;
                    int length = Math.min(n, toWrite);
                    ByteBuf byteBuf2 = headerBuffer2 = fastCgiChannel.alloc().ioBuffer(8, 8);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf2, (String)"headerBuffer");
                    this.writeHeader(byteBuf2, 5, length);
                    fastCgiChannel.write((Object)headerBuffer2);
                    ByteBuf chunk = content2.slice(position, length);
                    chunk.retain();
                    fastCgiChannel.write((Object)chunk);
                    toWrite -= length;
                    position += length;
                }
                ByteBuf byteBuf3 = headerBuffer = fastCgiChannel.alloc().ioBuffer(8, 8);
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf3, (String)"headerBuffer");
                this.writeHeader(byteBuf3, 5, 0);
                fastCgiChannel.write((Object)headerBuffer);
            }
        }
        finally {
            ByteBuf byteBuf = content2;
            if (byteBuf != null) {
                byteBuf.release();
            }
        }
        fastCgiChannel.flush();
    }

    private final void writeHeader(ByteBuf buffer, int type, int length) {
        buffer.writeByte(1);
        buffer.writeByte(type);
        buffer.writeShort(this.requestId);
        buffer.writeShort(length);
        buffer.writeZero(2);
    }

    public final int getRequestId() {
        return this.requestId;
    }

    public FastCgiRequest(int requestId, @NotNull ByteBufAllocator allocator) {
        Intrinsics.checkParameterIsNotNull((Object)allocator, (String)"allocator");
        this.requestId = requestId;
        this.params = allocator.ioBuffer(4096);
    }
}

