/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.intellij.internal.statistic.StatisticsStringUtil;
import com.intellij.internal.statistic.service.fus.EventLogMetadataParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FUStatisticsWhiteListGroupsService {
    @NotNull
    public static WLGroups parseWhiteListContent(@Nullable String content) throws EventLogMetadataParseException {
        block6: {
            if (StatisticsStringUtil.isEmptyOrSpaces((String)content)) {
                throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.EMPTY_CONTENT);
            }
            WLGroups groups = (WLGroups)new GsonBuilder().create().fromJson(content, WLGroups.class);
            if (groups == null) break block6;
            WLGroups wLGroups = groups;
            if (wLGroups == null) {
                FUStatisticsWhiteListGroupsService.$$$reportNull$$$0(0);
            }
            return wLGroups;
        }
        try {
            throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.INVALID_JSON);
        }
        catch (JsonSyntaxException e) {
            throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.INVALID_JSON, (Throwable)e);
        }
        catch (Exception e) {
            throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.UNKNOWN, (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/service/fus/FUStatisticsWhiteListGroupsService", "parseWhiteListContent"));
    }

    public static class WLBuild {
        public String from;
        public String to;
    }

    public static class WLRule {
        @Nullable
        public Set<String> event_id;
        @Nullable
        public Map<String, Set<String>> event_data;
        @Nullable
        public Map<String, Set<String>> enums;
        @Nullable
        public Map<String, String> regexps;
    }

    public static class WLVersion {
        public final String from;
        public final String to;

        public WLVersion(String from, String to) {
            this.from = from;
            this.to = to;
        }
    }

    public static class WLGroup {
        @Nullable
        public String id;
        @Nullable
        public final ArrayList<WLBuild> builds = new ArrayList();
        @Nullable
        public final ArrayList<WLVersion> versions = new ArrayList();
        @Nullable
        public WLRule rules;
    }

    public static class WLGroups {
        @NotNull
        public final ArrayList<WLGroup> groups = new ArrayList();
        @Nullable
        public WLRule rules;
        @Nullable
        public String version;
    }
}

