/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus;

import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.service.fus.StatisticsWhitelistGroupConditions;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatisticsWhitelistConditions {
    private final Map<String, StatisticsWhitelistGroupConditions> myGroups;

    private StatisticsWhitelistConditions(@NotNull Map<String, StatisticsWhitelistGroupConditions> groups) {
        if (groups == null) {
            StatisticsWhitelistConditions.$$$reportNull$$$0(0);
        }
        this.myGroups = groups;
    }

    @NotNull
    public static StatisticsWhitelistConditions create(@NotNull Map<String, StatisticsWhitelistGroupConditions> groups) {
        if (groups == null) {
            StatisticsWhitelistConditions.$$$reportNull$$$0(1);
        }
        return new StatisticsWhitelistConditions(groups);
    }

    @NotNull
    public static StatisticsWhitelistConditions empty() {
        return new StatisticsWhitelistConditions(Collections.emptyMap());
    }

    public boolean accepts(@NotNull String groupId, @Nullable String version, @NotNull String build) {
        if (groupId == null) {
            StatisticsWhitelistConditions.$$$reportNull$$$0(2);
        }
        if (build == null) {
            StatisticsWhitelistConditions.$$$reportNull$$$0(3);
        }
        if (!this.myGroups.containsKey(groupId)) {
            return false;
        }
        int parsedVersion = StatisticsWhitelistConditions.tryToParse(version);
        if (parsedVersion < 0) {
            return false;
        }
        StatisticsWhitelistGroupConditions condition = this.myGroups.get(groupId);
        return condition.accepts(EventLogBuild.fromString((String)build), parsedVersion);
    }

    public int getSize() {
        return this.myGroups.size();
    }

    public boolean isEmpty() {
        return this.myGroups.isEmpty();
    }

    private static int tryToParse(@Nullable String value) {
        try {
            if (value != null) {
                return Integer.parseInt(value.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticsWhitelistConditions whitelist = (StatisticsWhitelistConditions)o;
        return Objects.equals(this.myGroups, whitelist.myGroups);
    }

    public int hashCode() {
        return Objects.hash(this.myGroups);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/service/fus/StatisticsWhitelistConditions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "accepts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

