/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.util.HgUtil;

public class HgInitDialog
extends DialogWrapper {
    private JPanel contentPane;
    private JRadioButton myCreateRepositoryForTheRadioButton;
    private JRadioButton mySelectWhereToCreateRadioButton;
    private TextFieldWithBrowseButton myTextFieldBrowser;
    @Nullable
    private final Project myProject;
    private final boolean myShowDialog;
    private final FileChooserDescriptor myFileDescriptor;
    private VirtualFile mySelectedDir;

    public HgInitDialog(@Nullable Project project) {
        super(project);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myShowDialog = this.myProject != null && !this.myProject.isDefault() && !HgUtil.isHgRoot(this.myProject.getBaseDir());
        this.myFileDescriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public void validateSelectedFiles(VirtualFile @NotNull [] files) throws Exception {
                if (files == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (HgUtil.isHgRoot(files[0])) {
                    throw new ConfigurationException(HgBundle.message("hg4idea.init.this.is.hg.root", files[0].getPresentableUrl()));
                }
                HgInitDialog.this.updateEverything();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/zmlx/hg4idea/ui/HgInitDialog$1", "validateSelectedFiles"));
            }
        };
        this.myFileDescriptor.setHideIgnored(false);
        this.init();
    }

    protected void init() {
        super.init();
        this.setTitle(HgBundle.message("hg4idea.init.dialog.title", new Object[0]));
        if (this.myProject != null && !this.myProject.isDefault()) {
            this.mySelectedDir = this.myProject.getBaseDir();
        }
        this.mySelectWhereToCreateRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HgInitDialog.this.myTextFieldBrowser.setEnabled(true);
                HgInitDialog.this.updateEverything();
            }
        });
        this.myCreateRepositoryForTheRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HgInitDialog.this.myTextFieldBrowser.setEnabled(false);
                HgInitDialog.this.updateEverything();
            }
        });
        this.myTextFieldBrowser.getTextField().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                HgInitDialog.this.updateEverything();
            }
        });
        this.myTextFieldBrowser.addBrowseFolderListener(HgBundle.message("hg4idea.init.destination.directory.title", new Object[0]), HgBundle.message("hg4idea.init.destination.directory.description", new Object[0]), this.myProject, this.myFileDescriptor);
    }

    public void show() {
        if (this.myShowDialog) {
            super.show();
        } else {
            this.mySelectedDir = FileChooser.chooseFile((FileChooserDescriptor)this.myFileDescriptor, (Project)this.myProject, null);
        }
    }

    public boolean isOK() {
        return this.myShowDialog ? super.isOK() : this.mySelectedDir != null;
    }

    protected String getHelpId() {
        return "reference.mercurial.create.mercurial.repository";
    }

    @Nullable
    public VirtualFile getSelectedFolder() {
        return this.mySelectedDir;
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    private void updateEverything() {
        if (this.myShowDialog && this.myCreateRepositoryForTheRadioButton.isSelected()) {
            this.enableOKAction();
            this.mySelectedDir = this.myProject.getBaseDir();
        } else {
            VirtualFile vf = VcsUtil.getVirtualFile((String)this.myTextFieldBrowser.getText());
            if (vf == null) {
                this.disableOKAction();
                this.mySelectedDir = null;
                return;
            }
            vf.refresh(false, false);
            if (vf.exists() && vf.isValid() && vf.isDirectory()) {
                this.enableOKAction();
                this.mySelectedDir = vf;
            } else {
                this.disableOKAction();
                this.mySelectedDir = null;
            }
        }
    }

    private void enableOKAction() {
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    private void disableOKAction() {
        this.setErrorText(HgBundle.message("hg4idea.init.dialog.incorrect.path", new Object[0]), (JComponent)this.myTextFieldBrowser);
        this.setOKActionEnabled(false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCreateRepositoryForTheRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/HgBundle", HgInitDialog.class).getString("hg4idea.init.dialog.option.create.repository.for.whole.project"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySelectWhereToCreateRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/HgBundle", HgInitDialog.class).getString("hg4idea.init.dialog.option.select.folder"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTextFieldBrowser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEnabled(false);
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

