/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.codeFragment.PyCodeFragmentUtil;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.refactoring.introduce.IntroduceValidator;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyConvertLambdaToFunctionIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.convert.lambda.to.function", new Object[0]);
        if (string == null) {
            PyConvertLambdaToFunctionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyPsiBundle.message("INTN.convert.lambda.to.function", new Object[0]);
        if (string == null) {
            PyConvertLambdaToFunctionIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            PyConvertLambdaToFunctionIntention.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyLambdaExpression lambdaExpression = (PyLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor2.getCaretModel().getOffset()), PyLambdaExpression.class);
        if (lambdaExpression != null && lambdaExpression.getBody() != null) {
            ControlFlow flow = ControlFlowCache.getControlFlow(lambdaExpression);
            List<Instruction> graph = Arrays.asList(flow.getInstructions());
            List<PsiElement> elements = PyCodeFragmentUtil.getInputElements(graph, graph);
            return elements.size() <= 0;
        }
        return false;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        PyLambdaExpression lambdaExpression;
        if (project == null) {
            PyConvertLambdaToFunctionIntention.$$$reportNull$$$0(3);
        }
        if ((lambdaExpression = (PyLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor2.getCaretModel().getOffset()), PyLambdaExpression.class)) != null) {
            PsiElement statementParent;
            String name = "function";
            while (IntroduceValidator.isDefinedInScope(name, (PsiElement)lambdaExpression)) {
                name = name + "1";
            }
            PsiElement parent = lambdaExpression.getParent();
            if (parent instanceof PyAssignmentStatement) {
                name = ((PyAssignmentStatement)parent).getLeftHandSideExpression().getText();
            }
            if (name.isEmpty()) {
                return;
            }
            PyExpression body = lambdaExpression.getBody();
            PyFunctionBuilder functionBuilder = new PyFunctionBuilder(name, (PsiElement)lambdaExpression);
            for (PyParameter param : lambdaExpression.getParameterList().getParameters()) {
                functionBuilder.parameter(param.getText());
            }
            functionBuilder.statement("return " + body.getText());
            PyFunction function = functionBuilder.buildFunction();
            PyStatement statement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)lambdaExpression, PyStatement.class);
            if (statement != null && (statementParent = statement.getParent()) != null) {
                function = (PyFunction)statementParent.addBefore((PsiElement)function, (PsiElement)statement);
            }
            function = (PyFunction)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)function);
            if (parent instanceof PyAssignmentStatement) {
                parent.delete();
            } else {
                PsiFile parentScope = lambdaExpression.getContainingFile();
                TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)parentScope);
                PsiElement functionName = function.getNameIdentifier();
                functionName = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)functionName);
                lambdaExpression = (PyLambdaExpression)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)lambdaExpression);
                ConstantNode refExpr = new ConstantNode(name);
                builder.replaceElement((PsiElement)lambdaExpression, name, (Expression)refExpr, true);
                builder.replaceElement(functionName, name, name, false);
                editor2.getCaretModel().moveToOffset(parentScope.getTextRange().getStartOffset());
                builder.run(editor2, true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyConvertLambdaToFunctionIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyConvertLambdaToFunctionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

