/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.psi.PyFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PySignatureCacheManager {
    @NonNls
    static final String RETURN_TYPE = "<RETURN_TYPE>";

    public static PySignatureCacheManager getInstance(Project project) {
        return (PySignatureCacheManager)ServiceManager.getService((Project)project, PySignatureCacheManager.class);
    }

    public static String signatureToString(PySignature signature) {
        return signature.getFunctionName() + "\t" + StringUtil.join(PySignatureCacheManager.arguments(signature), (String)"\t") + (signature.getReturnType() != null ? "\t" + StringUtil.join((Collection)signature.getReturnType().getTypesList().stream().map(s -> "<RETURN_TYPE>:" + s).collect(Collectors.toList()), (String)"\t") : "");
    }

    private static List<String> arguments(PySignature signature) {
        ArrayList<String> res = new ArrayList<String>();
        for (PySignature.NamedParameter param : signature.getArgs()) {
            res.add(param.getName() + ":" + param.getTypeQualifiedName());
        }
        return res;
    }

    public abstract void recordSignature(@NotNull PySignature var1);

    @Nullable
    public abstract String findParameterType(@NotNull PyFunction var1, @NotNull String var2);

    @Nullable
    public abstract PySignature findSignature(@NotNull PyFunction var1);

    public abstract void clearCache();
}

