/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.toolbox.ChainIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class DocumentationBuilderKit {
    static final TagWrapper TagBold = new TagWrapper("b");
    static final TagWrapper TagSmall = new TagWrapper("small");
    static final TagWrapper TagCode = new TagWrapper("code");
    static final TagWrapper TagSpan = new TagWrapper("span");
    @NonNls
    public static final String BR = "<br>";
    @NotNull
    static final Function<String, String> ESCAPE_ONLY = StringUtil::escapeXmlEntities;
    @NotNull
    static final Function<String, String> TO_ONE_LINE_AND_ESCAPE = s -> ESCAPE_ONLY.apply(s.replace('\n', ' '));
    @NotNull
    static final Function<String, String> ESCAPE_AND_SAVE_NEW_LINES_AND_SPACES = s -> ESCAPE_ONLY.apply((String)s).replace("\n", BR).replace(" ", "&nbsp;");
    @NotNull
    static final Function<String, String> WRAP_IN_ITALIC = s -> "<i>" + s + "</i>";
    @NotNull
    static final Function<String, String> WRAP_IN_BOLD = s -> "<b>" + s + "</b>";

    private DocumentationBuilderKit() {
    }

    static ChainIterable<String> wrapInTag(String tag, Iterable<String> content2) {
        return new ChainIterable<String>("<" + tag + ">").add(content2).addItem("</" + tag + ">");
    }

    static ChainIterable<String> wrapInTag(String tag, List<? extends Pair<String, String>> attributes, Iterable<String> content2) {
        if (attributes.size() == 0) {
            return DocumentationBuilderKit.wrapInTag(tag, content2);
        }
        StringBuilder s = new StringBuilder("<" + tag);
        for (Pair<String, String> pair : attributes) {
            s.append(" ").append((String)pair.first).append("=\"").append((String)pair.second).append("\"");
        }
        s.append(">");
        return new ChainIterable<String>(s.toString()).add(content2).addItem("</" + tag + ">");
    }

    @NonNls
    static String combUp(@NonNls String what) {
        return XmlStringUtil.escapeString((String)what).replace("\n", BR).replace(" ", "&nbsp;");
    }

    static ChainIterable<String> $(String ... content2) {
        return new ChainIterable<List<String>>(Arrays.asList(content2));
    }

    static class TagWrapper
    implements Function<Iterable<String>, Iterable<String>> {
        private final String myTag;
        private final List<Pair<String, String>> myAttributes = new ArrayList<Pair<String, String>>();

        TagWrapper(String tag) {
            this.myTag = tag;
        }

        public TagWrapper withAttribute(String name, String value) {
            TagWrapper result = new TagWrapper(this.myTag);
            result.myAttributes.addAll(this.myAttributes);
            result.myAttributes.add((Pair<String, String>)Pair.create((Object)name, (Object)value));
            return result;
        }

        @Override
        public Iterable<String> apply(Iterable<String> contents) {
            return DocumentationBuilderKit.wrapInTag(this.myTag, this.myAttributes, contents);
        }
    }
}

