/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.validation.CompatibilityVisitor;
import com.jetbrains.python.validation.UnsupportedFeaturesUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCompatibilityInspection
extends PyInspection {
    @NotNull
    public static final List<String> BACKPORTED_PACKAGES = ImmutableList.builder().add((Object)"enum").add((Object)"typing").add((Object)"dataclasses").build();
    public static final List<String> COMPATIBILITY_LIBS = Collections.singletonList("six");
    public static final int LATEST_INSPECTION_VERSION = 3;
    @NotNull
    public static final List<LanguageLevel> DEFAULT_PYTHON_VERSIONS = ImmutableList.of((Object)((Object)LanguageLevel.PYTHON27), (Object)((Object)LanguageLevel.getLatest()));
    @NotNull
    public static final List<LanguageLevel> SUPPORTED_LEVELS = ((StreamEx)StreamEx.of((Object[])LanguageLevel.values()).filter(v -> v.isPython2() && v.isAtLeast(LanguageLevel.PYTHON26) || v.isAtLeast(LanguageLevel.PYTHON34))).toImmutableList();
    @NotNull
    private static final List<String> SUPPORTED_IN_SETTINGS = ContainerUtil.map(SUPPORTED_LEVELS, LanguageLevel::toString);
    public JDOMExternalizableStringList ourVersions = new JDOMExternalizableStringList();

    public PyCompatibilityInspection() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.ourVersions.addAll(SUPPORTED_IN_SETTINGS);
        } else {
            this.ourVersions.addAll((Collection)ContainerUtil.map(DEFAULT_PYTHON_VERSIONS, LanguageLevel::toString));
        }
    }

    @Nullable
    public static PyCompatibilityInspection getInstance(@NotNull PsiElement element) {
        if (element == null) {
            PyCompatibilityInspection.$$$reportNull$$$0(0);
        }
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        String toolName = PyCompatibilityInspection.class.getSimpleName();
        return (PyCompatibilityInspection)inspectionProfile.getUnwrappedTool(toolName, element);
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    private List<LanguageLevel> updateVersionsToProcess() {
        ArrayList<LanguageLevel> result = new ArrayList<LanguageLevel>();
        for (String version : this.ourVersions) {
            if (!SUPPORTED_IN_SETTINGS.contains(version)) continue;
            LanguageLevel level = LanguageLevel.fromPythonVersion(version);
            result.add(level);
        }
        return result;
    }

    public JComponent createOptionsPanel() {
        return PythonUiService.getInstance().createCompatibilityInspectionOptionsPanel(SUPPORTED_IN_SETTINGS, this.ourVersions);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PyCompatibilityInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, this.updateVersionsToProcess());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/PyCompatibilityInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends CompatibilityVisitor {
        private final ProblemsHolder myHolder;
        private final Set<String> myUsedImports = Collections.synchronizedSet(new HashSet());
        private final Set<String> myFromCompatibilityLibs = Collections.synchronizedSet(new HashSet());

        Visitor(ProblemsHolder holder, List<LanguageLevel> versionsToProcess) {
            super(versionsToProcess);
            this.myHolder = holder;
        }

        @Override
        protected void registerProblem(@NotNull PsiElement element, @NotNull TextRange range, @NotNull String message, @Nullable LocalQuickFix quickFix, boolean asError) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (range == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (message == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (element.getTextLength() == 0) {
                return;
            }
            range = range.shiftRight(-element.getTextRange().getStartOffset());
            if (quickFix != null) {
                this.myHolder.registerProblem(element, range, message, new LocalQuickFix[]{quickFix});
            } else {
                this.myHolder.registerProblem(element, range, message, new LocalQuickFix[0]);
            }
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyTargetExpression target;
            super.visitPyCallExpression(node);
            PyExpression callee = node.getCallee();
            if (callee != null && this.importedFromCompatibilityLibs(callee)) {
                return;
            }
            PsiElement resolvedCallee = Optional.ofNullable(callee).map(PsiElement::getReference).map(PsiReference::resolve).orElse(null);
            if (resolvedCallee instanceof PyFunction) {
                String className;
                String functionName;
                PyFunction function = (PyFunction)resolvedCallee;
                PyClass containingClass = function.getContainingClass();
                String string = functionName = PyUtil.isInitOrNewMethod(function) ? callee.getText() : function.getName();
                if (containingClass != null && UnsupportedFeaturesUtil.CLASS_METHODS.containsKey(className = containingClass.getName())) {
                    Map<LanguageLevel, Set<String>> unsupportedMethods = UnsupportedFeaturesUtil.CLASS_METHODS.get(className);
                    this.registerForAllMatchingVersions(level -> unsupportedMethods.getOrDefault(level, Collections.emptySet()).contains(functionName), " not have method " + functionName, (PsiElement)node);
                }
                if (PyBuiltinCache.getInstance(function).isBuiltin(function) && !"print".equals(functionName) && !"exec".equals(functionName) && !this.myUsedImports.contains(functionName)) {
                    this.registerForAllMatchingVersions(level -> UnsupportedFeaturesUtil.BUILTINS.get(level).contains(functionName), " not have method " + functionName, (PsiElement)node);
                }
            } else if (resolvedCallee instanceof PyTargetExpression && !(target = (PyTargetExpression)resolvedCallee).isQualified() && "long".equals(target.getName()) && PyBuiltinCache.getInstance(resolvedCallee).isBuiltin(resolvedCallee)) {
                this.registerForAllMatchingVersions(level -> UnsupportedFeaturesUtil.BUILTINS.get(level).contains("long"), " not have type long. Use int instead.", (PsiElement)node);
            }
        }

        @Override
        public void visitPyImportElement(PyImportElement importElement) {
            QualifiedName qName;
            this.myUsedImports.add(importElement.getVisibleName());
            PyIfStatement ifParent = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)importElement, PyIfStatement.class);
            if (ifParent != null) {
                return;
            }
            PyTryExceptStatement tryExceptStatement = (PyTryExceptStatement)PsiTreeUtil.getParentOfType((PsiElement)importElement, PyTryExceptStatement.class);
            if (tryExceptStatement != null) {
                for (PyExceptPart part : tryExceptStatement.getExceptParts()) {
                    PyExpression exceptClass = part.getExceptClass();
                    if (exceptClass == null || !exceptClass.getText().equals("ImportError")) continue;
                    return;
                }
            }
            if ((qName = Visitor.getImportedFullyQName(importElement)) != null && !qName.matches(new String[]{"builtins"}) && !qName.matches(new String[]{"__builtin__"})) {
                if (COMPATIBILITY_LIBS.contains(qName.getFirstComponent())) {
                    this.myFromCompatibilityLibs.add(qName.getLastComponent());
                }
                String moduleName = qName.toString();
                this.registerForAllMatchingVersions(level -> UnsupportedFeaturesUtil.MODULES.get(level).contains(moduleName) && !BACKPORTED_PACKAGES.contains(moduleName), " not have module " + moduleName, (PsiElement)importElement);
            }
        }

        @Nullable
        private static QualifiedName getImportedFullyQName(@NotNull PyImportElement importElement) {
            QualifiedName importedQName;
            if (importElement == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if ((importedQName = importElement.getImportedQName()) == null) {
                return null;
            }
            PyStatement containingImportStatement = importElement.getContainingImportStatement();
            QualifiedName importSourceQName = containingImportStatement instanceof PyFromImportStatement ? ((PyFromImportStatement)containingImportStatement).getImportSourceQName() : null;
            return importSourceQName == null ? importedQName : importSourceQName.append(importedQName);
        }

        @Override
        public void visitPyFromImportStatement(PyFromImportStatement node) {
            super.visitPyFromImportStatement(node);
            if (node.getRelativeLevel() > 0) {
                return;
            }
            QualifiedName name = node.getImportSourceQName();
            PyReferenceExpression source = node.getImportSource();
            if (name != null && source != null) {
                String moduleName = name.toString();
                this.registerForAllMatchingVersions(level -> UnsupportedFeaturesUtil.MODULES.get(level).contains(moduleName) && !BACKPORTED_PACKAGES.contains(moduleName), " not have module " + name, (PsiElement)source);
            }
        }

        @Override
        public void visitPyArgumentList(PyArgumentList node) {
            block2: {
                boolean isPython2;
                block3: {
                    if (!(node.getParent() instanceof PyClass)) break block2;
                    isPython2 = LanguageLevel.forElement((PsiElement)node).isPython2();
                    if (isPython2) break block3;
                    if (!this.myVersionsToProcess.stream().anyMatch(LanguageLevel::isPython2)) break block2;
                }
                Arrays.stream(node.getArguments()).filter(PyKeywordArgument.class::isInstance).forEach(expression -> this.myHolder.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.compatibility.this.syntax.available.only.since.py3", new Object[0]), !isPython2 ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]));
            }
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            super.visitPyElement(node);
            if (this.myVersionsToProcess.stream().anyMatch(LanguageLevel::isPy3K)) {
                PsiElement res;
                PyExpression qualifier;
                String nodeText = node.getText();
                if ((nodeText.endsWith("iteritems") || nodeText.endsWith("iterkeys") || nodeText.endsWith("itervalues")) && (qualifier = node.getQualifier()) != null) {
                    TypeEvalContext context = TypeEvalContext.codeAnalysis(node.getProject(), node.getContainingFile());
                    PyType type = context.getType(qualifier);
                    PyClassType dictType = PyBuiltinCache.getInstance((PsiElement)node).getDictType();
                    if (PyTypeChecker.match((PyType)dictType, type, context)) {
                        this.registerProblem((PsiElement)node, "dict.iterkeys(), dict.iteritems() and dict.itervalues() methods are not available in py3");
                    }
                }
                if ("basestring".equals(nodeText) && (res = node.getReference().resolve()) != null) {
                    PsiFile file = res.getContainingFile();
                    if (file != null) {
                        VirtualFile virtualFile = file.getVirtualFile();
                        if (virtualFile != null && ProjectRootManager.getInstance((Project)node.getProject()).getFileIndex().isInLibraryClasses(virtualFile)) {
                            this.registerProblem((PsiElement)node, "basestring type is not available in py3");
                        }
                    } else {
                        this.registerProblem((PsiElement)node, "basestring type is not available in py3");
                    }
                }
            }
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            super.visitPyTargetExpression(node);
            this.warnAsyncAndAwaitAreBecomingKeywordsInPy37(node);
        }

        @Override
        public void visitPyClass(PyClass node) {
            super.visitPyClass(node);
            this.warnAsyncAndAwaitAreBecomingKeywordsInPy37(node);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            super.visitPyFunction(node);
            this.warnAsyncAndAwaitAreBecomingKeywordsInPy37(node);
        }

        @Override
        protected boolean registerForLanguageLevel(@NotNull LanguageLevel level) {
            if (level == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            return level != LanguageLevel.forElement((PsiElement)this.myHolder.getFile());
        }

        private void warnAsyncAndAwaitAreBecomingKeywordsInPy37(@NotNull PsiNameIdentifierOwner nameIdentifierOwner) {
            PsiElement nameIdentifier;
            if (nameIdentifierOwner == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if ((nameIdentifier = nameIdentifierOwner.getNameIdentifier()) != null && ArrayUtil.contains((String)nameIdentifierOwner.getName(), (String[])new String[]{"await", "async"}) && LanguageLevel.forElement((PsiElement)nameIdentifierOwner).isOlderThan(LanguageLevel.PYTHON37)) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isAtLeast(LanguageLevel.PYTHON37), " not allow 'async' and 'await' as names", nameIdentifier, PythonUiService.getInstance().createPyRenameElementQuickFix((PsiElement)nameIdentifierOwner));
            }
        }

        private boolean importedFromCompatibilityLibs(@NotNull PyExpression callee) {
            if (callee == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (callee instanceof PyQualifiedExpression) {
                QualifiedName qualifiedName = ((PyQualifiedExpression)callee).asQualifiedName();
                return qualifiedName != null && this.myFromCompatibilityLibs.contains(qualifiedName.getFirstComponent());
            }
            return this.myFromCompatibilityLibs.contains(callee.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameIdentifierOwner";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callee";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyCompatibilityInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerProblem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getImportedFullyQName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerForLanguageLevel";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warnAsyncAndAwaitAreBecomingKeywordsInPy37";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "importedFromCompatibilityLibs";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

