/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyFunctionTypeAnnotation;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyParameterTypeList;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.inspections.PyFinalInspection;
import com.jetbrains.python.inspections.PyFinalInspection$Visitor$visitPyFunction$;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeCommentOwner;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyFinalInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyFinalInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new Visitor(holder, session);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JH\u0010\u001e\u001a\u00020\b2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\b\u0010!\u001a\u0004\u0018\u00010\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0#H\u0002J2\u0010$\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0002J6\u0010%\u001a(\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0&2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J4\u0010'\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0&2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J#\u0010(\u001a\u00020)\"\f\b\u0000\u0010**\u00020+*\u00020,2\u0006\u0010\u0012\u001a\u0002H*H\u0002\u00a2\u0006\u0002\u0010-J\u0010\u0010(\u001a\u00020)2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020)2\u0006\u0010\u0012\u001a\u000201H\u0002J\u0012\u00102\u001a\u00020)2\b\u00103\u001a\u0004\u0018\u000101H\u0002J\u0010\u00104\u001a\u00020\b2\u0006\u0010\u0012\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0019H\u0016J\u0010\u00107\u001a\u00020\b2\u0006\u0010\u0012\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u001dH\u0016J\u0010\u0010:\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010=\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010>\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020?H\u0016\u00a8\u0006@"}, d2={"Lcom/jetbrains/python/inspections/PyFinalInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "checkClassLevelFinalsAreInitialized", "", "classLevelFinals", "", "", "Lcom/jetbrains/python/psi/PyTargetExpression;", "initAttributes", "checkFinalInsideLoop", "loop", "Lcom/jetbrains/python/psi/PyLoopStatement;", "checkFinalIsOuterMost", "node", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "checkFinalReassignment", "target", "Lcom/jetbrains/python/psi/PyQualifiedExpression;", "checkInheritedClassFinalReassignmentOnClassLevel", "cls", "Lcom/jetbrains/python/psi/PyClass;", "checkInstanceFinalReassignment", "checkInstanceFinalsOutsideInit", "method", "Lcom/jetbrains/python/psi/PyFunction;", "checkOverridingInheritedFinalWithNewOne", "newFinals", "inheritedFinals", "ancestorName", "notRegistered", "", "checkSameNameClassAndInstanceFinals", "getClassLevelFinalsAndInitAttributes", "Lkotlin/Pair;", "getDeclaredClassAndInstanceFinals", "isFinal", "", "T", "Lcom/jetbrains/python/psi/PyAnnotationOwner;", "Lcom/jetbrains/python/psi/PyTypeCommentOwner;", "(Lcom/jetbrains/python/psi/PyAnnotationOwner;)Z", "decoratable", "Lcom/jetbrains/python/psi/PyDecoratable;", "isTopLevelInAnnotationOrTypeComment", "Lcom/jetbrains/python/psi/PyExpression;", "resolvesToFinal", "expression", "visitPyAugAssignmentStatement", "Lcom/jetbrains/python/psi/PyAugAssignmentStatement;", "visitPyClass", "visitPyForStatement", "Lcom/jetbrains/python/psi/PyForStatement;", "visitPyFunction", "visitPyNamedParameter", "Lcom/jetbrains/python/psi/PyNamedParameter;", "visitPyReferenceExpression", "visitPyTargetExpression", "visitPyWhileStatement", "Lcom/jetbrains/python/psi/PyWhileStatement;", "intellij.python.psi.impl"})
    private static final class Visitor
    extends PyInspectionVisitor {
        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPyClass(@NotNull PyClass node) {
            Object visitedNames;
            void $this$filterTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            super.visitPyClass(node);
            PyClass[] pyClassArray = node.getSuperClasses(this.myTypeEvalContext);
            Intrinsics.checkExpressionValueIsNotNull((Object)pyClassArray, (String)"node.getSuperClasses(myTypeEvalContext)");
            Object $this$filter$iv = pyClassArray;
            boolean $i$f$filter = false;
            PyClass[] pyClassArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var7_10 = $this$filterTo$iv$iv;
            int n = ((void)var7_10).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var7_10[i];
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                if (!this.isFinal((PyDecoratable)v1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            boolean bl = false;
            Object finalSuperClasses = $this$filter$iv;
            boolean bl2 = false;
            if (!finalSuperClasses.isEmpty()) {
                String postfix = ' ' + (finalSuperClasses.size() == 1 ? "is" : "are") + " marked as '@final' and should not be subclassed";
                this.registerProblem(node.getNameIdentifier(), CollectionsKt.joinToString$default((Iterable)((Iterable)finalSuperClasses), null, null, (CharSequence)postfix, (int)0, null, (Function1)visitPyClass.2.1.INSTANCE, (int)27, null));
            }
            if (PyiUtil.isInsideStub((PsiElement)node)) {
                $i$f$filter = false;
                visitedNames = new LinkedHashSet();
                node.visitMethods((Processor<PyFunction>)((Processor)new Processor<PyFunction>(this, (Set)visitedNames){
                    final /* synthetic */ Visitor this$0;
                    final /* synthetic */ Set $visitedNames;

                    public final boolean process(PyFunction m) {
                        PyFunction pyFunction = m;
                        Intrinsics.checkExpressionValueIsNotNull((Object)pyFunction, (String)"m");
                        if (!this.$visitedNames.add(pyFunction.getName()) && Visitor.access$isFinal(this.this$0, m)) {
                            this.this$0.registerProblem(m.getNameIdentifier(), "'@final' should be placed on the first overload");
                        }
                        return true;
                    }
                    {
                        this.this$0 = visitor2;
                        this.$visitedNames = set;
                    }
                }), false, this.myTypeEvalContext);
            } else {
                void classLevelFinals;
                Pair<Map<String, PyTargetExpression>, Map<String, PyTargetExpression>> pair = this.getClassLevelFinalsAndInitAttributes(node);
                visitedNames = (Map)pair.component1();
                Map initAttributes = (Map)pair.component2();
                this.checkClassLevelFinalsAreInitialized((Map<String, ? extends PyTargetExpression>)classLevelFinals, initAttributes);
                this.checkSameNameClassAndInstanceFinals((Map<String, ? extends PyTargetExpression>)classLevelFinals, initAttributes);
            }
            this.checkOverridingInheritedFinalWithNewOne(node);
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            block23: {
                PyElement pyElement;
                PyElement it;
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                super.visitPyFunction(node);
                PyClass cls = node.getContainingClass();
                if (cls != null) {
                    Object v2;
                    Object $this$firstOrNull$iv;
                    block21: {
                        Query<PsiElement> query = PySuperMethodsSearch.search(node, this.myTypeEvalContext);
                        Intrinsics.checkExpressionValueIsNotNull(query, (String)"PySuperMethodsSearch\n   \u2026(node, myTypeEvalContext)");
                        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)((Iterable)query));
                        boolean $i$f$filterIsInstance = false;
                        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Visitor$visitPyFunction$$inlined$filterIsInstance$1.INSTANCE);
                        if (sequence == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                        }
                        $this$firstOrNull$iv = sequence;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            PyFunction it2 = (PyFunction)element$iv;
                            boolean bl2 = false;
                            if (!this.isFinal(it2)) continue;
                            v2 = element$iv;
                            break block21;
                        }
                        v2 = null;
                    }
                    PyFunction pyFunction = v2;
                    if (pyFunction != null) {
                        $this$firstOrNull$iv = pyFunction;
                        bl = false;
                        boolean bl3 = false;
                        it = $this$firstOrNull$iv;
                        boolean bl4 = false;
                        String string = it.getQualifiedName();
                        if (string == null) {
                            PyClass pyClass = it.getContainingClass();
                            string = (pyClass != null ? pyClass.getName() : null) + "." + it.getName();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.qualifiedName ?: it.c\u2026ass?.name + \".\" + it.name");
                        String qualifiedName = string;
                        this.registerProblem(node.getNameIdentifier(), '\'' + qualifiedName + "' is marked as '@final' and should not be overridden");
                    }
                    if (!PyiUtil.isInsideStub(node)) {
                        if (this.isFinal(node) && PyiUtil.isOverload(node, this.myTypeEvalContext)) {
                            this.registerProblem(node.getNameIdentifier(), "'@final' should be placed on the implementation");
                        }
                        this.checkInstanceFinalsOutsideInit(node);
                    }
                    if (PyKnownDecoratorUtil.hasAbstractDecorator(node, this.myTypeEvalContext)) {
                        if (this.isFinal(node)) {
                            this.registerProblem(node.getNameIdentifier(), "'Final' could not be mixed with abstract decorators");
                        } else if (this.isFinal(cls)) {
                            String message = "'Final' class could not contain abstract methods";
                            this.registerProblem(node.getNameIdentifier(), message);
                            this.registerProblem(cls.getNameIdentifier(), message);
                        }
                    } else if (this.isFinal(node) && this.isFinal(cls)) {
                        this.registerProblem(node.getNameIdentifier(), "No need to mark method in 'Final' class as '@final'", ProblemHighlightType.WEAK_WARNING);
                    }
                } else if (this.isFinal(node)) {
                    this.registerProblem(node.getNameIdentifier(), "Non-method function could not be marked as '@final'");
                }
                PyFunctionTypeAnnotation pyFunctionTypeAnnotation = PyTypingTypeProvider.getFunctionTypeAnnotation(node);
                if (pyFunctionTypeAnnotation != null) {
                    boolean bl5;
                    block22: {
                        pyElement = pyFunctionTypeAnnotation;
                        bl = false;
                        boolean bl6 = false;
                        PyFunctionTypeAnnotation comment = pyElement;
                        boolean bl7 = false;
                        PyFunctionTypeAnnotation pyFunctionTypeAnnotation2 = comment;
                        Intrinsics.checkExpressionValueIsNotNull((Object)pyFunctionTypeAnnotation2, (String)"comment");
                        PyParameterTypeList pyParameterTypeList = pyFunctionTypeAnnotation2.getParameterTypeList();
                        Intrinsics.checkExpressionValueIsNotNull((Object)pyParameterTypeList, (String)"comment.parameterTypeList");
                        List<PyExpression> list = pyParameterTypeList.getParameterTypes();
                        Intrinsics.checkExpressionValueIsNotNull(list, (String)"comment.parameterTypeList.parameterTypes");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                PyExpression it3 = (PyExpression)element$iv;
                                boolean bl8 = false;
                                if (!this.resolvesToFinal(it3 instanceof PySubscriptionExpression ? ((PySubscriptionExpression)it3).getOperand() : it3)) continue;
                                bl5 = true;
                                break block22;
                            }
                            bl5 = false;
                        }
                    }
                    if (bl5) {
                        this.registerProblem((PsiElement)node.getTypeComment(), "'Final' could not be used in annotations for function parameters");
                    }
                }
                PyExpression pyExpression = PyTypingTypeProvider.getReturnTypeAnnotation(node, this.myTypeEvalContext);
                if (pyExpression == null) break block23;
                pyElement = pyExpression;
                bl = false;
                boolean bl9 = false;
                it = pyElement;
                boolean bl10 = false;
                if (this.resolvesToFinal((PyExpression)(it instanceof PySubscriptionExpression ? ((PySubscriptionExpression)it).getOperand() : it))) {
                    PsiComment psiComment = node.getTypeComment();
                    this.registerProblem(psiComment != null ? (PsiElement)psiComment : (PsiElement)node.getAnnotation(), "'Final' could not be used in annotation for function return value");
                }
            }
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            super.visitPyTargetExpression(node);
            if (!node.hasAssignedValue()) {
                PyElement pyElement = node.getAnnotation();
                if (pyElement != null && (pyElement = pyElement.getValue()) != null) {
                    PyElement pyElement2 = pyElement;
                    boolean bl = false;
                    boolean bl2 = false;
                    PyElement it = pyElement2;
                    boolean bl3 = false;
                    if (PyiUtil.isInsideStub(node) || ScopeUtil.getScopeOwner(node) instanceof PyClass) {
                        if (this.resolvesToFinal((PyExpression)it)) {
                            this.registerProblem((PsiElement)it, "If assigned value is omitted, there should be an explicit type argument to 'Final'");
                        }
                    } else if (this.resolvesToFinal((PyExpression)(it instanceof PySubscriptionExpression ? ((PySubscriptionExpression)it).getOperand() : it))) {
                        this.registerProblem(node, "'Final' name should be initialized with a value");
                    }
                }
            } else if (!this.isFinal((PyAnnotationOwner)node)) {
                this.checkFinalReassignment(node);
            }
            if (this.isFinal((PyAnnotationOwner)node)) {
                boolean bl;
                block13: {
                    List<PsiElement> list = PyUtil.multiResolveTopPriority(node, this.getResolveContext());
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"PyUtil.multiResolveTopPr\u2026ity(node, resolveContext)");
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl4 = false;
                            if (!(Intrinsics.areEqual((Object)it, (Object)node) ^ true)) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    this.registerProblem(node, "Already declared name could not be redefined as 'Final'");
                }
            }
        }

        @Override
        public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            super.visitPyNamedParameter(node);
            if (this.isFinal((PyAnnotationOwner)node)) {
                PyElement pyElement = node.getAnnotation();
                this.registerProblem(pyElement != null && (pyElement = pyElement.getValue()) != null ? (PsiElement)pyElement : (PsiElement)node.getTypeComment(), "'Final' could not be used in annotations for function parameters");
            }
        }

        @Override
        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            super.visitPyReferenceExpression(node);
            this.checkFinalIsOuterMost(node);
        }

        @Override
        public void visitPyForStatement(@NotNull PyForStatement node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            super.visitPyForStatement(node);
            this.checkFinalInsideLoop(node);
        }

        @Override
        public void visitPyWhileStatement(@NotNull PyWhileStatement node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            super.visitPyWhileStatement(node);
            this.checkFinalInsideLoop(node);
        }

        @Override
        public void visitPyAugAssignmentStatement(@NotNull PyAugAssignmentStatement node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            super.visitPyAugAssignmentStatement(node);
            PyExpression pyExpression = node.getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)pyExpression, (String)"node.target");
            PyExpression target = pyExpression;
            if (target instanceof PyQualifiedExpression) {
                this.checkFinalReassignment((PyQualifiedExpression)target);
            }
        }

        private final Pair<Map<String, PyTargetExpression>, Map<String, PyTargetExpression>> getClassLevelFinalsAndInitAttributes(PyClass cls) {
            Map initAttributes;
            Map classLevelFinals;
            block1: {
                StubBasedPsiElement<PyTargetExpressionStub> it;
                boolean bl = false;
                classLevelFinals = new LinkedHashMap();
                List<PyTargetExpression> list = cls.getClassAttributes();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"cls.classAttributes");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (PyTargetExpression)element$iv;
                    boolean bl2 = false;
                    if (!this.isFinal((PyAnnotationOwner)it)) continue;
                    PyTargetExpression pyTargetExpression = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pyTargetExpression, (String)"it");
                    classLevelFinals.put(pyTargetExpression.getName(), it);
                }
                boolean bl3 = false;
                initAttributes = new LinkedHashMap();
                PyFunction pyFunction = cls.findMethodByName("__init__", false, this.myTypeEvalContext);
                if (pyFunction == null) break block1;
                PyFunction pyFunction2 = pyFunction;
                boolean bl4 = false;
                boolean bl5 = false;
                it = pyFunction2;
                boolean bl6 = false;
                PyClassImpl.collectInstanceAttributes((PyFunction)it, initAttributes);
            }
            return new Pair((Object)classLevelFinals, (Object)initAttributes);
        }

        private final Pair<Map<String, PyTargetExpression>, Map<String, PyTargetExpression>> getDeclaredClassAndInstanceFinals(PyClass cls) {
            Map instanceFinals;
            Map classFinals;
            block3: {
                boolean bl = false;
                classFinals = new LinkedHashMap();
                boolean bl2 = false;
                instanceFinals = new LinkedHashMap();
                Iterator<PyTargetExpression> iterator = cls.getClassAttributes().iterator();
                while (iterator.hasNext()) {
                    String name;
                    PyTargetExpression classAttribute;
                    PyTargetExpression pyTargetExpression = classAttribute = iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)pyTargetExpression, (String)"classAttribute");
                    if (pyTargetExpression.getName() == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"classAttribute.name ?: continue");
                    if (!this.isFinal((PyAnnotationOwner)classAttribute)) continue;
                    Map mapToPut = classAttribute.hasAssignedValue() ? classFinals : instanceFinals;
                    mapToPut.put(name, classAttribute);
                }
                PyFunction pyFunction = cls.findMethodByName("__init__", false, this.myTypeEvalContext);
                if (pyFunction == null) break block3;
                PyFunction pyFunction2 = pyFunction;
                boolean bl3 = false;
                boolean bl4 = false;
                PyFunction init = pyFunction2;
                boolean bl5 = false;
                boolean bl6 = false;
                Map attributesInInit = new LinkedHashMap();
                PyClassImpl.collectInstanceAttributes(init, attributesInInit, instanceFinals.keySet());
                Map map2 = instanceFinals;
                Map $this$filterValues$iv = attributesInInit;
                boolean $i$f$filterValues = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                Map map3 = $this$filterValues$iv;
                boolean bl7 = false;
                for (Map.Entry entry$iv : map3.entrySet()) {
                    PyTargetExpression it = (PyTargetExpression)entry$iv.getValue();
                    boolean bl8 = false;
                    if (!this.isFinal((PyAnnotationOwner)it)) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                Map map4 = result$iv;
                boolean bl9 = false;
                map2.putAll(map4);
            }
            return new Pair((Object)classFinals, (Object)instanceFinals);
        }

        /*
         * WARNING - void declaration
         */
        private final void checkClassLevelFinalsAreInitialized(Map<String, ? extends PyTargetExpression> classLevelFinals, Map<String, ? extends PyTargetExpression> initAttributes) {
            Map<String, ? extends PyTargetExpression> $this$forEach$iv = classLevelFinals;
            boolean $i$f$forEach = false;
            Map<String, ? extends PyTargetExpression> map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, ? extends PyTargetExpression>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                void name;
                Map.Entry<String, ? extends PyTargetExpression> element$iv;
                Map.Entry<String, ? extends PyTargetExpression> $dstr$name$psi = element$iv = iterator.next();
                boolean bl2 = false;
                Object object = $dstr$name$psi;
                boolean bl3 = false;
                String string = object.getKey();
                object = $dstr$name$psi;
                bl3 = false;
                PyTargetExpression psi = object.getValue();
                if (psi.hasAssignedValue()) continue;
                object = initAttributes;
                bl3 = false;
                Object object2 = object;
                boolean bl4 = false;
                if (object2.containsKey(name)) continue;
                this.registerProblem(psi, "'Final' name should be initialized with a value");
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkSameNameClassAndInstanceFinals(Map<String, ? extends PyTargetExpression> classLevelFinals, Map<String, ? extends PyTargetExpression> initAttributes) {
            Map<String, ? extends PyTargetExpression> $this$forEach$iv = initAttributes;
            boolean $i$f$forEach = false;
            Map<String, ? extends PyTargetExpression> map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, ? extends PyTargetExpression>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                void name;
                Map.Entry<String, ? extends PyTargetExpression> element$iv;
                Map.Entry<String, ? extends PyTargetExpression> $dstr$name$initAttribute = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry<String, ? extends PyTargetExpression> entry = $dstr$name$initAttribute;
                boolean bl3 = false;
                String string = entry.getKey();
                entry = $dstr$name$initAttribute;
                bl3 = false;
                PyTargetExpression initAttribute = entry.getValue();
                PyTargetExpression sameNameClassLevelFinal = classLevelFinals.get(name);
                if (sameNameClassLevelFinal == null || !this.isFinal((PyAnnotationOwner)initAttribute)) continue;
                if (sameNameClassLevelFinal.hasAssignedValue()) {
                    this.registerProblem(initAttribute, "Already declared name could not be redefined as 'Final'");
                    continue;
                }
                String message = "Either instance attribute or class attribute could be type hinted as 'Final'";
                this.registerProblem(sameNameClassLevelFinal, message);
                this.registerProblem(initAttribute, message);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkOverridingInheritedFinalWithNewOne(PyClass cls) {
            void newClassFinals;
            Pair<Map<String, PyTargetExpression>, Map<String, PyTargetExpression>> pair = this.getDeclaredClassAndInstanceFinals(cls);
            Map map2 = (Map)pair.component1();
            Map newInstanceFinals = (Map)pair.component2();
            Set notRegisteredClassFinals = CollectionsKt.toMutableSet((Iterable)newClassFinals.keySet());
            Set notRegisteredInstanceFinals = CollectionsKt.toMutableSet((Iterable)newInstanceFinals.keySet());
            if (notRegisteredClassFinals.isEmpty() && notRegisteredInstanceFinals.isEmpty()) {
                return;
            }
            Iterator<PyClass> iterator = cls.getAncestorClasses(this.myTypeEvalContext).iterator();
            while (iterator.hasNext()) {
                void inheritedClassFinals;
                PyClass ancestor;
                PyClass pyClass = ancestor = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)pyClass, (String)"ancestor");
                Pair<Map<String, PyTargetExpression>, Map<String, PyTargetExpression>> pair2 = this.getDeclaredClassAndInstanceFinals(pyClass);
                Map map3 = (Map)pair2.component1();
                Map inheritedInstanceFinals = (Map)pair2.component2();
                this.checkOverridingInheritedFinalWithNewOne((Map<String, ? extends PyTargetExpression>)newClassFinals, (Map<String, ? extends PyTargetExpression>)inheritedClassFinals, ancestor.getName(), notRegisteredClassFinals);
                this.checkOverridingInheritedFinalWithNewOne(newInstanceFinals, inheritedInstanceFinals, ancestor.getName(), notRegisteredInstanceFinals);
                if (!notRegisteredClassFinals.isEmpty() || !notRegisteredInstanceFinals.isEmpty()) continue;
                break;
            }
        }

        private final void checkOverridingInheritedFinalWithNewOne(Map<String, ? extends PyTargetExpression> newFinals, Map<String, ? extends PyTargetExpression> inheritedFinals, String ancestorName, Set<String> notRegistered) {
            if (notRegistered.isEmpty()) {
                return;
            }
            for (String commonFinal : CollectionsKt.intersect((Iterable)newFinals.keySet(), (Iterable)inheritedFinals.keySet())) {
                this.registerProblem(newFinals.get(commonFinal), '\'' + ancestorName + '.' + commonFinal + "' is 'Final' and could not be overridden");
                notRegistered.remove(commonFinal);
            }
        }

        private final void checkInstanceFinalsOutsideInit(PyFunction method) {
            if (PyUtil.isInitMethod(method)) {
                return;
            }
            boolean bl = false;
            Map instanceAttributes = new LinkedHashMap();
            PyClassImpl.collectInstanceAttributes(method, instanceAttributes);
            Iterable $this$forEach$iv = instanceAttributes.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyTargetExpression it = (PyTargetExpression)element$iv;
                boolean bl2 = false;
                if (!this.isFinal((PyAnnotationOwner)it)) continue;
                this.registerProblem(it, "'Final' attribute should be declared in class body or '__init__'");
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkFinalReassignment(PyQualifiedExpression target) {
            ScopeOwner scopeOwner;
            boolean bl;
            List resolved;
            block15: {
                List list;
                PyType qualifierType;
                PyType pyType;
                PyExpression pyExpression = target.getQualifier();
                if (pyExpression != null) {
                    PyExpression pyExpression2 = pyExpression;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    PyExpression it = pyExpression2;
                    boolean bl4 = false;
                    pyType = this.myTypeEvalContext.getType(it);
                } else {
                    pyType = qualifierType = null;
                }
                if (qualifierType instanceof PyClassType && !((PyClassType)qualifierType).isDefinition()) {
                    PyClass pyClass = ((PyClassType)qualifierType).getPyClass();
                    Intrinsics.checkExpressionValueIsNotNull((Object)pyClass, (String)"qualifierType.pyClass");
                    this.checkInstanceFinalReassignment(target, pyClass);
                    return;
                }
                PyQualifiedExpression pyQualifiedExpression = target;
                if (pyQualifiedExpression instanceof PyReferenceOwner) {
                    void $this$mapNotNullTo$iv$iv;
                    ResolveResult[] resolveResultArray = ((PyReferenceOwner)((Object)target)).getReference(this.getResolveContext()).multiResolve(false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"target.getReference(reso\u2026text).multiResolve(false)");
                    ResolveResult[] $this$mapNotNull$iv = resolveResultArray;
                    boolean $i$f$mapNotNull = false;
                    ResolveResult[] bl4 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    void var12_27 = $this$forEach$iv$iv$iv;
                    int n = ((void)var12_27).length;
                    for (int i = 0; i < n; ++i) {
                        PsiElement psiElement;
                        void element$iv$iv$iv;
                        void element$iv$iv = element$iv$iv$iv = var12_27[i];
                        boolean bl5 = false;
                        void it = element$iv$iv;
                        boolean bl6 = false;
                        void v4 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                        if (v4.getElement() == null) continue;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        PsiElement it$iv$iv = psiElement;
                        boolean bl9 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    List list2 = PyUtil.multiResolveTopPriority((PsiElement)target, this.getResolveContext());
                    list = list2;
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"PyUtil.multiResolveTopPr\u2026y(target, resolveContext)");
                }
                resolved = list;
                Iterable $this$any$iv = resolved;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl10 = false;
                        if (!(it instanceof PyTargetExpression && this.isFinal((PyAnnotationOwner)it))) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl) {
                this.registerProblem((PsiElement)target, '\'' + target.getName() + "' is 'Final' and could not be reassigned");
                return;
            }
            for (PsiElement e : resolved) {
                boolean bl11;
                block16: {
                    if (!this.myTypeEvalContext.maySwitchToAST(e)) continue;
                    PsiElement psiElement = e;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"e");
                    PsiElement $i$f$mapNotNull = psiElement.getParent();
                    boolean element$iv = false;
                    boolean bl12 = false;
                    PsiElement it = $i$f$mapNotNull;
                    boolean bl13 = false;
                    if (!(it instanceof PyNonlocalStatement || it instanceof PyGlobalStatement)) continue;
                    List<PsiElement> list = PyUtil.multiResolveTopPriority(e, this.getResolveContext());
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"PyUtil.multiResolveTopPriority(e, resolveContext)");
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl11 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            PsiElement it2 = (PsiElement)element$iv2;
                            boolean bl14 = false;
                            if (!(it2 instanceof PyTargetExpression && this.isFinal((PyAnnotationOwner)it2))) continue;
                            bl11 = true;
                            break block16;
                        }
                        bl11 = false;
                    }
                }
                if (!bl11) continue;
                this.registerProblem((PsiElement)target, '\'' + target.getName() + "' is 'Final' and could not be reassigned");
                return;
            }
            if (!target.isQualified() && (scopeOwner = ScopeUtil.getScopeOwner((PsiElement)target)) instanceof PyClass) {
                this.checkInheritedClassFinalReassignmentOnClassLevel(target, (PyClass)scopeOwner);
            }
        }

        private final void checkInstanceFinalReassignment(PyQualifiedExpression target, PyClass cls) {
            boolean bl;
            String string = target.getName();
            if (string == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target.name ?: return");
            String name = string;
            PyTargetExpression classAttribute = cls.findClassAttribute(name, false, this.myTypeEvalContext);
            if (classAttribute != null && !classAttribute.hasAssignedValue() && this.isFinal((PyAnnotationOwner)classAttribute)) {
                if (target instanceof PyTargetExpression) {
                    ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)target);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ScopeOwner it = scopeOwner;
                    bl = false;
                    if (it instanceof PyFunction && Intrinsics.areEqual((Object)PyUtil.turnConstructorIntoClass((PyFunction)it), (Object)cls)) {
                        return;
                    }
                }
                this.registerProblem((PsiElement)target, '\'' + name + "' is 'Final' and could not be reassigned");
            }
            for (PyClass ancestor : cls.getAncestorClasses(this.myTypeEvalContext)) {
                PyTargetExpression inheritedClassAttribute = ancestor.findClassAttribute(name, false, this.myTypeEvalContext);
                if (inheritedClassAttribute == null || inheritedClassAttribute.hasAssignedValue() || !this.isFinal((PyAnnotationOwner)inheritedClassAttribute)) continue;
                PsiElement psiElement = (PsiElement)target;
                StringBuilder stringBuilder = new StringBuilder().append('\'');
                PyClass pyClass = ancestor;
                Intrinsics.checkExpressionValueIsNotNull((Object)pyClass, (String)"ancestor");
                this.registerProblem(psiElement, stringBuilder.append(pyClass.getName()).append('.').append(name).append("' is 'Final' and could not be reassigned").toString());
                return;
            }
            Sequence sequence = SequencesKt.sequenceOf((Object[])new PyClass[]{cls});
            List<PyClass> list = cls.getAncestorClasses(this.myTypeEvalContext);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"cls.getAncestorClasses(myTypeEvalContext)");
            for (PyClass current : SequencesKt.plus((Sequence)sequence, (Sequence)CollectionsKt.asSequence((Iterable)list))) {
                String string2;
                PyFunction init = current.findMethodByName("__init__", false, this.myTypeEvalContext);
                if (init == null) continue;
                bl = false;
                Map attributesInInit = new LinkedHashMap();
                PyClassImpl.collectInstanceAttributes(init, attributesInInit);
                if ((PyTargetExpression)attributesInInit.get(name) == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                PyTargetExpression it = bl;
                boolean bl6 = false;
                if (!(Intrinsics.areEqual((Object)it, (Object)target) ^ true && this.isFinal((PyAnnotationOwner)it))) continue;
                if (Intrinsics.areEqual((Object)cls, (Object)current)) {
                    string2 = "";
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    PyClass pyClass = current;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pyClass, (String)"current");
                    string2 = stringBuilder.append(pyClass.getName()).append('.').toString();
                }
                String qualifier = string2;
                this.registerProblem((PsiElement)target, '\'' + qualifier + name + "' is 'Final' and could not be reassigned");
                break;
            }
        }

        private final void checkInheritedClassFinalReassignmentOnClassLevel(PyQualifiedExpression target, PyClass cls) {
            String string = target.getName();
            if (string == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target.name ?: return");
            String name = string;
            for (PyClass ancestor : cls.getAncestorClasses(this.myTypeEvalContext)) {
                PyTargetExpression ancestorClassAttribute = ancestor.findClassAttribute(name, false, this.myTypeEvalContext);
                if (ancestorClassAttribute == null || !ancestorClassAttribute.hasAssignedValue() || !this.isFinal((PyAnnotationOwner)ancestorClassAttribute)) continue;
                PsiElement psiElement = (PsiElement)target;
                StringBuilder stringBuilder = new StringBuilder().append('\'');
                PyClass pyClass = ancestor;
                Intrinsics.checkExpressionValueIsNotNull((Object)pyClass, (String)"ancestor");
                this.registerProblem(psiElement, stringBuilder.append(pyClass.getName()).append('.').append(name).append("' is 'Final' and could not be reassigned").toString());
                break;
            }
        }

        private final void checkFinalIsOuterMost(PyReferenceExpression node) {
            if (this.isTopLevelInAnnotationOrTypeComment(node)) {
                return;
            }
            PsiElement psiElement = node.getParent();
            if (!(psiElement instanceof PySubscriptionExpression)) {
                psiElement = null;
            }
            PySubscriptionExpression pySubscriptionExpression = (PySubscriptionExpression)psiElement;
            if (pySubscriptionExpression != null) {
                PySubscriptionExpression pySubscriptionExpression2 = pySubscriptionExpression;
                boolean bl = false;
                boolean bl2 = false;
                PySubscriptionExpression it = pySubscriptionExpression2;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)it.getOperand(), (Object)node) && this.isTopLevelInAnnotationOrTypeComment(it)) {
                    return;
                }
            }
            if (PyTypingTypeProvider.isInAnnotationOrTypeComment((PsiElement)node) && this.resolvesToFinal(node)) {
                this.registerProblem((PsiElement)node, "'Final' could only be used as the outermost type");
            }
        }

        private final void checkFinalInsideLoop(PyLoopStatement loop) {
            loop.acceptChildren(new PyRecursiveElementVisitor(this){
                final /* synthetic */ Visitor this$0;

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    if (!(element instanceof ScopeOwner)) {
                        super.visitElement(element);
                    }
                }

                public void visitPyForStatement(@NotNull PyForStatement node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                }

                public void visitPyWhileStatement(@NotNull PyWhileStatement node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                }

                public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    if (Visitor.access$isFinal(this.this$0, node)) {
                        this.this$0.registerProblem(node, "'Final' could not be used inside a loop");
                    }
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        private final boolean isFinal(PyDecoratable decoratable) {
            return PyTypingTypeProvider.isFinal(decoratable, this.myTypeEvalContext);
        }

        private final <T extends PyAnnotationOwner & PyTypeCommentOwner> boolean isFinal(T node) {
            return PyTypingTypeProvider.isFinal(node, this.myTypeEvalContext);
        }

        private final boolean resolvesToFinal(PyExpression expression) {
            return expression instanceof PyReferenceExpression && PyTypingTypeProvider.eventuallyResolvesToFinal(expression, this.myTypeEvalContext);
        }

        private final boolean isTopLevelInAnnotationOrTypeComment(PyExpression node) {
            PsiElement parent = node.getParent();
            if (parent instanceof PyAnnotation) {
                return true;
            }
            if (parent instanceof PyExpressionStatement && ((PyExpressionStatement)parent).getParent() instanceof PyDocstringFile) {
                return true;
            }
            if (parent instanceof PyParameterTypeList) {
                return true;
            }
            return parent instanceof PyFunctionTypeAnnotation;
        }

        public Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            super(holder, session);
        }

        public static final /* synthetic */ boolean access$isFinal(Visitor $this, PyDecoratable decoratable) {
            return $this.isFinal(decoratable);
        }

        public static final /* synthetic */ boolean access$isFinal(Visitor $this, PyAnnotationOwner node) {
            return $this.isFinal(node);
        }
    }
}

